/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.util.function.Function;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.DeleteHandler;
import org.hibernate.query.sqm.mutation.internal.temptable.RestrictedDeleteExecutionDelegate;
import org.hibernate.query.sqm.mutation.internal.temptable.SoftDeleteExecutionDelegate;
import org.hibernate.query.sqm.mutation.spi.AbstractMutationHandler;
import org.hibernate.query.sqm.mutation.spi.AfterUseAction;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.jboss.logging.Logger;

public class TableBasedDeleteHandler
extends AbstractMutationHandler
implements DeleteHandler {
    private static final Logger log = Logger.getLogger(TableBasedDeleteHandler.class);
    private final TemporaryTable idTable;
    private final AfterUseAction afterUseAction;
    private final Function<SharedSessionContractImplementor, String> sessionUidAccess;
    private final DomainParameterXref domainParameterXref;

    public TableBasedDeleteHandler(SqmDeleteStatement<?> sqmDeleteStatement, DomainParameterXref domainParameterXref, TemporaryTable idTable, AfterUseAction afterUseAction, Function<SharedSessionContractImplementor, String> sessionUidAccess, SessionFactoryImplementor sessionFactory) {
        super(sqmDeleteStatement, sessionFactory);
        this.idTable = idTable;
        this.domainParameterXref = domainParameterXref;
        this.afterUseAction = afterUseAction;
        this.sessionUidAccess = sessionUidAccess;
    }

    @Override
    public int execute(DomainQueryExecutionContext executionContext) {
        if (log.isTraceEnabled()) {
            log.tracef("Starting multi-table delete execution - %s", (Object)((SqmRoot)((SqmDeleteStatement)this.getSqmDeleteOrUpdateStatement()).getRoot()).getModel().getName());
        }
        return this.resolveDelegate(executionContext).execute(executionContext);
    }

    protected ExecutionDelegate resolveDelegate(DomainQueryExecutionContext executionContext) {
        if (this.getEntityDescriptor().getSoftDeleteMapping() != null) {
            return new SoftDeleteExecutionDelegate(this.getEntityDescriptor(), this.idTable, this.afterUseAction, (SqmDeleteStatement<?>)this.getSqmDeleteOrUpdateStatement(), this.domainParameterXref, executionContext.getQueryOptions(), executionContext.getSession().getLoadQueryInfluencers(), executionContext.getQueryParameterBindings(), this.sessionUidAccess, this.getSessionFactory());
        }
        return new RestrictedDeleteExecutionDelegate(this.getEntityDescriptor(), this.idTable, this.afterUseAction, (SqmDeleteStatement<?>)this.getSqmDeleteOrUpdateStatement(), this.domainParameterXref, executionContext.getQueryOptions(), executionContext.getSession().getLoadQueryInfluencers(), executionContext.getQueryParameterBindings(), this.sessionUidAccess, this.getSessionFactory());
    }

    protected TemporaryTable getIdTable() {
        return this.idTable;
    }

    protected AfterUseAction getAfterUseAction() {
        return this.afterUseAction;
    }

    protected Function<SharedSessionContractImplementor, String> getSessionUidAccess() {
        return this.sessionUidAccess;
    }

    protected DomainParameterXref getDomainParameterXref() {
        return this.domainParameterXref;
    }

    public SqmDeleteStatement<?> getSqmDeleteOrUpdateStatement() {
        return (SqmDeleteStatement)super.getSqmDeleteOrUpdateStatement();
    }

    public static interface ExecutionDelegate {
        public int execute(DomainQueryExecutionContext var1);
    }
}

