/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.List;
import org.hibernate.Incubating;
import org.hibernate.query.criteria.JpaSetReturningFunction;
import org.hibernate.query.derived.AnonymousTupleType;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.function.SqmSetReturningFunctionDescriptor;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.AbstractSqmNode;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.SqmVisitableNode;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;

@Incubating
public abstract class SqmSetReturningFunction<T>
extends AbstractSqmNode
implements SqmVisitableNode,
JpaSetReturningFunction<T> {
    private final String functionName;
    private final SqmSetReturningFunctionDescriptor functionDescriptor;
    private final List<? extends SqmTypedNode<?>> arguments;

    public SqmSetReturningFunction(String functionName, SqmSetReturningFunctionDescriptor functionDescriptor, List<? extends SqmTypedNode<?>> arguments, NodeBuilder criteriaBuilder) {
        super(criteriaBuilder);
        this.functionName = functionName;
        this.functionDescriptor = functionDescriptor;
        this.arguments = arguments;
    }

    @Override
    public abstract SqmSetReturningFunction<T> copy(SqmCopyContext var1);

    public SqmSetReturningFunctionDescriptor getFunctionDescriptor() {
        return this.functionDescriptor;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    public abstract AnonymousTupleType<T> getType();

    public List<? extends SqmTypedNode<?>> getArguments() {
        return this.arguments;
    }

    public abstract TableGroup convertToSqlAst(NavigablePath var1, String var2, boolean var3, boolean var4, boolean var5, SqmToSqlAstConverter var6);

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitSetReturningFunction(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append(this.functionName);
        if (this.arguments.isEmpty()) {
            sb.append("()");
            return;
        }
        sb.append('(');
        this.arguments.get(0).appendHqlString(sb);
        for (int i = 1; i < this.arguments.size(); ++i) {
            sb.append(", ");
            this.arguments.get(i).appendHqlString(sb);
        }
        sb.append(')');
    }
}

