/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.internal.util.QuotingHelper;
import org.hibernate.query.criteria.JpaCastTarget;
import org.hibernate.query.criteria.JpaXmlTableColumnNode;
import org.hibernate.query.criteria.JpaXmlTableFunction;
import org.hibernate.query.derived.AnonymousTupleType;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.function.SelfRenderingSqmSetReturningFunction;
import org.hibernate.query.sqm.function.SetReturningFunctionRenderer;
import org.hibernate.query.sqm.function.SqmSetReturningFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.SetReturningFunctionTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmCastTarget;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.XmlTableColumnDefinition;
import org.hibernate.sql.ast.tree.expression.XmlTableColumnsClause;
import org.hibernate.sql.ast.tree.expression.XmlTableOrdinalityColumnDefinition;
import org.hibernate.sql.ast.tree.expression.XmlTableQueryColumnDefinition;
import org.hibernate.sql.ast.tree.expression.XmlTableValueColumnDefinition;
import org.hibernate.type.BasicType;

public class SqmXmlTableFunction<T>
extends SelfRenderingSqmSetReturningFunction<T>
implements JpaXmlTableFunction {
    private final Columns columns;

    public SqmXmlTableFunction(SqmSetReturningFunctionDescriptor descriptor, SetReturningFunctionRenderer renderer, @Nullable ArgumentsValidator argumentsValidator, SetReturningFunctionTypeResolver setReturningTypeResolver, NodeBuilder nodeBuilder, SqmExpression<String> xpath, SqmExpression<?> document) {
        this(descriptor, renderer, Arrays.asList(xpath, document, null), argumentsValidator, setReturningTypeResolver, nodeBuilder, new ArrayList<ColumnDefinition>());
    }

    private SqmXmlTableFunction(SqmSetReturningFunctionDescriptor descriptor, SetReturningFunctionRenderer renderer, List<SqmTypedNode<?>> arguments, @Nullable ArgumentsValidator argumentsValidator, SetReturningFunctionTypeResolver setReturningTypeResolver, NodeBuilder nodeBuilder, ArrayList<ColumnDefinition> columnDefinitions) {
        super(descriptor, renderer, arguments, argumentsValidator, setReturningTypeResolver, nodeBuilder, "xmltable");
        this.columns = new Columns(this, columnDefinitions);
        arguments.set(arguments.size() - 1, this.columns);
    }

    @Override
    public SqmXmlTableFunction<T> copy(SqmCopyContext context) {
        SqmXmlTableFunction existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        List<SqmTypedNode<?>> arguments = this.getArguments();
        ArrayList argumentsCopy = new ArrayList(arguments.size());
        for (int i = 0; i < arguments.size() - 1; ++i) {
            argumentsCopy.add((SqmTypedNode<?>)arguments.get(i).copy(context));
        }
        SqmXmlTableFunction<T> tableFunction = new SqmXmlTableFunction<T>(this.getFunctionDescriptor(), this.getFunctionRenderer(), argumentsCopy, this.getArgumentsValidator(), this.getSetReturningTypeResolver(), this.nodeBuilder(), this.columns.columnDefinitions);
        context.registerCopy(this, tableFunction);
        tableFunction.columns.columnDefinitions.ensureCapacity(this.columns.columnDefinitions.size());
        for (ColumnDefinition columnDefinition : this.columns.columnDefinitions) {
            tableFunction.columns.columnDefinitions.add(columnDefinition.copy(context));
        }
        return tableFunction;
    }

    @Override
    protected List<SqlAstNode> resolveSqlAstArguments(List<? extends SqmTypedNode<?>> sqmArguments, SqmToSqlAstConverter walker) {
        List<SqlAstNode> sqlAstNodes = super.resolveSqlAstArguments(sqmArguments, walker);
        sqlAstNodes.remove(sqlAstNodes.size() - 1);
        ArrayList<XmlTableColumnDefinition> definitions = new ArrayList<XmlTableColumnDefinition>(this.columns.columnDefinitions.size());
        for (ColumnDefinition columnDefinition : this.columns.columnDefinitions) {
            definitions.add(columnDefinition.convertToSqlAst(walker));
        }
        sqlAstNodes.add(new XmlTableColumnsClause(definitions));
        return sqlAstNodes;
    }

    @Override
    public JpaXmlTableColumnNode<String> queryColumn(String columnName) {
        return this.queryColumn(columnName, null);
    }

    @Override
    public JpaXmlTableColumnNode<String> queryColumn(String columnName, @Nullable String xpath) {
        QueryColumnDefinition definition = new QueryColumnDefinition(this, columnName, this.nodeBuilder().getTypeConfiguration().getBasicTypeRegistry().resolve(String.class, 2009), xpath);
        this.columns.addColumn(definition);
        return definition;
    }

    @Override
    public <X> JpaXmlTableColumnNode<X> valueColumn(String columnName, Class<X> type) {
        return this.valueColumn(columnName, type, null);
    }

    @Override
    public <X> JpaXmlTableColumnNode<X> valueColumn(String columnName, JpaCastTarget<X> castTarget) {
        return this.valueColumn(columnName, castTarget, null);
    }

    @Override
    public <X> JpaXmlTableColumnNode<X> valueColumn(String columnName, Class<X> type, String xpath) {
        return this.valueColumn(columnName, this.nodeBuilder().castTarget((Class)type), xpath);
    }

    @Override
    public <X> JpaXmlTableColumnNode<X> valueColumn(String columnName, JpaCastTarget<X> castTarget, @Nullable String xpath) {
        ValueColumnDefinition definition = new ValueColumnDefinition(this, columnName, (SqmCastTarget)castTarget, xpath);
        this.columns.addColumn(definition);
        return definition;
    }

    @Override
    public SqmXmlTableFunction<T> ordinalityColumn(String columnName) {
        this.columns.addColumn(new OrdinalityColumnDefinition(columnName, this.nodeBuilder().getLongType()));
        return this;
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("xmltable(");
        this.getArguments().get(0).appendHqlString(sb);
        sb.append(" passing ");
        this.getArguments().get(1).appendHqlString(sb);
        this.columns.appendHqlString(sb);
        sb.append(')');
    }

    private void checkTypeResolved() {
        if (this.isTypeResolved()) {
            throw new IllegalStateException("Type for xmltable function is already resolved. Mutation is not allowed anymore");
        }
    }

    public static final class Columns
    implements SqmTypedNode<Object> {
        private final SqmXmlTableFunction<?> table;
        private final Set<String> columnNames;
        private final ArrayList<ColumnDefinition> columnDefinitions;

        private Columns(SqmXmlTableFunction<?> table, ArrayList<ColumnDefinition> columnDefinitions) {
            this.table = table;
            this.columnDefinitions = columnDefinitions;
            this.columnNames = new HashSet<String>(columnDefinitions.size());
            for (ColumnDefinition columnDefinition : columnDefinitions) {
                this.columnNames.add(columnDefinition.name());
            }
        }

        public AnonymousTupleType<?> createTupleType() {
            if (this.columnDefinitions.isEmpty()) {
                throw new IllegalArgumentException("Couldn't determine types of columns of function 'xmltable'");
            }
            SqmExpressible[] componentTypes = new SqmExpressible[this.columnDefinitions.size()];
            String[] componentNames = new String[this.columnDefinitions.size()];
            int offset = 0;
            for (ColumnDefinition columnDefinition : this.columnDefinitions) {
                offset += columnDefinition.populateTupleType(offset, componentNames, componentTypes);
            }
            assert (offset == componentTypes.length);
            return new AnonymousTupleType(componentTypes, componentNames);
        }

        @Override
        public Columns copy(SqmCopyContext context) {
            ArrayList<ColumnDefinition> definitions = new ArrayList<ColumnDefinition>(this.columnDefinitions.size());
            for (ColumnDefinition columnDefinition : this.columnDefinitions) {
                definitions.add(columnDefinition.copy(context));
            }
            return new Columns(context.getCopy(this.table), definitions);
        }

        private void addColumn(ColumnDefinition columnDefinition) {
            this.table.checkTypeResolved();
            if (!this.columnNames.add(columnDefinition.name())) {
                throw new IllegalStateException("Duplicate column: " + columnDefinition.name());
            }
            this.columnDefinitions.add(columnDefinition);
        }

        @Override
        public void appendHqlString(StringBuilder sb) {
            String separator = " columns ";
            for (ColumnDefinition columnDefinition : this.columnDefinitions) {
                sb.append(separator);
                columnDefinition.appendHqlString(sb);
                separator = ", ";
            }
        }

        @Override
        public @Nullable SqmExpressible<Object> getNodeType() {
            return null;
        }

        @Override
        public NodeBuilder nodeBuilder() {
            return this.table.nodeBuilder();
        }

        @Override
        public <X> X accept(SemanticQueryWalker<X> walker) {
            for (ColumnDefinition columnDefinition : this.columnDefinitions) {
                if (columnDefinition instanceof ValueColumnDefinition) {
                    ValueColumnDefinition definition = (ValueColumnDefinition)columnDefinition;
                    if (definition.defaultExpression == null) continue;
                    definition.defaultExpression.accept(walker);
                    continue;
                }
                if (!(columnDefinition instanceof QueryColumnDefinition)) continue;
                QueryColumnDefinition definition = (QueryColumnDefinition)columnDefinition;
                if (definition.defaultExpression == null) continue;
                definition.defaultExpression.accept(walker);
            }
            return null;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface ColumnDefinition {
        public String name();

        public ColumnDefinition copy(SqmCopyContext var1);

        public XmlTableColumnDefinition convertToSqlAst(SqmToSqlAstConverter var1);

        public void appendHqlString(StringBuilder var1);

        public int populateTupleType(int var1, String[] var2, SqmExpressible<?>[] var3);
    }

    static final class QueryColumnDefinition
    implements ColumnDefinition,
    JpaXmlTableColumnNode<String> {
        private final SqmXmlTableFunction<?> table;
        private final String name;
        private final BasicType<String> type;
        private final @Nullable String xpath;
        private @Nullable SqmExpression<String> defaultExpression;

        QueryColumnDefinition(SqmXmlTableFunction<?> table, String name, BasicType<String> type, @Nullable String xpath) {
            this.table = table;
            this.name = name;
            this.type = type;
            this.xpath = xpath;
        }

        private QueryColumnDefinition(SqmXmlTableFunction<?> table, String name, BasicType<String> type, @Nullable String xpath, @Nullable SqmExpression<String> defaultExpression) {
            this.table = table;
            this.name = name;
            this.type = type;
            this.xpath = xpath;
            this.defaultExpression = defaultExpression;
        }

        @Override
        public ColumnDefinition copy(SqmCopyContext context) {
            return new QueryColumnDefinition((SqmXmlTableFunction<?>)this.table.copy(context), this.name, this.type, this.xpath, (SqmExpression<String>)(this.defaultExpression == null ? null : this.defaultExpression.copy(context)));
        }

        @Override
        public XmlTableColumnDefinition convertToSqlAst(SqmToSqlAstConverter walker) {
            return new XmlTableQueryColumnDefinition(this.name, this.type, this.xpath, this.defaultExpression == null ? null : (Expression)this.defaultExpression.accept(walker));
        }

        @Override
        public JpaXmlTableColumnNode<String> defaultValue(String value) {
            return this.defaultExpression((jakarta.persistence.criteria.Expression<String>)this.table.nodeBuilder().value(value));
        }

        @Override
        public JpaXmlTableColumnNode<String> defaultExpression(jakarta.persistence.criteria.Expression<String> expression) {
            this.table.checkTypeResolved();
            this.defaultExpression = (SqmExpression)expression;
            return this;
        }

        @Override
        public void appendHqlString(StringBuilder sb) {
            sb.append(this.name);
            sb.append(" xml");
            if (this.xpath != null) {
                sb.append(" path ");
                QuotingHelper.appendSingleQuoteEscapedString(sb, this.xpath);
            }
            if (this.defaultExpression != null) {
                sb.append(" default ");
                this.defaultExpression.appendHqlString(sb);
            }
        }

        @Override
        public int populateTupleType(int offset, String[] componentNames, SqmExpressible<?>[] componentTypes) {
            componentNames[offset] = this.name;
            componentTypes[offset] = this.type;
            return 1;
        }

        @Override
        public String name() {
            return this.name;
        }
    }

    static final class ValueColumnDefinition<X>
    implements ColumnDefinition,
    JpaXmlTableColumnNode<X> {
        private final SqmXmlTableFunction<?> table;
        private final String name;
        private final SqmCastTarget<X> type;
        private final @Nullable String xpath;
        private @Nullable SqmExpression<X> defaultExpression;

        ValueColumnDefinition(SqmXmlTableFunction<?> table, String name, SqmCastTarget<X> type, @Nullable String xpath) {
            this.table = table;
            this.name = name;
            this.type = type;
            this.xpath = xpath;
        }

        private ValueColumnDefinition(SqmXmlTableFunction<?> table, String name, SqmCastTarget<X> type, @Nullable String xpath, @Nullable SqmExpression<X> defaultExpression) {
            this.table = table;
            this.name = name;
            this.type = type;
            this.xpath = xpath;
            this.defaultExpression = defaultExpression;
        }

        @Override
        public ColumnDefinition copy(SqmCopyContext context) {
            return new ValueColumnDefinition<X>((SqmXmlTableFunction<?>)this.table.copy(context), this.name, this.type, this.xpath, this.defaultExpression == null ? null : this.defaultExpression.copy(context));
        }

        @Override
        public XmlTableColumnDefinition convertToSqlAst(SqmToSqlAstConverter walker) {
            return new XmlTableValueColumnDefinition(this.name, (CastTarget)this.type.accept(walker), this.xpath, this.defaultExpression == null ? null : (Expression)this.defaultExpression.accept(walker));
        }

        @Override
        public JpaXmlTableColumnNode<X> defaultValue(X value) {
            return this.defaultExpression((jakarta.persistence.criteria.Expression<X>)this.table.nodeBuilder().value(value));
        }

        @Override
        public JpaXmlTableColumnNode<X> defaultExpression(jakarta.persistence.criteria.Expression<X> expression) {
            this.table.checkTypeResolved();
            this.defaultExpression = (SqmExpression)expression;
            return this;
        }

        @Override
        public void appendHqlString(StringBuilder sb) {
            sb.append(this.name);
            sb.append(' ');
            this.type.appendHqlString(sb);
            if (this.xpath != null) {
                sb.append(" path ");
                QuotingHelper.appendSingleQuoteEscapedString(sb, this.xpath);
            }
            if (this.defaultExpression != null) {
                sb.append(" default ");
                this.defaultExpression.appendHqlString(sb);
            }
        }

        @Override
        public int populateTupleType(int offset, String[] componentNames, SqmExpressible<?>[] componentTypes) {
            componentNames[offset] = this.name;
            componentTypes[offset] = this.type.getNodeType();
            return 1;
        }

        @Override
        public String name() {
            return this.name;
        }
    }

    record OrdinalityColumnDefinition(String name, BasicType<Long> type) implements ColumnDefinition
    {
        @Override
        public ColumnDefinition copy(SqmCopyContext context) {
            return this;
        }

        @Override
        public XmlTableColumnDefinition convertToSqlAst(SqmToSqlAstConverter walker) {
            return new XmlTableOrdinalityColumnDefinition(this.name);
        }

        @Override
        public void appendHqlString(StringBuilder sb) {
            sb.append(this.name);
            sb.append(" for ordinality");
        }

        @Override
        public int populateTupleType(int offset, String[] componentNames, SqmExpressible<?>[] componentTypes) {
            componentNames[offset] = this.name;
            componentTypes[offset] = this.type;
            return 1;
        }
    }
}

