/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.insert;

import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.EntityType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Incubating;
import org.hibernate.query.criteria.JpaConflictClause;
import org.hibernate.query.criteria.JpaCriteriaInsertSelect;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.ValueBindJpaCriteriaParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.AbstractSqmInsertStatement;
import org.hibernate.query.sqm.tree.insert.SqmConflictClause;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;

@Incubating
public class SqmInsertSelectStatement<T>
extends AbstractSqmInsertStatement<T>
implements JpaCriteriaInsertSelect<T> {
    private SqmQueryPart<?> selectQueryPart;

    public SqmInsertSelectStatement(SqmRoot<T> targetRoot, NodeBuilder nodeBuilder) {
        super(targetRoot, SqmQuerySource.HQL, nodeBuilder);
        this.selectQueryPart = new SqmQuerySpec(nodeBuilder);
    }

    public SqmInsertSelectStatement(Class<T> targetEntity, NodeBuilder nodeBuilder) {
        super(new SqmRoot(nodeBuilder.getDomainModel().entity(targetEntity), null, false, nodeBuilder), SqmQuerySource.CRITERIA, nodeBuilder);
        this.selectQueryPart = new SqmQuerySpec(nodeBuilder);
    }

    private SqmInsertSelectStatement(NodeBuilder builder, SqmQuerySource querySource, Set<SqmParameter<?>> parameters, Map<String, SqmCteStatement<?>> cteStatements, SqmRoot<T> target, List<SqmPath<?>> insertionTargetPaths, SqmConflictClause<T> conflictClause, SqmQueryPart<?> selectQueryPart) {
        super(builder, querySource, parameters, cteStatements, target, insertionTargetPaths, conflictClause);
        this.selectQueryPart = selectQueryPart;
    }

    @Override
    public SqmInsertSelectStatement<T> copy(SqmCopyContext context) {
        SqmInsertSelectStatement existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        return context.registerCopy(this, new SqmInsertSelectStatement<T>(this.nodeBuilder(), context.getQuerySource() == null ? this.getQuerySource() : context.getQuerySource(), this.copyParameters(context), this.copyCteStatements(context), ((SqmRoot)this.getTarget()).copy(context), this.copyInsertionTargetPaths(context), this.getConflictClause() == null ? null : ((SqmConflictClause)this.getConflictClause()).copy(context), (SqmQueryPart<?>)this.selectQueryPart.copy(context)));
    }

    @Override
    public void validate(@Nullable String hql) {
        List<SqmPath<?>> insertionTargetPaths = this.getInsertionTargetPaths();
        List<SqmSelectableNode<?>> selections = this.getSelectQueryPart().getFirstQuerySpec().getSelectClause().getSelectionItems();
        this.verifyInsertTypesMatch(insertionTargetPaths, selections);
        this.getSelectQueryPart().validateQueryStructureAndFetchOwners();
    }

    @Override
    public SqmInsertSelectStatement<T> select(CriteriaQuery<Tuple> criteriaQuery) {
        SqmSelectStatement selectStatement = (SqmSelectStatement)criteriaQuery;
        this.putAllCtes(selectStatement);
        this.setSelectQueryPart((SqmQueryPart<?>)selectStatement.getQueryPart());
        return this;
    }

    public SqmQueryPart<?> getSelectQueryPart() {
        return this.selectQueryPart;
    }

    public void setSelectQueryPart(SqmQueryPart<?> selectQueryPart) {
        this.selectQueryPart = selectQueryPart;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitInsertSelectStatement(this);
    }

    @Override
    public <U> Subquery<U> subquery(EntityType<U> type) {
        throw new UnsupportedOperationException("INSERT cannot be basis for subquery");
    }

    @Override
    public JpaPredicate getRestriction() {
        return null;
    }

    @Override
    public Set<ParameterExpression<?>> getParameters() {
        assert (this.getQuerySource() == SqmQuerySource.CRITERIA);
        return this.getSqmParameters().stream().filter(parameterExpression -> !(parameterExpression instanceof ValueBindJpaCriteriaParameter)).collect(Collectors.toSet());
    }

    @Override
    public SqmInsertSelectStatement<T> setInsertionTargetPaths(Path<?> ... insertionTargetPaths) {
        super.setInsertionTargetPaths((Path[])insertionTargetPaths);
        return this;
    }

    @Override
    public SqmInsertSelectStatement<T> setInsertionTargetPaths(List<? extends Path<?>> insertionTargetPaths) {
        super.setInsertionTargetPaths((List)insertionTargetPaths);
        return this;
    }

    @Override
    public SqmInsertSelectStatement<T> onConflict(JpaConflictClause<T> conflictClause) {
        super.onConflict(conflictClause);
        return this;
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        super.appendHqlString(sb);
        sb.append(' ');
        this.selectQueryPart.appendHqlString(sb);
        JpaConflictClause conflictClause = this.getConflictClause();
        if (conflictClause != null) {
            ((SqmConflictClause)conflictClause).appendHqlString(sb);
        }
    }
}

