/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.update;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.HibernateException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.ImmutableEntityUpdateQueryHandlingMode;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.JpaCriteriaUpdate;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.internal.SqmCriteriaNodeBuilder;
import org.hibernate.query.sqm.internal.TypecheckUtil;
import org.hibernate.query.sqm.tree.AbstractSqmRestrictedDmlStatement;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPolymorphicRootDescriptor;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.query.sqm.tree.update.SqmAssignment;
import org.hibernate.query.sqm.tree.update.SqmSetClause;

public class SqmUpdateStatement<T>
extends AbstractSqmRestrictedDmlStatement<T>
implements SqmDeleteOrUpdateStatement<T>,
JpaCriteriaUpdate<T> {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(SqmUpdateStatement.class);
    private boolean versioned;
    private SqmSetClause setClause;

    public SqmUpdateStatement(NodeBuilder nodeBuilder) {
        super(SqmQuerySource.HQL, nodeBuilder);
    }

    @Deprecated(forRemoval=true)
    public SqmUpdateStatement(SqmRoot<T> target, NodeBuilder nodeBuilder) {
        super(target, SqmQuerySource.HQL, nodeBuilder);
    }

    @Deprecated(forRemoval=true)
    public SqmUpdateStatement(SqmRoot<T> target, SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        super(target, querySource, nodeBuilder);
    }

    public SqmUpdateStatement(Class<T> targetEntity, SqmCriteriaNodeBuilder nodeBuilder) {
        super(new SqmRoot(nodeBuilder.getDomainModel().entity(targetEntity), null, !nodeBuilder.isJpaQueryComplianceEnabled(), (NodeBuilder)nodeBuilder), SqmQuerySource.CRITERIA, (NodeBuilder)nodeBuilder);
    }

    public SqmUpdateStatement(NodeBuilder builder, SqmQuerySource querySource, Set<SqmParameter<?>> parameters, Map<String, SqmCteStatement<?>> cteStatements, SqmRoot<T> target) {
        super(builder, querySource, parameters, cteStatements, target);
    }

    @Override
    public SqmUpdateStatement<T> copy(SqmCopyContext context) {
        SqmUpdateStatement existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmUpdateStatement<T> statement = context.registerCopy(this, new SqmUpdateStatement<T>(this.nodeBuilder(), context.getQuerySource() == null ? this.getQuerySource() : context.getQuerySource(), this.copyParameters(context), this.copyCteStatements(context), ((SqmRoot)this.getTarget()).copy(context)));
        statement.setWhereClause(this.copyWhereClause(context));
        statement.versioned = this.versioned;
        if (this.setClause != null) {
            statement.setClause = this.setClause.copy(context);
        }
        return statement;
    }

    @Override
    public void validate(@Nullable String hql) {
        this.verifyImmutableEntityUpdate(hql);
        if (this.getSetClause() == null || this.getSetClause().getAssignments().isEmpty()) {
            throw new IllegalArgumentException("No assignments specified as part of UPDATE criteria");
        }
        this.verifyUpdateTypesMatch();
    }

    private void verifyImmutableEntityUpdate(String hql) {
        EntityPersister persister = this.nodeBuilder().getMappingMetamodel().getEntityDescriptor(((SqmRoot)this.getTarget()).getEntityName());
        if (!persister.isMutable()) {
            ImmutableEntityUpdateQueryHandlingMode mode = this.nodeBuilder().getImmutableEntityUpdateQueryHandlingMode();
            String querySpaces = Arrays.toString(persister.getQuerySpaces());
            switch (mode) {
                case WARNING: {
                    LOG.immutableEntityUpdateQuery(hql, querySpaces);
                    break;
                }
                case EXCEPTION: {
                    throw new HibernateException("The query attempts to update an immutable entity: " + querySpaces);
                }
                default: {
                    throw new UnsupportedOperationException("The " + mode + " is not supported");
                }
            }
        }
    }

    private void verifyUpdateTypesMatch() {
        List<SqmAssignment<?>> assignments = this.getSetClause().getAssignments();
        for (int i = 0; i < assignments.size(); ++i) {
            SqmAssignment<?> assignment = assignments.get(i);
            SqmPath<?> targetPath = assignment.getTargetPath();
            SqmExpression<?> expression = assignment.getValue();
            TypecheckUtil.assertAssignable(null, targetPath, expression, this.nodeBuilder());
        }
    }

    public SqmSetClause getSetClause() {
        return this.setClause;
    }

    public void setSetClause(SqmSetClause setClause) {
        this.setClause = setClause;
    }

    @Override
    public <Y, X extends Y> SqmUpdateStatement<T> set(SingularAttribute<? super T, Y> attribute, X value) {
        this.applyAssignment((SqmPath<Y>)((AbstractSqmPath)((Object)this.getTarget())).get((SingularAttribute)attribute), (SqmExpression)this.nodeBuilder().value(value));
        return this;
    }

    @Override
    public <Y> SqmUpdateStatement<T> set(SingularAttribute<? super T, Y> attribute, Expression<? extends Y> value) {
        this.applyAssignment((SqmPath<Y>)((AbstractSqmPath)((Object)this.getTarget())).get((SingularAttribute)attribute), (SqmExpression)value);
        return this;
    }

    @Override
    public <Y, X extends Y> SqmUpdateStatement<T> set(Path<Y> attribute, X value) {
        SqmCriteriaNodeBuilder nodeBuilder = (SqmCriteriaNodeBuilder)this.nodeBuilder();
        SqmPath sqmAttribute = (SqmPath)attribute;
        this.applyAssignment(sqmAttribute, nodeBuilder.value(value, sqmAttribute));
        return this;
    }

    @Override
    public <Y> SqmUpdateStatement<T> set(Path<Y> attribute, Expression<? extends Y> value) {
        this.applyAssignment((SqmPath)attribute, (SqmExpression)value);
        return this;
    }

    @Override
    public SqmUpdateStatement<T> set(String attributeName, Object value) {
        SqmExpression<Object> expression;
        JpaPath sqmPath = ((AbstractSqmPath)((Object)this.getTarget())).get(attributeName);
        if (value instanceof SqmExpression) {
            expression = (SqmExpression<Object>)value;
        } else {
            SqmCriteriaNodeBuilder nodeBuilder = (SqmCriteriaNodeBuilder)this.nodeBuilder();
            expression = nodeBuilder.value(value, sqmPath);
        }
        this.applyAssignment((SqmPath)sqmPath, (SqmExpression)expression);
        return this;
    }

    @Override
    public boolean isVersioned() {
        return this.versioned;
    }

    @Override
    public SqmUpdateStatement<T> versioned() {
        this.versioned = true;
        return this;
    }

    @Override
    public SqmUpdateStatement<T> versioned(boolean versioned) {
        this.versioned = versioned;
        return this;
    }

    @Override
    public void setTarget(JpaRoot<T> root) {
        if (root.getModel() instanceof SqmPolymorphicRootDescriptor) {
            throw new SemanticException(String.format("Target type '%s' is not an entity", root.getModel().getHibernateEntityName()));
        }
        super.setTarget(root);
    }

    @Override
    public SqmUpdateStatement<T> where(Expression<Boolean> restriction) {
        this.setWhere(restriction);
        return this;
    }

    @Override
    public SqmUpdateStatement<T> where(Predicate ... restrictions) {
        this.setWhere(restrictions);
        return this;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitUpdateStatement(this);
    }

    @Override
    public <U> SqmSubQuery<U> subquery(EntityType<U> type) {
        return new SqmSubQuery<U>(this, type, this.nodeBuilder());
    }

    public <Y> void applyAssignment(SqmPath<Y> targetPath, SqmExpression<? extends Y> value) {
        this.applyAssignment(new SqmAssignment<Y>(targetPath, value));
    }

    public <Y> void applyAssignment(SqmAssignment<Y> assignment) {
        if (this.setClause == null) {
            this.setClause = new SqmSetClause();
        }
        this.setClause.addAssignment(assignment);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        this.appendHqlCteString(sb);
        sb.append("update ");
        if (this.versioned) {
            sb.append("versioned ");
        }
        JpaRoot root = this.getTarget();
        sb.append(((SqmRoot)root).getEntityName());
        sb.append(' ').append(root.resolveAlias());
        SqmFromClause.appendJoins(root, sb);
        SqmFromClause.appendTreatJoins(root, sb);
        this.setClause.appendHqlString(sb);
        super.appendHqlString(sb);
    }
}

