/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.beans.internal;

import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.resource.beans.container.internal.ContainerManagedLifecycleStrategy;
import org.hibernate.resource.beans.container.internal.JpaCompliantLifecycleStrategy;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.container.spi.BeanLifecycleStrategy;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.service.ServiceRegistry;

public final class Helper {
    private Helper() {
    }

    public static String determineBeanCacheKey(Class<?> beanType) {
        return beanType.getName();
    }

    public static String determineBeanCacheKey(String name, Class<?> beanType) {
        return beanType.getName() + ":" + name;
    }

    public static boolean allowExtensionsInCdi(ServiceRegistry serviceRegistry) {
        return serviceRegistry.requireService(ConfigurationService.class).getSetting("hibernate.cdi.extensions", StandardConverters.BOOLEAN, Boolean.valueOf(false));
    }

    public static BeanLifecycleStrategy getLifecycleStrategy(boolean shouldRegistryManageLifecycle) {
        return shouldRegistryManageLifecycle ? JpaCompliantLifecycleStrategy.INSTANCE : ContainerManagedLifecycleStrategy.INSTANCE;
    }

    public static @Nullable BeanContainer getBeanContainer(ServiceRegistry serviceRegistry) {
        return Helper.allowExtensionsInCdi(serviceRegistry) ? serviceRegistry.requireService(ManagedBeanRegistry.class).getBeanContainer() : null;
    }

    public static <T> @Nullable T getBean(@Nullable BeanContainer beanContainer, Class<?> beanType, final boolean canUseCachedReferences, final boolean useJpaCompliantCreation, final @Nullable Supplier<T> fallbackSupplier) {
        if (beanContainer == null) {
            return null;
        }
        return (T)beanContainer.getBean(beanType, new BeanContainer.LifecycleOptions(){

            @Override
            public boolean canUseCachedReferences() {
                return canUseCachedReferences;
            }

            @Override
            public boolean useJpaCompliantCreation() {
                return useJpaCompliantCreation;
            }
        }, new BeanInstanceProducer(){

            @Override
            public <B> B produceBeanInstance(Class<B> beanType) {
                return fallbackSupplier != null ? (B)fallbackSupplier.get() : null;
            }

            @Override
            public <B> B produceBeanInstance(String name, Class<B> beanType) {
                throw new UnsupportedOperationException("The method shouldn't be called");
            }
        }).getBeanInstance();
    }
}

