/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.spi;

import java.util.List;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.FetchingScrollableResultsImpl;
import org.hibernate.internal.ScrollableResultsImpl;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.entity.EntityResult;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.ResultsConsumer;
import org.hibernate.sql.results.spi.RowReader;

public class ScrollableResultsConsumer<R>
implements ResultsConsumer<ScrollableResultsImplementor<R>, R> {
    @Deprecated(forRemoval=true)
    public static final ScrollableResultsConsumer INSTANCE = new ScrollableResultsConsumer();

    public static <R> ScrollableResultsConsumer<R> instance() {
        return INSTANCE;
    }

    @Override
    public ScrollableResultsImplementor<R> consume(JdbcValues jdbcValues, SharedSessionContractImplementor session, JdbcValuesSourceProcessingOptions processingOptions, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, RowProcessingStateStandardImpl rowProcessingState, RowReader<R> rowReader) {
        rowReader.startLoading(rowProcessingState);
        if (this.containsCollectionFetches(jdbcValues.getValuesMapping())) {
            return new FetchingScrollableResultsImpl<R>(jdbcValues, processingOptions, jdbcValuesSourceProcessingState, rowProcessingState, rowReader, session);
        }
        return new ScrollableResultsImpl<R>(jdbcValues, processingOptions, jdbcValuesSourceProcessingState, rowProcessingState, rowReader, session);
    }

    @Override
    public boolean canResultsBeCached() {
        return false;
    }

    private boolean containsCollectionFetches(JdbcValuesMapping valuesMapping) {
        List<DomainResult<?>> domainResults = valuesMapping.getDomainResults();
        for (DomainResult<?> domainResult : domainResults) {
            if (!(domainResult instanceof EntityResult) || !((EntityResult)domainResult).containsCollectionFetches()) continue;
            return true;
        }
        return false;
    }
}

