/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat.internal;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.spi.CacheImplementor;
import org.hibernate.cache.spi.QueryResultsCache;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.Region;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.service.Service;
import org.hibernate.stat.internal.CacheRegionStatisticsImpl;
import org.hibernate.stat.internal.CollectionStatisticsImpl;
import org.hibernate.stat.internal.EntityStatisticsImpl;
import org.hibernate.stat.internal.NaturalIdStatisticsImpl;
import org.hibernate.stat.internal.QueryStatisticsImpl;
import org.hibernate.stat.internal.StatsNamedContainer;
import org.hibernate.stat.spi.StatisticsImplementor;

public class StatisticsImpl
implements StatisticsImplementor,
Service {
    private static final @UnknownKeyFor @NonNull @Initialized CoreMessageLogger log = CoreLogging.messageLogger(StatisticsImpl.class);
    private final @UnknownKeyFor @NonNull @Initialized MappingMetamodelImplementor metamodel;
    private final @UnknownKeyFor @NonNull @Initialized CacheImplementor cache;
    private final @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] allEntityNames;
    private final @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] allCollectionRoles;
    private final @UnknownKeyFor @NonNull @Initialized boolean secondLevelCacheEnabled;
    private final @UnknownKeyFor @NonNull @Initialized boolean queryCacheEnabled;
    private volatile @UnknownKeyFor @NonNull @Initialized boolean isStatisticsEnabled;
    private volatile @UnknownKeyFor @NonNull @Initialized Instant startTime;
    private final @UnknownKeyFor @NonNull @Initialized LongAdder sessionOpenCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder sessionCloseCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder flushCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder connectCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder prepareStatementCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder closeStatementCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder entityLoadCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder entityUpdateCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder entityInsertCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder entityDeleteCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder entityFetchCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder collectionLoadCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder collectionUpdateCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder collectionRemoveCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder collectionRecreateCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder collectionFetchCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder secondLevelCacheHitCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder secondLevelCacheMissCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder secondLevelCachePutCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder naturalIdCacheHitCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder naturalIdCacheMissCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder naturalIdCachePutCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder naturalIdQueryExecutionCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized AtomicLong naturalIdQueryExecutionMaxTime = new AtomicLong();
    private volatile @Nullable @UnknownKeyFor @Initialized String naturalIdQueryExecutionMaxTimeRegion;
    private volatile @Nullable @UnknownKeyFor @Initialized String naturalIdQueryExecutionMaxTimeEntity;
    private final @UnknownKeyFor @NonNull @Initialized LongAdder queryExecutionCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized AtomicLong queryExecutionMaxTime = new AtomicLong();
    private volatile @Nullable @UnknownKeyFor @Initialized String queryExecutionMaxTimeQueryString;
    private final @UnknownKeyFor @NonNull @Initialized LongAdder queryCacheHitCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder queryCacheMissCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder queryCachePutCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder queryPlanCacheHitCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder queryPlanCacheMissCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder updateTimestampsCacheHitCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder updateTimestampsCacheMissCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder updateTimestampsCachePutCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder committedTransactionCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder transactionCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder optimisticFailureCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized StatsNamedContainer<@UnknownKeyFor @NonNull @Initialized EntityStatisticsImpl> entityStatsMap = new StatsNamedContainer();
    private final @UnknownKeyFor @NonNull @Initialized StatsNamedContainer<@UnknownKeyFor @NonNull @Initialized NaturalIdStatisticsImpl> naturalIdQueryStatsMap = new StatsNamedContainer();
    private final @UnknownKeyFor @NonNull @Initialized StatsNamedContainer<@UnknownKeyFor @NonNull @Initialized CollectionStatisticsImpl> collectionStatsMap = new StatsNamedContainer();
    private final @UnknownKeyFor @NonNull @Initialized StatsNamedContainer<@UnknownKeyFor @NonNull @Initialized QueryStatisticsImpl> queryStatsMap;
    private final @UnknownKeyFor @NonNull @Initialized StatsNamedContainer<@UnknownKeyFor @NonNull @Initialized CacheRegionStatisticsImpl> l2CacheStatsMap = new StatsNamedContainer();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long> slowQueries = new ConcurrentHashMap<String, Long>();

    public StatisticsImpl(@UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor sessionFactory) {
        Objects.requireNonNull(sessionFactory);
        SessionFactoryOptions sessionFactoryOptions = sessionFactory.getSessionFactoryOptions();
        this.queryStatsMap = new StatsNamedContainer(sessionFactoryOptions.getQueryStatisticsMaxSize(), 20);
        this.resetStart();
        this.metamodel = sessionFactory.getRuntimeMetamodels().getMappingMetamodel();
        this.cache = sessionFactory.getCache();
        this.secondLevelCacheEnabled = sessionFactoryOptions.isSecondLevelCacheEnabled();
        this.queryCacheEnabled = sessionFactoryOptions.isQueryCacheEnabled();
        ArrayList entityNames = new ArrayList();
        this.metamodel.forEachEntityDescriptor(entityDescriptor -> entityNames.add(entityDescriptor.getEntityName()));
        this.allEntityNames = entityNames.toArray(new String[0]);
        ArrayList collectionRoles = new ArrayList();
        this.metamodel.forEachCollectionDescriptor(collectionDescriptor -> collectionRoles.add(collectionDescriptor.getRole()));
        this.allCollectionRoles = collectionRoles.toArray(new String[0]);
    }

    @Override
    public void clear() {
        this.secondLevelCacheHitCount.reset();
        this.secondLevelCacheMissCount.reset();
        this.secondLevelCachePutCount.reset();
        this.naturalIdCacheHitCount.reset();
        this.naturalIdCacheMissCount.reset();
        this.naturalIdCachePutCount.reset();
        this.naturalIdQueryExecutionCount.reset();
        this.naturalIdQueryExecutionMaxTime.set(0L);
        this.naturalIdQueryExecutionMaxTimeRegion = null;
        this.naturalIdQueryExecutionMaxTimeEntity = null;
        this.sessionCloseCount.reset();
        this.sessionOpenCount.reset();
        this.flushCount.reset();
        this.connectCount.reset();
        this.prepareStatementCount.reset();
        this.closeStatementCount.reset();
        this.entityDeleteCount.reset();
        this.entityInsertCount.reset();
        this.entityUpdateCount.reset();
        this.entityLoadCount.reset();
        this.entityFetchCount.reset();
        this.collectionRemoveCount.reset();
        this.collectionUpdateCount.reset();
        this.collectionRecreateCount.reset();
        this.collectionLoadCount.reset();
        this.collectionFetchCount.reset();
        this.queryExecutionCount.reset();
        this.queryCacheHitCount.reset();
        this.queryExecutionMaxTime.set(0L);
        this.queryExecutionMaxTimeQueryString = null;
        this.queryCacheMissCount.reset();
        this.queryCachePutCount.reset();
        this.updateTimestampsCacheMissCount.reset();
        this.updateTimestampsCacheHitCount.reset();
        this.updateTimestampsCachePutCount.reset();
        this.transactionCount.reset();
        this.committedTransactionCount.reset();
        this.optimisticFailureCount.reset();
        this.entityStatsMap.clear();
        this.collectionStatsMap.clear();
        this.naturalIdQueryStatsMap.clear();
        this.l2CacheStatsMap.clear();
        this.queryStatsMap.clear();
        this.queryPlanCacheHitCount.reset();
        this.queryPlanCacheMissCount.reset();
        this.resetStart();
    }

    private void resetStart(@UnknownInitialization StatisticsImpl this) {
        this.startTime = Instant.now();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Instant getStart() {
        return this.startTime;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getStartTime() {
        return this.startTime.toEpochMilli();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isStatisticsEnabled() {
        return this.isStatisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(@UnknownKeyFor @NonNull @Initialized boolean enabled) {
        this.isStatisticsEnabled = enabled;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] getEntityNames() {
        return this.allEntityNames;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized EntityStatisticsImpl getEntityStatistics(@UnknownKeyFor @NonNull @Initialized String entityName) {
        return NullnessUtil.castNonNull(this.entityStatsMap.getOrCompute(entityName, this::instantiateEntityStatistics));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getEntityLoadCount() {
        return this.entityLoadCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getEntityFetchCount() {
        return this.entityFetchCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getEntityDeleteCount() {
        return this.entityDeleteCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getEntityInsertCount() {
        return this.entityInsertCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getEntityUpdateCount() {
        return this.entityUpdateCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getOptimisticFailureCount() {
        return this.optimisticFailureCount.sum();
    }

    @Override
    public void loadEntity(@UnknownKeyFor @NonNull @Initialized String entityName) {
        this.entityLoadCount.increment();
        this.getEntityStatistics(entityName).incrementLoadCount();
    }

    @Override
    public void fetchEntity(@UnknownKeyFor @NonNull @Initialized String entityName) {
        this.entityFetchCount.increment();
        this.getEntityStatistics(entityName).incrementFetchCount();
    }

    @Override
    public void updateEntity(@UnknownKeyFor @NonNull @Initialized String entityName) {
        this.entityUpdateCount.increment();
        this.getEntityStatistics(entityName).incrementUpdateCount();
    }

    @Override
    public void insertEntity(@UnknownKeyFor @NonNull @Initialized String entityName) {
        this.entityInsertCount.increment();
        this.getEntityStatistics(entityName).incrementInsertCount();
    }

    @Override
    public void deleteEntity(@UnknownKeyFor @NonNull @Initialized String entityName) {
        this.entityDeleteCount.increment();
        this.getEntityStatistics(entityName).incrementDeleteCount();
    }

    @Override
    public void optimisticFailure(@UnknownKeyFor @NonNull @Initialized String entityName) {
        this.optimisticFailureCount.increment();
        this.getEntityStatistics(entityName).incrementOptimisticFailureCount();
    }

    @Override
    public void entityCachePut(@UnknownKeyFor @NonNull @Initialized NavigableRole entityName, @UnknownKeyFor @NonNull @Initialized String regionName) {
        this.secondLevelCachePutCount.increment();
        this.getDomainDataRegionStatistics(regionName).incrementPutCount();
        this.getEntityStatistics(entityName.getFullPath()).incrementCachePutCount();
    }

    @Override
    public void entityCacheHit(@UnknownKeyFor @NonNull @Initialized NavigableRole entityName, @UnknownKeyFor @NonNull @Initialized String regionName) {
        this.secondLevelCacheHitCount.increment();
        this.getDomainDataRegionStatistics(regionName).incrementHitCount();
        this.getEntityStatistics(entityName.getFullPath()).incrementCacheHitCount();
    }

    @Override
    public void entityCacheMiss(@UnknownKeyFor @NonNull @Initialized NavigableRole entityName, @UnknownKeyFor @NonNull @Initialized String regionName) {
        this.secondLevelCacheMissCount.increment();
        this.getDomainDataRegionStatistics(regionName).incrementMissCount();
        this.getEntityStatistics(entityName.getFullPath()).incrementCacheMissCount();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] getCollectionRoleNames() {
        return this.allCollectionRoles;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized CollectionStatisticsImpl getCollectionStatistics(@UnknownKeyFor @NonNull @Initialized String role) {
        return NullnessUtil.castNonNull(this.collectionStatsMap.getOrCompute(role, this::instantiateCollectionStatistics));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getCollectionLoadCount() {
        return this.collectionLoadCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getCollectionFetchCount() {
        return this.collectionFetchCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getCollectionUpdateCount() {
        return this.collectionUpdateCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getCollectionRemoveCount() {
        return this.collectionRemoveCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getCollectionRecreateCount() {
        return this.collectionRecreateCount.sum();
    }

    @Override
    public void loadCollection(@UnknownKeyFor @NonNull @Initialized String role) {
        this.collectionLoadCount.increment();
        this.getCollectionStatistics(role).incrementLoadCount();
    }

    @Override
    public void fetchCollection(@UnknownKeyFor @NonNull @Initialized String role) {
        this.collectionFetchCount.increment();
        this.getCollectionStatistics(role).incrementFetchCount();
    }

    @Override
    public void updateCollection(@UnknownKeyFor @NonNull @Initialized String role) {
        this.collectionUpdateCount.increment();
        this.getCollectionStatistics(role).incrementUpdateCount();
    }

    @Override
    public void recreateCollection(@UnknownKeyFor @NonNull @Initialized String role) {
        this.collectionRecreateCount.increment();
        this.getCollectionStatistics(role).incrementRecreateCount();
    }

    @Override
    public void removeCollection(@UnknownKeyFor @NonNull @Initialized String role) {
        this.collectionRemoveCount.increment();
        this.getCollectionStatistics(role).incrementRemoveCount();
    }

    @Override
    public void collectionCachePut(@UnknownKeyFor @NonNull @Initialized NavigableRole collectionRole, @UnknownKeyFor @NonNull @Initialized String regionName) {
        this.secondLevelCachePutCount.increment();
        this.getDomainDataRegionStatistics(regionName).incrementPutCount();
        this.getCollectionStatistics(collectionRole.getFullPath()).incrementCachePutCount();
    }

    @Override
    public void collectionCacheHit(@UnknownKeyFor @NonNull @Initialized NavigableRole collectionRole, @UnknownKeyFor @NonNull @Initialized String regionName) {
        this.secondLevelCacheHitCount.increment();
        this.getDomainDataRegionStatistics(regionName).incrementHitCount();
        this.getCollectionStatistics(collectionRole.getFullPath()).incrementCacheHitCount();
    }

    @Override
    public void collectionCacheMiss(@UnknownKeyFor @NonNull @Initialized NavigableRole collectionRole, @UnknownKeyFor @NonNull @Initialized String regionName) {
        this.secondLevelCacheMissCount.increment();
        this.getDomainDataRegionStatistics(regionName).incrementMissCount();
        this.getCollectionStatistics(collectionRole.getFullPath()).incrementCacheMissCount();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized NaturalIdStatisticsImpl getNaturalIdStatistics(@UnknownKeyFor @NonNull @Initialized String rootEntityName) {
        return NullnessUtil.castNonNull(this.naturalIdQueryStatsMap.getOrCompute(rootEntityName, this::instantiateNaturalStatistics));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getNaturalIdQueryExecutionCount() {
        return this.naturalIdQueryExecutionCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getNaturalIdQueryExecutionMaxTime() {
        return this.naturalIdQueryExecutionMaxTime.get();
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String getNaturalIdQueryExecutionMaxTimeRegion() {
        return this.naturalIdQueryExecutionMaxTimeRegion;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String getNaturalIdQueryExecutionMaxTimeEntity() {
        return this.naturalIdQueryExecutionMaxTimeEntity;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getNaturalIdCacheHitCount() {
        return this.naturalIdCacheHitCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getNaturalIdCacheMissCount() {
        return this.naturalIdCacheMissCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getNaturalIdCachePutCount() {
        return this.naturalIdCachePutCount.sum();
    }

    @Override
    public void naturalIdCachePut(@UnknownKeyFor @NonNull @Initialized NavigableRole rootEntityName, @UnknownKeyFor @NonNull @Initialized String regionName) {
        this.naturalIdCachePutCount.increment();
        this.getDomainDataRegionStatistics(regionName).incrementPutCount();
        this.getNaturalIdStatistics(rootEntityName.getFullPath()).incrementCachePutCount();
    }

    @Override
    public void naturalIdCacheHit(@UnknownKeyFor @NonNull @Initialized NavigableRole rootEntityName, @UnknownKeyFor @NonNull @Initialized String regionName) {
        this.naturalIdCacheHitCount.increment();
        this.getDomainDataRegionStatistics(regionName).incrementHitCount();
        this.getNaturalIdStatistics(rootEntityName.getFullPath()).incrementCacheHitCount();
    }

    @Override
    public void naturalIdCacheMiss(@UnknownKeyFor @NonNull @Initialized NavigableRole rootEntityName, @UnknownKeyFor @NonNull @Initialized String regionName) {
        this.naturalIdCacheMissCount.increment();
        this.getDomainDataRegionStatistics(regionName).incrementMissCount();
        this.getNaturalIdStatistics(rootEntityName.getFullPath()).incrementCacheMissCount();
    }

    @Override
    public void naturalIdQueryExecuted(@UnknownKeyFor @NonNull @Initialized String rootEntityName, @UnknownKeyFor @NonNull @Initialized long time) {
        boolean isLongestQuery;
        this.naturalIdQueryExecutionCount.increment();
        long old = this.naturalIdQueryExecutionMaxTime.get();
        while ((isLongestQuery = time > old) && !this.naturalIdQueryExecutionMaxTime.compareAndSet(old, time)) {
            old = this.naturalIdQueryExecutionMaxTime.get();
        }
        if (isLongestQuery) {
            this.naturalIdQueryExecutionMaxTimeEntity = rootEntityName;
        }
        EntityPersister rootEntityPersister = this.metamodel.getEntityDescriptor(rootEntityName);
        this.getNaturalIdStatistics(rootEntityName).queryExecuted(time);
        if (isLongestQuery && rootEntityPersister.hasNaturalIdCache()) {
            this.naturalIdQueryExecutionMaxTimeRegion = rootEntityPersister.getNaturalIdCacheAccessStrategy().getRegion().getName();
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] getSecondLevelCacheRegionNames() {
        return this.cache.getCacheRegionNames().toArray(new String[0]);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized CacheRegionStatisticsImpl getDomainDataRegionStatistics(@UnknownKeyFor @NonNull @Initialized String regionName) {
        return NullnessUtil.castNonNull(this.l2CacheStatsMap.getOrCompute(regionName, this::instantiateCacheRegionStatistics));
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized CacheRegionStatisticsImpl getQueryRegionStatistics(@UnknownKeyFor @NonNull @Initialized String regionName) {
        return this.l2CacheStatsMap.getOrCompute(regionName, new Function<String, CacheRegionStatisticsImpl>(){

            @Override
            public @Nullable CacheRegionStatisticsImpl apply(String regionName1) {
                return StatisticsImpl.this.computeQueryRegionStatistics(regionName1);
            }
        });
    }

    private @Nullable @UnknownKeyFor @Initialized CacheRegionStatisticsImpl computeQueryRegionStatistics(@UnknownKeyFor @NonNull @Initialized String regionName) {
        QueryResultsCache regionAccess = this.cache.getQueryResultsCacheStrictly(regionName);
        if (regionAccess == null) {
            return null;
        }
        return new CacheRegionStatisticsImpl(regionAccess.getRegion());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized CacheRegionStatisticsImpl getCacheRegionStatistics(@UnknownKeyFor @NonNull @Initialized String regionName) {
        if (!this.secondLevelCacheEnabled) {
            return null;
        }
        return this.l2CacheStatsMap.getOrCompute(regionName, new Function<String, CacheRegionStatisticsImpl>(){

            @Override
            public @Nullable CacheRegionStatisticsImpl apply(String regionName1) {
                return StatisticsImpl.this.createCacheRegionStatistics(regionName1);
            }
        });
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getSecondLevelCacheHitCount() {
        return this.secondLevelCacheHitCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getSecondLevelCacheMissCount() {
        return this.secondLevelCacheMissCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getSecondLevelCachePutCount() {
        return this.secondLevelCachePutCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getUpdateTimestampsCacheHitCount() {
        return this.updateTimestampsCacheHitCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getUpdateTimestampsCacheMissCount() {
        return this.updateTimestampsCacheMissCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getUpdateTimestampsCachePutCount() {
        return this.updateTimestampsCachePutCount.sum();
    }

    @Override
    public void updateTimestampsCacheHit() {
        this.updateTimestampsCacheHitCount.increment();
    }

    @Override
    public void updateTimestampsCacheMiss() {
        this.updateTimestampsCacheMissCount.increment();
    }

    @Override
    public void updateTimestampsCachePut() {
        this.updateTimestampsCachePutCount.increment();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] getQueries() {
        return this.queryStatsMap.keysAsArray();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized QueryStatisticsImpl getQueryStatistics(@UnknownKeyFor @NonNull @Initialized String queryString) {
        return NullnessUtil.castNonNull(this.queryStatsMap.getOrCompute(queryString, QueryStatisticsImpl::new));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getQueryExecutionCount() {
        return this.queryExecutionCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getQueryCacheHitCount() {
        return this.queryCacheHitCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getQueryCacheMissCount() {
        return this.queryCacheMissCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getQueryCachePutCount() {
        return this.queryCachePutCount.sum();
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String getQueryExecutionMaxTimeQueryString() {
        return this.queryExecutionMaxTimeQueryString;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getQueryExecutionMaxTime() {
        return this.queryExecutionMaxTime.get();
    }

    @Override
    public void queryExecuted(@UnknownKeyFor @NonNull @Initialized String hql, @UnknownKeyFor @NonNull @Initialized int rows, @UnknownKeyFor @NonNull @Initialized long time) {
        boolean isLongestQuery;
        log.hql(hql, time, Long.valueOf(rows));
        this.queryExecutionCount.increment();
        long old = this.queryExecutionMaxTime.get();
        while ((isLongestQuery = time > old) && !this.queryExecutionMaxTime.compareAndSet(old, time)) {
            old = this.queryExecutionMaxTime.get();
        }
        if (isLongestQuery) {
            this.queryExecutionMaxTimeQueryString = hql;
        }
        if (hql != null) {
            this.getQueryStatistics(hql).executed(rows, time);
        }
    }

    @Override
    public void queryCacheHit(@UnknownKeyFor @NonNull @Initialized String hql, @UnknownKeyFor @NonNull @Initialized String regionName) {
        log.tracef("Statistics#queryCacheHit( `%s`, `%s` )", hql, regionName);
        this.queryCacheHitCount.increment();
        this.getQueryRegionStats(regionName).incrementHitCount();
        if (hql != null) {
            this.getQueryStatistics(hql).incrementCacheHitCount();
        }
    }

    @Override
    public void queryCacheMiss(@UnknownKeyFor @NonNull @Initialized String hql, @UnknownKeyFor @NonNull @Initialized String regionName) {
        log.tracef("Statistics#queryCacheMiss( `%s`, `%s` )", hql, regionName);
        this.queryCacheMissCount.increment();
        this.getQueryRegionStats(regionName).incrementMissCount();
        if (hql != null) {
            this.getQueryStatistics(hql).incrementCacheMissCount();
        }
    }

    @Override
    public void queryCachePut(@UnknownKeyFor @NonNull @Initialized String hql, @UnknownKeyFor @NonNull @Initialized String regionName) {
        log.tracef("Statistics#queryCachePut( `%s`, `%s` )", hql, regionName);
        this.queryCachePutCount.increment();
        this.getQueryRegionStats(regionName).incrementPutCount();
        if (hql != null) {
            this.getQueryStatistics(hql).incrementCachePutCount();
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getQueryPlanCacheHitCount() {
        return this.queryPlanCacheHitCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getQueryPlanCacheMissCount() {
        return this.queryPlanCacheMissCount.sum();
    }

    @Override
    public void queryCompiled(@UnknownKeyFor @NonNull @Initialized String hql, @UnknownKeyFor @NonNull @Initialized long microseconds) {
        this.queryPlanCacheMissCount.increment();
        if (hql != null) {
            this.getQueryStatistics(hql).compiled(microseconds);
        }
    }

    @Override
    public void queryPlanCacheHit(@UnknownKeyFor @NonNull @Initialized String query) {
        this.queryPlanCacheHitCount.increment();
        if (query != null) {
            this.getQueryStatistics(query).incrementPlanCacheHitCount();
        }
    }

    @Override
    public void queryPlanCacheMiss(@UnknownKeyFor @NonNull @Initialized String query) {
        this.queryPlanCacheMissCount.increment();
        if (query != null) {
            this.getQueryStatistics(query).incrementPlanCacheMissCount();
        }
    }

    private @UnknownKeyFor @NonNull @Initialized CacheRegionStatisticsImpl getQueryRegionStats(@UnknownKeyFor @NonNull @Initialized String regionName) {
        return NullnessUtil.castNonNull(this.l2CacheStatsMap.getOrCompute(regionName, this::instantiateCacheRegionStatsForQueryResults));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getSessionOpenCount() {
        return this.sessionOpenCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getSessionCloseCount() {
        return this.sessionCloseCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getFlushCount() {
        return this.flushCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getConnectCount() {
        return this.connectCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getSuccessfulTransactionCount() {
        return this.committedTransactionCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getTransactionCount() {
        return this.transactionCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getCloseStatementCount() {
        return this.closeStatementCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getPrepareStatementCount() {
        return this.prepareStatementCount.sum();
    }

    @Override
    public void openSession() {
        this.sessionOpenCount.increment();
    }

    @Override
    public void closeSession() {
        this.sessionCloseCount.increment();
    }

    @Override
    public void flush() {
        this.flushCount.increment();
    }

    @Override
    public void connect() {
        this.connectCount.increment();
    }

    @Override
    public void prepareStatement() {
        this.prepareStatementCount.increment();
    }

    @Override
    public void closeStatement() {
        this.closeStatementCount.increment();
    }

    @Override
    public void endTransaction(@UnknownKeyFor @NonNull @Initialized boolean success) {
        this.transactionCount.increment();
        if (success) {
            this.committedTransactionCount.increment();
        }
    }

    @Override
    public void logSummary() {
        log.logStatistics(this.startTime.toEpochMilli(), this.sessionOpenCount.sum(), this.sessionCloseCount.sum(), this.transactionCount.sum(), this.committedTransactionCount.sum(), this.optimisticFailureCount.sum(), this.flushCount.sum(), this.connectCount.sum(), this.prepareStatementCount.sum(), this.closeStatementCount.sum(), this.secondLevelCachePutCount.sum(), this.secondLevelCacheHitCount.sum(), this.secondLevelCacheMissCount.sum(), this.entityLoadCount.sum(), this.entityFetchCount.sum(), this.entityUpdateCount.sum(), this.entityInsertCount.sum(), this.entityDeleteCount.sum(), this.collectionLoadCount.sum(), this.collectionFetchCount.sum(), this.collectionUpdateCount.sum(), this.collectionRemoveCount.sum(), this.collectionRecreateCount.sum(), this.naturalIdQueryExecutionCount.sum(), this.naturalIdCachePutCount.sum(), this.naturalIdCacheHitCount.sum(), this.naturalIdCacheMissCount.sum(), this.naturalIdQueryExecutionMaxTime.get(), this.queryExecutionCount.sum(), this.queryCachePutCount.sum(), this.queryCacheHitCount.sum(), this.queryCacheMissCount.sum(), this.queryExecutionMaxTime.get(), this.updateTimestampsCachePutCount.sum(), this.updateTimestampsCacheHitCount.sum(), this.updateTimestampsCacheMissCount.sum(), this.queryPlanCacheHitCount.sum(), this.queryPlanCacheMissCount.sum());
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "Statistics[start time=" + this.startTime + ",sessions opened=" + this.sessionOpenCount + ",sessions closed=" + this.sessionCloseCount + ",transactions=" + this.transactionCount + ",successful transactions=" + this.committedTransactionCount + ",optimistic lock failures=" + this.optimisticFailureCount + ",flushes=" + this.flushCount + ",connections obtained=" + this.connectCount + ",statements prepared=" + this.prepareStatementCount + ",statements closed=" + this.closeStatementCount + ",second level cache puts=" + this.secondLevelCachePutCount + ",second level cache hits=" + this.secondLevelCacheHitCount + ",second level cache misses=" + this.secondLevelCacheMissCount + ",entities loaded=" + this.entityLoadCount + ",entities updated=" + this.entityUpdateCount + ",entities inserted=" + this.entityInsertCount + ",entities deleted=" + this.entityDeleteCount + ",entities fetched=" + this.entityFetchCount + ",collections loaded=" + this.collectionLoadCount + ",collections updated=" + this.collectionUpdateCount + ",collections removed=" + this.collectionRemoveCount + ",collections recreated=" + this.collectionRecreateCount + ",collections fetched=" + this.collectionFetchCount + ",naturalId queries executed to database=" + this.naturalIdQueryExecutionCount + ",naturalId cache puts=" + this.naturalIdCachePutCount + ",naturalId cache hits=" + this.naturalIdCacheHitCount + ",naturalId cache misses=" + this.naturalIdCacheMissCount + ",naturalId max query time=" + this.naturalIdQueryExecutionMaxTime + ",queries executed to database=" + this.queryExecutionCount + ",query cache puts=" + this.queryCachePutCount + ",query cache hits=" + this.queryCacheHitCount + ",query cache misses=" + this.queryCacheMissCount + ",update timestamps cache puts=" + this.updateTimestampsCachePutCount + ",update timestamps cache hits=" + this.updateTimestampsCacheHitCount + ",update timestamps cache misses=" + this.updateTimestampsCacheMissCount + ",max query time=" + this.queryExecutionMaxTime + ",query plan cache hits=" + this.queryPlanCacheHitCount + ",query plan cache misses=" + this.queryPlanCacheMissCount + "]";
    }

    private @UnknownKeyFor @NonNull @Initialized EntityStatisticsImpl instantiateEntityStatistics(@UnknownKeyFor @NonNull @Initialized String entityName) {
        return new EntityStatisticsImpl(this.metamodel.getEntityDescriptor(entityName));
    }

    private @UnknownKeyFor @NonNull @Initialized CollectionStatisticsImpl instantiateCollectionStatistics(@UnknownKeyFor @NonNull @Initialized String role) {
        return new CollectionStatisticsImpl(this.metamodel.getCollectionDescriptor(role));
    }

    private @UnknownKeyFor @NonNull @Initialized NaturalIdStatisticsImpl instantiateNaturalStatistics(@UnknownKeyFor @NonNull @Initialized String entityName) {
        EntityPersister entityDescriptor = this.metamodel.getEntityDescriptor(entityName);
        if (!entityDescriptor.hasNaturalIdentifier()) {
            throw new IllegalArgumentException("Given entity [" + entityName + "] does not define natural-id");
        }
        return new NaturalIdStatisticsImpl(entityDescriptor);
    }

    private @UnknownKeyFor @NonNull @Initialized CacheRegionStatisticsImpl instantiateCacheRegionStatistics(@UnknownKeyFor @NonNull @Initialized String regionName) {
        Region region = this.cache.getRegion(regionName);
        if (region == null) {
            throw new IllegalArgumentException("Unknown cache region : " + regionName);
        }
        if (region instanceof QueryResultsRegion) {
            throw new IllegalArgumentException("Region name [" + regionName + "] referred to a query result region, not a domain data region");
        }
        return new CacheRegionStatisticsImpl(region);
    }

    private @UnknownKeyFor @NonNull @Initialized CacheRegionStatisticsImpl instantiateCacheRegionStatsForQueryResults(@UnknownKeyFor @NonNull @Initialized String regionName) {
        return new CacheRegionStatisticsImpl(this.cache.getQueryResultsCache(regionName).getRegion());
    }

    private @Nullable @UnknownKeyFor @Initialized CacheRegionStatisticsImpl createCacheRegionStatistics(@UnknownKeyFor @NonNull @Initialized String regionName) {
        Region region = this.cache.getRegion(regionName);
        if (region == null) {
            if (!this.queryCacheEnabled) {
                return null;
            }
            region = this.cache.getQueryResultsCache(regionName).getRegion();
        }
        return new CacheRegionStatisticsImpl(region);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long> getSlowQueries() {
        return this.slowQueries;
    }

    @Override
    public void slowQuery(@UnknownKeyFor @NonNull @Initialized String sql, @UnknownKeyFor @NonNull @Initialized long executionTime) {
        this.slowQueries.merge(sql, executionTime, Math::max);
    }
}

