/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.collection.spi.PersistentMap;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.CollectionType;

public class MapType
extends CollectionType {
    public MapType(String role, String propertyRef) {
        super(role, propertyRef);
    }

    @Override
    public CollectionClassification getCollectionClassification() {
        return CollectionClassification.MAP;
    }

    @Override
    public PersistentCollection<?> instantiate(SharedSessionContractImplementor session, CollectionPersister persister, Object key) {
        return new PersistentMap(session);
    }

    @Override
    public Class<?> getReturnedClass() {
        return Map.class;
    }

    @Override
    public Iterator<?> getElementsIterator(Object collection) {
        return ((Map)collection).values().iterator();
    }

    @Override
    public PersistentCollection<?> wrap(SharedSessionContractImplementor session, Object collection) {
        return new PersistentMap(session, (Map)collection);
    }

    @Override
    public Object instantiate(int anticipatedSize) {
        return anticipatedSize <= 0 ? new HashMap() : new HashMap(anticipatedSize + (int)((float)anticipatedSize * 0.75f), 0.75f);
    }

    @Override
    public Object replaceElements(Object original, Object target, Object owner, Map<Object, Object> copyCache, SharedSessionContractImplementor session) throws HibernateException {
        CollectionPersister persister = session.getFactory().getRuntimeMetamodels().getMappingMetamodel().getCollectionDescriptor(this.getRole());
        Map source = (Map)original;
        Map result = (Map)target;
        result.clear();
        Iterator iterator = source.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry me = entry = iterator.next();
            Object key = persister.getIndexType().replace(me.getKey(), null, session, owner, copyCache);
            Object value = persister.getElementType().replace(me.getValue(), null, session, owner, copyCache);
            result.put(key, value);
        }
        return result;
    }

    @Override
    public Object indexOf(Object collection, Object element) {
        Map map = (Map)collection;
        for (Map.Entry entry : map.entrySet()) {
            Map.Entry me = entry;
            if (me.getValue() != element) continue;
            return me.getKey();
        }
        return null;
    }
}

