/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.CoercionException;
import org.hibernate.type.descriptor.java.spi.PrimitiveJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class CharacterJavaType
extends AbstractClassJavaType<Character>
implements PrimitiveJavaType<Character> {
    public static final CharacterJavaType INSTANCE = new CharacterJavaType();

    public CharacterJavaType() {
        super(Character.class);
    }

    @Override
    public boolean useObjectEqualsHashCode() {
        return true;
    }

    @Override
    public String toString(Character value) {
        return value.toString();
    }

    @Override
    public Character fromString(CharSequence string) {
        if (string.length() != 1) {
            throw new CoercionException("value must contain exactly one character: '" + string + "'");
        }
        return Character.valueOf(string.charAt(0));
    }

    @Override
    public <X> X unwrap(Character value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Character.class.isAssignableFrom(type) || type == Object.class) {
            return (X)value;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)value.toString();
        }
        if (Number.class.isAssignableFrom(type)) {
            return (X)Short.valueOf((short)value.charValue());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Character wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            Character character = (Character)value;
            return character;
        }
        if (value instanceof String) {
            String string = (String)value;
            switch (string.length()) {
                case 1: {
                    return Character.valueOf(string.charAt(0));
                }
                case 0: {
                    if (options.getDialect().stripsTrailingSpacesFromChar()) {
                        return Character.valueOf(' ');
                    }
                    throw new CoercionException("value does not contain a character: '" + string + "'");
                }
            }
            throw new CoercionException("value contains more than one character: '" + string + "'");
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Character.valueOf((char)number.shortValue());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public Class<?> getPrimitiveClass() {
        return Character.TYPE;
    }

    @Override
    public Class<Character[]> getArrayClass() {
        return Character[].class;
    }

    @Override
    public Class<?> getPrimitiveArrayClass() {
        return char[].class;
    }

    @Override
    public Character getDefaultValue() {
        return Character.valueOf('\u0000');
    }

    @Override
    public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return 1L;
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return 3;
    }

    @Override
    public int getDefaultSqlScale(Dialect dialect, JdbcType jdbcType) {
        return 0;
    }
}

