/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.SQLException;
import org.hibernate.Incubating;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.query.sqm.CastType;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StringBuilderSqlAppender;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.SqlTypes;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.JdbcTypeJavaClassMappings;
import org.hibernate.type.spi.TypeConfiguration;

public interface JdbcType
extends Serializable {
    default public String getFriendlyName() {
        return Integer.toString(this.getDefaultSqlTypeCode());
    }

    public int getJdbcTypeCode();

    default public int getDefaultSqlTypeCode() {
        return this.getJdbcTypeCode();
    }

    default public int getDdlTypeCode() {
        return this.getDefaultSqlTypeCode();
    }

    default public <T> JavaType<T> getJdbcRecommendedJavaTypeMapping(Integer precision, Integer scale, TypeConfiguration typeConfiguration) {
        return typeConfiguration.getJavaTypeRegistry().getDescriptor(JdbcTypeJavaClassMappings.INSTANCE.determineJavaClassForJdbcTypeCode(this.getDefaultSqlTypeCode()));
    }

    default public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return (appender, value, dialect, wrapperOptions) -> appender.appendSql(value.toString());
    }

    public <X> ValueBinder<X> getBinder(JavaType<X> var1);

    public <X> ValueExtractor<X> getExtractor(JavaType<X> var1);

    @Incubating
    default public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
        return null;
    }

    default public String getCheckCondition(String columnName, JavaType<?> javaType, BasicValueConverter<?, ?> converter, Dialect dialect) {
        return null;
    }

    @Incubating
    default public Expression wrapTopLevelSelectionExpression(Expression expression) {
        return expression;
    }

    @Incubating
    default public String wrapWriteExpression(String writeExpression, Dialect dialect) {
        StringBuilder sb = new StringBuilder(writeExpression.length());
        this.appendWriteExpression(writeExpression, new StringBuilderSqlAppender(sb), dialect);
        return sb.toString();
    }

    @Incubating
    default public void appendWriteExpression(String writeExpression, SqlAppender appender, Dialect dialect) {
        appender.append(writeExpression);
    }

    default public boolean isInteger() {
        int typeCode = this.getDdlTypeCode();
        return SqlTypes.isIntegral(typeCode) || typeCode == -7;
    }

    default public boolean isFloat() {
        return SqlTypes.isFloatOrRealOrDouble(this.getDdlTypeCode());
    }

    default public boolean isDecimal() {
        return SqlTypes.isNumericOrDecimal(this.getDdlTypeCode());
    }

    default public boolean isNumber() {
        return SqlTypes.isNumericType(this.getDdlTypeCode());
    }

    default public boolean isBinary() {
        return SqlTypes.isBinaryType(this.getDdlTypeCode());
    }

    default public boolean isString() {
        return SqlTypes.isCharacterOrClobType(this.getDdlTypeCode());
    }

    default public boolean isStringLike() {
        int ddlTypeCode = this.getDdlTypeCode();
        return SqlTypes.isCharacterOrClobType(ddlTypeCode) || SqlTypes.isEnumType(ddlTypeCode);
    }

    default public boolean isTemporal() {
        return SqlTypes.isTemporalType(this.getDdlTypeCode());
    }

    default public boolean isLob() {
        return JdbcType.isLob(this.getDdlTypeCode());
    }

    public static boolean isLob(int jdbcTypeCode) {
        switch (jdbcTypeCode) {
            case 2004: 
            case 2005: 
            case 2011: {
                return true;
            }
        }
        return false;
    }

    default public boolean isLobOrLong() {
        return JdbcType.isLobOrLong(this.getDdlTypeCode());
    }

    public static boolean isLobOrLong(int jdbcTypeCode) {
        switch (jdbcTypeCode) {
            case 2004: 
            case 2005: 
            case 2011: 
            case 4001: 
            case 4002: 
            case 4003: {
                return true;
            }
        }
        return false;
    }

    default public boolean isNationalized() {
        return JdbcType.isNationalized(this.getDdlTypeCode());
    }

    public static boolean isNationalized(int jdbcTypeCode) {
        switch (jdbcTypeCode) {
            case -16: 
            case -15: 
            case -9: 
            case 2011: 
            case 4002: {
                return true;
            }
        }
        return false;
    }

    default public boolean isInterval() {
        return SqlTypes.isIntervalType(this.getDdlTypeCode());
    }

    default public boolean isDuration() {
        int ddlTypeCode = this.getDefaultSqlTypeCode();
        return SqlTypes.isDurationType(ddlTypeCode) || SqlTypes.isIntervalType(ddlTypeCode);
    }

    default public boolean isArray() {
        return JdbcType.isArray(this.getDdlTypeCode());
    }

    public static boolean isArray(int jdbcTypeCode) {
        switch (jdbcTypeCode) {
            case 2003: 
            case 3016: 
            case 3018: 
            case 3019: {
                return true;
            }
        }
        return false;
    }

    default public CastType getCastType() {
        return JdbcType.getCastType(this.getDdlTypeCode());
    }

    public static CastType getCastType(int typeCode) {
        switch (typeCode) {
            case -6: 
            case 4: 
            case 5: {
                return CastType.INTEGER;
            }
            case -5: {
                return CastType.LONG;
            }
            case 6: 
            case 7: {
                return CastType.FLOAT;
            }
            case 8: {
                return CastType.DOUBLE;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return CastType.STRING;
            }
            case 2005: {
                return CastType.CLOB;
            }
            case 16: {
                return CastType.BOOLEAN;
            }
            case 2: 
            case 3: {
                return CastType.FIXED;
            }
            case 91: {
                return CastType.DATE;
            }
            case 92: 
            case 2013: 
            case 3007: {
                return CastType.TIME;
            }
            case 93: {
                return CastType.TIMESTAMP;
            }
            case 2014: {
                return CastType.OFFSET_TIMESTAMP;
            }
            case 3001: 
            case 3018: {
                return CastType.JSON;
            }
            case 2009: 
            case 3019: {
                return CastType.XML;
            }
            case 0: {
                return CastType.NULL;
            }
        }
        return CastType.OTHER;
    }

    default public void registerOutParameter(CallableStatement callableStatement, String name) throws SQLException {
        callableStatement.registerOutParameter(name, this.getJdbcTypeCode());
    }

    default public void registerOutParameter(CallableStatement callableStatement, int index) throws SQLException {
        callableStatement.registerOutParameter(index, this.getJdbcTypeCode());
    }

    @Incubating
    default public void addAuxiliaryDatabaseObjects(JavaType<?> javaType, BasicValueConverter<?, ?> valueConverter, Size columnSize, Database database, JdbcTypeIndicators context) {
    }

    @Incubating
    default public String getExtraCreateTableInfo(JavaType<?> javaType, String columnName, String tableName, Database database) {
        return "";
    }

    @Incubating
    default public boolean isComparable() {
        int code = this.getDefaultSqlTypeCode();
        return SqlTypes.isCharacterType(code) || SqlTypes.isTemporalType(code) || SqlTypes.isNumericType(code) || SqlTypes.isEnumType(code) || this.isBoolean() || code == 3000;
    }

    @Incubating
    default public boolean hasDatePart() {
        return SqlTypes.hasDatePart(this.getDefaultSqlTypeCode());
    }

    @Incubating
    default public boolean hasTimePart() {
        return SqlTypes.hasTimePart(this.getDefaultSqlTypeCode());
    }

    @Incubating
    default public boolean isStringLikeExcludingClob() {
        int code = this.getDefaultSqlTypeCode();
        return SqlTypes.isCharacterType(code) || SqlTypes.isEnumType(code);
    }

    @Incubating
    default public boolean isSpatial() {
        return SqlTypes.isSpatialType(this.getDefaultSqlTypeCode());
    }

    @Incubating
    default public boolean isJson() {
        return SqlTypes.isJsonType(this.getDefaultSqlTypeCode());
    }

    @Incubating
    default public boolean isImplicitJson() {
        return SqlTypes.isImplicitJsonType(this.getDefaultSqlTypeCode());
    }

    @Incubating
    default public boolean isXml() {
        return SqlTypes.isXmlType(this.getDefaultSqlTypeCode());
    }

    @Incubating
    default public boolean isImplicitXml() {
        return SqlTypes.isImplicitXmlType(this.getDefaultSqlTypeCode());
    }

    @Incubating
    default public boolean isBoolean() {
        return this.getDefaultSqlTypeCode() == 16;
    }

    @Incubating
    default public boolean isSmallInteger() {
        return SqlTypes.isSmallOrTinyInt(this.getDefaultSqlTypeCode());
    }
}

