/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.format.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.format.FormatMapper;
import org.hibernate.type.internal.ParameterizedTypeImpl;

public final class JacksonXmlFormatMapper
implements FormatMapper {
    public static final String SHORT_NAME = "jackson-xml";
    private boolean legacyFormat;
    private final ObjectMapper objectMapper;

    public JacksonXmlFormatMapper() {
        this(true);
    }

    public JacksonXmlFormatMapper(boolean legacyFormat) {
        this((ObjectMapper)JacksonXmlFormatMapper.createXmlMapper(legacyFormat));
        this.legacyFormat = legacyFormat;
    }

    public JacksonXmlFormatMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    private static XmlMapper createXmlMapper(boolean legacyFormat) {
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.findAndRegisterModules();
        xmlMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        xmlMapper.enable(ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(String[].class, (JsonDeserializer)new StringArrayDeserializer());
        if (!legacyFormat) {
            module.addDeserializer(byte[].class, (JsonDeserializer)new ByteArrayDeserializer());
            module.addSerializer(byte[].class, (JsonSerializer)new ByteArraySerializer());
        }
        xmlMapper.registerModule((Module)module);
        return xmlMapper;
    }

    @Override
    public <T> T fromString(CharSequence charSequence, JavaType<T> javaType, WrapperOptions wrapperOptions) {
        if (javaType.getJavaType() == String.class || javaType.getJavaType() == Object.class) {
            return (T)charSequence.toString();
        }
        try {
            if (!this.legacyFormat) {
                if (Map.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                    Object elementType;
                    Object keyType;
                    Type type = javaType.getJavaType();
                    if (type instanceof ParameterizedType) {
                        ParameterizedType parameterizedType = (ParameterizedType)type;
                        keyType = parameterizedType.getActualTypeArguments()[0];
                        elementType = parameterizedType.getActualTypeArguments()[1];
                    } else {
                        keyType = Object.class;
                        elementType = Object.class;
                    }
                    MapWrapper collectionWrapper = (MapWrapper)this.objectMapper.readValue(charSequence.toString(), this.objectMapper.constructType((Type)new ParameterizedTypeImpl((Type)((Object)MapWrapper.class), new Type[]{keyType, elementType}, null)));
                    LinkedHashMap map = new LinkedHashMap(collectionWrapper.entry.size());
                    for (EntryWrapper entry : collectionWrapper.entry) {
                        map.put(entry.key, entry.value);
                    }
                    return javaType.wrap(map, wrapperOptions);
                }
                if (Collection.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                    Object object;
                    Type type = javaType.getJavaType();
                    if (type instanceof ParameterizedType) {
                        ParameterizedType parameterizedType = (ParameterizedType)type;
                        object = parameterizedType.getActualTypeArguments()[0];
                    } else {
                        object = Object.class;
                    }
                    Class<Object> elementType = object;
                    CollectionWrapper collectionWrapper = (CollectionWrapper)this.objectMapper.readValue(charSequence.toString(), this.objectMapper.constructType((Type)new ParameterizedTypeImpl((Type)((Object)CollectionWrapper.class), new Type[]{elementType}, null)));
                    return javaType.wrap(collectionWrapper.value, wrapperOptions);
                }
                if (javaType.getJavaTypeClass().isArray()) {
                    CollectionWrapper collectionWrapper = (CollectionWrapper)this.objectMapper.readValue(charSequence.toString(), this.objectMapper.constructType((Type)new ParameterizedTypeImpl((Type)((Object)CollectionWrapper.class), new Type[]{javaType.getJavaTypeClass().getComponentType()}, null)));
                    return javaType.wrap(collectionWrapper.value, wrapperOptions);
                }
            }
            return (T)this.objectMapper.readValue(charSequence.toString(), this.objectMapper.constructType(javaType.getJavaType()));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not deserialize string to java type: " + javaType, e);
        }
    }

    @Override
    public <T> String toString(T value, JavaType<T> javaType, WrapperOptions wrapperOptions) {
        if (javaType.getJavaType() == String.class || javaType.getJavaType() == Object.class) {
            return (String)value;
        }
        if (!this.legacyFormat) {
            if (Map.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                Object elementType;
                Object keyType;
                Type type = javaType.getJavaType();
                if (type instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)type;
                    keyType = parameterizedType.getActualTypeArguments()[0];
                    elementType = parameterizedType.getActualTypeArguments()[1];
                } else {
                    keyType = Object.class;
                    elementType = Object.class;
                }
                MapWrapper mapWrapper = new MapWrapper();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    mapWrapper.entry.add(new EntryWrapper(entry.getKey(), entry.getValue()));
                }
                return this.writeValueAsString(mapWrapper, javaType, new ParameterizedTypeImpl((Type)((Object)MapWrapper.class), new Type[]{keyType, elementType}, null));
            }
            if (Collection.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                Object object;
                Type mapWrapper = javaType.getJavaType();
                if (mapWrapper instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)mapWrapper;
                    object = parameterizedType.getActualTypeArguments()[0];
                } else {
                    object = Object.class;
                }
                Class<Object> elementType = object;
                return this.writeValueAsString(new CollectionWrapper((Collection)value), javaType, new ParameterizedTypeImpl((Type)((Object)CollectionWrapper.class), new Type[]{elementType}, null));
            }
            if (javaType.getJavaTypeClass().isArray()) {
                CollectionWrapper<Object> collectionWrapper;
                if (Object[].class.isAssignableFrom(javaType.getJavaTypeClass())) {
                    collectionWrapper = new CollectionWrapper<Object>(Arrays.asList((Object[])value));
                } else {
                    int length = Array.getLength(value);
                    ArrayList<Object> list = new ArrayList<Object>(length);
                    for (int i = 0; i < length; ++i) {
                        list.add(Array.get(value, i));
                    }
                    collectionWrapper = new CollectionWrapper(list);
                }
                return this.writeValueAsString(collectionWrapper, javaType, new ParameterizedTypeImpl((Type)((Object)CollectionWrapper.class), new Type[]{javaType.getJavaTypeClass().getComponentType()}, null));
            }
        }
        return this.writeValueAsString(value, javaType, javaType.getJavaType());
    }

    private <T> String writeValueAsString(Object value, JavaType<T> javaType, Type type) {
        try {
            return this.objectMapper.writerFor(this.objectMapper.constructType(type)).writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not serialize object of java type: " + javaType, e);
        }
    }

    private static class StringArrayDeserializer
    extends JsonDeserializer<String[]> {
        private StringArrayDeserializer() {
        }

        public String[] deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
            JsonToken token;
            ArrayList<String> result = new ArrayList<String>();
            while ((token = jp.nextValue()) != JsonToken.END_OBJECT) {
                if (!token.isScalarValue()) continue;
                result.add(jp.getValueAsString());
            }
            return (String[])result.toArray(String[]::new);
        }
    }

    private static class ByteArrayDeserializer
    extends JsonDeserializer<byte[]> {
        private ByteArrayDeserializer() {
        }

        public byte[] deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
            return PrimitiveByteArrayJavaType.INSTANCE.fromString(jp.getValueAsString());
        }
    }

    public static class ByteArraySerializer
    extends StdSerializer<byte[]> {
        public ByteArraySerializer() {
            super(byte[].class);
        }

        public boolean isEmpty(SerializerProvider prov, byte[] value) {
            return value.length == 0;
        }

        public void serialize(byte[] value, JsonGenerator g, SerializerProvider provider) throws IOException {
            g.writeString(PrimitiveByteArrayJavaType.INSTANCE.toString(value));
        }
    }

    @JacksonXmlRootElement(localName="Map")
    public static class MapWrapper<K, V> {
        @JacksonXmlElementWrapper(useWrapping=false)
        @JacksonXmlProperty(localName="e")
        Collection<EntryWrapper<K, V>> entry;

        public MapWrapper() {
            this.entry = new ArrayList<EntryWrapper<K, V>>();
        }

        public MapWrapper(Collection<EntryWrapper<K, V>> entry) {
            this.entry = entry;
        }
    }

    public static class EntryWrapper<K, V> {
        @JacksonXmlProperty(localName="k")
        K key;
        @JacksonXmlProperty(localName="v")
        V value;

        public EntryWrapper() {
        }

        public EntryWrapper(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }

    @JacksonXmlRootElement(localName="Collection")
    public static class CollectionWrapper<E> {
        @JacksonXmlElementWrapper(useWrapping=false)
        @JacksonXmlProperty(localName="e")
        Collection<E> value;

        public CollectionWrapper() {
            this.value = new ArrayList();
        }

        public CollectionWrapper(Collection<E> value) {
            this.value = value;
        }
    }
}

