/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.format.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.JAXBIntrospector;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.sql.ast.spi.StringBuilderSqlAppender;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JavaTypeHelper;
import org.hibernate.type.format.FormatMapper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class JaxbXmlFormatMapper
implements FormatMapper {
    public static final String SHORT_NAME = "jaxb";
    private final boolean legacyFormat;
    private final String collectionElementTagName;
    private final String mapKeyTagName;
    private final String mapValueTagName;

    public JaxbXmlFormatMapper() {
        this(true);
    }

    public JaxbXmlFormatMapper(boolean legacyFormat) {
        this.legacyFormat = legacyFormat;
        if (legacyFormat) {
            this.collectionElementTagName = "value";
            this.mapKeyTagName = "key";
            this.mapValueTagName = "value";
        } else {
            this.collectionElementTagName = "e";
            this.mapKeyTagName = "k";
            this.mapValueTagName = "v";
        }
    }

    @Override
    public <T> T fromString(CharSequence charSequence, JavaType<T> javaType, WrapperOptions wrapperOptions) {
        if (javaType.getJavaType() == String.class || javaType.getJavaType() == Object.class) {
            return (T)charSequence.toString();
        }
        try {
            StringBuilderSqlAppender appender = null;
            if (Map.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                JAXBElementTransformer valueTransformer;
                JAXBElementTransformer keyTransformer;
                JAXBContext context;
                Class valueClass;
                Class keyClass;
                if (javaType.getJavaType() instanceof ParameterizedType) {
                    Type[] typeArguments = ((ParameterizedType)javaType.getJavaType()).getActualTypeArguments();
                    keyClass = ReflectHelper.getClass(typeArguments[0]);
                    valueClass = ReflectHelper.getClass(typeArguments[1]);
                    context = this.legacyFormat ? JAXBContext.newInstance((Class[])new Class[]{LegacyMapWrapper.class, keyClass, valueClass}) : JAXBContext.newInstance((Class[])new Class[]{MapWrapper.class, EntryWrapper.class, keyClass, valueClass});
                } else {
                    keyClass = Object.class;
                    valueClass = Object.class;
                    context = this.legacyFormat ? JAXBContext.newInstance((Class[])new Class[]{LegacyMapWrapper.class}) : JAXBContext.newInstance((Class[])new Class[]{MapWrapper.class, EntryWrapper.class});
                }
                Unmarshaller unmarshaller = context.createUnmarshaller();
                ManagedMapWrapper mapWrapper = (ManagedMapWrapper)unmarshaller.unmarshal((Reader)new StringReader(charSequence.toString()));
                LinkedHashMap<Object, Object> map = CollectionHelper.linkedMapOfSize(mapWrapper.size() >> 1);
                JAXBIntrospector jaxbIntrospector = context.createJAXBIntrospector();
                if (javaType instanceof BasicPluralJavaType) {
                    keyTransformer = this.createTransformer(appender, keyClass, this.mapKeyTagName, null, jaxbIntrospector, wrapperOptions);
                    valueTransformer = this.createTransformer(appender, ((BasicPluralJavaType)((Object)javaType)).getElementJavaType(), this.mapValueTagName, null, jaxbIntrospector, wrapperOptions);
                } else {
                    keyTransformer = this.createTransformer(appender, keyClass, this.mapKeyTagName, null, jaxbIntrospector, wrapperOptions);
                    valueTransformer = this.createTransformer(appender, valueClass, this.mapValueTagName, null, jaxbIntrospector, wrapperOptions);
                }
                if (this.legacyFormat) {
                    Collection<Object> elements = ((LegacyMapWrapper)mapWrapper).elements;
                    Iterator<Object> iterator = elements.iterator();
                    while (iterator.hasNext()) {
                        Object key = keyTransformer.fromJAXBElement(iterator.next(), unmarshaller);
                        Object value = valueTransformer.fromJAXBElement(iterator.next(), unmarshaller);
                        map.put(key, value);
                    }
                } else {
                    for (EntryWrapper entry : ((MapWrapper)mapWrapper).entries) {
                        Object key = keyTransformer.fromXmlContent(entry.key);
                        Object value = valueTransformer.fromXmlContent(entry.value);
                        map.put(key, value);
                    }
                }
                return javaType.wrap(map, wrapperOptions);
            }
            if (Collection.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                JAXBContext context;
                Class valueClass;
                if (javaType.getJavaType() instanceof ParameterizedType) {
                    Type[] typeArguments = ((ParameterizedType)javaType.getJavaType()).getActualTypeArguments();
                    valueClass = ReflectHelper.getClass(typeArguments[0]);
                    context = JAXBContext.newInstance((Class[])new Class[]{CollectionWrapper.class, valueClass});
                } else {
                    valueClass = Object.class;
                    context = JAXBContext.newInstance((Class[])new Class[]{CollectionWrapper.class});
                }
                Unmarshaller unmarshaller = context.createUnmarshaller();
                CollectionWrapper collectionWrapper = (CollectionWrapper)unmarshaller.unmarshal((Reader)new StringReader(charSequence.toString()));
                Collection<Object> elements = collectionWrapper.elements;
                ArrayList<Object> collection = new ArrayList<Object>(elements.size());
                JAXBIntrospector jaxbIntrospector = context.createJAXBIntrospector();
                JAXBElementTransformer valueTransformer = javaType instanceof BasicPluralJavaType ? this.createTransformer(appender, ((BasicPluralJavaType)((Object)javaType)).getElementJavaType(), this.collectionElementTagName, null, jaxbIntrospector, wrapperOptions) : this.createTransformer(appender, valueClass, this.collectionElementTagName, null, jaxbIntrospector, wrapperOptions);
                for (Object element : elements) {
                    Object value = valueTransformer.fromJAXBElement(element, unmarshaller);
                    collection.add(value);
                }
                return javaType.wrap(collection, wrapperOptions);
            }
            if (javaType.getJavaTypeClass().isArray()) {
                Class<?> valueClass = javaType.getJavaTypeClass().getComponentType();
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{CollectionWrapper.class, valueClass});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                CollectionWrapper collectionWrapper = (CollectionWrapper)unmarshaller.unmarshal((Reader)new StringReader(charSequence.toString()));
                Collection<Object> elements = collectionWrapper.elements;
                JAXBIntrospector jaxbIntrospector = context.createJAXBIntrospector();
                JAXBElementTransformer valueTransformer = javaType instanceof BasicPluralJavaType ? this.createTransformer(appender, ((BasicPluralJavaType)((Object)javaType)).getElementJavaType(), this.collectionElementTagName, null, jaxbIntrospector, wrapperOptions) : this.createTransformer(appender, valueClass, this.collectionElementTagName, null, jaxbIntrospector, wrapperOptions);
                int length = elements.size();
                if (Object[].class.isAssignableFrom(javaType.getJavaTypeClass())) {
                    Object[] array = (Object[])Array.newInstance(valueClass, length);
                    int i = 0;
                    for (Object element : elements) {
                        Object value;
                        array[i] = value = valueTransformer.fromJAXBElement(element, unmarshaller);
                        ++i;
                    }
                    return (T)array;
                }
                Object array = Array.newInstance(valueClass, length);
                int i = 0;
                for (Object element : elements) {
                    Object value = valueTransformer.fromJAXBElement(element, unmarshaller);
                    Array.set(array, i, value);
                    ++i;
                }
                return (T)array;
            }
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{javaType.getJavaTypeClass()});
            return (T)context.createUnmarshaller().unmarshal((Reader)new StringReader(charSequence.toString()));
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Could not deserialize string to java type: " + javaType, e);
        }
    }

    @Override
    public <T> String toString(T value, JavaType<T> javaType, WrapperOptions wrapperOptions) {
        if (javaType.getJavaType() == String.class || javaType.getJavaType() == Object.class) {
            return (String)value;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            StringBuilderSqlAppender appender = new StringBuilderSqlAppender();
            if (Map.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                ManagedMapWrapper managedMapWrapper;
                JAXBContext context;
                Class valueClass;
                Class keyClass;
                Map map = (Map)value;
                if (javaType.getJavaType() instanceof ParameterizedType) {
                    Type[] typeArguments = ((ParameterizedType)javaType.getJavaType()).getActualTypeArguments();
                    keyClass = ReflectHelper.getClass(typeArguments[0]);
                    valueClass = ReflectHelper.getClass(typeArguments[1]);
                    context = this.legacyFormat ? JAXBContext.newInstance((Class[])new Class[]{LegacyMapWrapper.class, keyClass, valueClass}) : JAXBContext.newInstance((Class[])new Class[]{MapWrapper.class, EntryWrapper.class, keyClass, valueClass});
                } else if (map.isEmpty()) {
                    keyClass = Object.class;
                    valueClass = Object.class;
                    context = this.legacyFormat ? JAXBContext.newInstance((Class[])new Class[]{LegacyMapWrapper.class}) : JAXBContext.newInstance((Class[])new Class[]{MapWrapper.class, EntryWrapper.class});
                } else {
                    Map.Entry firstEntry = map.entrySet().iterator().next();
                    keyClass = firstEntry.getKey().getClass();
                    valueClass = firstEntry.getValue().getClass();
                    context = this.legacyFormat ? JAXBContext.newInstance((Class[])new Class[]{LegacyMapWrapper.class, keyClass, valueClass}) : JAXBContext.newInstance((Class[])new Class[]{MapWrapper.class, EntryWrapper.class, keyClass, valueClass});
                }
                ManagedMapWrapper managedMapWrapper2 = managedMapWrapper = this.legacyFormat ? new LegacyMapWrapper() : new MapWrapper();
                if (!map.isEmpty()) {
                    Object exampleKey = null;
                    Object exampleValue = null;
                    for (Map.Entry entry : map.entrySet()) {
                        Object mapKey = entry.getKey();
                        Object mapValue = entry.getValue();
                        if (exampleKey == null && mapKey != null) {
                            exampleKey = mapKey;
                            if (exampleValue != null) break;
                        }
                        if (exampleValue != null || mapValue == null) continue;
                        exampleValue = mapValue;
                        if (exampleKey == null) continue;
                        break;
                    }
                    JAXBIntrospector jaxbIntrospector = context.createJAXBIntrospector();
                    JAXBElementTransformer keyTransformer = this.createTransformer(appender, keyClass, this.mapKeyTagName, exampleKey, jaxbIntrospector, wrapperOptions);
                    JAXBElementTransformer valueTransformer = this.createTransformer(appender, valueClass, this.mapValueTagName, exampleValue, jaxbIntrospector, wrapperOptions);
                    if (this.legacyFormat) {
                        ManagedMapWrapper legacyMapWrapper = managedMapWrapper;
                        for (Map.Entry entry : map.entrySet()) {
                            legacyMapWrapper.elements.add(keyTransformer.toJAXBElement(entry.getKey()));
                            legacyMapWrapper.elements.add(valueTransformer.toJAXBElement(entry.getValue()));
                        }
                    } else {
                        MapWrapper mapWrapper = (MapWrapper)managedMapWrapper;
                        for (Map.Entry entry : map.entrySet()) {
                            mapWrapper.entries.add(new EntryWrapper((String)keyTransformer.toJAXBElement(entry.getKey()).getValue(), (String)valueTransformer.toJAXBElement(entry.getValue()).getValue()));
                        }
                    }
                }
                this.createMarshaller(context).marshal((Object)managedMapWrapper, (Writer)stringWriter);
            } else if (Collection.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                CollectionWrapper collectionWrapper;
                JAXBContext context;
                Class valueClass;
                Collection collection = (Collection)value;
                if (javaType.getJavaType() instanceof ParameterizedType) {
                    Type[] typeArguments = ((ParameterizedType)javaType.getJavaType()).getActualTypeArguments();
                    valueClass = ReflectHelper.getClass(typeArguments[0]);
                    context = JAXBContext.newInstance((Class[])new Class[]{CollectionWrapper.class, valueClass});
                } else if (collection.isEmpty()) {
                    valueClass = Object.class;
                    context = JAXBContext.newInstance((Class[])new Class[]{CollectionWrapper.class});
                } else {
                    valueClass = collection.iterator().next().getClass();
                    context = JAXBContext.newInstance((Class[])new Class[]{CollectionWrapper.class, valueClass});
                }
                if (collection.isEmpty()) {
                    collectionWrapper = new CollectionWrapper();
                } else {
                    collectionWrapper = new CollectionWrapper(new ArrayList<Object>(collection.size()));
                    Object exampleValue = null;
                    for (Object o : collection) {
                        if (o == null) continue;
                        exampleValue = o;
                        break;
                    }
                    JAXBElementTransformer valueTransformer = javaType instanceof BasicPluralJavaType ? this.createTransformer(appender, ((BasicPluralJavaType)((Object)javaType)).getElementJavaType(), this.collectionElementTagName, exampleValue, context.createJAXBIntrospector(), wrapperOptions) : this.createTransformer(appender, valueClass, this.collectionElementTagName, exampleValue, context.createJAXBIntrospector(), wrapperOptions);
                    for (Object o : collection) {
                        collectionWrapper.elements.add(valueTransformer.toJAXBElement(o));
                    }
                }
                this.createMarshaller(context).marshal((Object)collectionWrapper, (Writer)stringWriter);
            } else if (javaType.getJavaTypeClass().isArray()) {
                CollectionWrapper collectionWrapper;
                Class<?> valueClass = javaType.getJavaTypeClass().getComponentType();
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{CollectionWrapper.class, valueClass});
                if (Object[].class.isAssignableFrom(javaType.getJavaTypeClass())) {
                    Object[] array = (Object[])value;
                    ArrayList<Object> list = new ArrayList<Object>(array.length);
                    Object exampleElement = null;
                    for (Object o : array) {
                        if (o == null) continue;
                        exampleElement = o;
                        break;
                    }
                    JAXBElementTransformer transformer = javaType instanceof BasicPluralJavaType ? this.createTransformer(appender, ((BasicPluralJavaType)((Object)javaType)).getElementJavaType(), this.collectionElementTagName, exampleElement, context.createJAXBIntrospector(), wrapperOptions) : this.createTransformer(appender, valueClass, this.collectionElementTagName, exampleElement, context.createJAXBIntrospector(), wrapperOptions);
                    for (Object o : array) {
                        list.add(transformer.toJAXBElement(o));
                    }
                    collectionWrapper = new CollectionWrapper(list);
                } else {
                    int length = Array.getLength(value);
                    ArrayList<Object> list = new ArrayList<Object>(length);
                    JavaTypeJAXBElementTransformer transformer = new JavaTypeJAXBElementTransformer(appender, ((BasicPluralJavaType)((Object)javaType)).getElementJavaType(), this.collectionElementTagName);
                    for (int i = 0; i < length; ++i) {
                        list.add(transformer.toJAXBElement(Array.get(value, i)));
                    }
                    collectionWrapper = new CollectionWrapper(list);
                }
                this.createMarshaller(context).marshal((Object)collectionWrapper, (Writer)stringWriter);
            } else {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{javaType.getJavaTypeClass()});
                this.createMarshaller(context).marshal(value, (Writer)stringWriter);
            }
            return stringWriter.toString();
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Could not serialize object of java type: " + javaType, e);
        }
    }

    private JAXBElementTransformer createTransformer(StringBuilderSqlAppender appender, Class<?> elementClass, String tagName, Object exampleElement, JAXBIntrospector introspector, WrapperOptions wrapperOptions) {
        QName elementName;
        JavaType elementJavaType = wrapperOptions.getSessionFactory().getTypeConfiguration().getJavaTypeRegistry().findDescriptor(elementClass);
        if (exampleElement == null && (elementJavaType == null || JavaTypeHelper.isUnknown(elementJavaType))) {
            try {
                Constructor<?> declaredConstructor = elementClass.getDeclaredConstructor(new Class[0]);
                exampleElement = declaredConstructor.newInstance(new Object[0]);
            }
            catch (Exception declaredConstructor) {
                // empty catch block
            }
        }
        QName qName = elementName = exampleElement == null ? null : introspector.getElementName(exampleElement);
        if (elementName == null && elementClass != String.class && elementJavaType != null) {
            return this.createTransformer(appender, elementJavaType, tagName, exampleElement, introspector, wrapperOptions);
        }
        return new SimpleJAXBElementTransformer(elementClass, tagName);
    }

    private JAXBElementTransformer createTransformer(StringBuilderSqlAppender appender, JavaType<?> elementJavaType, String tagName, Object exampleElement, JAXBIntrospector introspector, WrapperOptions wrapperOptions) {
        QName elementName;
        if (exampleElement == null && JavaTypeHelper.isUnknown(elementJavaType)) {
            try {
                Constructor<?> declaredConstructor = elementJavaType.getJavaTypeClass().getDeclaredConstructor(new Class[0]);
                exampleElement = declaredConstructor.newInstance(new Object[0]);
            }
            catch (Exception declaredConstructor) {
                // empty catch block
            }
        }
        QName qName = elementName = exampleElement == null ? null : introspector.getElementName(exampleElement);
        if (elementName == null && elementJavaType.getJavaTypeClass() != String.class) {
            return new JavaTypeJAXBElementTransformer(appender, elementJavaType, tagName);
        }
        return new SimpleJAXBElementTransformer(elementJavaType.getJavaTypeClass(), tagName);
    }

    private Marshaller createMarshaller(JAXBContext context) throws JAXBException {
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)true);
        return marshaller;
    }

    @XmlRootElement(name="Map")
    public static class LegacyMapWrapper
    implements ManagedMapWrapper {
        @XmlAnyElement
        Collection<Object> elements;

        public LegacyMapWrapper() {
            this.elements = new ArrayList<Object>();
        }

        public LegacyMapWrapper(Collection<Object> elements) {
            this.elements = elements;
        }

        @Override
        public int size() {
            return this.elements.size();
        }
    }

    @XmlRootElement(name="Map")
    public static class MapWrapper
    implements ManagedMapWrapper {
        @XmlElement(name="e")
        Collection<EntryWrapper> entries;

        public MapWrapper() {
            this.entries = new ArrayList<EntryWrapper>();
        }

        public MapWrapper(Collection<EntryWrapper> elements) {
            this.entries = elements;
        }

        @Override
        public int size() {
            return this.entries.size();
        }
    }

    public static class EntryWrapper {
        @XmlElement(name="k", nillable=true)
        String key;
        @XmlElement(name="v", nillable=true)
        String value;

        public EntryWrapper() {
        }

        public EntryWrapper(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    public static interface ManagedMapWrapper {
        public int size();
    }

    private static interface JAXBElementTransformer {
        public JAXBElement<?> toJAXBElement(Object var1);

        public Object fromJAXBElement(Object var1, Unmarshaller var2) throws JAXBException;

        public Object fromXmlContent(String var1);
    }

    @XmlRootElement(name="Collection")
    public static class CollectionWrapper {
        @XmlAnyElement
        Collection<Object> elements;

        public CollectionWrapper() {
            this.elements = new ArrayList<Object>();
        }

        public CollectionWrapper(Collection<Object> elements) {
            this.elements = elements;
        }
    }

    private static class JavaTypeJAXBElementTransformer
    implements JAXBElementTransformer {
        private final StringBuilderSqlAppender appender;
        private final JavaType<Object> elementJavaType;
        private final QName tagName;

        public JavaTypeJAXBElementTransformer(StringBuilderSqlAppender appender, JavaType<?> elementJavaType, String tagName) {
            this.appender = appender;
            this.elementJavaType = elementJavaType;
            this.tagName = new QName(tagName);
        }

        @Override
        public JAXBElement<?> toJAXBElement(Object o) {
            String value;
            if (o == null) {
                value = null;
            } else {
                this.elementJavaType.appendEncodedString(this.appender, o);
                value = this.appender.toString();
                this.appender.getStringBuilder().setLength(0);
            }
            return new JAXBElement(this.tagName, String.class, value);
        }

        @Override
        public Object fromJAXBElement(Object element, Unmarshaller unmarshaller) throws JAXBException {
            String value = element == null ? null : (String)unmarshaller.unmarshal((Node)element, String.class).getValue();
            return value == null ? null : this.elementJavaType.fromEncodedString(value, 0, value.length());
        }

        @Override
        public Object fromXmlContent(String content) {
            return content == null ? null : this.elementJavaType.fromEncodedString(content, 0, content.length());
        }
    }

    private static class SimpleJAXBElementTransformer
    implements JAXBElementTransformer {
        private final Class<Object> elementClass;
        private final QName tagName;

        public SimpleJAXBElementTransformer(Class<?> elementClass, String tagName) {
            this.elementClass = elementClass;
            this.tagName = new QName(tagName);
        }

        @Override
        public JAXBElement<?> toJAXBElement(Object o) {
            return new JAXBElement(this.tagName, this.elementClass, o);
        }

        @Override
        public Object fromJAXBElement(Object element, Unmarshaller unmarshaller) throws JAXBException {
            Object valueElement = unmarshaller.unmarshal((Node)element, this.elementClass).getValue();
            Object value = valueElement instanceof Element ? ((Element)valueElement).getFirstChild().getTextContent() : valueElement;
            return value;
        }

        @Override
        public Object fromXmlContent(String content) {
            return content;
        }
    }
}

