/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.annotation;

import java.beans.Introspector;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.util.Elements;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaEntity;
import org.hibernate.jpamodelgen.model.MetaAttribute;
import org.hibernate.jpamodelgen.model.MetaEntity;
import org.hibernate.jpamodelgen.util.StringUtil;

public abstract class AnnotationMetaAttribute
implements MetaAttribute {
    private final Element element;
    private final AnnotationMetaEntity parent;
    private final String type;

    public AnnotationMetaAttribute(AnnotationMetaEntity parent, Element element, String type) {
        this.element = element;
        this.parent = parent;
        this.type = type;
    }

    @Override
    public String getAttributeDeclarationString() {
        return "public static volatile " + this.parent.importType(this.getMetaType()) + "<" + this.parent.importType(this.parent.getQualifiedName()) + ", " + this.parent.importType(this.getTypeDeclaration()) + "> " + this.getPropertyName() + ";";
    }

    @Override
    public String getAttributeNameDeclarationString() {
        return "public static final " + this.parent.importType(String.class.getName()) + " " + StringUtil.getUpperUnderscoreCaseFromLowerCamelCase(this.getPropertyName()) + " = " + "\"" + this.getPropertyName() + "\"" + ";";
    }

    @Override
    public String getPropertyName() {
        Elements elementsUtil = this.parent.getContext().getElementUtils();
        if (this.element.getKind() == ElementKind.FIELD) {
            return this.element.getSimpleName().toString();
        }
        if (this.element.getKind() == ElementKind.METHOD) {
            String name = this.element.getSimpleName().toString();
            if (name.startsWith("get")) {
                return elementsUtil.getName(Introspector.decapitalize(name.substring("get".length()))).toString();
            }
            if (name.startsWith("is")) {
                return elementsUtil.getName(Introspector.decapitalize(name.substring("is".length()))).toString();
            }
            return elementsUtil.getName(Introspector.decapitalize(name)).toString();
        }
        return elementsUtil.getName(this.element.getSimpleName() + "/* " + this.element.getKind() + " */").toString();
    }

    @Override
    public MetaEntity getHostingEntity() {
        return this.parent;
    }

    @Override
    public abstract String getMetaType();

    @Override
    public String getTypeDeclaration() {
        return this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AnnotationMetaAttribute");
        sb.append("{element=").append(this.element);
        sb.append(", type='").append(this.type).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

