/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.tools.Diagnostic;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.MetaModelGenerationException;
import org.hibernate.jpamodelgen.util.AccessType;
import org.hibernate.jpamodelgen.util.AccessTypeInformation;
import org.hibernate.jpamodelgen.util.NullnessUtil;
import org.hibernate.jpamodelgen.util.StringUtil;
import org.hibernate.jpamodelgen.util.TypeRenderingVisitor;

public final class TypeUtils {
    public static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_ANNOTATION_PARAMETER_NAME = "value";
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TypeKind, @UnknownKeyFor @NonNull @Initialized String> PRIMITIVE_WRAPPERS = new HashMap<TypeKind, String>();
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TypeKind, @UnknownKeyFor @NonNull @Initialized String> PRIMITIVES = new HashMap<TypeKind, String>();

    private TypeUtils() {
    }

    public static @UnknownKeyFor @NonNull @Initialized String toTypeString(@UnknownKeyFor @NonNull @Initialized TypeMirror type) {
        if (type.getKind().isPrimitive()) {
            return NullnessUtil.castNonNull(PRIMITIVE_WRAPPERS.get((Object)type.getKind()));
        }
        return TypeRenderingVisitor.toString(type);
    }

    public static @UnknownKeyFor @NonNull @Initialized String toArrayTypeString(@UnknownKeyFor @NonNull @Initialized ArrayType type, @UnknownKeyFor @NonNull @Initialized Context context) {
        TypeMirror componentType = type.getComponentType();
        if (componentType.getKind().isPrimitive()) {
            return PRIMITIVES.get((Object)componentType.getKind()) + "[]";
        }
        TypeMirror component = componentType.accept(new SimpleTypeVisitor6<TypeMirror, Void>(){

            @Override
            protected TypeMirror defaultAction(TypeMirror e, Void aVoid) {
                return e;
            }
        }, null);
        return TypeUtils.extractClosestRealTypeAsString(component, context) + "[]";
    }

    public static @Nullable @UnknownKeyFor @Initialized TypeElement getSuperclassTypeElement(@UnknownKeyFor @NonNull @Initialized TypeElement element) {
        TypeMirror superClass = element.getSuperclass();
        if (superClass.getKind() == TypeKind.DECLARED) {
            Element superClassElement = ((DeclaredType)superClass).asElement();
            return (TypeElement)superClassElement;
        }
        return null;
    }

    public static @UnknownKeyFor @NonNull @Initialized String extractClosestRealTypeAsString(@UnknownKeyFor @NonNull @Initialized TypeMirror type, @UnknownKeyFor @NonNull @Initialized Context context) {
        if (type instanceof TypeVariable) {
            TypeMirror compositeUpperBound = ((TypeVariable)type).getUpperBound();
            return TypeUtils.extractClosestRealTypeAsString(compositeUpperBound, context);
        }
        TypeMirror erasureType = context.getTypeUtils().erasure(type);
        if (TypeKind.ARRAY.equals((Object)erasureType.getKind())) {
            return erasureType.toString();
        }
        return ((TypeElement)context.getTypeUtils().asElement(erasureType)).getQualifiedName().toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean containsAnnotation(@UnknownKeyFor @NonNull @Initialized Element element, String ... annotations) {
        assert (element != null);
        assert (annotations != null);
        ArrayList annotationClassNames = new ArrayList();
        Collections.addAll(annotationClassNames, annotations);
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationClassNames.contains(annotationMirror.getAnnotationType().toString())) continue;
            return true;
        }
        return false;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isAnnotationMirrorOfType(@UnknownKeyFor @NonNull @Initialized AnnotationMirror annotationMirror, @UnknownKeyFor @NonNull @Initialized String fqcn) {
        assert (annotationMirror != null);
        assert (fqcn != null);
        String annotationClassName = annotationMirror.getAnnotationType().toString();
        return annotationClassName.equals(fqcn);
    }

    public static @Nullable @UnknownKeyFor @Initialized AnnotationMirror getAnnotationMirror(@UnknownKeyFor @NonNull @Initialized Element element, @UnknownKeyFor @NonNull @Initialized String fqcn) {
        assert (element != null);
        assert (fqcn != null);
        AnnotationMirror mirror = null;
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!TypeUtils.isAnnotationMirrorOfType(annotationMirror, fqcn)) continue;
            mirror = annotationMirror;
            break;
        }
        return mirror;
    }

    public static @Nullable @UnknownKeyFor @Initialized Object getAnnotationValue(@UnknownKeyFor @NonNull @Initialized AnnotationMirror annotationMirror, @UnknownKeyFor @NonNull @Initialized String parameterValue) {
        assert (annotationMirror != null);
        assert (parameterValue != null);
        Object returnValue = null;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!parameterValue.equals(entry.getKey().getSimpleName().toString())) continue;
            returnValue = entry.getValue().getValue();
            break;
        }
        return returnValue;
    }

    public static void determineAccessTypeForHierarchy(@UnknownKeyFor @NonNull @Initialized TypeElement searchedElement, @UnknownKeyFor @NonNull @Initialized Context context) {
        String fqcn = searchedElement.getQualifiedName().toString();
        context.logMessage(Diagnostic.Kind.OTHER, "Determining access type for " + fqcn);
        AccessTypeInformation accessTypeInfo = context.getAccessTypeInfo(fqcn);
        if (accessTypeInfo != null && accessTypeInfo.isAccessTypeResolved()) {
            context.logMessage(Diagnostic.Kind.OTHER, "AccessType for " + searchedElement.toString() + " found in cache: " + accessTypeInfo);
            return;
        }
        AccessType forcedAccessType = TypeUtils.determineAnnotationSpecifiedAccessType(searchedElement);
        if (forcedAccessType != null) {
            context.logMessage(Diagnostic.Kind.OTHER, "Explicit access type on " + searchedElement + ":" + forcedAccessType);
            accessTypeInfo = new AccessTypeInformation(fqcn, forcedAccessType, null);
            context.addAccessTypeInformation(fqcn, accessTypeInfo);
            TypeUtils.updateEmbeddableAccessType(searchedElement, context, forcedAccessType);
            return;
        }
        AccessType defaultAccessType = TypeUtils.getAccessTypeInCaseElementIsRoot(searchedElement, context);
        if (defaultAccessType != null) {
            accessTypeInfo = new AccessTypeInformation(fqcn, null, defaultAccessType);
            context.addAccessTypeInformation(fqcn, accessTypeInfo);
            TypeUtils.updateEmbeddableAccessType(searchedElement, context, defaultAccessType);
            TypeUtils.setDefaultAccessTypeForMappedSuperclassesInHierarchy(searchedElement, defaultAccessType, context);
            return;
        }
        defaultAccessType = TypeUtils.getDefaultAccessForHierarchy(searchedElement, context);
        if (defaultAccessType == null) {
            defaultAccessType = AccessType.PROPERTY;
        }
        accessTypeInfo = new AccessTypeInformation(fqcn, null, defaultAccessType);
        context.addAccessTypeInformation(fqcn, accessTypeInfo);
        TypeUtils.updateEmbeddableAccessType(searchedElement, context, defaultAccessType);
    }

    public static @UnknownKeyFor @NonNull @Initialized TypeMirror getCollectionElementType(@UnknownKeyFor @NonNull @Initialized DeclaredType t, @UnknownKeyFor @NonNull @Initialized String fqNameOfReturnedType, @Nullable @UnknownKeyFor @Initialized String explicitTargetEntityName, @UnknownKeyFor @NonNull @Initialized Context context) {
        TypeMirror collectionElementType;
        if (explicitTargetEntityName != null) {
            Elements elements = context.getElementUtils();
            TypeElement element = elements.getTypeElement(explicitTargetEntityName);
            collectionElementType = element.asType();
        } else {
            List<? extends TypeMirror> typeArguments = t.getTypeArguments();
            if (typeArguments.size() == 0) {
                throw new MetaModelGenerationException("Unable to determine collection type");
            }
            collectionElementType = Map.class.getCanonicalName().equals(fqNameOfReturnedType) ? t.getTypeArguments().get(1) : t.getTypeArguments().get(0);
        }
        return collectionElementType;
    }

    private static void updateEmbeddableAccessType(@UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType) {
        List<VariableElement> fieldsOfClass = ElementFilter.fieldsIn(element.getEnclosedElements());
        for (Element element2 : fieldsOfClass) {
            TypeUtils.updateEmbeddableAccessTypeForMember(context, defaultAccessType, element2);
        }
        List<ExecutableElement> methodOfClass = ElementFilter.methodsIn(element.getEnclosedElements());
        for (Element element3 : methodOfClass) {
            TypeUtils.updateEmbeddableAccessTypeForMember(context, defaultAccessType, element3);
        }
    }

    private static void updateEmbeddableAccessTypeForMember(@UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType, @UnknownKeyFor @NonNull @Initialized Element member) {
        EmbeddedAttributeVisitor visitor = new EmbeddedAttributeVisitor(context);
        String embeddedClassName = member.asType().accept(visitor, member);
        if (embeddedClassName != null) {
            AccessTypeInformation accessTypeInfo = context.getAccessTypeInfo(embeddedClassName);
            if (accessTypeInfo == null) {
                accessTypeInfo = new AccessTypeInformation(embeddedClassName, null, defaultAccessType);
                context.addAccessTypeInformation(embeddedClassName, accessTypeInfo);
            } else {
                accessTypeInfo.setDefaultAccessType(defaultAccessType);
            }
        }
    }

    private static @Nullable @UnknownKeyFor @Initialized AccessType getDefaultAccessForHierarchy(@UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized Context context) {
        AccessType defaultAccessType = null;
        TypeElement superClass = element;
        do {
            if ((superClass = TypeUtils.getSuperclassTypeElement(superClass)) == null) continue;
            String fqcn = superClass.getQualifiedName().toString();
            AccessTypeInformation accessTypeInfo = context.getAccessTypeInfo(fqcn);
            if (accessTypeInfo != null && accessTypeInfo.getDefaultAccessType() != null) {
                return accessTypeInfo.getDefaultAccessType();
            }
            if (!TypeUtils.containsAnnotation(superClass, "jakarta.persistence.Entity", "jakarta.persistence.MappedSuperclass")) continue;
            defaultAccessType = TypeUtils.getAccessTypeInCaseElementIsRoot(superClass, context);
            if (defaultAccessType != null) {
                accessTypeInfo = new AccessTypeInformation(fqcn, null, defaultAccessType);
                context.addAccessTypeInformation(fqcn, accessTypeInfo);
                TypeUtils.setDefaultAccessTypeForMappedSuperclassesInHierarchy(superClass, defaultAccessType, context);
                break;
            }
            defaultAccessType = TypeUtils.getDefaultAccessForHierarchy(superClass, context);
        } while (superClass != null);
        return defaultAccessType;
    }

    private static void setDefaultAccessTypeForMappedSuperclassesInHierarchy(@UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType, @UnknownKeyFor @NonNull @Initialized Context context) {
        TypeElement superClass = element;
        do {
            if ((superClass = TypeUtils.getSuperclassTypeElement(superClass)) == null) continue;
            String fqcn = superClass.getQualifiedName().toString();
            if (!TypeUtils.containsAnnotation(superClass, "jakarta.persistence.MappedSuperclass")) continue;
            AccessType forcedAccessType = TypeUtils.determineAnnotationSpecifiedAccessType(superClass);
            AccessTypeInformation accessTypeInfo = forcedAccessType != null ? new AccessTypeInformation(fqcn, null, forcedAccessType) : new AccessTypeInformation(fqcn, null, defaultAccessType);
            context.addAccessTypeInformation(fqcn, accessTypeInfo);
        } while (superClass != null);
    }

    private static @Nullable @UnknownKeyFor @Initialized AccessType getAccessTypeInCaseElementIsRoot(@UnknownKeyFor @NonNull @Initialized TypeElement searchedElement, @UnknownKeyFor @NonNull @Initialized Context context) {
        List<? extends Element> myMembers = searchedElement.getEnclosedElements();
        for (Element element : myMembers) {
            List<? extends AnnotationMirror> entityAnnotations = context.getElementUtils().getAllAnnotationMirrors(element);
            for (AnnotationMirror annotationMirror : entityAnnotations) {
                AnnotationMirror annotationMirror2 = annotationMirror;
                if (!TypeUtils.isIdAnnotation(annotationMirror2)) continue;
                return TypeUtils.getAccessTypeOfIdAnnotation(element);
            }
        }
        return null;
    }

    private static @Nullable @UnknownKeyFor @Initialized AccessType getAccessTypeOfIdAnnotation(@UnknownKeyFor @NonNull @Initialized Element element) {
        AccessType accessType = null;
        ElementKind kind = element.getKind();
        if (kind == ElementKind.FIELD || kind == ElementKind.METHOD) {
            accessType = kind == ElementKind.FIELD ? AccessType.FIELD : AccessType.PROPERTY;
        }
        return accessType;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isIdAnnotation(@UnknownKeyFor @NonNull @Initialized AnnotationMirror annotationMirror) {
        return TypeUtils.isAnnotationMirrorOfType(annotationMirror, "jakarta.persistence.Id") || TypeUtils.isAnnotationMirrorOfType(annotationMirror, "jakarta.persistence.EmbeddedId");
    }

    public static @Nullable @UnknownKeyFor @Initialized AccessType determineAnnotationSpecifiedAccessType(@UnknownKeyFor @NonNull @Initialized Element element) {
        Element accessElement;
        AnnotationMirror accessAnnotationMirror = TypeUtils.getAnnotationMirror(element, "jakarta.persistence.Access");
        AccessType forcedAccessType = null;
        if (accessAnnotationMirror != null && (accessElement = (Element)NullnessUtil.castNonNull(TypeUtils.getAnnotationValue(accessAnnotationMirror, DEFAULT_ANNOTATION_PARAMETER_NAME))).getKind().equals((Object)ElementKind.ENUM_CONSTANT)) {
            if (accessElement.getSimpleName().toString().equals(AccessType.PROPERTY.toString())) {
                forcedAccessType = AccessType.PROPERTY;
            } else if (accessElement.getSimpleName().toString().equals(AccessType.FIELD.toString())) {
                forcedAccessType = AccessType.FIELD;
            }
        }
        return forcedAccessType;
    }

    public static @UnknownKeyFor @NonNull @Initialized ElementKind getElementKindForAccessType(@UnknownKeyFor @NonNull @Initialized AccessType accessType) {
        if (AccessType.FIELD.equals((Object)accessType)) {
            return ElementKind.FIELD;
        }
        return ElementKind.METHOD;
    }

    public static @UnknownKeyFor @NonNull @Initialized String getKeyType(@UnknownKeyFor @NonNull @Initialized DeclaredType t, @UnknownKeyFor @NonNull @Initialized Context context) {
        List<? extends TypeMirror> typeArguments = t.getTypeArguments();
        if (typeArguments.size() == 0) {
            context.logMessage(Diagnostic.Kind.ERROR, "Unable to determine type argument for " + t);
        }
        return TypeUtils.extractClosestRealTypeAsString(typeArguments.get(0), context);
    }

    static {
        PRIMITIVE_WRAPPERS.put(TypeKind.CHAR, "Character");
        PRIMITIVE_WRAPPERS.put(TypeKind.BYTE, "Byte");
        PRIMITIVE_WRAPPERS.put(TypeKind.SHORT, "Short");
        PRIMITIVE_WRAPPERS.put(TypeKind.INT, "Integer");
        PRIMITIVE_WRAPPERS.put(TypeKind.LONG, "Long");
        PRIMITIVE_WRAPPERS.put(TypeKind.BOOLEAN, "Boolean");
        PRIMITIVE_WRAPPERS.put(TypeKind.FLOAT, "Float");
        PRIMITIVE_WRAPPERS.put(TypeKind.DOUBLE, "Double");
        PRIMITIVES.put(TypeKind.CHAR, "char");
        PRIMITIVES.put(TypeKind.BYTE, "byte");
        PRIMITIVES.put(TypeKind.SHORT, "short");
        PRIMITIVES.put(TypeKind.INT, "int");
        PRIMITIVES.put(TypeKind.LONG, "long");
        PRIMITIVES.put(TypeKind.BOOLEAN, "boolean");
        PRIMITIVES.put(TypeKind.FLOAT, "float");
        PRIMITIVES.put(TypeKind.DOUBLE, "double");
    }

    static class EmbeddedAttributeVisitor
    extends SimpleTypeVisitor6<String, Element> {
        private @UnknownKeyFor @NonNull @Initialized Context context;

        EmbeddedAttributeVisitor(@UnknownKeyFor @NonNull @Initialized Context context) {
            this.context = context;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized String visitDeclared(@UnknownKeyFor @NonNull @Initialized DeclaredType declaredType, @UnknownKeyFor @NonNull @Initialized Element element) {
            TypeElement returnedElement = (TypeElement)this.context.getTypeUtils().asElement(declaredType);
            String fqNameOfReturnType = null;
            if (TypeUtils.containsAnnotation(returnedElement, "jakarta.persistence.Embeddable")) {
                fqNameOfReturnType = returnedElement.getQualifiedName().toString();
            }
            return fqNameOfReturnType;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized String visitExecutable(@UnknownKeyFor @NonNull @Initialized ExecutableType t, @UnknownKeyFor @NonNull @Initialized Element p) {
            if (!p.getKind().equals((Object)ElementKind.METHOD)) {
                return null;
            }
            String string = p.getSimpleName().toString();
            if (!StringUtil.isProperty(string, TypeUtils.toTypeString(t.getReturnType()))) {
                return null;
            }
            TypeMirror returnType = t.getReturnType();
            return returnType.accept(this, p);
        }
    }
}

