/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.JPAMetaModelEntityProcessor;
import org.hibernate.jpamodelgen.model.MetaAttribute;
import org.hibernate.jpamodelgen.model.MetaEntity;
import org.hibernate.jpamodelgen.util.TypeUtils;

public final class ClassWriter {
    private static final @UnknownKeyFor @NonNull @Initialized String META_MODEL_CLASS_NAME_SUFFIX = "_";
    private static final @UnknownKeyFor @NonNull @Initialized ThreadLocal<@UnknownKeyFor @NonNull @Initialized SimpleDateFormat> SIMPLE_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        public SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        }
    };

    private ClassWriter() {
    }

    public static void writeFile(@UnknownKeyFor @NonNull @Initialized MetaEntity entity, @UnknownKeyFor @NonNull @Initialized Context context) {
        try {
            String metaModelPackage = entity.getPackageName();
            String body = ClassWriter.generateBody(entity, context).toString();
            JavaFileObject fo = context.getProcessingEnvironment().getFiler().createSourceFile(ClassWriter.getFullyQualifiedClassName(entity, metaModelPackage), entity.getTypeElement());
            OutputStream os = fo.openOutputStream();
            PrintWriter pw = new PrintWriter(os);
            if (!metaModelPackage.isEmpty()) {
                pw.println("package " + metaModelPackage + ";");
                pw.println();
            }
            pw.println(entity.generateImports());
            pw.println(body);
            pw.flush();
            pw.close();
        }
        catch (FilerException filerEx) {
            context.logMessage(Diagnostic.Kind.ERROR, "Problem with Filer: " + filerEx.getMessage());
        }
        catch (IOException ioEx) {
            context.logMessage(Diagnostic.Kind.ERROR, "Problem opening file to write MetaModel for " + entity.getSimpleName() + ": " + ioEx.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static @UnknownKeyFor @NonNull @Initialized StringBuffer generateBody(@UnknownKeyFor @NonNull @Initialized MetaEntity entity, @UnknownKeyFor @NonNull @Initialized Context context) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = null;){
            pw = new PrintWriter(sw);
            if (context.addGeneratedAnnotation()) {
                pw.println(ClassWriter.writeGeneratedAnnotation(entity, context));
            }
            if (context.isAddSuppressWarningsAnnotation()) {
                pw.println(ClassWriter.writeSuppressWarnings());
            }
            pw.println(ClassWriter.writeStaticMetaModelAnnotation(entity));
            ClassWriter.printClassDeclaration(entity, pw, context);
            pw.println();
            List<MetaAttribute> members = entity.getMembers();
            for (MetaAttribute metaMember : members) {
                pw.println("\t" + metaMember.getAttributeDeclarationString());
            }
            pw.println();
            for (MetaAttribute metaMember : members) {
                pw.println("\t" + metaMember.getAttributeNameDeclarationString());
            }
            pw.println();
            pw.println("}");
            StringBuffer stringBuffer = sw.getBuffer();
            return stringBuffer;
        }
    }

    private static void printClassDeclaration(@UnknownKeyFor @NonNull @Initialized MetaEntity entity, @UnknownKeyFor @NonNull @Initialized PrintWriter pw, @UnknownKeyFor @NonNull @Initialized Context context) {
        pw.print("public abstract class " + entity.getSimpleName() + META_MODEL_CLASS_NAME_SUFFIX);
        String superClassName = ClassWriter.findMappedSuperClass(entity, context);
        if (superClassName != null) {
            pw.print(" extends " + superClassName + META_MODEL_CLASS_NAME_SUFFIX);
        }
        pw.println(" {");
    }

    private static @Nullable @UnknownKeyFor @Initialized String findMappedSuperClass(@UnknownKeyFor @NonNull @Initialized MetaEntity entity, @UnknownKeyFor @NonNull @Initialized Context context) {
        TypeMirror superClass = entity.getTypeElement().getSuperclass();
        while (superClass.getKind() == TypeKind.DECLARED) {
            Element superClassElement = ((DeclaredType)superClass).asElement();
            String superClassName = ((TypeElement)superClassElement).getQualifiedName().toString();
            if (ClassWriter.extendsSuperMetaModel(superClassElement, entity.isMetaComplete(), context)) {
                return superClassName;
            }
            superClass = ((TypeElement)superClassElement).getSuperclass();
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean extendsSuperMetaModel(@UnknownKeyFor @NonNull @Initialized Element superClassElement, @UnknownKeyFor @NonNull @Initialized boolean entityMetaComplete, @UnknownKeyFor @NonNull @Initialized Context context) {
        String superClassName = ((TypeElement)superClassElement).getQualifiedName().toString();
        if (context.containsMetaEntity(superClassName) || context.containsMetaEmbeddable(superClassName)) {
            return true;
        }
        return !entityMetaComplete && (TypeUtils.containsAnnotation(superClassElement, "jakarta.persistence.Entity") || TypeUtils.containsAnnotation(superClassElement, "jakarta.persistence.MappedSuperclass"));
    }

    private static @UnknownKeyFor @NonNull @Initialized String getFullyQualifiedClassName(@UnknownKeyFor @NonNull @Initialized MetaEntity entity, @UnknownKeyFor @NonNull @Initialized String metaModelPackage) {
        Object fullyQualifiedClassName = "";
        if (!metaModelPackage.isEmpty()) {
            fullyQualifiedClassName = (String)fullyQualifiedClassName + metaModelPackage + ".";
        }
        fullyQualifiedClassName = (String)fullyQualifiedClassName + entity.getSimpleName() + META_MODEL_CLASS_NAME_SUFFIX;
        return fullyQualifiedClassName;
    }

    private static @UnknownKeyFor @NonNull @Initialized String writeGeneratedAnnotation(@UnknownKeyFor @NonNull @Initialized MetaEntity entity, @UnknownKeyFor @NonNull @Initialized Context context) {
        StringBuilder generatedAnnotation = new StringBuilder();
        generatedAnnotation.append("@").append(entity.importType(context.getGeneratedAnnotationFqcn())).append("(value = \"").append(JPAMetaModelEntityProcessor.class.getName());
        if (context.addGeneratedDate()) {
            generatedAnnotation.append("\", date = \"").append(SIMPLE_DATE_FORMAT.get().format(new Date())).append("\")");
        } else {
            generatedAnnotation.append("\")");
        }
        return generatedAnnotation.toString();
    }

    private static @UnknownKeyFor @NonNull @Initialized String writeSuppressWarnings() {
        return "@SuppressWarnings({ \"deprecation\", \"rawtypes\" })";
    }

    private static @UnknownKeyFor @NonNull @Initialized String writeStaticMetaModelAnnotation(@UnknownKeyFor @NonNull @Initialized MetaEntity entity) {
        return "@" + entity.importType("jakarta.persistence.metamodel.StaticMetamodel") + "(" + entity.getSimpleName() + ".class)";
    }
}

