/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.annotation;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.ImportContextImpl;
import org.hibernate.jpamodelgen.ProcessLaterException;
import org.hibernate.jpamodelgen.annotation.AnnotationMeta;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaAttribute;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaType;
import org.hibernate.jpamodelgen.annotation.CriteriaFinderMethod;
import org.hibernate.jpamodelgen.annotation.DaoConstructor;
import org.hibernate.jpamodelgen.annotation.ErrorHandler;
import org.hibernate.jpamodelgen.annotation.IdFinderMethod;
import org.hibernate.jpamodelgen.annotation.MetaAttributeGenerationVisitor;
import org.hibernate.jpamodelgen.annotation.NaturalIdFinderMethod;
import org.hibernate.jpamodelgen.annotation.QueryMethod;
import org.hibernate.jpamodelgen.model.ImportContext;
import org.hibernate.jpamodelgen.model.MetaAttribute;
import org.hibernate.jpamodelgen.model.Metamodel;
import org.hibernate.jpamodelgen.util.AccessType;
import org.hibernate.jpamodelgen.util.AccessTypeInformation;
import org.hibernate.jpamodelgen.util.Constants;
import org.hibernate.jpamodelgen.util.NullnessUtil;
import org.hibernate.jpamodelgen.util.TypeUtils;
import org.hibernate.jpamodelgen.validation.ProcessorSessionFactory;
import org.hibernate.jpamodelgen.validation.Validation;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.criteria.JpaEntityJoin;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;

public class AnnotationMetaEntity
extends AnnotationMeta {
    private final @UnknownKeyFor @NonNull @Initialized ImportContext importContext;
    private final @UnknownKeyFor @NonNull @Initialized TypeElement element;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MetaAttribute> members;
    private final @UnknownKeyFor @NonNull @Initialized Context context;
    private final @UnknownKeyFor @NonNull @Initialized boolean managed;
    private @UnknownKeyFor @NonNull @Initialized AccessTypeInformation entityAccessTypeInfo;
    private @UnknownKeyFor @NonNull @Initialized boolean initialized;
    private @UnknownKeyFor @NonNull @Initialized Metamodel entityToMerge;
    private @UnknownKeyFor @NonNull @Initialized boolean dao = false;
    private @UnknownKeyFor @NonNull @Initialized String sessionType = "jakarta.persistence.EntityManager";
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> memberTypes = new HashMap<String, String>();

    public AnnotationMetaEntity(@UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized boolean managed) {
        this.element = element;
        this.context = context;
        this.managed = managed;
        this.members = new HashMap<String, MetaAttribute>();
        this.importContext = new ImportContextImpl(AnnotationMetaEntity.getPackageName(context, element));
    }

    public static @UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity create(@UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized boolean lazilyInitialised, @UnknownKeyFor @NonNull @Initialized boolean managed) {
        AnnotationMetaEntity annotationMetaEntity = new AnnotationMetaEntity(element, context, managed);
        if (!lazilyInitialised) {
            annotationMetaEntity.init();
        }
        return annotationMetaEntity;
    }

    public @Nullable @UnknownKeyFor @Initialized String getMemberType(@UnknownKeyFor @NonNull @Initialized String entityType, @UnknownKeyFor @NonNull @Initialized String memberName) {
        return this.memberTypes.get(StringHelper.qualify((String)entityType, (String)memberName));
    }

    public @UnknownKeyFor @NonNull @Initialized AccessTypeInformation getEntityAccessTypeInfo() {
        return this.entityAccessTypeInfo;
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized Context getContext() {
        return this.context;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isImplementation() {
        return this.dao;
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String getSimpleName() {
        return this.element.getSimpleName().toString();
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String getQualifiedName() {
        return this.element.getQualifiedName().toString();
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String getPackageName() {
        return AnnotationMetaEntity.getPackageName(this.context, this.element);
    }

    private static @UnknownKeyFor @NonNull @Initialized String getPackageName(@UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized TypeElement element) {
        return context.getElementUtils().getPackageOf(element).getQualifiedName().toString();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MetaAttribute> getMembers() {
        if (!this.initialized) {
            this.init();
            if (this.entityToMerge != null) {
                this.mergeInMembers(this.entityToMerge.getMembers());
            }
        }
        return new ArrayList<MetaAttribute>(this.members.values());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isMetaComplete() {
        return false;
    }

    private void mergeInMembers(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized MetaAttribute> attributes) {
        for (MetaAttribute attribute : attributes) {
            this.importType(attribute.getMetaType());
            this.importType(attribute.getTypeDeclaration());
            this.members.put(attribute.getPropertyName(), attribute);
        }
    }

    public void mergeInMembers(@UnknownKeyFor @NonNull @Initialized Metamodel other) {
        if (!this.initialized) {
            this.entityToMerge = other;
        } else {
            this.mergeInMembers(other.getMembers());
        }
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String generateImports() {
        return this.importContext.generateImports();
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String importType(@UnknownKeyFor @NonNull @Initialized String fqcn) {
        return this.importContext.importType(fqcn);
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String staticImport(@UnknownKeyFor @NonNull @Initialized String fqcn, @UnknownKeyFor @NonNull @Initialized String member) {
        return this.importContext.staticImport(fqcn, member);
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized TypeElement getElement() {
        return this.element;
    }

    @Override
    void putMember(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized MetaAttribute nameMetaAttribute) {
        this.members.put(name, nameMetaAttribute);
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized boolean belongsToDao() {
        return this.dao;
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized String getSessionType() {
        return this.sessionType;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isInjectable() {
        return this.dao;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "AnnotationMetaEntity" + "{element=" + this.element + ", members=" + this.members + '}';
    }

    protected final void init() {
        this.getContext().logMessage(Diagnostic.Kind.OTHER, "Initializing type '" + this.getQualifiedName() + "'");
        TypeUtils.determineAccessTypeForHierarchy(this.element, this.context);
        this.entityAccessTypeInfo = NullnessUtil.castNonNull(this.context.getAccessTypeInfo(this.getQualifiedName()));
        List<VariableElement> fieldsOfClass = ElementFilter.fieldsIn(this.element.getEnclosedElements());
        List<ExecutableElement> methodsOfClass = ElementFilter.methodsIn(this.element.getEnclosedElements());
        ArrayList<ExecutableElement> gettersAndSettersOfClass = new ArrayList<ExecutableElement>();
        ArrayList<ExecutableElement> queryMethods = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : methodsOfClass) {
            if (this.isGetterOrSetter(method)) {
                gettersAndSettersOfClass.add(method);
                continue;
            }
            if (!TypeUtils.containsAnnotation(method, "org.hibernate.annotations.processing.HQL", "org.hibernate.annotations.processing.SQL", "org.hibernate.annotations.processing.Find")) continue;
            queryMethods.add(method);
        }
        this.findSessionGetter(methodsOfClass);
        if (this.managed) {
            this.putMember("class", new AnnotationMetaType(this));
        }
        this.addPersistentMembers(fieldsOfClass, AccessType.FIELD);
        this.addPersistentMembers(gettersAndSettersOfClass, AccessType.PROPERTY);
        this.addAuxiliaryMembers();
        this.checkNamedQueries();
        this.addQueryMethods(queryMethods);
        this.initialized = true;
    }

    private void findSessionGetter(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ExecutableElement> methodsOfClass) {
        if (!TypeUtils.containsAnnotation(this.element, "jakarta.persistence.Entity")) {
            for (ExecutableElement method : methodsOfClass) {
                if (!AnnotationMetaEntity.isSessionGetter(method)) continue;
                this.dao = true;
                this.sessionType = this.addDaoConstructor(method);
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized String addDaoConstructor(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        String name = method.getSimpleName().toString();
        String typeName = this.element.getSimpleName().toString() + "_";
        String sessionType = method.getReturnType().toString();
        this.putMember(name, new DaoConstructor(this, typeName, name, sessionType, this.context.addInjectAnnotation(), this.context.addNonnullAnnotation()));
        return sessionType;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isSessionGetter(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        DeclaredType declaredType;
        Element element;
        TypeMirror type;
        if (method.getParameters().isEmpty() && (type = method.getReturnType()).getKind() == TypeKind.DECLARED && (element = (declaredType = (DeclaredType)type).asElement()).getKind() == ElementKind.INTERFACE) {
            Name name = ((TypeElement)element).getQualifiedName();
            return name.contentEquals("org.hibernate.Session") || name.contentEquals("org.hibernate.StatelessSession") || name.contentEquals("org.hibernate.reactive.mutiny.Mutiny.Session") || name.contentEquals("jakarta.persistence.EntityManager");
        }
        return false;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isGetterOrSetter(@UnknownKeyFor @NonNull @Initialized Element methodOfClass) {
        TypeMirror returnType;
        List<? extends TypeMirror> methodParameterTypes;
        ExecutableType methodType = (ExecutableType)methodOfClass.asType();
        Name methodSimpleName = methodOfClass.getSimpleName();
        return AnnotationMetaEntity.isSetter(methodSimpleName, methodParameterTypes = methodType.getParameterTypes(), returnType = methodType.getReturnType()) || AnnotationMetaEntity.isGetter(methodSimpleName, methodParameterTypes, returnType);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isGetter(@UnknownKeyFor @NonNull @Initialized Name methodSimpleName, @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized TypeMirror> methodParameterTypes, @UnknownKeyFor @NonNull @Initialized TypeMirror returnType) {
        return (methodSimpleName.subSequence(0, 3).toString().equals("get") || methodSimpleName.subSequence(0, 2).toString().equals("is")) && methodParameterTypes.isEmpty() && returnType.getKind() != TypeKind.VOID;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isSetter(@UnknownKeyFor @NonNull @Initialized Name methodSimpleName, @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized TypeMirror> methodParameterTypes, @UnknownKeyFor @NonNull @Initialized TypeMirror returnType) {
        return methodSimpleName.subSequence(0, 3).toString().equals("set") && methodParameterTypes.size() == 1 && returnType.getKind() != TypeKind.VOID;
    }

    private void addPersistentMembers(@UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Element> membersOfClass, @UnknownKeyFor @NonNull @Initialized AccessType membersKind) {
        for (Element element : membersOfClass) {
            AnnotationMetaAttribute result;
            if (!this.isPersistent(element, membersKind) || (result = element.asType().accept(new MetaAttributeGenerationVisitor(this, this.context), element)) == null) continue;
            this.members.put(result.getPropertyName(), result);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isPersistent(@UnknownKeyFor @NonNull @Initialized Element memberOfClass, @UnknownKeyFor @NonNull @Initialized AccessType membersKind) {
        return (this.entityAccessTypeInfo.getAccessType() == membersKind || TypeUtils.determineAnnotationSpecifiedAccessType(memberOfClass) != null) && !TypeUtils.containsAnnotation(memberOfClass, "jakarta.persistence.Transient") && !memberOfClass.getModifiers().contains((Object)Modifier.TRANSIENT) && !memberOfClass.getModifiers().contains((Object)Modifier.STATIC);
    }

    private void addQueryMethods(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ExecutableElement> queryMethods) {
        for (ExecutableElement method : queryMethods) {
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            this.addQueryMethod(method);
        }
    }

    private void addQueryMethod(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        TypeMirror returnType = method.getReturnType();
        TypeKind kind = returnType.getKind();
        if (kind == TypeKind.VOID || kind.isPrimitive()) {
            this.addQueryMethod(method, returnType, null);
        } else if (kind == TypeKind.DECLARED) {
            DeclaredType declaredType = AnnotationMetaEntity.ununi((DeclaredType)returnType);
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            switch (typeArguments.size()) {
                case 0: {
                    if (TypeUtils.containsAnnotation(declaredType.asElement(), "jakarta.persistence.Entity")) {
                        this.addQueryMethod(method, declaredType, null);
                        break;
                    }
                    if (AnnotationMetaEntity.isLegalRawResultType(typeElement.getQualifiedName().toString())) {
                        this.addQueryMethod(method, null, typeElement);
                        break;
                    }
                    this.addQueryMethod(method, declaredType, null);
                    break;
                }
                case 1: {
                    if (AnnotationMetaEntity.isLegalGenericResultType(typeElement.toString())) {
                        this.addQueryMethod(method, typeArguments.get(0), typeElement);
                        break;
                    }
                    this.context.message(method, "incorrect return type '" + typeElement + "'", Diagnostic.Kind.ERROR);
                    break;
                }
                default: {
                    this.context.message(method, "incorrect return type '" + declaredType + "'", Diagnostic.Kind.ERROR);
                }
            }
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized DeclaredType ununi(@UnknownKeyFor @NonNull @Initialized DeclaredType returnType) {
        TypeElement typeElement = (TypeElement)returnType.asElement();
        return typeElement.getQualifiedName().contentEquals("io.smallrye.mutiny.Uni") ? (DeclaredType)returnType.getTypeArguments().get(0) : returnType;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isLegalRawResultType(@UnknownKeyFor @NonNull @Initialized String containerTypeName) {
        return containerTypeName.equals(Constants.LIST) || containerTypeName.equals("jakarta.persistence.Query") || containerTypeName.equals("org.hibernate.query.Query");
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isLegalGenericResultType(@UnknownKeyFor @NonNull @Initialized String containerTypeName) {
        return containerTypeName.equals(Constants.LIST) || containerTypeName.equals("jakarta.persistence.TypedQuery") || containerTypeName.equals("org.hibernate.query.Query") || containerTypeName.equals("org.hibernate.query.SelectionQuery");
    }

    private void addQueryMethod(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @Nullable @UnknownKeyFor @Initialized TypeElement containerType) {
        AnnotationMirror find;
        AnnotationMirror sql;
        AnnotationMirror hql = TypeUtils.getAnnotationMirror(method, "org.hibernate.annotations.processing.HQL");
        if (hql != null) {
            this.addQueryMethod(method, returnType, containerType, hql, false);
        }
        if ((sql = TypeUtils.getAnnotationMirror(method, "org.hibernate.annotations.processing.SQL")) != null) {
            this.addQueryMethod(method, returnType, containerType, sql, true);
        }
        if ((find = TypeUtils.getAnnotationMirror(method, "org.hibernate.annotations.processing.Find")) != null) {
            this.addFinderMethod(method, returnType, containerType);
        }
    }

    private void addFinderMethod(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @Nullable @UnknownKeyFor @Initialized TypeElement containerType) {
        if (returnType == null || returnType.getKind() != TypeKind.DECLARED) {
            this.context.message(method, "incorrect return type '" + returnType + "' is not an entity type", Diagnostic.Kind.ERROR);
        } else {
            DeclaredType declaredType = AnnotationMetaEntity.ununi((DeclaredType)returnType);
            TypeElement entity = (TypeElement)declaredType.asElement();
            if (!TypeUtils.containsAnnotation(entity, "jakarta.persistence.Entity")) {
                this.context.message(method, "incorrect return type '" + returnType + "' is not annotated '@Entity'", Diagnostic.Kind.ERROR);
            } else if (containerType != null) {
                this.createCriteriaFinder(method, returnType, containerType, entity);
            } else {
                long parameterCount = method.getParameters().stream().filter(AnnotationMetaEntity::isFinderParameterMappingToAttribute).count();
                switch ((int)parameterCount) {
                    case 0: {
                        this.context.message(method, "missing parameter", Diagnostic.Kind.ERROR);
                        break;
                    }
                    case 1: {
                        this.createSingleParameterFinder(method, returnType, entity);
                        break;
                    }
                    default: {
                        this.createMultipleParameterFinder(method, returnType, entity);
                    }
                }
            }
        }
    }

    private void createCriteriaFinder(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized TypeMirror returnType, @Nullable @UnknownKeyFor @Initialized TypeElement containerType, @UnknownKeyFor @NonNull @Initialized TypeElement entity) {
        String methodName = method.getSimpleName().toString();
        List<String> paramNames = AnnotationMetaEntity.parameterNames(method);
        List<String> paramTypes = AnnotationMetaEntity.parameterTypes(method);
        String[] sessionType = this.sessionTypeFromParameters(paramNames, paramTypes);
        String methodKey = methodName + paramTypes;
        for (VariableElement variableElement : method.getParameters()) {
            if (!AnnotationMetaEntity.isFinderParameterMappingToAttribute(variableElement)) continue;
            this.validateFinderParameter(entity, variableElement);
        }
        this.putMember(methodKey, new CriteriaFinderMethod(this, methodName, returnType.toString(), containerType == null ? null : containerType.toString(), paramNames, paramTypes, this.parameterNullability(method, entity), this.dao, sessionType[0], sessionType[1], AnnotationMetaEntity.enabledFetchProfiles(method), this.context.addNonnullAnnotation()));
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isFinderParameterMappingToAttribute(@UnknownKeyFor @NonNull @Initialized VariableElement param) {
        String type = param.asType().toString();
        return !AnnotationMetaEntity.isSessionParameter(type) && !QueryMethod.isPageParam(type) && !QueryMethod.isOrderParam(type);
    }

    private @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] sessionTypeFromParameters(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes) {
        for (int i = 0; i < paramNames.size(); ++i) {
            String type = paramTypes.get(i);
            String name = paramNames.get(i);
            if (!AnnotationMetaEntity.isSessionParameter(type)) continue;
            return new String[]{type, name};
        }
        return new String[]{this.sessionType, "entityManager"};
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> enabledFetchProfiles(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        Object enabledFetchProfiles = TypeUtils.getAnnotationValue(NullnessUtil.castNonNull(TypeUtils.getAnnotationMirror(method, "org.hibernate.annotations.processing.Find")), "enabledFetchProfiles");
        if (enabledFetchProfiles == null) {
            return Collections.emptyList();
        }
        List annotationValues = (List)enabledFetchProfiles;
        List<String> result = annotationValues.stream().map(AnnotationValue::toString).collect(Collectors.toList());
        if (result.stream().anyMatch("<error>"::equals)) {
            throw new ProcessLaterException();
        }
        return result;
    }

    private void createMultipleParameterFinder(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized TypeElement entity) {
        String methodName = method.getSimpleName().toString();
        List<String> paramNames = AnnotationMetaEntity.parameterNames(method);
        List<String> paramTypes = AnnotationMetaEntity.parameterTypes(method);
        String[] sessionType = this.sessionTypeFromParameters(paramNames, paramTypes);
        String methodKey = methodName + paramTypes;
        if (!this.usingStatelessSession(sessionType[0]) && this.matchesNaturalKey(method, entity)) {
            this.putMember(methodKey, new NaturalIdFinderMethod(this, methodName, returnType.toString(), paramNames, paramTypes, this.parameterNullability(method, entity), this.dao, sessionType[0], sessionType[1], AnnotationMetaEntity.enabledFetchProfiles(method), this.context.addNonnullAnnotation()));
        } else {
            this.putMember(methodKey, new CriteriaFinderMethod(this, methodName, returnType.toString(), null, paramNames, paramTypes, this.parameterNullability(method, entity), this.dao, sessionType[0], sessionType[1], AnnotationMetaEntity.enabledFetchProfiles(method), this.context.addNonnullAnnotation()));
        }
    }

    private void createSingleParameterFinder(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized TypeElement entity) {
        String methodName = method.getSimpleName().toString();
        VariableElement parameter = method.getParameters().stream().filter(AnnotationMetaEntity::isFinderParameterMappingToAttribute).findFirst().orElseThrow();
        List<String> paramNames = AnnotationMetaEntity.parameterNames(method);
        List<String> paramTypes = AnnotationMetaEntity.parameterTypes(method);
        String[] sessionType = this.sessionTypeFromParameters(paramNames, paramTypes);
        FieldType fieldType = this.validateFinderParameter(entity, parameter);
        if (fieldType != null) {
            String methodKey = methodName + "!";
            List<String> profiles = AnnotationMetaEntity.enabledFetchProfiles(method);
            switch (this.pickStrategy(fieldType, sessionType[0], profiles)) {
                case ID: {
                    this.putMember(methodKey, new IdFinderMethod(this, methodName, returnType.toString(), paramNames, paramTypes, this.dao, sessionType[0], sessionType[1], profiles, this.context.addNonnullAnnotation()));
                    break;
                }
                case NATURAL_ID: {
                    this.putMember(methodKey, new NaturalIdFinderMethod(this, methodName, returnType.toString(), paramNames, paramTypes, this.parameterNullability(method, entity), this.dao, sessionType[0], sessionType[1], profiles, this.context.addNonnullAnnotation()));
                    break;
                }
                case BASIC: {
                    this.putMember(methodKey, new CriteriaFinderMethod(this, methodName, returnType.toString(), null, paramNames, paramTypes, this.parameterNullability(method, entity), this.dao, sessionType[0], sessionType[1], profiles, this.context.addNonnullAnnotation()));
                }
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized FieldType pickStrategy(@UnknownKeyFor @NonNull @Initialized FieldType fieldType, @UnknownKeyFor @NonNull @Initialized String sessionType, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> profiles) {
        switch (fieldType) {
            case ID: {
                return (this.usingStatelessSession(sessionType) || this.usingReactiveSession(sessionType)) && !profiles.isEmpty() ? FieldType.BASIC : FieldType.ID;
            }
            case NATURAL_ID: {
                return this.usingStatelessSession(sessionType) || this.usingReactiveSession(sessionType) && !profiles.isEmpty() ? FieldType.BASIC : FieldType.NATURAL_ID;
            }
        }
        return FieldType.BASIC;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean matchesNaturalKey(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized TypeElement entity) {
        boolean result = true;
        List<? extends VariableElement> parameters = method.getParameters();
        int count = 0;
        for (VariableElement variableElement : parameters) {
            if (!AnnotationMetaEntity.isFinderParameterMappingToAttribute(variableElement)) continue;
            ++count;
            if (this.validateFinderParameter(entity, variableElement) == FieldType.NATURAL_ID) continue;
            result = false;
        }
        return result && this.countNaturalIdFields(entity) == count;
    }

    private @UnknownKeyFor @NonNull @Initialized int countNaturalIdFields(@UnknownKeyFor @NonNull @Initialized TypeElement entity) {
        int count = 0;
        for (Element element : entity.getEnclosedElements()) {
            if (!TypeUtils.containsAnnotation(element, "org.hibernate.annotations.NaturalId")) continue;
            ++count;
        }
        return count;
    }

    private @Nullable @UnknownKeyFor @Initialized FieldType validateFinderParameter(@UnknownKeyFor @NonNull @Initialized TypeElement entityType, @UnknownKeyFor @NonNull @Initialized VariableElement param) {
        Object value;
        Element member = this.memberMatchingParameter(entityType, param);
        if (member != null) {
            String memberType = AnnotationMetaEntity.memberType(member).toString();
            String paramType = param.asType().toString();
            if (!AnnotationMetaEntity.isLegalAssignment(paramType, memberType)) {
                this.context.message(param, "matching field has type '" + memberType + "' in entity class '" + entityType + "'", Diagnostic.Kind.ERROR);
            }
            if (TypeUtils.containsAnnotation(member, "jakarta.persistence.Id", "jakarta.persistence.EmbeddedId")) {
                return FieldType.ID;
            }
            if (TypeUtils.containsAnnotation(member, "org.hibernate.annotations.NaturalId")) {
                return FieldType.NATURAL_ID;
            }
            return FieldType.BASIC;
        }
        AnnotationMirror idClass = TypeUtils.getAnnotationMirror(entityType, "jakarta.persistence.IdClass");
        if (idClass != null && (value = TypeUtils.getAnnotationValue(idClass, "value")) instanceof TypeMirror && this.context.getTypeUtils().isSameType(param.asType(), (TypeMirror)value)) {
            return FieldType.ID;
        }
        this.context.message(param, "no matching field named '" + param.getSimpleName().toString().replace('$', '.') + "' in entity class '" + entityType + "'", Diagnostic.Kind.ERROR);
        return null;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean finderParameterNullable(@UnknownKeyFor @NonNull @Initialized TypeElement entity, @UnknownKeyFor @NonNull @Initialized VariableElement param) {
        Element member = this.memberMatchingParameter(entity, param);
        return member == null || AnnotationMetaEntity.isNullable(member);
    }

    private @UnknownKeyFor @NonNull @Initialized AccessType getAccessType(@UnknownKeyFor @NonNull @Initialized TypeElement entity) {
        String entityClassName = entity.getQualifiedName().toString();
        TypeUtils.determineAccessTypeForHierarchy(entity, this.context);
        return NullnessUtil.castNonNull(this.context.getAccessTypeInfo(entityClassName)).getAccessType();
    }

    private static @UnknownKeyFor @NonNull @Initialized TypeMirror memberType(@UnknownKeyFor @NonNull @Initialized Element member) {
        if (member.getKind() == ElementKind.METHOD) {
            ExecutableElement method = (ExecutableElement)member;
            return method.getReturnType();
        }
        return member.asType();
    }

    private @Nullable @UnknownKeyFor @Initialized Element memberMatchingParameter(@UnknownKeyFor @NonNull @Initialized TypeElement entityType, @UnknownKeyFor @NonNull @Initialized VariableElement param) {
        StringTokenizer tokens = new StringTokenizer(param.getSimpleName().toString(), "$");
        return this.memberMatchingParameter(entityType, param, tokens);
    }

    private @Nullable @UnknownKeyFor @Initialized Element memberMatchingParameter(@UnknownKeyFor @NonNull @Initialized TypeElement entityType, @UnknownKeyFor @NonNull @Initialized VariableElement param, @UnknownKeyFor @NonNull @Initialized StringTokenizer tokens) {
        AccessType accessType = this.getAccessType(entityType);
        String nextToken = tokens.nextToken();
        for (Element element : entityType.getEnclosedElements()) {
            Element match = this.memberMatchingParameter(entityType, param, element, accessType, tokens, nextToken);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private @Nullable @UnknownKeyFor @Initialized Element memberMatchingParameter(@UnknownKeyFor @NonNull @Initialized TypeElement entityType, @UnknownKeyFor @NonNull @Initialized VariableElement param, @UnknownKeyFor @NonNull @Initialized Element candidate, @UnknownKeyFor @NonNull @Initialized AccessType accessType, @UnknownKeyFor @NonNull @Initialized StringTokenizer tokens, @UnknownKeyFor @NonNull @Initialized String token) {
        TypeMirror type;
        Name memberName = candidate.getSimpleName();
        if (accessType == AccessType.FIELD && candidate.getKind() == ElementKind.FIELD) {
            if (!AnnotationMetaEntity.fieldMatches(token, memberName)) {
                return null;
            }
            type = candidate.asType();
        } else if (accessType == AccessType.PROPERTY && candidate.getKind() == ElementKind.METHOD) {
            if (!AnnotationMetaEntity.getterMatches(token, memberName)) {
                return null;
            }
            ExecutableElement method = (ExecutableElement)candidate;
            type = method.getReturnType();
        } else {
            return null;
        }
        if (tokens.hasMoreTokens()) {
            if (type.getKind() == TypeKind.DECLARED) {
                DeclaredType declaredType = (DeclaredType)type;
                TypeElement memberType = (TypeElement)declaredType.asElement();
                this.memberTypes.put(StringHelper.qualify((String)entityType.getQualifiedName().toString(), (String)memberName.toString()), memberType.getQualifiedName().toString());
                return this.memberMatchingParameter(memberType, param, tokens);
            }
            return null;
        }
        return candidate;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean fieldMatches(@UnknownKeyFor @NonNull @Initialized String token, @UnknownKeyFor @NonNull @Initialized Name fieldName) {
        return fieldName.contentEquals(token);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean getterMatches(@UnknownKeyFor @NonNull @Initialized String token, @UnknownKeyFor @NonNull @Initialized Name methodName) {
        if (methodName.length() > 3 && methodName.subSequence(0, 3).toString().equals("get")) {
            String propertyName = Introspector.decapitalize(methodName.subSequence(3, methodName.length()).toString());
            return token.equals(propertyName);
        }
        if (methodName.length() > 2 && methodName.subSequence(0, 2).toString().equals("is")) {
            String propertyName = Introspector.decapitalize(methodName.subSequence(2, methodName.length()).toString());
            return token.equals(propertyName);
        }
        return false;
    }

    private void addQueryMethod(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @Nullable @UnknownKeyFor @Initialized TypeElement containerType, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized boolean isNative) {
        Object query;
        AnnotationValue value = TypeUtils.getAnnotationValueRef(mirror, "value");
        if (value != null && (query = value.getValue()) instanceof String) {
            String hql = (String)query;
            List<String> paramNames = AnnotationMetaEntity.parameterNames(method);
            List<String> paramTypes = AnnotationMetaEntity.parameterTypes(method);
            String[] sessionType = this.sessionTypeFromParameters(paramNames, paramTypes);
            QueryMethod attribute = new QueryMethod(this, method.getSimpleName().toString(), hql, returnType == null ? null : returnType.toString(), containerType == null ? null : containerType.getQualifiedName().toString(), paramNames, paramTypes, returnType != null && returnType.getKind() != TypeKind.DECLARED && returnType.getKind() != TypeKind.ARRAY, isNative, this.dao, sessionType[0], sessionType[1], this.context.addNonnullAnnotation());
            this.putMember(attribute.getPropertyName() + paramTypes, attribute);
            if (!isNative) {
                this.validateHql(method, returnType, mirror, value, hql, paramNames, paramTypes);
            }
            this.checkParameters(method, paramNames, paramTypes, mirror, value, hql);
        }
    }

    private void validateHql(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value, @UnknownKeyFor @NonNull @Initialized String hql, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes) {
        SqmStatement<?> statement = Validation.validate(hql, returnType, true, new ErrorHandler(this.context, method, mirror, value, hql), ProcessorSessionFactory.create(this.context.getProcessingEnvironment()));
        if (statement != null) {
            if (statement instanceof SqmSelectStatement) {
                this.validateSelectHql(method, returnType, mirror, value, (SqmSelectStatement)statement);
            } else {
                this.validateUpdateHql(method, returnType, mirror, value);
            }
            for (SqmParameter param : statement.getSqmParameters()) {
                this.checkParameter(param, paramNames, paramTypes, method, mirror, value);
            }
        }
    }

    private void validateUpdateHql(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value) {
        if (returnType == null || returnType.getKind() != TypeKind.VOID && returnType.getKind() != TypeKind.INT) {
            this.context.message(method, mirror, value, "return type of mutation query method must be 'int' or 'void'", Diagnostic.Kind.ERROR);
        }
    }

    private void validateSelectHql(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SqmSelectStatement<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> statement) {
        if (returnType != null) {
            boolean returnTypeCorrect;
            JpaSelection selection = statement.getSelection();
            if (selection.isCompoundSelection()) {
                switch (returnType.getKind()) {
                    case ARRAY: {
                        returnTypeCorrect = AnnotationMetaEntity.checkReturnedArrayType((ArrayType)returnType);
                        break;
                    }
                    case DECLARED: {
                        if (!AnnotationMetaEntity.checkConstructorReturn((DeclaredType)returnType, selection)) {
                            this.context.message(method, mirror, value, "return type '" + returnType + "' of method has no constructor matching query selection list", Diagnostic.Kind.ERROR);
                        }
                        returnTypeCorrect = true;
                        break;
                    }
                    default: {
                        returnTypeCorrect = false;
                        break;
                    }
                }
            } else if (selection instanceof JpaEntityJoin) {
                JpaEntityJoin from = (JpaEntityJoin)selection;
                returnTypeCorrect = this.checkReturnedEntity(from.getModel(), returnType);
            } else if (selection instanceof JpaRoot) {
                JpaRoot from = (JpaRoot)selection;
                returnTypeCorrect = this.checkReturnedEntity(from.getModel(), returnType);
            } else {
                returnTypeCorrect = true;
            }
            if (!returnTypeCorrect) {
                this.context.message(method, mirror, value, "return type of query did not match return type '" + returnType + "' of method", Diagnostic.Kind.ERROR);
            }
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean checkConstructorReturn(@UnknownKeyFor @NonNull @Initialized DeclaredType returnType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized JpaSelection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> selection) {
        List selectionItems = selection.getSelectionItems();
        if (selectionItems == null) {
            return true;
        }
        TypeElement typeElement = (TypeElement)returnType.asElement();
        Name qualifiedName = typeElement.getQualifiedName();
        if (qualifiedName.contentEquals("jakarta.persistence.Tuple") || qualifiedName.contentEquals(Constants.LIST) || qualifiedName.contentEquals(Constants.MAP)) {
            return true;
        }
        for (Element element : typeElement.getEnclosedElements()) {
            ExecutableElement constructor;
            if (element.getKind() != ElementKind.CONSTRUCTOR || !AnnotationMetaEntity.constructorMatches(selectionItems, (constructor = (ExecutableElement)element).getParameters())) continue;
            return true;
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean constructorMatches(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized JpaSelection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> selectionItems, @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized VariableElement> parameters) {
        int itemCount = selectionItems.size();
        if (parameters.size() == itemCount) {
            for (int i = 0; i < itemCount; ++i) {
                JpaSelection<?> item = selectionItems.get(i);
                if (item == null || item.getJavaType() == null || AnnotationMetaEntity.parameterMatches(parameters.get(i), item)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean parameterMatches(@UnknownKeyFor @NonNull @Initialized VariableElement parameter, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized JpaSelection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> item) {
        Class itemType = item.getJavaType();
        TypeMirror parameterType = parameter.asType();
        TypeKind kind = parameterType.getKind();
        String itemTypeName = itemType.getName();
        if (kind == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)parameterType;
            TypeElement paramTypeElement = (TypeElement)declaredType.asElement();
            return paramTypeElement.getQualifiedName().contentEquals(itemTypeName);
        }
        if (kind.isPrimitive()) {
            return parameterType.toString().equals(itemTypeName);
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean checkReturnedArrayType(@UnknownKeyFor @NonNull @Initialized ArrayType returnType) {
        TypeMirror componentType = returnType.getComponentType();
        if (componentType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)componentType;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            return typeElement.getQualifiedName().contentEquals("java.lang.Object");
        }
        return false;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean checkReturnedEntity(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized EntityDomainType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> model, @UnknownKeyFor @NonNull @Initialized TypeMirror returnType) {
        DeclaredType declaredType;
        TypeElement typeElement;
        AnnotationMirror mirror;
        if (returnType.getKind() == TypeKind.DECLARED && (mirror = TypeUtils.getAnnotationMirror(typeElement = (TypeElement)(declaredType = (DeclaredType)returnType).asElement(), "jakarta.persistence.Entity")) != null) {
            Object value = TypeUtils.getAnnotationValue(mirror, "name");
            String entityName = value instanceof String ? (String)value : typeElement.getSimpleName().toString();
            return model.getHibernateEntityName().equals(entityName);
        }
        return false;
    }

    private void checkParameter(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SqmParameter<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> param, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value) {
        String queryParamType;
        SqmExpressible expressible = param.getExpressible();
        String string = queryParamType = expressible == null ? "unknown" : expressible.getTypeName();
        if (param.getName() != null) {
            String name = param.getName();
            int index = paramNames.indexOf(name);
            if (index < 0) {
                this.context.message(method, mirror, value, "missing method parameter for query parameter :" + name + " (add a parameter '" + queryParamType + " " + name + "' to '" + method.getSimpleName() + "')", Diagnostic.Kind.ERROR);
            } else if (!AnnotationMetaEntity.isLegalAssignment(paramTypes.get(index), queryParamType)) {
                this.context.message(method, mirror, value, "parameter matching query parameter :" + name + " has the wrong type (change the method parameter type to '" + queryParamType + "')", Diagnostic.Kind.ERROR);
            }
        } else if (param.getPosition() != null) {
            int position = param.getPosition();
            if (position > paramNames.size()) {
                this.context.message(method, mirror, value, "missing method parameter for query parameter ?" + position + " (add a parameter of type '" + queryParamType + "' to '" + method.getSimpleName() + "')", Diagnostic.Kind.ERROR);
            } else if (!AnnotationMetaEntity.isLegalAssignment(paramTypes.get(position - 1), queryParamType)) {
                this.context.message(method, mirror, value, "parameter matching query parameter ?" + position + " has the wrong type (change the method parameter type to '" + queryParamType + "')", Diagnostic.Kind.ERROR);
            }
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isLegalAssignment(@UnknownKeyFor @NonNull @Initialized String argType, @UnknownKeyFor @NonNull @Initialized String paramType) {
        return paramType.equals("unknown") || paramType.equals(argType) || paramType.equals(AnnotationMetaEntity.fromPrimitive(argType));
    }

    private static @Nullable @UnknownKeyFor @Initialized String fromPrimitive(@UnknownKeyFor @NonNull @Initialized String argType) {
        switch (argType) {
            case "boolean": {
                return Boolean.class.getName();
            }
            case "char": {
                return Character.class.getName();
            }
            case "int": {
                return Integer.class.getName();
            }
            case "long": {
                return Long.class.getName();
            }
            case "short": {
                return Short.class.getName();
            }
            case "byte": {
                return Byte.class.getName();
            }
            case "float": {
                return Float.class.getName();
            }
            case "double": {
                return Double.class.getName();
            }
        }
        return null;
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> parameterNullability(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized TypeElement entity) {
        return method.getParameters().stream().map(param -> this.finderParameterNullable(entity, (VariableElement)param)).collect(Collectors.toList());
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> parameterTypes(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        return method.getParameters().stream().map(param -> param.asType().toString()).collect(Collectors.toList());
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> parameterNames(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        return method.getParameters().stream().map(param -> param.getSimpleName().toString()).collect(Collectors.toList());
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isNullable(@UnknownKeyFor @NonNull @Initialized Element member) {
        switch (member.getKind()) {
            case METHOD: {
                ExecutableElement method = (ExecutableElement)member;
                if (method.getReturnType().getKind().isPrimitive()) {
                    return false;
                }
            }
            case FIELD: {
                if (!member.asType().getKind().isPrimitive()) break;
                return false;
            }
        }
        boolean nullable = true;
        for (AnnotationMirror annotationMirror : member.getAnnotationMirrors()) {
            TypeElement annotationType = (TypeElement)annotationMirror.getAnnotationType().asElement();
            Name name = annotationType.getQualifiedName();
            if (name.contentEquals("jakarta.persistence.Id")) {
                nullable = false;
            }
            if (name.contentEquals("jakarta.validation.constraints.NotNull")) {
                nullable = false;
            }
            if (!name.contentEquals("jakarta.persistence.Basic") && !name.contentEquals("jakarta.persistence.ManyToOne") && !name.contentEquals("jakarta.persistence.OneToOne") || !Boolean.FALSE.equals(TypeUtils.getAnnotationValue(annotationMirror, "optional"))) continue;
            nullable = false;
        }
        return nullable;
    }

    private void checkParameters(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value, @UnknownKeyFor @NonNull @Initialized String hql) {
        for (int i = 1; i <= paramNames.size(); ++i) {
            String type;
            String param = paramNames.get(i - 1);
            if (!AnnotationMetaEntity.parameterIsMissing(hql, i, param, type = paramTypes.get(i - 1))) continue;
            this.context.message(method, mirror, value, "missing query parameter for '" + param + "' (no parameter named :" + param + " or ?" + i + ")", Diagnostic.Kind.ERROR);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean parameterIsMissing(@UnknownKeyFor @NonNull @Initialized String hql, @UnknownKeyFor @NonNull @Initialized int i, @UnknownKeyFor @NonNull @Initialized String param, @UnknownKeyFor @NonNull @Initialized String type) {
        return !hql.matches(".*(:" + param + "|\\?" + i + ")\\b.*") && !AnnotationMetaEntity.isSessionParameter(type) && !QueryMethod.isPageParam(type) && !QueryMethod.isOrderParam(type);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isSessionParameter(@UnknownKeyFor @NonNull @Initialized String type) {
        return Constants.SESSION_TYPES.contains(type);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean usingReactiveSession(@UnknownKeyFor @NonNull @Initialized String sessionType) {
        return "org.hibernate.reactive.mutiny.Mutiny.Session".equals(sessionType);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean usingStatelessSession(@UnknownKeyFor @NonNull @Initialized String sessionType) {
        return "org.hibernate.StatelessSession".equals(sessionType);
    }

    static enum FieldType {
        ID,
        NATURAL_ID,
        BASIC;

    }
}

