/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.annotation;

import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jpamodelgen.annotation.AbstractQueryMethod;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaEntity;
import org.hibernate.jpamodelgen.util.Constants;
import org.hibernate.jpamodelgen.util.StringUtil;

public class QueryMethod
extends AbstractQueryMethod {
    private final @UnknownKeyFor @NonNull @Initialized String queryString;
    private final @Nullable @UnknownKeyFor @Initialized String returnTypeName;
    private final @Nullable @UnknownKeyFor @Initialized String containerTypeName;
    private final @UnknownKeyFor @NonNull @Initialized boolean isUpdate;
    private final @UnknownKeyFor @NonNull @Initialized boolean isNative;

    public QueryMethod(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String queryString, @Nullable @UnknownKeyFor @Initialized String returnTypeName, @Nullable @UnknownKeyFor @Initialized String containerTypeName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized boolean isUpdate, @UnknownKeyFor @NonNull @Initialized boolean isNative, @UnknownKeyFor @NonNull @Initialized boolean belongsToDao, @UnknownKeyFor @NonNull @Initialized String sessionType, @UnknownKeyFor @NonNull @Initialized String sessionName, @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation) {
        super(annotationMetaEntity, methodName, paramNames, paramTypes, returnTypeName, sessionType, sessionName, belongsToDao, addNonnullAnnotation);
        this.queryString = queryString;
        this.returnTypeName = returnTypeName;
        this.containerTypeName = containerTypeName;
        this.isUpdate = isUpdate;
        this.isNative = isNative;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasStringAttribute() {
        return true;
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized boolean isNullable(@UnknownKeyFor @NonNull @Initialized int index) {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        List<String> paramTypes = this.parameterTypes();
        StringBuilder returnType = this.returnType();
        StringBuilder declaration = new StringBuilder();
        this.comment(declaration);
        this.modifiers(paramTypes, declaration);
        declaration.append((CharSequence)returnType).append(" ").append(this.methodName);
        this.parameters(paramTypes, declaration);
        declaration.append(" {").append("\n\t");
        if (this.returnTypeName == null || !this.returnTypeName.equals("void")) {
            declaration.append("return ");
        }
        if (this.isNative && this.returnTypeName != null && this.containerTypeName == null && this.isUsingEntityManager()) {
            declaration.append("(").append((CharSequence)returnType).append(") ");
        }
        declaration.append(this.sessionName).append(this.isNative ? ".createNativeQuery" : ".createQuery").append("(").append(this.getConstantName());
        if (this.returnTypeName != null && !this.isUpdate) {
            declaration.append(", ").append(this.annotationMetaEntity.importType(this.returnTypeName)).append(".class");
        }
        declaration.append(")");
        boolean unwrapped = this.setParameters(paramTypes, declaration);
        this.execute(declaration, unwrapped);
        declaration.append(";\n}");
        return declaration.toString();
    }

    private void execute(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized boolean unwrapped) {
        if (this.isUpdate) {
            declaration.append("\n\t\t\t.executeUpdate()");
        } else if (this.containerTypeName == null) {
            declaration.append("\n\t\t\t.getSingleResult()");
        } else if (this.containerTypeName.equals(Constants.LIST)) {
            declaration.append("\n\t\t\t.getResultList()");
        } else if (this.isUsingEntityManager() && !unwrapped && (this.containerTypeName.startsWith("org.hibernate") || this.isNative && this.returnTypeName != null)) {
            declaration.append("\n\t\t\t.unwrap(").append(this.annotationMetaEntity.importType(this.containerTypeName)).append(".class)");
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean setParameters(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        boolean unwrapped = !this.isUsingEntityManager();
        for (int i = 0; i < this.paramNames.size(); ++i) {
            String paramName = (String)this.paramNames.get(i);
            String paramType = paramTypes.get(i);
            if (QueryMethod.isSessionParameter(paramType)) continue;
            int ordinal = i + 1;
            if (this.queryString.contains(":" + paramName)) {
                QueryMethod.setNamedParameter(declaration, paramName);
                continue;
            }
            if (this.queryString.contains("?" + ordinal)) {
                QueryMethod.setOrdinalParameter(declaration, ordinal, paramName);
                continue;
            }
            if (QueryMethod.isPageParam(paramType)) {
                this.setPage(declaration, paramName);
                continue;
            }
            if (!QueryMethod.isOrderParam(paramType)) continue;
            unwrapped = this.setOrder(declaration, unwrapped, paramName, paramType);
        }
        return unwrapped;
    }

    private static void setOrdinalParameter(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized int i, @UnknownKeyFor @NonNull @Initialized String paramName) {
        declaration.append("\n\t\t\t.setParameter(").append(i).append(", ").append(paramName).append(")");
    }

    private static void setNamedParameter(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized String paramName) {
        declaration.append("\n\t\t\t.setParameter(\"").append(paramName).append("\", ").append(paramName).append(")");
    }

    private @UnknownKeyFor @NonNull @Initialized StringBuilder returnType() {
        boolean returnsUni;
        StringBuilder type = new StringBuilder();
        boolean bl = returnsUni = this.isReactive() && (this.containerTypeName == null || Constants.LIST.equals(this.containerTypeName));
        if (returnsUni) {
            type.append(this.annotationMetaEntity.importType("io.smallrye.mutiny.Uni")).append('<');
        }
        if (this.containerTypeName != null) {
            type.append(this.annotationMetaEntity.importType(this.containerTypeName));
            if (this.returnTypeName != null) {
                type.append("<").append(this.annotationMetaEntity.importType(this.returnTypeName)).append(">");
            }
        } else if (this.returnTypeName != null) {
            type.append(this.annotationMetaEntity.importType(this.returnTypeName));
        }
        if (returnsUni) {
            type.append('>');
        }
        return type;
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> parameterTypes() {
        return this.paramTypes.stream().map(paramType -> QueryMethod.isOrderParam(paramType) && paramType.endsWith("[]") ? paramType.substring(0, paramType.length() - 2) + "..." : paramType).collect(Collectors.toList());
    }

    private void comment(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append("\n/**");
        declaration.append("\n * Execute the query {@value #").append(this.getConstantName()).append("}.").append("\n *");
        this.see(declaration);
        declaration.append("\n **/\n");
    }

    private void modifiers(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        boolean hasVarargs = paramTypes.stream().anyMatch(ptype -> ptype.endsWith("..."));
        if (hasVarargs) {
            declaration.append("@SafeVarargs\n");
        }
        if (this.belongsToDao) {
            declaration.append("@Override\npublic ");
            if (hasVarargs) {
                declaration.append("final ");
            }
        } else {
            declaration.append("public static ");
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeNameDeclarationString() {
        return "static final String " + this.getConstantName() + " = \"" + this.queryString + "\";";
    }

    private @UnknownKeyFor @NonNull @Initialized String getConstantName() {
        String stem = StringUtil.getUpperUnderscoreCaseFromLowerCamelCase(this.methodName);
        if (this.paramTypes.isEmpty()) {
            return stem;
        }
        return stem + "_" + this.paramTypes.stream().filter(name -> !QueryMethod.isPageParam(name) && !QueryMethod.isOrderParam(name)).map(StringHelper::unqualify).reduce((x, y) -> x + "_" + y).orElse("");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTypeDeclaration() {
        return "jakarta.persistence.Query";
    }
}

