/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.tools.Diagnostic;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.jpamodelgen.ClassWriter;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.ProcessLaterException;
import org.hibernate.jpamodelgen.Version;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaEntity;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaPackage;
import org.hibernate.jpamodelgen.model.Metamodel;
import org.hibernate.jpamodelgen.util.Constants;
import org.hibernate.jpamodelgen.util.StringUtil;
import org.hibernate.jpamodelgen.util.TypeUtils;
import org.hibernate.jpamodelgen.xml.JpaDescriptorParser;

@SupportedAnnotationTypes(value={"jakarta.persistence.Entity", "jakarta.persistence.MappedSuperclass", "jakarta.persistence.Embeddable", "org.hibernate.annotations.processing.HQL", "org.hibernate.annotations.processing.SQL", "org.hibernate.annotations.processing.Find", "jakarta.persistence.NamedQuery", "jakarta.persistence.NamedNativeQuery", "jakarta.persistence.NamedEntityGraph", "jakarta.persistence.SqlResultSetMapping", "org.hibernate.annotations.FetchProfile", "org.hibernate.annotations.FilterDef", "org.hibernate.annotations.NamedQuery", "org.hibernate.annotations.NamedNativeQuery"})
@SupportedOptions(value={"debug", "persistenceXml", "ormXml", "fullyAnnotationConfigured", "lazyXmlParsing", "addGenerationDate", "addGeneratedAnnotation", "addSuppressWarningsAnnotation"})
public class JPAMetaModelEntityProcessor
extends AbstractProcessor {
    public static final @UnknownKeyFor @NonNull @Initialized String DEBUG_OPTION = "debug";
    public static final @UnknownKeyFor @NonNull @Initialized String PERSISTENCE_XML_OPTION = "persistenceXml";
    public static final @UnknownKeyFor @NonNull @Initialized String ORM_XML_OPTION = "ormXml";
    public static final @UnknownKeyFor @NonNull @Initialized String FULLY_ANNOTATION_CONFIGURED_OPTION = "fullyAnnotationConfigured";
    public static final @UnknownKeyFor @NonNull @Initialized String LAZY_XML_PARSING = "lazyXmlParsing";
    public static final @UnknownKeyFor @NonNull @Initialized String ADD_GENERATION_DATE = "addGenerationDate";
    public static final @UnknownKeyFor @NonNull @Initialized String ADD_GENERATED_ANNOTATION = "addGeneratedAnnotation";
    public static final @UnknownKeyFor @NonNull @Initialized String ADD_SUPPRESS_WARNINGS_ANNOTATION = "addSuppressWarningsAnnotation";
    private static final @UnknownKeyFor @NonNull @Initialized boolean ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS = false;
    private @UnknownKeyFor @NonNull @Initialized Context context;

    @Override
    public synchronized void init(@UnknownKeyFor @NonNull @Initialized ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.context = new Context(processingEnvironment);
        this.context.logMessage(Diagnostic.Kind.NOTE, "Hibernate/JPA static Metamodel Generator " + Version.getVersionString());
        boolean fullyAnnotationConfigured = this.handleSettings(processingEnvironment);
        if (!fullyAnnotationConfigured) {
            new JpaDescriptorParser(this.context).parseXml();
            if (this.context.isFullyXmlConfigured()) {
                this.createMetaModelClasses();
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean handleSettings(@UnknownKeyFor @NonNull @Initialized ProcessingEnvironment environment) {
        PackageElement jakartaInjectPackage = this.context.getProcessingEnvironment().getElementUtils().getPackageElement("jakarta.inject");
        PackageElement jakartaAnnotationPackage = this.context.getProcessingEnvironment().getElementUtils().getPackageElement("jakarta.annotation");
        PackageElement jakartaContextPackage = this.context.getProcessingEnvironment().getElementUtils().getPackageElement("jakarta.enterprise.context");
        this.context.setAddInjectAnnotation(jakartaInjectPackage != null);
        this.context.setAddNonnullAnnotation(jakartaAnnotationPackage != null);
        this.context.setAddGeneratedAnnotation(jakartaAnnotationPackage != null);
        this.context.setAddDependentAnnotation(jakartaContextPackage != null);
        Map<String, String> options = environment.getOptions();
        String setting = options.get(ADD_GENERATED_ANNOTATION);
        if (setting != null) {
            this.context.setAddGeneratedAnnotation(Boolean.parseBoolean(setting));
        }
        this.context.setAddGenerationDate(Boolean.parseBoolean(options.get(ADD_GENERATION_DATE)));
        this.context.setAddSuppressWarningsAnnotation(Boolean.parseBoolean(options.get(ADD_SUPPRESS_WARNINGS_ANNOTATION)));
        return Boolean.parseBoolean(options.get(FULLY_ANNOTATION_CONFIGURED_OPTION));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean process(@UnknownKeyFor @NonNull @Initialized Set<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized TypeElement> annotations, @UnknownKeyFor @NonNull @Initialized RoundEnvironment roundEnvironment) {
        if (roundEnvironment.processingOver()) {
            Set<CharSequence> elementsToRedo = this.context.getElementsToRedo();
            if (!elementsToRedo.isEmpty()) {
                this.context.logMessage(Diagnostic.Kind.ERROR, "Failed to generate code for " + elementsToRedo);
            }
        } else if (this.context.isFullyXmlConfigured()) {
            this.context.logMessage(Diagnostic.Kind.OTHER, "Skipping the processing of annotations since persistence unit is purely XML configured.");
        } else {
            this.context.logMessage(Diagnostic.Kind.OTHER, "Starting new round");
            try {
                this.processClasses(roundEnvironment);
                this.createMetaModelClasses();
            }
            catch (Exception e) {
                this.context.logMessage(Diagnostic.Kind.ERROR, "Error generating JPA metamodel: " + e.getMessage());
            }
        }
        return false;
    }

    private void processClasses(@UnknownKeyFor @NonNull @Initialized RoundEnvironment roundEnvironment) {
        TypeElement typeElement;
        for (CharSequence charSequence : new HashSet<CharSequence>(this.context.getElementsToRedo())) {
            this.context.logMessage(Diagnostic.Kind.OTHER, "Redoing element '" + charSequence + "'");
            typeElement = this.context.getElementUtils().getTypeElement(charSequence);
            try {
                AnnotationMetaEntity metaEntity = AnnotationMetaEntity.create(typeElement, this.context, false, false);
                this.context.addMetaAuxiliary(metaEntity.getQualifiedName(), metaEntity);
                this.context.removeElementToRedo(charSequence);
            }
            catch (ProcessLaterException processLaterException) {}
        }
        for (Element element : roundEnvironment.getRootElements()) {
            try {
                if (JPAMetaModelEntityProcessor.isEntityOrEmbeddable(element)) {
                    this.context.logMessage(Diagnostic.Kind.OTHER, "Processing annotated entity class '" + element + "'");
                    this.handleRootElementAnnotationMirrors(element);
                    continue;
                }
                if (this.hasAuxiliaryAnnotations(element)) {
                    this.context.logMessage(Diagnostic.Kind.OTHER, "Processing annotated class '" + element + "'");
                    this.handleRootElementAuxiliaryAnnotationMirrors(element);
                    continue;
                }
                if (!(element instanceof TypeElement)) continue;
                typeElement = (TypeElement)element;
                for (Element element2 : typeElement.getEnclosedElements()) {
                    if (!TypeUtils.containsAnnotation(element2, "org.hibernate.annotations.processing.HQL", "org.hibernate.annotations.processing.SQL", "org.hibernate.annotations.processing.Find")) continue;
                    this.context.logMessage(Diagnostic.Kind.OTHER, "Processing annotated class '" + element + "'");
                    AnnotationMetaEntity metaEntity = AnnotationMetaEntity.create(typeElement, this.context, false, false);
                    this.context.addMetaAuxiliary(metaEntity.getQualifiedName(), metaEntity);
                }
            }
            catch (ProcessLaterException processLaterException) {
                if (!(element instanceof TypeElement)) continue;
                this.context.logMessage(Diagnostic.Kind.OTHER, "Could not process '" + element + "' (will redo in next round)");
                this.context.addElementToRedo(((TypeElement)element).getQualifiedName());
            }
        }
    }

    private void createMetaModelClasses() {
        for (Metamodel aux : this.context.getMetaAuxiliaries()) {
            if (this.context.isAlreadyGenerated(aux.getQualifiedName())) continue;
            this.context.logMessage(Diagnostic.Kind.OTHER, "Writing metamodel for auxiliary '" + aux + "'");
            ClassWriter.writeFile(aux, this.context);
            this.context.markGenerated(aux.getQualifiedName());
        }
        for (Metamodel entity : this.context.getMetaEntities()) {
            if (this.context.isAlreadyGenerated(entity.getQualifiedName())) continue;
            this.context.logMessage(Diagnostic.Kind.OTHER, "Writing metamodel for entity '" + entity + "'");
            ClassWriter.writeFile(entity, this.context);
            this.context.markGenerated(entity.getQualifiedName());
        }
        Collection<Metamodel> toProcessEntities = this.context.getMetaEmbeddables();
        while (!toProcessEntities.isEmpty()) {
            HashSet<Metamodel> processedEntities = new HashSet<Metamodel>();
            int toProcessCountBeforeLoop = toProcessEntities.size();
            for (Metamodel entity : toProcessEntities) {
                if (this.context.isAlreadyGenerated(entity.getQualifiedName())) {
                    processedEntities.add(entity);
                    continue;
                }
                if (this.modelGenerationNeedsToBeDeferred(toProcessEntities, entity)) continue;
                this.context.logMessage(Diagnostic.Kind.OTHER, "Writing meta model for embeddable/mapped superclass " + entity);
                ClassWriter.writeFile(entity, this.context);
                this.context.markGenerated(entity.getQualifiedName());
                processedEntities.add(entity);
            }
            toProcessEntities.removeAll(processedEntities);
            if (toProcessEntities.size() < toProcessCountBeforeLoop) continue;
            this.context.logMessage(Diagnostic.Kind.ERROR, "Potential endless loop in generation of entities.");
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean modelGenerationNeedsToBeDeferred(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Metamodel> entities, @UnknownKeyFor @NonNull @Initialized Metamodel containedEntity) {
        Element element = containedEntity.getElement();
        if (element instanceof TypeElement) {
            ContainsAttributeTypeVisitor visitor = new ContainsAttributeTypeVisitor((TypeElement)element, this.context);
            for (Metamodel entity : entities) {
                TypeMirror mirror;
                if (entity.equals(containedEntity)) continue;
                for (Element element2 : ElementFilter.fieldsIn(entity.getElement().getEnclosedElements())) {
                    mirror = element2.asType();
                    if (TypeKind.DECLARED != mirror.getKind() || !mirror.accept(visitor, element2).booleanValue()) continue;
                    return true;
                }
                for (Element element3 : ElementFilter.methodsIn(entity.getElement().getEnclosedElements())) {
                    mirror = element3.asType();
                    if (TypeKind.DECLARED != mirror.getKind() || !mirror.accept(visitor, element3).booleanValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isEntityOrEmbeddable(@UnknownKeyFor @NonNull @Initialized Element element) {
        return TypeUtils.containsAnnotation(element, "jakarta.persistence.Entity", "jakarta.persistence.MappedSuperclass", "jakarta.persistence.Embeddable");
    }

    private @UnknownKeyFor @NonNull @Initialized boolean hasAuxiliaryAnnotations(@UnknownKeyFor @NonNull @Initialized Element element) {
        return TypeUtils.containsAnnotation(element, "jakarta.persistence.NamedQuery", "jakarta.persistence.NamedQueries", "jakarta.persistence.NamedNativeQuery", "jakarta.persistence.NamedNativeQueries", "jakarta.persistence.SqlResultSetMapping", "jakarta.persistence.SqlResultSetMappings", "jakarta.persistence.NamedEntityGraph", "jakarta.persistence.NamedEntityGraphs", "org.hibernate.annotations.NamedQuery", "org.hibernate.annotations.NamedQueries", "org.hibernate.annotations.NamedNativeQuery", "org.hibernate.annotations.NamedNativeQueries", "org.hibernate.annotations.FetchProfile", "org.hibernate.annotations.FetchProfiles", "org.hibernate.annotations.FilterDef", "org.hibernate.annotations.FilterDefs");
    }

    private void handleRootElementAnnotationMirrors(@UnknownKeyFor @NonNull @Initialized Element element) {
        if (TypeUtils.isClassOrRecordType(element)) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                TypeElement typeElement;
                String qualifiedName;
                Metamodel alreadyExistingMetaEntity = this.tryGettingExistingEntityFromContext(annotationMirror, qualifiedName = (typeElement = (TypeElement)element).getQualifiedName().toString());
                if (alreadyExistingMetaEntity != null && alreadyExistingMetaEntity.isMetaComplete()) {
                    this.context.logMessage(Diagnostic.Kind.OTHER, "Skipping processing of annotations for '" + qualifiedName + "' since XML configuration is metadata complete.");
                    continue;
                }
                boolean requiresLazyMemberInitialization = TypeUtils.containsAnnotation(element, "jakarta.persistence.Embeddable") || TypeUtils.containsAnnotation(element, "jakarta.persistence.MappedSuperclass");
                AnnotationMetaEntity metaEntity = AnnotationMetaEntity.create(typeElement, this.context, requiresLazyMemberInitialization, true);
                if (alreadyExistingMetaEntity != null) {
                    metaEntity.mergeInMembers(alreadyExistingMetaEntity);
                }
                this.addMetaEntityToContext(annotationMirror, metaEntity);
            }
        }
    }

    private void handleRootElementAuxiliaryAnnotationMirrors(@UnknownKeyFor @NonNull @Initialized Element element) {
        if (element instanceof TypeElement) {
            AnnotationMetaEntity metaEntity = AnnotationMetaEntity.create((TypeElement)element, this.context, false, false);
            this.context.addMetaAuxiliary(metaEntity.getQualifiedName(), metaEntity);
        } else if (element instanceof PackageElement) {
            AnnotationMetaPackage metaEntity = AnnotationMetaPackage.create((PackageElement)element, this.context);
            this.context.addMetaAuxiliary(metaEntity.getQualifiedName(), metaEntity);
        }
    }

    private @Nullable @UnknownKeyFor @Initialized Metamodel tryGettingExistingEntityFromContext(@UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        if (TypeUtils.isAnnotationMirrorOfType(mirror, "jakarta.persistence.Entity") || TypeUtils.isAnnotationMirrorOfType(mirror, "jakarta.persistence.MappedSuperclass")) {
            return this.context.getMetaEntity(qualifiedName);
        }
        if (TypeUtils.isAnnotationMirrorOfType(mirror, "jakarta.persistence.Embeddable")) {
            return this.context.getMetaEmbeddable(qualifiedName);
        }
        return null;
    }

    private void addMetaEntityToContext(@UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity metaEntity) {
        if (TypeUtils.isAnnotationMirrorOfType(mirror, "jakarta.persistence.Entity")) {
            this.context.addMetaEntity(metaEntity.getQualifiedName(), metaEntity);
        } else if (TypeUtils.isAnnotationMirrorOfType(mirror, "jakarta.persistence.MappedSuperclass")) {
            this.context.addMetaEntity(metaEntity.getQualifiedName(), metaEntity);
        } else if (TypeUtils.isAnnotationMirrorOfType(mirror, "jakarta.persistence.Embeddable")) {
            this.context.addMetaEmbeddable(metaEntity.getQualifiedName(), metaEntity);
        }
    }

    static class ContainsAttributeTypeVisitor
    extends SimpleTypeVisitor8<Boolean, Element> {
        private final @UnknownKeyFor @NonNull @Initialized Context context;
        private final @UnknownKeyFor @NonNull @Initialized TypeElement type;

        ContainsAttributeTypeVisitor(@UnknownKeyFor @NonNull @Initialized TypeElement elem, @UnknownKeyFor @NonNull @Initialized Context context) {
            this.context = context;
            this.type = elem;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Boolean visitDeclared(@UnknownKeyFor @NonNull @Initialized DeclaredType declaredType, @UnknownKeyFor @NonNull @Initialized Element element) {
            TypeElement returnedElement = (TypeElement)this.context.getTypeUtils().asElement(declaredType);
            String fqNameOfReturnType = returnedElement.getQualifiedName().toString();
            String collection = Constants.COLLECTIONS.get(fqNameOfReturnType);
            if (collection != null) {
                TypeMirror collectionElementType = TypeUtils.getCollectionElementType(declaredType, fqNameOfReturnType, null, this.context);
                Element collectionElement = this.context.getTypeUtils().asElement(collectionElementType);
                if (ElementKind.TYPE_PARAMETER.equals((Object)collectionElement.getKind())) {
                    return false;
                }
                returnedElement = (TypeElement)collectionElement;
            }
            return this.type.getQualifiedName().contentEquals(returnedElement.getQualifiedName());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Boolean visitExecutable(@UnknownKeyFor @NonNull @Initialized ExecutableType t, @UnknownKeyFor @NonNull @Initialized Element element) {
            return element.getKind().equals((Object)ElementKind.METHOD) && StringUtil.isProperty(element.getSimpleName().toString(), TypeUtils.toTypeString(t.getReturnType())) && t.getReturnType().accept(this, element) != false;
        }
    }
}

