/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class TypeRenderingVisitor
extends SimpleTypeVisitor8<Object, Object> {
    private final @UnknownKeyFor @NonNull @Initialized StringBuilder sb = new StringBuilder();
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized TypeVariable> visitedTypeVariables = new HashSet<TypeVariable>();

    private TypeRenderingVisitor() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized TypeMirror typeMirror) {
        if (typeMirror instanceof TypeVariable) {
            Element typeVariableElement = ((TypeVariable)typeMirror).asElement();
            if (typeVariableElement instanceof TypeParameterElement) {
                TypeParameterElement typeParameter = (TypeParameterElement)typeVariableElement;
                if (typeParameter.getEnclosingElement().getKind() != ElementKind.METHOD) return typeParameter.toString();
                typeMirror = ((TypeVariable)typeMirror).getUpperBound();
            } else {
                typeMirror = typeVariableElement.asType();
            }
        } else if (typeMirror instanceof IntersectionType) {
            typeMirror = ((IntersectionType)typeMirror).getBounds().get(0);
        }
        TypeRenderingVisitor typeRenderingVisitor = new TypeRenderingVisitor();
        typeMirror.accept(typeRenderingVisitor, null);
        return typeRenderingVisitor.sb.toString();
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Object visitPrimitive(@UnknownKeyFor @NonNull @Initialized PrimitiveType t, @Nullable @UnknownKeyFor @Initialized Object o) {
        String primitiveTypeName = TypeRenderingVisitor.getPrimitiveTypeName(t.getKind());
        if (primitiveTypeName != null) {
            this.sb.append(primitiveTypeName);
        }
        return null;
    }

    private static @Nullable @UnknownKeyFor @Initialized String getPrimitiveTypeName(@UnknownKeyFor @NonNull @Initialized TypeKind kind) {
        switch (kind) {
            case INT: {
                return "int";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case BYTE: {
                return "byte";
            }
            case CHAR: {
                return "char";
            }
            case DOUBLE: {
                return "double";
            }
            case FLOAT: {
                return "float";
            }
            case LONG: {
                return "long";
            }
            case SHORT: {
                return "short";
            }
            case VOID: {
                return "void";
            }
        }
        return null;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Object visitNull(@UnknownKeyFor @NonNull @Initialized NullType t, @Nullable @UnknownKeyFor @Initialized Object o) {
        return null;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Object visitArray(@UnknownKeyFor @NonNull @Initialized ArrayType t, @Nullable @UnknownKeyFor @Initialized Object o) {
        t.getComponentType().accept(this, null);
        this.sb.append("[]");
        return t;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Object visitDeclared(@UnknownKeyFor @NonNull @Initialized DeclaredType t, @Nullable @UnknownKeyFor @Initialized Object o) {
        this.sb.append(t.asElement().toString());
        List<? extends TypeMirror> typeArguments = t.getTypeArguments();
        if (!typeArguments.isEmpty()) {
            this.sb.append('<');
            typeArguments.get(0).accept(this, null);
            for (int i = 1; i < typeArguments.size(); ++i) {
                this.sb.append(", ");
                typeArguments.get(i).accept(this, null);
            }
            this.sb.append('>');
        }
        return null;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Object visitTypeVariable(@UnknownKeyFor @NonNull @Initialized TypeVariable t, @Nullable @UnknownKeyFor @Initialized Object o) {
        Element typeVariableElement = t.asElement();
        if (typeVariableElement instanceof TypeParameterElement) {
            TypeParameterElement typeParameter = (TypeParameterElement)typeVariableElement;
            this.sb.append(typeParameter);
            if (!"java.lang.Object".equals(t.getUpperBound().toString()) && this.visitedTypeVariables.add(t)) {
                this.sb.append(" extends ");
                t.getUpperBound().accept(this, null);
                this.visitedTypeVariables.remove(t);
            }
        } else {
            typeVariableElement.asType().accept(this, null);
        }
        return null;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Object visitWildcard(@UnknownKeyFor @NonNull @Initialized WildcardType t, @Nullable @UnknownKeyFor @Initialized Object o) {
        this.sb.append('?');
        if (t.getExtendsBound() != null) {
            this.sb.append(" extends ");
            t.getExtendsBound().accept(this, null);
        }
        if (t.getSuperBound() != null) {
            this.sb.append(" super ");
            t.getSuperBound().accept(this, null);
        }
        return null;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Object visitUnion(@UnknownKeyFor @NonNull @Initialized UnionType t, @Nullable @UnknownKeyFor @Initialized Object o) {
        return null;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Object visitIntersection(@UnknownKeyFor @NonNull @Initialized IntersectionType t, @Nullable @UnknownKeyFor @Initialized Object o) {
        List<? extends TypeMirror> bounds = t.getBounds();
        bounds.get(0).accept(this, null);
        for (int i = 0; i < bounds.size(); ++i) {
            this.sb.append(" & ");
            bounds.get(i).accept(this, null);
        }
        return null;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Object visitExecutable(@UnknownKeyFor @NonNull @Initialized ExecutableType t, @Nullable @UnknownKeyFor @Initialized Object o) {
        return null;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Object visitNoType(@UnknownKeyFor @NonNull @Initialized NoType t, @Nullable @UnknownKeyFor @Initialized Object o) {
        return null;
    }
}

