/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.antlr.v4.runtime.Token;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.AssertionFailure;
import org.hibernate.grammars.hql.HqlLexer;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.processor.Context;
import org.hibernate.processor.ImportContextImpl;
import org.hibernate.processor.ProcessLaterException;
import org.hibernate.processor.annotation.AbstractQueryMethod;
import org.hibernate.processor.annotation.AnnotationMeta;
import org.hibernate.processor.annotation.AnnotationMetaAttribute;
import org.hibernate.processor.annotation.AnnotationMetaType;
import org.hibernate.processor.annotation.CriteriaDeleteMethod;
import org.hibernate.processor.annotation.CriteriaFinderMethod;
import org.hibernate.processor.annotation.DataAnnotationMetaAttribute;
import org.hibernate.processor.annotation.DataMetaAttributeGenerationVisitor;
import org.hibernate.processor.annotation.DefaultConstructor;
import org.hibernate.processor.annotation.ErrorHandler;
import org.hibernate.processor.annotation.IdFinderMethod;
import org.hibernate.processor.annotation.LifecycleMethod;
import org.hibernate.processor.annotation.MetaAttributeGenerationVisitor;
import org.hibernate.processor.annotation.NaturalIdFinderMethod;
import org.hibernate.processor.annotation.OrderBy;
import org.hibernate.processor.annotation.QueryMethod;
import org.hibernate.processor.annotation.RepositoryConstructor;
import org.hibernate.processor.model.ImportContext;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.AccessType;
import org.hibernate.processor.util.AccessTypeInformation;
import org.hibernate.processor.util.NullnessUtil;
import org.hibernate.processor.util.TypeUtils;
import org.hibernate.processor.validation.ProcessorSessionFactory;
import org.hibernate.processor.validation.Validation;
import org.hibernate.query.criteria.JpaEntityJoin;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.hql.internal.HqlParseTreeBuilder;
import org.hibernate.query.sql.internal.ParameterParser;
import org.hibernate.query.sql.spi.ParameterRecognizer;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;

public class AnnotationMetaEntity
extends AnnotationMeta {
    private final @UnknownKeyFor @NonNull @Initialized ImportContext importContext;
    private final @UnknownKeyFor @NonNull @Initialized TypeElement element;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MetaAttribute> members;
    private final @UnknownKeyFor @NonNull @Initialized Context context;
    private final @UnknownKeyFor @NonNull @Initialized boolean managed;
    private @UnknownKeyFor @NonNull @Initialized boolean jakartaDataRepository;
    private final @UnknownKeyFor @NonNull @Initialized boolean quarkusInjection;
    private @UnknownKeyFor @NonNull @Initialized String qualifiedName;
    private final @UnknownKeyFor @NonNull @Initialized boolean jakartaDataStaticModel;
    private @UnknownKeyFor @NonNull @Initialized AccessTypeInformation entityAccessTypeInfo;
    private @UnknownKeyFor @NonNull @Initialized boolean initialized;
    private @UnknownKeyFor @NonNull @Initialized Metamodel entityToMerge;
    private @UnknownKeyFor @NonNull @Initialized boolean repository = false;
    private @UnknownKeyFor @NonNull @Initialized String sessionType = "jakarta.persistence.EntityManager";
    private @UnknownKeyFor @NonNull @Initialized String sessionGetter = "entityManager";
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> memberTypes = new HashMap<String, String>();
    private @Nullable @UnknownKeyFor @Initialized TypeElement primaryEntity;
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> LEGAL_RAW_RESULT_TYPES = Set.of("java.util.List", "jakarta.persistence.Query", "org.hibernate.query.Query");
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> LEGAL_GENERIC_RESULT_TYPES = Set.of("java.util.List", "java.util.stream.Stream", "java.util.Optional", "jakarta.persistence.TypedQuery", "org.hibernate.query.Query", "org.hibernate.query.SelectionQuery", "org.hibernate.query.KeyedResultList", "jakarta.data.page.Page", "jakarta.data.page.CursoredPage");

    public AnnotationMetaEntity(@UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized boolean managed, @UnknownKeyFor @NonNull @Initialized boolean jakartaDataStaticMetamodel) {
        this.element = element;
        this.context = context;
        this.managed = managed;
        this.members = new HashMap<String, MetaAttribute>();
        this.quarkusInjection = context.isQuarkusInjection();
        this.importContext = new ImportContextImpl(AnnotationMetaEntity.getPackageName(context, element));
        this.jakartaDataStaticModel = jakartaDataStaticMetamodel;
    }

    public static @UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity create(@UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized Context context) {
        return AnnotationMetaEntity.create(element, context, false, false, false);
    }

    public static @UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity create(@UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized boolean lazilyInitialised, @UnknownKeyFor @NonNull @Initialized boolean managed, @UnknownKeyFor @NonNull @Initialized boolean jakartaData) {
        AnnotationMetaEntity annotationMetaEntity = new AnnotationMetaEntity(element, context, managed, jakartaData);
        if (!lazilyInitialised) {
            annotationMetaEntity.init();
        }
        return annotationMetaEntity;
    }

    public @Nullable @UnknownKeyFor @Initialized String getMemberType(@UnknownKeyFor @NonNull @Initialized String entityType, @UnknownKeyFor @NonNull @Initialized String memberName) {
        return this.memberTypes.get(StringHelper.qualify((String)entityType, (String)memberName));
    }

    public @UnknownKeyFor @NonNull @Initialized AccessTypeInformation getEntityAccessTypeInfo() {
        return this.entityAccessTypeInfo;
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized Context getContext() {
        return this.context;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isImplementation() {
        return this.repository;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isJakartaDataStyle() {
        return this.jakartaDataStaticModel;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String getSimpleName() {
        return AnnotationMetaEntity.removeDollar(this.element.getSimpleName().toString());
    }

    private @UnknownKeyFor @NonNull @Initialized String getConstructorName() {
        return this.getSimpleName() + "_";
    }

    private static @UnknownKeyFor @NonNull @Initialized String removeDollar(@UnknownKeyFor @NonNull @Initialized String simpleName) {
        return simpleName.endsWith("$") ? simpleName.substring(0, simpleName.length() - 1) : simpleName;
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.element.getQualifiedName().toString();
        }
        return this.qualifiedName;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String getSupertypeName() {
        if (this.repository) {
            return null;
        }
        return TypeUtils.findMappedSuperClass(this, this.context);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getPackageName() {
        return AnnotationMetaEntity.getPackageName(this.context, this.element);
    }

    private static @UnknownKeyFor @NonNull @Initialized String getPackageName(@UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized TypeElement element) {
        return context.getElementUtils().getPackageOf(element).getQualifiedName().toString();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MetaAttribute> getMembers() {
        if (!this.initialized) {
            this.init();
            if (this.entityToMerge != null) {
                this.mergeInMembers(this.entityToMerge.getMembers());
            }
        }
        return new ArrayList<MetaAttribute>(this.members.values());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isMetaComplete() {
        return false;
    }

    private void mergeInMembers(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized MetaAttribute> attributes) {
        for (MetaAttribute attribute : attributes) {
            this.importType(attribute.getMetaType());
            this.importType(attribute.getTypeDeclaration());
            this.members.put(attribute.getPropertyName(), attribute);
        }
    }

    public void mergeInMembers(@UnknownKeyFor @NonNull @Initialized Metamodel other) {
        if (!this.initialized) {
            this.entityToMerge = other;
        } else {
            this.mergeInMembers(other.getMembers());
        }
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String generateImports() {
        return this.importContext.generateImports();
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String importType(@UnknownKeyFor @NonNull @Initialized String fqcn) {
        return this.importContext.importType(fqcn);
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String staticImport(@UnknownKeyFor @NonNull @Initialized String fqcn, @UnknownKeyFor @NonNull @Initialized String member) {
        return this.importContext.staticImport(fqcn, member);
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized TypeElement getElement() {
        return this.element;
    }

    @Override
    void putMember(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized MetaAttribute nameMetaAttribute) {
        this.members.put(name, nameMetaAttribute);
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized boolean isRepository() {
        return this.repository;
    }

    @UnknownKeyFor @NonNull @Initialized boolean isJakartaDataRepository() {
        return this.jakartaDataRepository;
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized String getSessionType() {
        return this.sessionType;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isInjectable() {
        return this.repository;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String scope() {
        if (this.jakartaDataRepository) {
            return this.context.addTransactionScopedAnnotation() ? "jakarta.transaction.TransactionScoped" : "jakarta.enterprise.context.RequestScoped";
        }
        return "jakarta.enterprise.context.Dependent";
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "AnnotationMetaEntity" + "{element=" + this.element + ", members=" + this.members + '}';
    }

    protected final void init() {
        this.getContext().logMessage(Diagnostic.Kind.OTHER, "Initializing type '" + this.getQualifiedName() + "'");
        this.setupSession();
        ArrayList<ExecutableElement> queryMethods = new ArrayList<ExecutableElement>();
        ArrayList<ExecutableElement> lifecycleMethods = new ArrayList<ExecutableElement>();
        if (this.repository) {
            List<ExecutableElement> methodsOfClass = ElementFilter.methodsIn(this.context.getAllMembers(this.element));
            for (ExecutableElement method : methodsOfClass) {
                if (TypeUtils.containsAnnotation(method, "org.hibernate.annotations.processing.HQL", "org.hibernate.annotations.processing.SQL", "jakarta.data.repository.Query", "org.hibernate.annotations.processing.Find", "jakarta.data.repository.Find")) {
                    queryMethods.add(method);
                    continue;
                }
                if (TypeUtils.containsAnnotation(method, "jakarta.data.repository.Insert", "jakarta.data.repository.Update", "jakarta.data.repository.Save")) {
                    lifecycleMethods.add(method);
                    continue;
                }
                if (TypeUtils.hasAnnotation((Element)method, "jakarta.data.repository.Delete")) {
                    if (this.isDeleteLifecycle(method)) {
                        lifecycleMethods.add(method);
                        continue;
                    }
                    queryMethods.add(method);
                    continue;
                }
                if (!method.getEnclosingElement().getKind().isInterface() || method.isDefault() || AnnotationMetaEntity.isSessionGetter(method)) continue;
                String companionClassName = this.element.getQualifiedName().toString() + "$";
                if (this.context.getElementUtils().getTypeElement(companionClassName) == null) {
                    this.message(method, "repository method cannot be implemented (skipping whole repository)", Diagnostic.Kind.WARNING);
                }
                return;
            }
            this.primaryEntity = this.primaryEntity(lifecycleMethods);
            if (this.primaryEntity != null && !TypeUtils.hasAnnotation((Element)this.primaryEntity, "jakarta.persistence.Entity") || !this.checkEntities(lifecycleMethods)) {
                return;
            }
            if (!lifecycleMethods.isEmpty()) {
                this.validateStatelessSessionType();
            }
        } else {
            TypeUtils.determineAccessTypeForHierarchy(this.element, this.context);
            this.entityAccessTypeInfo = NullnessUtil.castNonNull(this.context.getAccessTypeInfo(this.getQualifiedName()));
            List<VariableElement> fieldsOfClass = ElementFilter.fieldsIn(this.element.getEnclosedElements());
            List<ExecutableElement> methodsOfClass = ElementFilter.methodsIn(this.element.getEnclosedElements());
            ArrayList<ExecutableElement> gettersAndSettersOfClass = new ArrayList<ExecutableElement>();
            for (ExecutableElement method : methodsOfClass) {
                if (this.isGetterOrSetter(method)) {
                    gettersAndSettersOfClass.add(method);
                    continue;
                }
                if (!this.element.getTypeParameters().isEmpty() || !TypeUtils.containsAnnotation(method, "org.hibernate.annotations.processing.HQL", "org.hibernate.annotations.processing.SQL", "org.hibernate.annotations.processing.Find")) continue;
                queryMethods.add(method);
            }
            if (this.managed && !this.jakartaDataStaticModel) {
                this.putMember("class", new AnnotationMetaType(this));
            }
            this.validatePersistentMembers(fieldsOfClass);
            this.validatePersistentMembers(gettersAndSettersOfClass);
            this.addPersistentMembers(fieldsOfClass, AccessType.FIELD);
            this.addPersistentMembers(gettersAndSettersOfClass, AccessType.PROPERTY);
        }
        this.addAuxiliaryMembers();
        this.checkNamedQueries();
        this.addLifecycleMethods(lifecycleMethods);
        this.addQueryMethods(queryMethods);
        this.initialized = true;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean checkEntities(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ExecutableElement> lifecycleMethods) {
        boolean foundPersistenceEntity = false;
        VariableElement nonPersistenceParameter = null;
        for (ExecutableElement lifecycleMethod : lifecycleMethods) {
            List<? extends VariableElement> parameters = lifecycleMethod.getParameters();
            if (parameters.isEmpty()) continue;
            VariableElement parameter = parameters.get(0);
            TypeMirror declaredType = parameter.asType();
            TypeMirror parameterType = this.parameterType(parameter);
            DeclaredType type = this.entityType(parameterType);
            if (type == null) continue;
            if (TypeUtils.hasAnnotation(type.asElement(), "jakarta.persistence.Entity")) {
                foundPersistenceEntity = true;
                continue;
            }
            if (declaredType != parameterType || nonPersistenceParameter != null) continue;
            nonPersistenceParameter = parameter;
        }
        if (foundPersistenceEntity && nonPersistenceParameter != null) {
            this.message(nonPersistenceParameter, "parameter type '" + nonPersistenceParameter.asType() + "' is not a Jakarta Persistence entity class (skipping entire repository)", Diagnostic.Kind.WARNING);
        }
        return nonPersistenceParameter == null;
    }

    private void validateStatelessSessionType() {
        if (!AnnotationMetaEntity.usingStatelessSession(this.sessionType)) {
            this.message(this.element, "repository must be backed by a 'StatelessSession'", Diagnostic.Kind.ERROR);
        }
    }

    private static @Nullable @UnknownKeyFor @Initialized TypeElement primaryEntity(@UnknownKeyFor @NonNull @Initialized TypeElement element) {
        for (TypeMirror typeMirror : element.getInterfaces()) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            Name name = typeElement.getQualifiedName();
            if (declaredType.getTypeArguments().size() == 2 && (name.contentEquals("jakarta.data.repository.BasicRepository") || name.contentEquals("jakarta.data.repository.CrudRepository") || name.contentEquals("jakarta.data.repository.DataRepository"))) {
                TypeMirror entityType = declaredType.getTypeArguments().get(0);
                if (entityType.getKind() != TypeKind.DECLARED) continue;
                DeclaredType entityDeclared = (DeclaredType)entityType;
                return (TypeElement)entityDeclared.asElement();
            }
            TypeElement primaryEntity = AnnotationMetaEntity.primaryEntity(typeElement);
            if (primaryEntity == null) continue;
            return primaryEntity;
        }
        return null;
    }

    private @Nullable @UnknownKeyFor @Initialized TypeElement primaryEntity(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ExecutableElement> lifecycleMethods) {
        TypeElement result = AnnotationMetaEntity.primaryEntity(this.element);
        if (result != null) {
            return result;
        }
        Types types = this.context.getTypeUtils();
        for (ExecutableElement element : lifecycleMethods) {
            VariableElement param;
            DeclaredType declaredType;
            if (element.getParameters().size() != 1 || (declaredType = this.entityType(this.parameterType(param = element.getParameters().get(0)))) == null) continue;
            if (result == null) {
                result = (TypeElement)declaredType.asElement();
                continue;
            }
            if (types.isSameType(result.asType(), declaredType)) continue;
            return null;
        }
        return result;
    }

    private void addDefaultConstructor() {
        String sessionVariableName = this.getSessionVariableName(this.sessionType);
        this.putMember("_", new DefaultConstructor(this, this.getConstructorName(), sessionVariableName, this.sessionType, sessionVariableName, this.dataStore(), this.context.addInjectAnnotation()));
    }

    private @Nullable @UnknownKeyFor @Initialized String dataStore() {
        String dataStore;
        AnnotationValue dataStoreValue;
        AnnotationMirror repo = TypeUtils.getAnnotationMirror(this.element, "jakarta.data.repository.Repository");
        if (repo != null && (dataStoreValue = TypeUtils.getAnnotationValue(repo, "dataStore")) != null && !(dataStore = dataStoreValue.getValue().toString()).isEmpty()) {
            return dataStore;
        }
        return null;
    }

    private void setupSession() {
        if (this.element.getTypeParameters().isEmpty()) {
            this.jakartaDataRepository = TypeUtils.hasAnnotation((Element)this.element, "jakarta.data.repository.Repository");
            ExecutableElement getter = this.findSessionGetter(this.element);
            if (getter != null) {
                if (!this.isPanacheType(this.element)) {
                    this.repository = true;
                    this.sessionType = this.addDaoConstructor(getter);
                } else {
                    this.sessionType = this.fullReturnType(getter);
                }
            } else if (this.element.getKind() == ElementKind.INTERFACE && !this.jakartaDataRepository && (this.context.usesQuarkusOrm() || this.context.usesQuarkusReactive())) {
                this.repository = true;
                this.sessionType = this.setupQuarkusDaoConstructor();
            }
            if (!this.repository && this.jakartaDataRepository) {
                this.repository = true;
                this.sessionType = "org.hibernate.StatelessSession";
                this.addDaoConstructor(null);
            }
            if (this.needsDefaultConstructor()) {
                this.addDefaultConstructor();
            }
        }
    }

    @UnknownKeyFor @NonNull @Initialized boolean needsDefaultConstructor() {
        return this.jakartaDataRepository && !this.quarkusInjection && this.context.addDependentAnnotation();
    }

    private @Nullable @UnknownKeyFor @Initialized ExecutableElement findSessionGetter(@UnknownKeyFor @NonNull @Initialized TypeElement type) {
        if (!TypeUtils.hasAnnotation((Element)type, "jakarta.persistence.Entity", "jakarta.persistence.MappedSuperclass", "jakarta.persistence.Embeddable") || this.isPanacheType(type)) {
            DeclaredType declaredType;
            ExecutableElement executableElement;
            for (ExecutableElement method : ElementFilter.methodsIn(type.getEnclosedElements())) {
                if (!AnnotationMetaEntity.isSessionGetter(method)) continue;
                return method;
            }
            TypeMirror superclass = type.getSuperclass();
            if (superclass.getKind() == TypeKind.DECLARED && (executableElement = this.findSessionGetter((TypeElement)(declaredType = (DeclaredType)superclass).asElement())) != null) {
                return executableElement;
            }
            for (TypeMirror typeMirror : type.getInterfaces()) {
                DeclaredType declaredType2;
                ExecutableElement ret2;
                if (typeMirror.getKind() != TypeKind.DECLARED || (ret2 = this.findSessionGetter((TypeElement)(declaredType2 = (DeclaredType)typeMirror).asElement())) == null) continue;
                return ret2;
            }
        }
        return null;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isPanacheType(@UnknownKeyFor @NonNull @Initialized TypeElement type) {
        return this.isOrmPanacheType(type) || this.isReactivePanacheType(type);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isOrmPanacheType(@UnknownKeyFor @NonNull @Initialized TypeElement type) {
        ProcessingEnvironment processingEnvironment = this.context.getProcessingEnvironment();
        Elements elements = processingEnvironment.getElementUtils();
        TypeElement panacheRepositorySuperType = elements.getTypeElement("io.quarkus.hibernate.orm.panache.PanacheRepositoryBase");
        TypeElement panacheEntitySuperType = elements.getTypeElement("io.quarkus.hibernate.orm.panache.PanacheEntityBase");
        if (panacheRepositorySuperType == null || panacheEntitySuperType == null) {
            return false;
        }
        Types types = processingEnvironment.getTypeUtils();
        return types.isSubtype(type.asType(), types.getDeclaredType(panacheRepositorySuperType, new TypeMirror[0])) || types.isSubtype(type.asType(), panacheEntitySuperType.asType());
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isReactivePanacheType(@UnknownKeyFor @NonNull @Initialized TypeElement type) {
        ProcessingEnvironment processingEnvironment = this.context.getProcessingEnvironment();
        Elements elements = processingEnvironment.getElementUtils();
        TypeElement panacheRepositorySuperType = elements.getTypeElement("io.quarkus.hibernate.reactive.panache.PanacheRepositoryBase");
        TypeElement panacheEntitySuperType = elements.getTypeElement("io.quarkus.hibernate.reactive.panache.PanacheEntityBase");
        if (panacheRepositorySuperType == null || panacheEntitySuperType == null) {
            return false;
        }
        Types types = processingEnvironment.getTypeUtils();
        return types.isSubtype(type.asType(), types.getDeclaredType(panacheRepositorySuperType, new TypeMirror[0])) || types.isSubtype(type.asType(), panacheEntitySuperType.asType());
    }

    private @UnknownKeyFor @NonNull @Initialized String addDaoConstructor(@Nullable @UnknownKeyFor @Initialized ExecutableElement method) {
        String name;
        String sessionType = method == null ? this.sessionType : this.fullReturnType(method);
        String sessionVariableName = this.getSessionVariableName(sessionType);
        String string = name = method == null ? sessionVariableName : method.getSimpleName().toString();
        if (method == null || !method.isDefault()) {
            this.putMember(name, new RepositoryConstructor(this, this.getConstructorName(), name, sessionType, sessionVariableName, this.dataStore(), this.context.addInjectAnnotation(), this.context.addNonnullAnnotation(), method != null, this.jakartaDataRepository, this.quarkusInjection));
        } else {
            this.sessionGetter = method.getSimpleName() + "()";
        }
        return sessionType;
    }

    private @UnknownKeyFor @NonNull @Initialized String setupQuarkusDaoConstructor() {
        if (this.context.usesQuarkusOrm()) {
            String name = "getEntityManager";
            this.putMember(name, new RepositoryConstructor(this, this.getConstructorName(), name, this.sessionType, this.getSessionVariableName(this.sessionType), this.dataStore(), this.context.addInjectAnnotation(), this.context.addNonnullAnnotation(), false, false, true));
            return "jakarta.persistence.EntityManager";
        }
        this.importType("io.quarkus.hibernate.reactive.panache.common.runtime.SessionOperations");
        this.sessionGetter = "SessionOperations.getSession()";
        return "io.smallrye.mutiny.Uni<org.hibernate.reactive.mutiny.Mutiny.Session>";
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isSessionGetter(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        DeclaredType declaredType;
        Element element;
        TypeMirror returnType;
        if (method.getParameters().isEmpty() && (returnType = method.getReturnType()).getKind() == TypeKind.DECLARED && (element = (declaredType = (DeclaredType)AnnotationMetaEntity.ununi(returnType)).asElement()).getKind() == ElementKind.INTERFACE) {
            TypeElement typeElement = (TypeElement)element;
            Name name = typeElement.getQualifiedName();
            return name.contentEquals("org.hibernate.Session") || name.contentEquals("org.hibernate.StatelessSession") || name.contentEquals("org.hibernate.reactive.mutiny.Mutiny.Session") || name.contentEquals("org.hibernate.reactive.mutiny.Mutiny.StatelessSession") || name.contentEquals("jakarta.persistence.EntityManager");
        }
        return false;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isGetterOrSetter(@UnknownKeyFor @NonNull @Initialized Element methodOfClass) {
        TypeMirror returnType;
        List<? extends TypeMirror> methodParameterTypes;
        ExecutableType methodType = (ExecutableType)methodOfClass.asType();
        Name methodSimpleName = methodOfClass.getSimpleName();
        return AnnotationMetaEntity.isSetter(methodSimpleName, methodParameterTypes = methodType.getParameterTypes(), returnType = methodType.getReturnType()) || AnnotationMetaEntity.isGetter(methodSimpleName, methodParameterTypes, returnType);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean hasPrefix(@UnknownKeyFor @NonNull @Initialized Name methodSimpleName, @UnknownKeyFor @NonNull @Initialized String prefix) {
        int prefixLength = prefix.length();
        if (methodSimpleName.length() > prefixLength) {
            for (int i = 0; i < prefixLength; ++i) {
                if (methodSimpleName.charAt(i) == prefix.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isGetter(@UnknownKeyFor @NonNull @Initialized Name methodSimpleName, @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized TypeMirror> methodParameterTypes, @UnknownKeyFor @NonNull @Initialized TypeMirror returnType) {
        return (AnnotationMetaEntity.hasPrefix(methodSimpleName, "get") || AnnotationMetaEntity.hasPrefix(methodSimpleName, "is")) && methodParameterTypes.isEmpty() && returnType.getKind() != TypeKind.VOID;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isSetter(@UnknownKeyFor @NonNull @Initialized Name methodSimpleName, @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized TypeMirror> methodParameterTypes, @UnknownKeyFor @NonNull @Initialized TypeMirror returnType) {
        return AnnotationMetaEntity.hasPrefix(methodSimpleName, "set") && methodParameterTypes.size() == 1 && returnType.getKind() != TypeKind.VOID;
    }

    private void validatePersistentMembers(@UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Element> membersOfClass) {
        for (Element element : membersOfClass) {
            if (!TypeUtils.hasAnnotation(element, "jakarta.persistence.ManyToOne", "jakarta.persistence.OneToOne", "jakarta.persistence.OneToMany", "jakarta.persistence.ManyToMany")) continue;
            this.validateAssociation(element);
        }
    }

    private void addPersistentMembers(@UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Element> membersOfClass, @UnknownKeyFor @NonNull @Initialized AccessType membersKind) {
        for (Element element : membersOfClass) {
            if (!this.isPersistent(element, membersKind)) continue;
            this.addPersistentMember(element);
        }
    }

    private void addPersistentMember(@UnknownKeyFor @NonNull @Initialized Element memberOfClass) {
        if (this.jakartaDataStaticModel) {
            DataAnnotationMetaAttribute dataMetaAttribute = memberOfClass.asType().accept(new DataMetaAttributeGenerationVisitor(this, this.context), memberOfClass);
            if (dataMetaAttribute != null) {
                String path = dataMetaAttribute.getPropertyName();
                this.members.put("_" + path, dataMetaAttribute);
                if (AnnotationMetaEntity.isEmbedded(memberOfClass)) {
                    TypeMirror type = AnnotationMetaEntity.attributeType(memberOfClass);
                    DeclaredType declaredType = (DeclaredType)type;
                    TypeElement typeElement = (TypeElement)declaredType.asElement();
                    for (Element element : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
                        this.addEmbeddablePersistentMember(element, path, AccessType.FIELD);
                    }
                    for (Element element : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                        if (!this.isGetterOrSetter(element)) continue;
                        this.addEmbeddablePersistentMember(element, path, AccessType.PROPERTY);
                    }
                }
            }
        } else {
            AnnotationMetaAttribute jpaMetaAttribute = memberOfClass.asType().accept(new MetaAttributeGenerationVisitor(this, this.context), memberOfClass);
            if (jpaMetaAttribute != null) {
                this.members.put(jpaMetaAttribute.getPropertyName(), jpaMetaAttribute);
            }
        }
    }

    private void addEmbeddablePersistentMember(@UnknownKeyFor @NonNull @Initialized Element memberOfEmbeddable, @UnknownKeyFor @NonNull @Initialized String path, @UnknownKeyFor @NonNull @Initialized AccessType membersKind) {
        DataAnnotationMetaAttribute metaAttribute;
        if (this.isPersistent(memberOfEmbeddable, membersKind) && (metaAttribute = memberOfEmbeddable.asType().accept(new DataMetaAttributeGenerationVisitor(this, path, this.context), memberOfEmbeddable)) != null) {
            this.members.put("_" + metaAttribute.getPropertyName(), metaAttribute);
        }
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isEmbedded(@UnknownKeyFor @NonNull @Initialized Element memberOfClass) {
        if (TypeUtils.hasAnnotation(memberOfClass, "jakarta.persistence.Embedded")) {
            return true;
        }
        TypeMirror type = AnnotationMetaEntity.attributeType(memberOfClass);
        if (type.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)type;
            return TypeUtils.hasAnnotation(declaredType.asElement(), "jakarta.persistence.Embeddable");
        }
        return false;
    }

    private void validateAssociation(@UnknownKeyFor @NonNull @Initialized Element memberOfClass) {
        TypeMirror type = AnnotationMetaEntity.attributeType(memberOfClass);
        if (TypeUtils.hasAnnotation(memberOfClass, "jakarta.persistence.ManyToOne")) {
            AnnotationMirror annotation = NullnessUtil.castNonNull(TypeUtils.getAnnotationMirror(memberOfClass, "jakarta.persistence.ManyToOne"));
            this.validateToOneAssociation(memberOfClass, annotation, type);
        } else if (TypeUtils.hasAnnotation(memberOfClass, "jakarta.persistence.OneToOne")) {
            AnnotationMirror annotation = NullnessUtil.castNonNull(TypeUtils.getAnnotationMirror(memberOfClass, "jakarta.persistence.OneToOne"));
            this.validateToOneAssociation(memberOfClass, annotation, type);
        } else if (TypeUtils.hasAnnotation(memberOfClass, "jakarta.persistence.OneToMany")) {
            AnnotationMirror annotation = NullnessUtil.castNonNull(TypeUtils.getAnnotationMirror(memberOfClass, "jakarta.persistence.OneToMany"));
            this.validateToManyAssociation(memberOfClass, annotation, type);
        } else if (TypeUtils.hasAnnotation(memberOfClass, "jakarta.persistence.ManyToMany")) {
            AnnotationMirror annotation = NullnessUtil.castNonNull(TypeUtils.getAnnotationMirror(memberOfClass, "jakarta.persistence.ManyToMany"));
            this.validateToManyAssociation(memberOfClass, annotation, type);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized TypeMirror attributeType(@UnknownKeyFor @NonNull @Initialized Element memberOfClass) {
        switch (memberOfClass.getKind()) {
            case METHOD: {
                ExecutableElement method = (ExecutableElement)memberOfClass;
                return method.getReturnType();
            }
            case FIELD: {
                return memberOfClass.asType();
            }
        }
        throw new AssertionFailure("should be a field or getter");
    }

    private void validateToOneAssociation(@UnknownKeyFor @NonNull @Initialized Element memberOfClass, @UnknownKeyFor @NonNull @Initialized AnnotationMirror annotation, @UnknownKeyFor @NonNull @Initialized TypeMirror type) {
        AnnotationValue target = TypeUtils.getAnnotationValue(annotation, "targetEntity");
        this.validateAssociation(memberOfClass, annotation, target == null ? type : (TypeMirror)target.getValue());
    }

    private void validateToManyAssociation(@UnknownKeyFor @NonNull @Initialized Element memberOfClass, @UnknownKeyFor @NonNull @Initialized AnnotationMirror annotation, @UnknownKeyFor @NonNull @Initialized TypeMirror type) {
        AnnotationValue target = TypeUtils.getAnnotationValue(annotation, "targetEntity");
        this.validateAssociation(memberOfClass, annotation, target == null ? this.elementType(type) : (TypeMirror)target.getValue());
    }

    private void validateAssociation(@UnknownKeyFor @NonNull @Initialized Element memberOfClass, @UnknownKeyFor @NonNull @Initialized AnnotationMirror annotation, @Nullable @UnknownKeyFor @Initialized TypeMirror typeMirror) {
        if (typeMirror != null) {
            switch (typeMirror.getKind()) {
                case TYPEVAR: {
                    if (!TypeUtils.hasAnnotation((Element)this.element, "jakarta.persistence.Entity")) break;
                    this.message(memberOfClass, "type '" + typeMirror + "' is a type variable", Diagnostic.Kind.WARNING);
                    break;
                }
                case DECLARED: {
                    DeclaredType assocDeclaredType = (DeclaredType)typeMirror;
                    TypeElement assocTypeElement = (TypeElement)assocDeclaredType.asElement();
                    if (TypeUtils.hasAnnotation((Element)assocTypeElement, "jakarta.persistence.Entity")) {
                        AnnotationValue mappedBy = TypeUtils.getAnnotationValue(annotation, "mappedBy");
                        String propertyName = mappedBy == null ? null : mappedBy.getValue().toString();
                        this.validateBidirectionalMapping(memberOfClass, annotation, propertyName, assocTypeElement);
                        break;
                    }
                    this.message(memberOfClass, "type '" + assocTypeElement.getSimpleName() + "' is not annotated '@Entity'", Diagnostic.Kind.WARNING);
                    break;
                }
                default: {
                    this.message(memberOfClass, "type '" + typeMirror + "' is not an entity type", Diagnostic.Kind.WARNING);
                }
            }
        }
    }

    private void validateBidirectionalMapping(@UnknownKeyFor @NonNull @Initialized Element memberOfClass, @UnknownKeyFor @NonNull @Initialized AnnotationMirror annotation, @Nullable @UnknownKeyFor @Initialized String mappedBy, @UnknownKeyFor @NonNull @Initialized TypeElement assocTypeElement) {
        if (mappedBy != null && !mappedBy.isEmpty()) {
            if (mappedBy.equals("<error>")) {
                return;
            }
            if (mappedBy.indexOf(46) > 0) {
                return;
            }
            AnnotationValue annotationVal = NullnessUtil.castNonNull(TypeUtils.getAnnotationValue(annotation, "mappedBy"));
            for (Element member : this.context.getAllMembers(assocTypeElement)) {
                if (!TypeUtils.propertyName(this, member).contentEquals(mappedBy) || !this.compatibleAccess(assocTypeElement, member)) continue;
                this.validateBackRef(memberOfClass, annotation, assocTypeElement, member, annotationVal);
                return;
            }
            this.message(memberOfClass, annotation, annotationVal, "no matching member in '" + assocTypeElement.getSimpleName() + "'", Diagnostic.Kind.ERROR);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean compatibleAccess(@UnknownKeyFor @NonNull @Initialized TypeElement assocTypeElement, @UnknownKeyFor @NonNull @Initialized Element member) {
        AccessType memberAccessType = TypeUtils.determineAnnotationSpecifiedAccessType(member);
        AccessType accessType = memberAccessType == null ? this.getAccessType(assocTypeElement) : memberAccessType;
        switch (member.getKind()) {
            case FIELD: {
                return accessType == AccessType.FIELD;
            }
            case METHOD: {
                return accessType == AccessType.PROPERTY;
            }
        }
        return false;
    }

    private void validateBackRef(@UnknownKeyFor @NonNull @Initialized Element memberOfClass, @UnknownKeyFor @NonNull @Initialized AnnotationMirror annotation, @UnknownKeyFor @NonNull @Initialized TypeElement assocTypeElement, @UnknownKeyFor @NonNull @Initialized Element member, @UnknownKeyFor @NonNull @Initialized AnnotationValue annotationVal) {
        TypeMirror backType;
        switch (annotation.getAnnotationType().asElement().toString()) {
            case "jakarta.persistence.OneToOne": {
                backType = AnnotationMetaEntity.attributeType(member);
                if (TypeUtils.hasAnnotation(member, "jakarta.persistence.OneToOne")) break;
                this.message(memberOfClass, annotation, annotationVal, "member '" + member.getSimpleName() + "' of '" + assocTypeElement.getSimpleName() + "' is not annotated '@OneToOne'", Diagnostic.Kind.WARNING);
                break;
            }
            case "jakarta.persistence.OneToMany": {
                backType = AnnotationMetaEntity.attributeType(member);
                if (TypeUtils.hasAnnotation(member, "jakarta.persistence.ManyToOne")) break;
                this.message(memberOfClass, annotation, annotationVal, "member '" + member.getSimpleName() + "' of '" + assocTypeElement.getSimpleName() + "' is not annotated '@ManyToOne'", Diagnostic.Kind.WARNING);
                break;
            }
            case "jakarta.persistence.ManyToMany": {
                backType = this.elementType(AnnotationMetaEntity.attributeType(member));
                if (TypeUtils.hasAnnotation(member, "jakarta.persistence.ManyToMany")) break;
                this.message(memberOfClass, annotation, annotationVal, "member '" + member.getSimpleName() + "' of '" + assocTypeElement.getSimpleName() + "' is not annotated '@ManyToMany'", Diagnostic.Kind.WARNING);
                break;
            }
            default: {
                throw new AssertionFailure("should not have a mappedBy");
            }
        }
        if (backType != null && !this.context.getTypeUtils().isSameType(backType, this.element.asType())) {
            this.message(memberOfClass, annotation, annotationVal, "member '" + member.getSimpleName() + "' of '" + assocTypeElement.getSimpleName() + "' is not of type '" + this.element.getSimpleName() + "'", Diagnostic.Kind.WARNING);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isPersistent(@UnknownKeyFor @NonNull @Initialized Element memberOfClass, @UnknownKeyFor @NonNull @Initialized AccessType membersKind) {
        return !(this.entityAccessTypeInfo.getAccessType() != membersKind && TypeUtils.determineAnnotationSpecifiedAccessType(memberOfClass) == null || TypeUtils.containsAnnotation(memberOfClass, "jakarta.persistence.Transient") || memberOfClass.getModifiers().contains((Object)Modifier.TRANSIENT) || memberOfClass.getModifiers().contains((Object)Modifier.STATIC) || memberOfClass.getKind() == ElementKind.METHOD && AnnotationMetaEntity.isSessionGetter((ExecutableElement)memberOfClass));
    }

    private void addLifecycleMethods(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ExecutableElement> queryMethods) {
        for (ExecutableElement method : queryMethods) {
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            this.addLifecycleMethod(method);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isDeleteLifecycle(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        if (method.getParameters().size() == 1) {
            VariableElement parameter = method.getParameters().get(0);
            DeclaredType declaredType = this.entityType(this.parameterType(parameter));
            return declaredType != null && TypeUtils.containsAnnotation(declaredType.asElement(), "jakarta.persistence.Entity");
        }
        return false;
    }

    private void addQueryMethods(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ExecutableElement> queryMethods) {
        for (ExecutableElement method : queryMethods) {
            Set<Modifier> modifiers = method.getModifiers();
            if (!modifiers.contains((Object)Modifier.ABSTRACT) && !modifiers.contains((Object)Modifier.NATIVE)) continue;
            this.addQueryMethod(method);
        }
    }

    private void addQueryMethod(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        TypeMirror returnType = this.memberMethodType(method).getReturnType();
        TypeKind kind = returnType.getKind();
        if (kind == TypeKind.VOID || kind == TypeKind.ARRAY || kind.isPrimitive()) {
            this.addQueryMethod(method, returnType, null);
        } else if (kind == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)this.ununiIfPossible(method, returnType);
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            switch (typeArguments.size()) {
                case 0: {
                    if (TypeUtils.containsAnnotation(declaredType.asElement(), "jakarta.persistence.Entity")) {
                        this.addQueryMethod(method, declaredType, null);
                        break;
                    }
                    if (AnnotationMetaEntity.isLegalRawResultType(typeElement.getQualifiedName().toString())) {
                        this.addQueryMethod(method, null, typeElement);
                        break;
                    }
                    this.addQueryMethod(method, declaredType, null);
                    break;
                }
                case 1: {
                    if (!this.validatedQueryReturnType(method, typeElement)) break;
                    this.addQueryMethod(method, typeArguments.get(0), typeElement);
                    break;
                }
                default: {
                    this.message(method, "incorrect return type '" + declaredType + "'", Diagnostic.Kind.ERROR);
                }
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized TypeMirror ununiIfPossible(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized TypeMirror returnType) {
        TypeMirror result = AnnotationMetaEntity.ununi(returnType);
        if (this.repository) {
            if (AnnotationMetaEntity.usingReactiveSession(this.sessionType)) {
                if (result == returnType) {
                    this.message(method, "backed by a reactive session, must return 'Uni'", Diagnostic.Kind.ERROR);
                }
            } else if (result != returnType) {
                this.message(method, "not backed by a reactive session, must not return 'Uni'", Diagnostic.Kind.ERROR);
            }
        }
        return result;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean validatedQueryReturnType(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized TypeElement typeElement) {
        String typeName;
        switch (typeName = typeElement.getQualifiedName().toString()) {
            case "jakarta.data.page.Page": {
                if (!AnnotationMetaEntity.hasPageRequest(method)) {
                    this.message(method, "method with return type '" + typeName + "' has no parameter of type 'PageRequest'", Diagnostic.Kind.ERROR);
                    return false;
                }
                return true;
            }
            case "jakarta.data.page.CursoredPage": {
                if (!AnnotationMetaEntity.hasPageRequest(method)) {
                    this.message(method, "method with return type '" + typeName + "' has no parameter of type 'PageRequest'", Diagnostic.Kind.ERROR);
                    return false;
                }
                if (!AnnotationMetaEntity.hasOrder(method)) {
                    this.message(method, "method with return type '" + typeName + "' has no parameter of type 'Order' or 'Sort' and no '@OrderBy' annotation", Diagnostic.Kind.ERROR);
                    return false;
                }
                return true;
            }
            case "org.hibernate.query.KeyedResultList": {
                if (!AnnotationMetaEntity.hashKeyedPage(method)) {
                    this.message(method, "method with return type '" + typeName + "' has no parameter of type 'KeyedPage'", Diagnostic.Kind.ERROR);
                    return false;
                }
                return true;
            }
        }
        if (AnnotationMetaEntity.isLegalGenericResultType(typeName)) {
            return true;
        }
        this.message(method, "incorrect return type '" + typeName + "'", Diagnostic.Kind.ERROR);
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean hashKeyedPage(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        return method.getParameters().stream().anyMatch(param -> AnnotationMetaEntity.typeNameEquals(param.asType(), "org.hibernate.query.KeyedPage"));
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean hasPageRequest(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        return method.getParameters().stream().anyMatch(param -> AnnotationMetaEntity.typeNameEquals(param.asType(), "jakarta.data.page.PageRequest"));
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean hasOrder(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        return TypeUtils.hasAnnotation((Element)method, "jakarta.data.repository.OrderBy", "jakarta.data.repository.OrderBy.List") || method.getParameters().stream().anyMatch(param -> AnnotationMetaEntity.typeNameEquals(param.asType(), "jakarta.data.Order") || AnnotationMetaEntity.typeNameEquals(param.asType(), "jakarta.data.Sort") || AnnotationMetaEntity.typeNameEqualsArray(param.asType(), "jakarta.data.Sort"));
    }

    private static @UnknownKeyFor @NonNull @Initialized TypeMirror ununi(@UnknownKeyFor @NonNull @Initialized TypeMirror returnType) {
        DeclaredType declaredType;
        TypeElement typeElement;
        if (returnType.getKind() == TypeKind.DECLARED && (typeElement = (TypeElement)(declaredType = (DeclaredType)returnType).asElement()).getQualifiedName().contentEquals("io.smallrye.mutiny.Uni")) {
            return declaredType.getTypeArguments().get(0);
        }
        return returnType;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isLegalRawResultType(@UnknownKeyFor @NonNull @Initialized String containerTypeName) {
        return LEGAL_RAW_RESULT_TYPES.contains(containerTypeName);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isLegalGenericResultType(@UnknownKeyFor @NonNull @Initialized String containerTypeName) {
        return LEGAL_GENERIC_RESULT_TYPES.contains(containerTypeName);
    }

    private void addQueryMethod(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @Nullable @UnknownKeyFor @Initialized TypeElement containerType) {
        AnnotationMirror jdql;
        AnnotationMirror sql;
        AnnotationMirror hql = TypeUtils.getAnnotationMirror(method, "org.hibernate.annotations.processing.HQL");
        if (hql != null) {
            this.addQueryMethod(method, returnType, containerType, hql, false);
        }
        if ((sql = TypeUtils.getAnnotationMirror(method, "org.hibernate.annotations.processing.SQL")) != null) {
            this.addQueryMethod(method, returnType, containerType, sql, true);
        }
        if ((jdql = TypeUtils.getAnnotationMirror(method, "jakarta.data.repository.Query")) != null) {
            this.addQueryMethod(method, returnType, containerType, jdql, false);
        }
        if (TypeUtils.hasAnnotation((Element)method, "org.hibernate.annotations.processing.Find", "jakarta.data.repository.Find")) {
            this.addFinderMethod(method, returnType, containerType);
        } else if (TypeUtils.hasAnnotation((Element)method, "jakarta.data.repository.Delete")) {
            this.addDeleteMethod(method, returnType);
        }
    }

    private void addDeleteMethod(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType) {
        if (returnType != null) {
            TypeKind kind = returnType.getKind();
            if (kind != TypeKind.VOID && kind != TypeKind.INT && kind != TypeKind.LONG) {
                this.message(method, "must be 'void' or return 'int' or 'long'", Diagnostic.Kind.ERROR);
            } else {
                this.createCriteriaDelete(method);
            }
        }
    }

    private void addLifecycleMethod(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        TypeMirror returnType = this.ununiIfPossible(method, method.getReturnType());
        if (method.getParameters().size() != 1) {
            this.message(method, "must have exactly one parameter", Diagnostic.Kind.ERROR);
        } else if (returnType == null) {
            this.message(method, "must be declared 'void'", Diagnostic.Kind.ERROR);
        } else {
            boolean returnArgument = !AnnotationMetaEntity.isVoid(returnType);
            String operation = AnnotationMetaEntity.lifecycleOperation(method);
            VariableElement parameter = method.getParameters().get(0);
            TypeMirror declaredParameterType = parameter.asType();
            TypeMirror parameterType = this.parameterType(parameter);
            DeclaredType declaredType = this.entityType(parameterType);
            if (declaredType == null) {
                this.message(parameter, "incorrect parameter type '" + parameterType + "' is not an entity type", Diagnostic.Kind.ERROR);
            } else if (!TypeUtils.hasAnnotation(declaredType.asElement(), "jakarta.persistence.Entity") && declaredParameterType == parameterType) {
                this.message(parameter, "incorrect parameter type '" + parameterType + "' is not annotated '@Entity'", Diagnostic.Kind.ERROR);
            } else if (returnArgument && !this.context.getTypeUtils().isSameType(returnType, declaredParameterType)) {
                this.message(parameter, "return type '" + returnType + "' disagrees with parameter type '" + parameterType + "'", Diagnostic.Kind.ERROR);
            } else {
                String entity = this.typeAsString(parameterType);
                String methodName = method.getSimpleName().toString();
                this.putMember(methodName + "." + entity, new LifecycleMethod(this, method, entity, methodName, parameter.getSimpleName().toString(), this.getSessionVariableName(), this.sessionType, operation, this.context.addNonnullAnnotation(), AnnotationMetaEntity.isIterableLifecycleParameter(parameterType), returnArgument, this.hasGeneratedId(declaredType)));
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean hasGeneratedId(@UnknownKeyFor @NonNull @Initialized DeclaredType entityType) {
        TypeElement typeElement = (TypeElement)entityType.asElement();
        for (Element member : this.context.getAllMembers(typeElement)) {
            if (!TypeUtils.hasAnnotation(member, "jakarta.persistence.GeneratedValue") || !TypeUtils.hasAnnotation(member, "jakarta.persistence.Id")) continue;
            return true;
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isIterableLifecycleParameter(@UnknownKeyFor @NonNull @Initialized TypeMirror parameterType) {
        switch (parameterType.getKind()) {
            case ARRAY: {
                return true;
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)parameterType;
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                return typeElement.getQualifiedName().contentEquals("java.util.List");
            }
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isVoid(@UnknownKeyFor @NonNull @Initialized TypeMirror returnType) {
        switch (returnType.getKind()) {
            case VOID: {
                return true;
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)returnType;
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                return typeElement.getQualifiedName().contentEquals(Void.class.getName());
            }
        }
        return false;
    }

    private @Nullable @UnknownKeyFor @Initialized DeclaredType entityType(@UnknownKeyFor @NonNull @Initialized TypeMirror parameterType) {
        Types types = this.context.getTypeUtils();
        switch (parameterType.getKind()) {
            case TYPEVAR: {
                TypeVariable typeVariable = (TypeVariable)parameterType;
                parameterType = typeVariable.getUpperBound();
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)parameterType;
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                if (typeElement.getQualifiedName().contentEquals("java.util.List") && !declaredType.getTypeArguments().isEmpty()) {
                    TypeMirror elementType = types.erasure(declaredType.getTypeArguments().get(0));
                    return elementType.getKind() == TypeKind.DECLARED ? (DeclaredType)elementType : null;
                }
                return declaredType;
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)parameterType;
                TypeMirror componentType = types.erasure(arrayType.getComponentType());
                return componentType.getKind() == TypeKind.DECLARED ? (DeclaredType)componentType : null;
            }
        }
        return null;
    }

    private @Nullable @UnknownKeyFor @Initialized TypeMirror elementType(@UnknownKeyFor @NonNull @Initialized TypeMirror parameterType) {
        switch (parameterType.getKind()) {
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)parameterType;
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                switch (typeArguments.size()) {
                    case 1: {
                        return typeArguments.get(0);
                    }
                    case 2: {
                        return typeArguments.get(1);
                    }
                }
                return null;
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)parameterType;
                return arrayType.getComponentType();
            }
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized String lifecycleOperation(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        if (TypeUtils.hasAnnotation((Element)method, "jakarta.data.repository.Insert")) {
            return "insert";
        }
        if (TypeUtils.hasAnnotation((Element)method, "jakarta.data.repository.Update")) {
            return "update";
        }
        if (TypeUtils.hasAnnotation((Element)method, "jakarta.data.repository.Delete")) {
            return "delete";
        }
        if (TypeUtils.hasAnnotation((Element)method, "jakarta.data.repository.Save")) {
            return "upsert";
        }
        throw new AssertionFailure("Unrecognized lifecycle operation");
    }

    private void addFinderMethod(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @Nullable @UnknownKeyFor @Initialized TypeElement containerType) {
        if (returnType == null) {
            this.message(method, "missing return type", Diagnostic.Kind.ERROR);
        } else if (returnType.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)returnType;
            TypeMirror componentType = arrayType.getComponentType();
            if (componentType.getKind() != TypeKind.DECLARED) {
                this.message(method, "incorrect return type '" + returnType + "' is not an array with entity elements", Diagnostic.Kind.ERROR);
            } else {
                DeclaredType declaredType = (DeclaredType)componentType;
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                if (!TypeUtils.containsAnnotation(typeElement, "jakarta.persistence.Entity")) {
                    this.message(method, "incorrect return type '" + returnType + "' is not annotated '@Entity'", Diagnostic.Kind.ERROR);
                } else {
                    this.createCriteriaFinder(method, arrayType.getComponentType(), "[]", typeElement);
                }
            }
        } else if (returnType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)returnType;
            TypeElement entity = (TypeElement)declaredType.asElement();
            if (!TypeUtils.containsAnnotation(entity, "jakarta.persistence.Entity")) {
                this.message(method, "incorrect return type '" + declaredType + "' is not annotated '@Entity'", Diagnostic.Kind.ERROR);
            } else if (containerType != null && !containerType.getQualifiedName().contentEquals("java.util.Optional")) {
                this.createCriteriaFinder(method, declaredType, containerType.toString(), entity);
            } else {
                for (VariableElement variableElement : method.getParameters()) {
                    String type = AnnotationMetaEntity.typeName(variableElement.asType());
                    if (QueryMethod.isPageParam(type)) {
                        this.message(variableElement, "pagination would have no effect", Diagnostic.Kind.ERROR);
                        continue;
                    }
                    if (!QueryMethod.isOrderParam(type)) continue;
                    this.message(variableElement, "ordering would have no effect", Diagnostic.Kind.ERROR);
                }
                String containerTypeName = containerType == null ? null : "java.util.Optional";
                long l = method.getParameters().stream().filter(AnnotationMetaEntity::isFinderParameterMappingToAttribute).count();
                switch ((int)l) {
                    case 0: {
                        this.message(method, "missing parameter", Diagnostic.Kind.ERROR);
                        break;
                    }
                    case 1: {
                        this.createSingleParameterFinder(method, declaredType, entity, containerTypeName);
                        break;
                    }
                    default: {
                        this.createMultipleParameterFinder(method, declaredType, entity, containerTypeName);
                    }
                }
            }
        } else {
            this.message(method, "incorrect return type '" + returnType + "' is not an entity type", Diagnostic.Kind.ERROR);
        }
    }

    private void createCriteriaFinder(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized TypeMirror returnType, @Nullable @UnknownKeyFor @Initialized String containerType, @UnknownKeyFor @NonNull @Initialized TypeElement entity) {
        String methodName = method.getSimpleName().toString();
        List<String> paramNames = this.parameterNames(method, entity);
        List<String> paramTypes = this.parameterTypes(method);
        List<Boolean> paramPatterns = AnnotationMetaEntity.parameterPatterns(method);
        String[] sessionType = this.sessionTypeFromParameters(paramNames, paramTypes);
        String methodKey = methodName + paramTypes;
        ArrayList<Boolean> multivalued = new ArrayList<Boolean>();
        for (VariableElement variableElement : method.getParameters()) {
            if (AnnotationMetaEntity.isFinderParameterMappingToAttribute(variableElement)) {
                multivalued.add(this.validateFinderParameter(entity, variableElement) == FieldType.MULTIVALUED);
                continue;
            }
            multivalued.add(false);
            this.checkFinderParameter(entity, variableElement);
        }
        this.putMember(methodKey, new CriteriaFinderMethod(this, method, methodName, returnType.toString(), containerType, paramNames, paramTypes, this.parameterNullability(method, entity), multivalued, paramPatterns, this.repository, sessionType[0], sessionType[1], AnnotationMetaEntity.enabledFetchProfiles(method), this.orderByList(method, entity), this.context.addNonnullAnnotation(), this.jakartaDataRepository, this.fullReturnType(method), TypeUtils.hasAnnotation((Element)method, "jakarta.annotation.Nullable")));
    }

    private void checkFinderParameter(@UnknownKeyFor @NonNull @Initialized TypeElement entity, @UnknownKeyFor @NonNull @Initialized VariableElement parameter) {
        Types types = this.context.getTypeUtils();
        TypeMirror parameterType = this.parameterType(parameter);
        if (QueryMethod.isOrderParam(AnnotationMetaEntity.typeName(parameterType))) {
            TypeMirror typeArgument = AnnotationMetaEntity.getTypeArgument(parameterType, entity);
            if (typeArgument == null) {
                this.missingTypeArgError(entity.getSimpleName().toString(), parameter);
            } else if (!types.isSameType(typeArgument, entity.asType())) {
                this.wrongTypeArgError(entity.getSimpleName().toString(), parameter);
            }
        }
    }

    private void createCriteriaDelete(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        TypeElement entity = this.primaryEntity;
        if (entity == null) {
            this.message(method, "repository does not have a well-defined primary entity type", Diagnostic.Kind.ERROR);
        } else {
            String methodName = method.getSimpleName().toString();
            List<String> paramNames = this.parameterNames(method, entity);
            List<String> paramTypes = this.parameterTypes(method);
            List<Boolean> paramPatterns = AnnotationMetaEntity.parameterPatterns(method);
            String[] sessionType = this.sessionTypeFromParameters(paramNames, paramTypes);
            String methodKey = methodName + paramTypes;
            ArrayList<Boolean> multivalued = new ArrayList<Boolean>();
            for (VariableElement variableElement : method.getParameters()) {
                if (AnnotationMetaEntity.isFinderParameterMappingToAttribute(variableElement)) {
                    multivalued.add(this.validateFinderParameter(entity, variableElement) == FieldType.MULTIVALUED);
                    continue;
                }
                multivalued.add(false);
            }
            this.putMember(methodKey, new CriteriaDeleteMethod(this, method, methodName, entity.getQualifiedName().toString(), paramNames, paramTypes, this.parameterNullability(method, entity), multivalued, paramPatterns, this.repository, sessionType[0], sessionType[1], this.context.addNonnullAnnotation(), this.jakartaDataRepository, this.fullReturnType(method)));
        }
    }

    private void wrongTypeArgError(@UnknownKeyFor @NonNull @Initialized String entity, @UnknownKeyFor @NonNull @Initialized VariableElement parameter) {
        this.message(parameter, "mismatched type of order (should be 'Order<? super " + entity + ">')", Diagnostic.Kind.ERROR);
    }

    private void missingTypeArgError(@UnknownKeyFor @NonNull @Initialized String entity, @UnknownKeyFor @NonNull @Initialized VariableElement parameter) {
        this.message(parameter, "missing type of order (should be 'Order<? super " + entity + ">')", Diagnostic.Kind.ERROR);
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized OrderBy> orderByList(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized TypeElement returnType) {
        TypeElement entityType = this.implicitEntityType(returnType);
        if (entityType != null) {
            AnnotationMirror orderByList = TypeUtils.getAnnotationMirror(method, "jakarta.data.repository.OrderBy.List");
            if (orderByList != null) {
                ArrayList<OrderBy> result = new ArrayList<OrderBy>();
                List list = (List)NullnessUtil.castNonNull(TypeUtils.getAnnotationValue(orderByList, "value")).getValue();
                for (AnnotationValue element : list) {
                    result.add(this.orderByExpression(NullnessUtil.castNonNull((AnnotationMirror)element.getValue()), entityType, method));
                }
                return result;
            }
            AnnotationMirror orderBy = TypeUtils.getAnnotationMirror(method, "jakarta.data.repository.OrderBy");
            if (orderBy != null) {
                return List.of(this.orderByExpression(orderBy, entityType, method));
            }
        }
        return Collections.emptyList();
    }

    private @UnknownKeyFor @NonNull @Initialized OrderBy orderByExpression(@UnknownKeyFor @NonNull @Initialized AnnotationMirror orderBy, @UnknownKeyFor @NonNull @Initialized TypeElement entityType, @UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        String fieldName = NullnessUtil.castNonNull(TypeUtils.getAnnotationValue(orderBy, "value")).getValue().toString();
        if (fieldName.equals("<error>")) {
            throw new ProcessLaterException();
        }
        AnnotationValue descendingOrNull = TypeUtils.getAnnotationValue(orderBy, "descending");
        AnnotationValue ignoreCaseOrNull = TypeUtils.getAnnotationValue(orderBy, "ignoreCase");
        boolean descending = descendingOrNull != null && (Boolean)descendingOrNull.getValue() != false;
        boolean ignoreCase = ignoreCaseOrNull != null && (Boolean)ignoreCaseOrNull.getValue() != false;
        String path = fieldName.replace('$', '.').replace('_', '.');
        if (this.memberMatchingPath(entityType, path) == null) {
            this.message(method, orderBy, "no matching field named '" + fieldName + "' in entity class '" + entityType.getQualifiedName() + "'", Diagnostic.Kind.ERROR);
        }
        return new OrderBy(path, descending, ignoreCase);
    }

    private static @Nullable @UnknownKeyFor @Initialized TypeMirror getTypeArgument(@UnknownKeyFor @NonNull @Initialized TypeMirror parameterType, @UnknownKeyFor @NonNull @Initialized TypeElement entity) {
        switch (parameterType.getKind()) {
            case ARRAY: {
                ArrayType arrayType = (ArrayType)parameterType;
                return AnnotationMetaEntity.getTypeArgument(arrayType.getComponentType(), entity);
            }
            case DECLARED: {
                DeclaredType type = (DeclaredType)parameterType;
                switch (AnnotationMetaEntity.typeName(parameterType)) {
                    case "java.util.List": {
                        Iterator<? extends TypeMirror> iterator = type.getTypeArguments().iterator();
                        if (iterator.hasNext()) {
                            TypeMirror arg = iterator.next();
                            return AnnotationMetaEntity.getTypeArgument(arg, entity);
                        }
                        return null;
                    }
                    case "org.hibernate.query.Order": 
                    case "jakarta.data.Sort": 
                    case "jakarta.data.Order": {
                        Iterator<? extends TypeMirror> iterator = type.getTypeArguments().iterator();
                        if (iterator.hasNext()) {
                            TypeMirror arg = iterator.next();
                            switch (arg.getKind()) {
                                case WILDCARD: {
                                    TypeMirror superBound = ((WildcardType)arg).getSuperBound();
                                    return superBound == null ? entity.asType() : superBound;
                                }
                                case TYPEVAR: 
                                case DECLARED: 
                                case ARRAY: {
                                    return arg;
                                }
                            }
                            return null;
                        }
                        return null;
                    }
                }
                return null;
            }
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isFinderParameterMappingToAttribute(@UnknownKeyFor @NonNull @Initialized VariableElement param) {
        return !AbstractQueryMethod.isSpecialParam(AnnotationMetaEntity.typeName(param.asType()));
    }

    private @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] sessionTypeFromParameters(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes) {
        for (int i = 0; i < paramNames.size(); ++i) {
            String type = paramTypes.get(i);
            String name = paramNames.get(i);
            if (!AbstractQueryMethod.isSessionParameter(type)) continue;
            return new String[]{type, name};
        }
        return new String[]{this.getSessionType(), this.getSessionVariableName()};
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized String getSessionVariableName() {
        return this.getSessionVariableName(this.sessionType);
    }

    private @UnknownKeyFor @NonNull @Initialized String getSessionVariableName(@UnknownKeyFor @NonNull @Initialized String sessionType) {
        switch (sessionType) {
            case "org.hibernate.Session": 
            case "org.hibernate.StatelessSession": 
            case "org.hibernate.reactive.mutiny.Mutiny.Session": 
            case "org.hibernate.reactive.mutiny.Mutiny.StatelessSession": {
                return "session";
            }
        }
        return this.sessionGetter;
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> enabledFetchProfiles(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        AnnotationMirror findAnnotation = TypeUtils.getAnnotationMirror(method, "org.hibernate.annotations.processing.Find");
        if (findAnnotation == null) {
            return Collections.emptyList();
        }
        AnnotationValue enabledFetchProfiles = TypeUtils.getAnnotationValue(findAnnotation, "enabledFetchProfiles");
        if (enabledFetchProfiles == null) {
            return Collections.emptyList();
        }
        List annotationValues = (List)enabledFetchProfiles.getValue();
        List<String> result = annotationValues.stream().map(AnnotationValue::toString).collect(Collectors.toList());
        if (result.stream().anyMatch("<error>"::equals)) {
            throw new ProcessLaterException();
        }
        return result;
    }

    private void createMultipleParameterFinder(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized TypeElement entity, @Nullable @UnknownKeyFor @Initialized String containerType) {
        String methodName = method.getSimpleName().toString();
        List<String> paramNames = this.parameterNames(method, entity);
        List<String> paramTypes = this.parameterTypes(method);
        String[] sessionType = this.sessionTypeFromParameters(paramNames, paramTypes);
        String methodKey = methodName + paramTypes;
        ArrayList<Boolean> multivalued = new ArrayList<Boolean>();
        ArrayList<@Nullable FieldType> fieldTypes = new ArrayList<FieldType>();
        for (VariableElement variableElement : method.getParameters()) {
            if (AnnotationMetaEntity.isFinderParameterMappingToAttribute(variableElement)) {
                FieldType fieldType = this.validateFinderParameter(entity, variableElement);
                fieldTypes.add(fieldType);
                multivalued.add(fieldType == FieldType.MULTIVALUED);
                continue;
            }
            multivalued.add(false);
        }
        if (!AnnotationMetaEntity.usingStatelessSession(sessionType[0]) && this.matchesNaturalKey(entity, fieldTypes)) {
            this.putMember(methodKey, new NaturalIdFinderMethod(this, method, methodName, returnType.toString(), containerType, paramNames, paramTypes, this.parameterNullability(method, entity), this.repository, sessionType[0], sessionType[1], AnnotationMetaEntity.enabledFetchProfiles(method), this.context.addNonnullAnnotation(), this.jakartaDataRepository, this.fullReturnType(method)));
        } else {
            List<Boolean> paramPatterns = AnnotationMetaEntity.parameterPatterns(method);
            this.putMember(methodKey, new CriteriaFinderMethod(this, method, methodName, returnType.toString(), containerType, paramNames, paramTypes, this.parameterNullability(method, entity), multivalued, paramPatterns, this.repository, sessionType[0], sessionType[1], AnnotationMetaEntity.enabledFetchProfiles(method), this.orderByList(method, entity), this.context.addNonnullAnnotation(), this.jakartaDataRepository, this.fullReturnType(method), TypeUtils.hasAnnotation((Element)method, "jakarta.annotation.Nullable")));
        }
    }

    private void createSingleParameterFinder(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized TypeElement entity, @Nullable @UnknownKeyFor @Initialized String containerType) {
        String methodName = method.getSimpleName().toString();
        VariableElement parameter = method.getParameters().stream().filter(AnnotationMetaEntity::isFinderParameterMappingToAttribute).findFirst().orElseThrow();
        List<String> paramNames = this.parameterNames(method, entity);
        List<String> paramTypes = this.parameterTypes(method);
        String[] sessionType = this.sessionTypeFromParameters(paramNames, paramTypes);
        FieldType fieldType = this.validateFinderParameter(entity, parameter);
        if (fieldType != null) {
            String methodKey = methodName + "!";
            List<String> profiles = AnnotationMetaEntity.enabledFetchProfiles(method);
            switch (this.pickStrategy(fieldType, sessionType[0], profiles)) {
                case ID: {
                    this.putMember(methodKey, new IdFinderMethod(this, method, methodName, returnType.toString(), containerType, paramNames, paramTypes, this.repository, sessionType[0], sessionType[1], profiles, this.context.addNonnullAnnotation(), this.jakartaDataRepository, this.fullReturnType(method), TypeUtils.hasAnnotation((Element)method, "jakarta.annotation.Nullable")));
                    break;
                }
                case NATURAL_ID: {
                    if (!AnnotationMetaEntity.usingStatelessSession(sessionType[0])) {
                        this.putMember(methodKey, new NaturalIdFinderMethod(this, method, methodName, returnType.toString(), containerType, paramNames, paramTypes, this.parameterNullability(method, entity), this.repository, sessionType[0], sessionType[1], profiles, this.context.addNonnullAnnotation(), this.jakartaDataRepository, this.fullReturnType(method)));
                        break;
                    }
                }
                case BASIC: 
                case MULTIVALUED: {
                    List<Boolean> paramPatterns = AnnotationMetaEntity.parameterPatterns(method);
                    this.putMember(methodKey, new CriteriaFinderMethod(this, method, methodName, returnType.toString(), containerType, paramNames, paramTypes, this.parameterNullability(method, entity), method.getParameters().stream().map(param -> AnnotationMetaEntity.isFinderParameterMappingToAttribute(param) && fieldType == FieldType.MULTIVALUED).collect(Collectors.toList()), paramPatterns, this.repository, sessionType[0], sessionType[1], profiles, this.orderByList(method, entity), this.context.addNonnullAnnotation(), this.jakartaDataRepository, this.fullReturnType(method), TypeUtils.hasAnnotation((Element)method, "jakarta.annotation.Nullable")));
                }
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized FieldType pickStrategy(@UnknownKeyFor @NonNull @Initialized FieldType fieldType, @UnknownKeyFor @NonNull @Initialized String sessionType, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> profiles) {
        if ((AnnotationMetaEntity.usingStatelessSession(sessionType) || AnnotationMetaEntity.usingReactiveSession(sessionType)) && !profiles.isEmpty()) {
            return FieldType.BASIC;
        }
        switch (fieldType) {
            case ID: {
                return FieldType.ID;
            }
            case NATURAL_ID: {
                return FieldType.NATURAL_ID;
            }
        }
        return FieldType.BASIC;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean matchesNaturalKey(@UnknownKeyFor @NonNull @Initialized TypeElement entity, @UnknownKeyFor @NonNull @Initialized List<@Nullable @UnknownKeyFor @Initialized FieldType> fieldTypes) {
        return fieldTypes.stream().allMatch(type -> type == FieldType.NATURAL_ID) && entity.getEnclosedElements().stream().filter(member -> TypeUtils.hasAnnotation(member, "org.hibernate.annotations.NaturalId")).count() == (long)fieldTypes.size();
    }

    private @Nullable @UnknownKeyFor @Initialized FieldType validateFinderParameter(@UnknownKeyFor @NonNull @Initialized TypeElement entityType, @UnknownKeyFor @NonNull @Initialized VariableElement param) {
        AnnotationValue value;
        Element member = this.memberMatchingPath(entityType, AnnotationMetaEntity.parameterName(param));
        if (member != null) {
            if (TypeUtils.containsAnnotation(member, "jakarta.persistence.ManyToMany", "jakarta.persistence.OneToMany", "jakarta.persistence.ElementCollection")) {
                this.message(param, "matching field is a collection", Diagnostic.Kind.ERROR);
                return null;
            }
            if (this.checkParameterType(entityType, param, AnnotationMetaEntity.memberType(member))) {
                return FieldType.MULTIVALUED;
            }
            if (TypeUtils.containsAnnotation(param, "org.hibernate.annotations.processing.Pattern")) {
                AnnotationMirror mirror = TypeUtils.getAnnotationMirror(param, "org.hibernate.annotations.processing.Pattern");
                if (mirror != null && !AnnotationMetaEntity.typeNameEquals(param.asType(), String.class.getName())) {
                    this.message(param, mirror, "parameter annotated '@Pattern' is not of type 'String'", Diagnostic.Kind.ERROR);
                }
                return FieldType.BASIC;
            }
            if (TypeUtils.containsAnnotation(member, "jakarta.persistence.Id", "jakarta.persistence.EmbeddedId")) {
                return FieldType.ID;
            }
            if (TypeUtils.containsAnnotation(member, "org.hibernate.annotations.NaturalId")) {
                return FieldType.NATURAL_ID;
            }
            return FieldType.BASIC;
        }
        AnnotationMirror idClass = TypeUtils.getAnnotationMirror(entityType, "jakarta.persistence.IdClass");
        if (idClass != null && (value = TypeUtils.getAnnotationValue(idClass, "value")) != null && this.context.getTypeUtils().isSameType(param.asType(), (TypeMirror)value.getValue())) {
            return FieldType.ID;
        }
        this.message(param, "no matching field named '" + AnnotationMetaEntity.parameterName(param) + "' in entity class '" + entityType + "'", Diagnostic.Kind.ERROR);
        return null;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean checkParameterType(@UnknownKeyFor @NonNull @Initialized TypeElement entityType, @UnknownKeyFor @NonNull @Initialized VariableElement param, @UnknownKeyFor @NonNull @Initialized TypeMirror attributeType) {
        TypeMirror parameterType;
        Types types = this.context.getTypeUtils();
        if (types.isSameType(parameterType = this.parameterType(param), attributeType)) {
            return false;
        }
        if (attributeType.getKind().isPrimitive()) {
            PrimitiveType primitiveType = (PrimitiveType)attributeType;
            attributeType = types.boxedClass(primitiveType).asType();
        }
        TypeKind kind = parameterType.getKind();
        switch (kind) {
            case TYPEVAR: {
                TypeVariable typeVariable = (TypeVariable)parameterType;
                parameterType = typeVariable.getUpperBound();
            }
            case DECLARED: {
                if (types.isSameType(parameterType, attributeType)) {
                    return false;
                }
                TypeElement list = this.context.getTypeElementForFullyQualifiedName("java.util.List");
                if (types.isSameType(parameterType, types.getDeclaredType(list, attributeType))) {
                    return true;
                }
                this.parameterTypeError(entityType, param, attributeType);
                return false;
            }
            case ARRAY: {
                if (!types.isSameType(parameterType, types.getArrayType(attributeType))) {
                    this.parameterTypeError(entityType, param, attributeType);
                }
                return true;
            }
        }
        if (kind.isPrimitive()) {
            PrimitiveType primitiveType = (PrimitiveType)parameterType;
            if (!types.isSameType(types.boxedClass(primitiveType).asType(), attributeType)) {
                this.parameterTypeError(entityType, param, attributeType);
            }
            return false;
        }
        return false;
    }

    private void parameterTypeError(@UnknownKeyFor @NonNull @Initialized TypeElement entityType, @UnknownKeyFor @NonNull @Initialized VariableElement param, @UnknownKeyFor @NonNull @Initialized TypeMirror attributeType) {
        this.message(param, "matching field has type '" + attributeType + "' in entity class '" + entityType + "'", Diagnostic.Kind.ERROR);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean finderParameterNullable(@UnknownKeyFor @NonNull @Initialized TypeElement entity, @UnknownKeyFor @NonNull @Initialized VariableElement param) {
        Element member = this.memberMatchingPath(entity, AnnotationMetaEntity.parameterName(param));
        return AnnotationMetaEntity.isNullable(param) && (member == null || AnnotationMetaEntity.isNullable(member));
    }

    private @UnknownKeyFor @NonNull @Initialized AccessType getAccessType(@UnknownKeyFor @NonNull @Initialized TypeElement entity) {
        String entityClassName = entity.getQualifiedName().toString();
        TypeUtils.determineAccessTypeForHierarchy(entity, this.context);
        return NullnessUtil.castNonNull(this.context.getAccessTypeInfo(entityClassName)).getAccessType();
    }

    private static @UnknownKeyFor @NonNull @Initialized TypeMirror memberType(@UnknownKeyFor @NonNull @Initialized Element member) {
        if (member.getKind() == ElementKind.METHOD) {
            ExecutableElement method = (ExecutableElement)member;
            return method.getReturnType();
        }
        return member.asType();
    }

    private @Nullable @UnknownKeyFor @Initialized Element memberMatchingPath(@UnknownKeyFor @NonNull @Initialized TypeElement entityType, @UnknownKeyFor @NonNull @Initialized String path) {
        return this.memberMatchingPath(entityType, new StringTokenizer(path, "."));
    }

    private @Nullable @UnknownKeyFor @Initialized Element memberMatchingPath(@UnknownKeyFor @NonNull @Initialized TypeElement entityType, @UnknownKeyFor @NonNull @Initialized StringTokenizer tokens) {
        AccessType accessType = this.getAccessType(entityType);
        String nextToken = tokens.nextToken();
        for (Element member : this.context.getAllMembers(entityType)) {
            if (AnnotationMetaEntity.isIdRef(nextToken) && TypeUtils.hasAnnotation(member, "jakarta.persistence.Id")) {
                return member;
            }
            Element match = this.memberMatchingPath(entityType, member, accessType, tokens, nextToken);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isIdRef(@UnknownKeyFor @NonNull @Initialized String token) {
        return "#id".equals(token) || "id(this)".equalsIgnoreCase(token);
    }

    private @Nullable @UnknownKeyFor @Initialized Element memberMatchingPath(@UnknownKeyFor @NonNull @Initialized TypeElement entityType, @UnknownKeyFor @NonNull @Initialized Element candidate, @UnknownKeyFor @NonNull @Initialized AccessType accessType, @UnknownKeyFor @NonNull @Initialized StringTokenizer tokens, @UnknownKeyFor @NonNull @Initialized String token) {
        Name memberName = candidate.getSimpleName();
        TypeMirror type = AnnotationMetaEntity.memberType(candidate, accessType, token, memberName);
        if (type == null) {
            return null;
        }
        if (tokens.hasMoreTokens()) {
            return type.getKind() == TypeKind.DECLARED ? this.memberForPath(entityType, tokens, (DeclaredType)type, memberName) : null;
        }
        return candidate;
    }

    private @Nullable @UnknownKeyFor @Initialized Element memberForPath(@UnknownKeyFor @NonNull @Initialized TypeElement entityType, @UnknownKeyFor @NonNull @Initialized StringTokenizer tokens, @UnknownKeyFor @NonNull @Initialized DeclaredType type, @UnknownKeyFor @NonNull @Initialized Name memberName) {
        TypeElement memberType = (TypeElement)type.asElement();
        this.memberTypes.put(StringHelper.qualify((String)entityType.getQualifiedName().toString(), (String)memberName.toString()), memberType.getQualifiedName().toString());
        return this.memberMatchingPath(memberType, tokens);
    }

    private static @Nullable @UnknownKeyFor @Initialized TypeMirror memberType(@UnknownKeyFor @NonNull @Initialized Element candidate, @UnknownKeyFor @NonNull @Initialized AccessType accessType, @UnknownKeyFor @NonNull @Initialized String token, @UnknownKeyFor @NonNull @Initialized Name memberName) {
        ElementKind kind = candidate.getKind();
        if (accessType == AccessType.FIELD && kind == ElementKind.FIELD) {
            return AnnotationMetaEntity.fieldMatches(token, memberName) ? candidate.asType() : null;
        }
        if (accessType == AccessType.PROPERTY && kind == ElementKind.METHOD) {
            ExecutableElement executable = (ExecutableElement)candidate;
            return AnnotationMetaEntity.getterMatches(token, memberName) ? executable.getReturnType() : null;
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean fieldMatches(@UnknownKeyFor @NonNull @Initialized String token, @UnknownKeyFor @NonNull @Initialized Name fieldName) {
        return fieldName.contentEquals(token);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean getterMatches(@UnknownKeyFor @NonNull @Initialized String token, @UnknownKeyFor @NonNull @Initialized Name methodName) {
        if (AnnotationMetaEntity.hasPrefix(methodName, "get")) {
            return token.equals(Introspector.decapitalize(methodName.subSequence(3, methodName.length()).toString()));
        }
        if (AnnotationMetaEntity.hasPrefix(methodName, "is")) {
            return token.equals(Introspector.decapitalize(methodName.subSequence(2, methodName.length()).toString()));
        }
        return false;
    }

    private void addQueryMethod(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @Nullable @UnknownKeyFor @Initialized TypeElement containerType, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized boolean isNative) {
        Object queryString;
        String containerTypeName;
        if (containerType == null) {
            if (returnType != null && returnType.getKind() == TypeKind.ARRAY) {
                ArrayType arrayType = (ArrayType)returnType;
                TypeMirror componentType = arrayType.getComponentType();
                TypeElement object = this.context.getElementUtils().getTypeElement("java.lang.Object");
                if (!this.context.getTypeUtils().isSameType(object.asType(), componentType)) {
                    returnType = componentType;
                    containerTypeName = "[]";
                } else {
                    containerTypeName = null;
                }
            } else {
                containerTypeName = null;
            }
        } else {
            containerTypeName = containerType.getQualifiedName().toString();
        }
        AnnotationValue value = TypeUtils.getAnnotationValue(mirror, "value");
        if (value != null && (queryString = value.getValue()) instanceof String) {
            this.addQueryMethod(method, returnType, containerTypeName, mirror, isNative, value, (String)queryString);
        }
    }

    private void addQueryMethod(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @Nullable @UnknownKeyFor @Initialized String containerTypeName, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized boolean isNative, @UnknownKeyFor @NonNull @Initialized AnnotationValue value, @UnknownKeyFor @NonNull @Initialized String queryString) {
        String processedQuery;
        List<OrderBy> orderBys;
        List<String> paramNames = AnnotationMetaEntity.parameterNames(method);
        List<String> paramTypes = this.parameterTypes(method);
        this.checkParameters(method, returnType, paramNames, paramTypes, mirror, value, queryString);
        String[] sessionType = this.sessionTypeFromParameters(paramNames, paramTypes);
        DeclaredType resultType = this.resultType(method, returnType, mirror, value);
        List<OrderBy> list = orderBys = resultType == null ? Collections.emptyList() : this.orderByList(method, (TypeElement)resultType.asElement());
        if (isNative) {
            processedQuery = queryString;
            this.validateSql(method, mirror, processedQuery, paramNames, value);
        } else {
            processedQuery = AnnotationMetaEntity.addFromClauseIfNecessary(queryString, this.implicitEntityName(resultType));
            this.validateHql(method, returnType, mirror, value, processedQuery, paramNames, paramTypes);
        }
        QueryMethod attribute = new QueryMethod(this, method, method.getSimpleName().toString(), processedQuery, returnType == null ? null : returnType.toString(), returnType == null ? null : AnnotationMetaEntity.returnTypeClass(returnType), containerTypeName, paramNames, paramTypes, AnnotationMetaEntity.isInsertUpdateDelete(queryString), isNative, this.repository, sessionType[0], sessionType[1], orderBys, this.context.addNonnullAnnotation(), this.jakartaDataRepository, this.fullReturnType(method), TypeUtils.hasAnnotation((Element)method, "jakarta.annotation.Nullable"));
        this.putMember(attribute.getPropertyName() + paramTypes, attribute);
    }

    private @UnknownKeyFor @NonNull @Initialized String fullReturnType(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        return this.typeAsString(this.memberMethodType(method).getReturnType());
    }

    private static @UnknownKeyFor @NonNull @Initialized String returnTypeClass(@UnknownKeyFor @NonNull @Initialized TypeMirror returnType) {
        switch (returnType.getKind()) {
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)returnType;
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                return typeElement.getQualifiedName().toString();
            }
            case INT: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case SHORT: {
                return "short";
            }
            case BYTE: {
                return "byte";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case CHAR: {
                return "char";
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)returnType;
                return AnnotationMetaEntity.returnTypeClass(arrayType.getComponentType()) + "[]";
            }
        }
        return returnType.toString();
    }

    private @Nullable @UnknownKeyFor @Initialized String implicitEntityName(@Nullable @UnknownKeyFor @Initialized DeclaredType resultType) {
        if (resultType != null && TypeUtils.hasAnnotation(resultType.asElement(), "jakarta.persistence.Entity")) {
            AnnotationMirror annotation = TypeUtils.getAnnotationMirror(resultType.asElement(), "jakarta.persistence.Entity");
            if (annotation == null) {
                throw new AssertionFailure("@Entity annotation should not be missing");
            }
            return AnnotationMetaEntity.entityName(resultType, annotation);
        }
        if (this.primaryEntity != null) {
            return this.primaryEntity.getSimpleName().toString();
        }
        return null;
    }

    private @Nullable @UnknownKeyFor @Initialized TypeElement implicitEntityType(@Nullable @UnknownKeyFor @Initialized TypeElement resultType) {
        if (resultType != null && TypeUtils.hasAnnotation((Element)resultType, "jakarta.persistence.Entity")) {
            return resultType;
        }
        if (this.primaryEntity != null) {
            return this.primaryEntity;
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized String entityName(@UnknownKeyFor @NonNull @Initialized DeclaredType resultType, @UnknownKeyFor @NonNull @Initialized AnnotationMirror annotation) {
        String explicitName;
        AnnotationValue name = TypeUtils.getAnnotationValue(annotation, "name");
        if (name != null && !(explicitName = name.getValue().toString()).isEmpty()) {
            return explicitName;
        }
        return resultType.asElement().getSimpleName().toString();
    }

    private static @UnknownKeyFor @NonNull @Initialized String addFromClauseIfNecessary(@UnknownKeyFor @NonNull @Initialized String hql, @Nullable @UnknownKeyFor @Initialized String entityType) {
        if (entityType == null) {
            return hql;
        }
        if (AnnotationMetaEntity.isInsertUpdateDelete(hql)) {
            return hql;
        }
        HqlLexer hqlLexer = HqlParseTreeBuilder.INSTANCE.buildHqlLexer(hql);
        Object thisText = "";
        List allTokens = hqlLexer.getAllTokens();
        for (Token token : allTokens) {
            if (token.getType() != 221) continue;
            String text = token.getText();
            if (!text.equalsIgnoreCase("this")) break;
            thisText = " as " + text;
            break;
        }
        for (int i = 0; i < allTokens.size(); ++i) {
            Token token;
            token = (Token)allTokens.get(i);
            switch (token.getType()) {
                case 102: {
                    return ((String)thisText).isEmpty() || AnnotationMetaEntity.hasAlias(i, allTokens) ? hql : new StringBuilder(hql).insert(((Token)allTokens.get(i + 1)).getStopIndex() + 1, (String)thisText).toString();
                }
                case 105: 
                case 107: 
                case 164: 
                case 212: {
                    return new StringBuilder(hql).insert(token.getStartIndex(), "from " + entityType + (String)thisText + " ").toString();
                }
            }
        }
        return hql + " from " + entityType + (String)thisText;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean hasAlias(@UnknownKeyFor @NonNull @Initialized int i, @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Token> allTokens) {
        if (allTokens.size() <= i + 2) {
            return false;
        }
        int nextTokenType = allTokens.get(i + 2).getType();
        return nextTokenType == 221 || nextTokenType == 50;
    }

    private @Nullable @UnknownKeyFor @Initialized DeclaredType resultType(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value) {
        if (returnType != null && returnType.getKind() == TypeKind.DECLARED) {
            DeclaredType resultType = (DeclaredType)returnType;
            if (!resultType.getTypeArguments().isEmpty()) {
                this.message(method, mirror, value, "query result type may not be a generic type (change '" + returnType + "' to '" + this.context.getTypeUtils().erasure(returnType) + "')", Diagnostic.Kind.ERROR);
            }
            return resultType;
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isInsertUpdateDelete(@UnknownKeyFor @NonNull @Initialized String hql) {
        String trimmed = hql.trim();
        String keyword = trimmed.length() > 6 ? trimmed.substring(0, 6) : "";
        return keyword.equalsIgnoreCase("update") || keyword.equalsIgnoreCase("delete") || keyword.equalsIgnoreCase("insert");
    }

    private void validateHql(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value, @UnknownKeyFor @NonNull @Initialized String hql, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes) {
        SqmStatement<?> statement = Validation.validate(hql, returnType, true, new ErrorHandler(this.context, this.isLocal(method) ? method : this.element, mirror, value, hql), ProcessorSessionFactory.create(this.context.getProcessingEnvironment(), this.context.getEntityNameMappings(), this.context.getEnumTypesByValue()));
        if (statement != null) {
            if (statement instanceof SqmSelectStatement) {
                this.validateSelectHql(method, returnType, mirror, value, (SqmSelectStatement)statement);
            } else {
                this.validateUpdateHql(method, returnType, mirror, value);
            }
            for (SqmParameter param : statement.getSqmParameters()) {
                this.checkParameter(param, paramNames, paramTypes, method, mirror, value);
            }
        }
    }

    private void validateUpdateHql(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value) {
        boolean reactive = AnnotationMetaEntity.usingReactiveSession(this.sessionType);
        if (!this.isValidUpdateReturnType(returnType, method, reactive)) {
            this.message(method, mirror, value, "return type of mutation query method must be " + (!reactive ? "'int', 'long', 'boolean' or 'void'" : "'Uni<Integer>', 'Uni<Boolean>' or 'Uni<Void>'"), Diagnostic.Kind.ERROR);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isValidUpdateReturnType(@Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized boolean reactive) {
        if (returnType == null) {
            return false;
        }
        if (reactive) {
            String returnTypeName = this.fullReturnType(method);
            return returnTypeName.equals("io.smallrye.mutiny.Uni<java.lang.Void>") || returnTypeName.equals("io.smallrye.mutiny.Uni<java.lang.Boolean>") || returnTypeName.equals("io.smallrye.mutiny.Uni<java.lang.Integer>");
        }
        return returnType.getKind() == TypeKind.VOID || returnType.getKind() == TypeKind.BOOLEAN || returnType.getKind() == TypeKind.INT || returnType.getKind() == TypeKind.LONG;
    }

    private void validateSelectHql(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SqmSelectStatement<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> statement) {
        if (returnType != null) {
            boolean returnTypeCorrect;
            JpaSelection selection = statement.getSelection();
            if (selection.isCompoundSelection()) {
                switch (returnType.getKind()) {
                    case ARRAY: {
                        returnTypeCorrect = AnnotationMetaEntity.checkReturnedArrayType((ArrayType)returnType);
                        break;
                    }
                    case DECLARED: {
                        if (!AnnotationMetaEntity.checkConstructorReturn((DeclaredType)returnType, selection)) {
                            this.message(method, mirror, value, "return type '" + returnType + "' of method has no constructor matching query selection list", Diagnostic.Kind.ERROR);
                        }
                        returnTypeCorrect = true;
                        break;
                    }
                    default: {
                        returnTypeCorrect = false;
                        break;
                    }
                }
            } else if (selection instanceof JpaEntityJoin) {
                JpaEntityJoin from = (JpaEntityJoin)selection;
                returnTypeCorrect = this.checkReturnedEntity(from.getModel(), returnType);
            } else if (selection instanceof JpaRoot) {
                JpaRoot from = (JpaRoot)selection;
                returnTypeCorrect = this.checkReturnedEntity(from.getModel(), returnType);
            } else {
                try {
                    Class javaResultType = selection.getJavaType();
                    if (javaResultType == null) {
                        returnTypeCorrect = true;
                    } else {
                        TypeElement typeElement = this.context.getTypeElementForFullyQualifiedName(javaResultType.getName());
                        Types types = this.context.getTypeUtils();
                        returnTypeCorrect = this.context.getTypeUtils().isAssignable(returnType, types.erasure(typeElement.asType()));
                    }
                }
                catch (Exception e) {
                    returnTypeCorrect = true;
                }
            }
            if (!returnTypeCorrect) {
                this.message(method, mirror, value, "return type of query did not match return type '" + returnType + "' of method", Diagnostic.Kind.ERROR);
            }
        }
    }

    private void validateSql(final @UnknownKeyFor @NonNull @Initialized ExecutableElement method, final @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized String sql, final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, final @UnknownKeyFor @NonNull @Initialized AnnotationValue value) {
        ParameterParser.parse((String)sql, (ParameterRecognizer)new ParameterRecognizer(){
            int ordinalCount = 0;

            public void ordinalParameter(int sourcePosition) {
                ++this.ordinalCount;
                if (this.ordinalCount > paramNames.size()) {
                    AnnotationMetaEntity.this.message(method, mirror, value, "missing method parameter for query parameter " + this.ordinalCount + " (add a parameter to '" + method.getSimpleName() + "')", Diagnostic.Kind.ERROR);
                }
            }

            public void namedParameter(String name, int sourcePosition) {
                if (!paramNames.contains(name)) {
                    AnnotationMetaEntity.this.message(method, mirror, value, "missing method parameter for query parameter :" + name + " (add a parameter '" + name + "' to '" + method.getSimpleName() + "')", Diagnostic.Kind.ERROR);
                }
            }

            public void jpaPositionalParameter(int label, int sourcePosition) {
                if (label > paramNames.size()) {
                    AnnotationMetaEntity.this.message(method, mirror, value, "missing method parameter for query parameter ?" + label + " (add a parameter to '" + method.getSimpleName() + "')", Diagnostic.Kind.ERROR);
                }
            }

            public void other(char character) {
            }
        });
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean checkConstructorReturn(@UnknownKeyFor @NonNull @Initialized DeclaredType returnType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized JpaSelection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> selection) {
        List selectionItems = selection.getSelectionItems();
        if (selectionItems == null) {
            return true;
        }
        TypeElement typeElement = (TypeElement)returnType.asElement();
        Name qualifiedName = typeElement.getQualifiedName();
        if (qualifiedName.contentEquals("jakarta.persistence.Tuple") || qualifiedName.contentEquals("java.util.List") || qualifiedName.contentEquals("java.util.Map")) {
            return true;
        }
        for (Element element : typeElement.getEnclosedElements()) {
            ExecutableElement constructor;
            if (element.getKind() != ElementKind.CONSTRUCTOR || !AnnotationMetaEntity.constructorMatches(selectionItems, (constructor = (ExecutableElement)element).getParameters())) continue;
            return true;
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean constructorMatches(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized JpaSelection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> selectionItems, @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized VariableElement> parameters) {
        int itemCount = selectionItems.size();
        if (parameters.size() == itemCount) {
            for (int i = 0; i < itemCount; ++i) {
                JpaSelection<?> item = selectionItems.get(i);
                if (item == null || item.getJavaType() == null || AnnotationMetaEntity.parameterMatches(parameters.get(i), item)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean parameterMatches(@UnknownKeyFor @NonNull @Initialized VariableElement parameter, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized JpaSelection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> item) {
        Class javaType = item.getJavaType();
        return javaType != null && AnnotationMetaEntity.parameterMatches(parameter.asType(), javaType);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean parameterMatches(@UnknownKeyFor @NonNull @Initialized TypeMirror parameterType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> itemType) {
        TypeKind kind = parameterType.getKind();
        String itemTypeName = itemType.getName();
        if (kind == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)parameterType;
            TypeElement paramTypeElement = (TypeElement)declaredType.asElement();
            return paramTypeElement.getQualifiedName().contentEquals(itemTypeName);
        }
        if (kind.isPrimitive()) {
            return TypeUtils.primitiveClassMatchesKind(itemType, kind);
        }
        if (kind == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)parameterType;
            return itemType.isArray() && AnnotationMetaEntity.parameterMatches(arrayType.getComponentType(), itemType.getComponentType());
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean checkReturnedArrayType(@UnknownKeyFor @NonNull @Initialized ArrayType returnType) {
        TypeMirror componentType = returnType.getComponentType();
        if (componentType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)componentType;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            return typeElement.getQualifiedName().contentEquals("java.lang.Object");
        }
        return false;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean checkReturnedEntity(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized EntityDomainType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> model, @UnknownKeyFor @NonNull @Initialized TypeMirror returnType) {
        DeclaredType declaredType;
        TypeElement typeElement;
        AnnotationMirror mirror;
        if (returnType.getKind() == TypeKind.DECLARED && (mirror = TypeUtils.getAnnotationMirror(typeElement = (TypeElement)(declaredType = (DeclaredType)returnType).asElement(), "jakarta.persistence.Entity")) != null) {
            String entityName = AnnotationMetaEntity.entityName(declaredType, mirror);
            return model.getHibernateEntityName().equals(entityName);
        }
        return false;
    }

    private void checkParameter(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SqmParameter<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> param, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value) {
        String queryParamType;
        SqmExpressible expressible = param.getExpressible();
        String string = queryParamType = expressible == null ? null : expressible.getTypeName();
        if (queryParamType != null && !"unknown".equals(queryParamType)) {
            if (param.getName() != null) {
                this.checkNamedParameter(param, paramNames, paramTypes, method, mirror, value, queryParamType);
            } else if (param.getPosition() != null) {
                this.checkOrdinalParameter(param, paramNames, paramTypes, method, mirror, value, queryParamType);
            }
        }
    }

    private void checkOrdinalParameter(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SqmParameter<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> param, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value, @UnknownKeyFor @NonNull @Initialized String queryParamType) {
        int position = param.getPosition();
        if (position > paramNames.size()) {
            this.message(method, mirror, value, "missing method parameter for query parameter ?" + position + " (add a parameter of type '" + queryParamType + "' to '" + method.getSimpleName() + "')", Diagnostic.Kind.ERROR);
        } else {
            String argType = paramTypes.get(position - 1);
            if (!AnnotationMetaEntity.isLegalAssignment(param, argType, queryParamType)) {
                this.message(method, mirror, value, "parameter matching query parameter ?" + position + " has the wrong type (change the method parameter type to '" + queryParamType + "')", Diagnostic.Kind.ERROR);
            }
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized String stripTypeAnnotations(@UnknownKeyFor @NonNull @Initialized String argType) {
        while (argType.startsWith("@")) {
            int index = argType.indexOf(32);
            if (index <= 0) continue;
            argType = argType.substring(index + 1);
        }
        return argType;
    }

    private void checkNamedParameter(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SqmParameter<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> param, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value, @UnknownKeyFor @NonNull @Initialized String queryParamType) {
        String name = param.getName();
        int index = paramNames.indexOf(name);
        if (index < 0) {
            this.message(method, mirror, value, "missing method parameter for query parameter :" + name + " (add a parameter '" + queryParamType + " " + name + "' to '" + method.getSimpleName() + "')", Diagnostic.Kind.ERROR);
        } else {
            String argType = paramTypes.get(index);
            if (!AnnotationMetaEntity.isLegalAssignment(param, argType, queryParamType)) {
                this.message(method, mirror, value, "parameter matching query parameter :" + name + " has the wrong type (change the method parameter type to '" + queryParamType + "')", Diagnostic.Kind.ERROR);
            }
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isLegalAssignment(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SqmParameter<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> param, @UnknownKeyFor @NonNull @Initialized String argumentType, @UnknownKeyFor @NonNull @Initialized String queryParamType) {
        String argType = AnnotationMetaEntity.stripTypeAnnotations(argumentType);
        return param.allowMultiValuedBinding() ? AnnotationMetaEntity.isLegalAssignment(argType, "java.util.List<" + queryParamType + ">") || AnnotationMetaEntity.isLegalAssignment(argType, "java.util.Set<" + queryParamType + ">") || AnnotationMetaEntity.isLegalAssignment(argType, "java.util.Collection<" + queryParamType + ">") : AnnotationMetaEntity.isLegalAssignment(argType, queryParamType);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isLegalAssignment(@UnknownKeyFor @NonNull @Initialized String argType, @UnknownKeyFor @NonNull @Initialized String paramType) {
        return paramType.equals(argType) || paramType.equals(AnnotationMetaEntity.fromPrimitive(argType));
    }

    private static @Nullable @UnknownKeyFor @Initialized String fromPrimitive(@UnknownKeyFor @NonNull @Initialized String argType) {
        switch (argType) {
            case "boolean": {
                return Boolean.class.getName();
            }
            case "char": {
                return Character.class.getName();
            }
            case "int": {
                return Integer.class.getName();
            }
            case "long": {
                return Long.class.getName();
            }
            case "short": {
                return Short.class.getName();
            }
            case "byte": {
                return Byte.class.getName();
            }
            case "float": {
                return Float.class.getName();
            }
            case "double": {
                return Double.class.getName();
            }
        }
        return null;
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> parameterNullability(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized TypeElement entity) {
        return method.getParameters().stream().map(param -> this.finderParameterNullable(entity, (VariableElement)param)).collect(Collectors.toList());
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> parameterTypes(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        return method.getParameters().stream().map(param -> this.typeAsString(this.parameterType((VariableElement)param))).collect(Collectors.toList());
    }

    private @UnknownKeyFor @NonNull @Initialized String typeAsString(@UnknownKeyFor @NonNull @Initialized TypeMirror type) {
        Object result = type.toString();
        for (AnnotationMirror annotationMirror : type.getAnnotationMirrors()) {
            String annotationString = annotationMirror.toString();
            result = ((String)result).replace(annotationString + " ", "").replace(annotationString, "");
        }
        for (AnnotationMirror annotationMirror : type.getAnnotationMirrors()) {
            result = annotationMirror.toString() + " " + (String)result;
        }
        return result;
    }

    private @UnknownKeyFor @NonNull @Initialized TypeMirror parameterType(@UnknownKeyFor @NonNull @Initialized VariableElement parameter) {
        ExecutableElement method = (ExecutableElement)parameter.getEnclosingElement();
        TypeMirror type = this.memberMethodType(method).getParameterTypes().get(method.getParameters().indexOf(parameter));
        switch (type.getKind()) {
            case TYPEVAR: {
                TypeVariable typeVariable = (TypeVariable)type;
                return this.context.getTypeUtils().erasure(typeVariable);
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)type;
                return declaredType.getTypeArguments().stream().anyMatch(arg -> arg.getKind() == TypeKind.TYPEVAR) ? this.context.getTypeUtils().erasure(type) : type;
            }
        }
        return type;
    }

    private @UnknownKeyFor @NonNull @Initialized ExecutableType memberMethodType(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        return (ExecutableType)this.context.getTypeUtils().asMemberOf((DeclaredType)this.element.asType(), method);
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> parameterPatterns(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        return method.getParameters().stream().map(param -> TypeUtils.hasAnnotation((Element)param, "org.hibernate.annotations.processing.Pattern")).collect(Collectors.toList());
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> parameterNames(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized TypeElement entity) {
        String idName = entity.getEnclosedElements().stream().filter(member -> TypeUtils.hasAnnotation(member, "jakarta.persistence.Id")).map(member -> TypeUtils.propertyName(this, member)).findFirst().orElse("id");
        return method.getParameters().stream().map(AnnotationMetaEntity::parameterName).map(name -> AnnotationMetaEntity.isIdRef(name) ? idName : name).collect(Collectors.toList());
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> parameterNames(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        return method.getParameters().stream().map(AnnotationMetaEntity::parameterName).collect(Collectors.toList());
    }

    private static @UnknownKeyFor @NonNull @Initialized String parameterName(@UnknownKeyFor @NonNull @Initialized VariableElement parameter) {
        AnnotationMirror by = TypeUtils.getAnnotationMirror(parameter, "jakarta.data.repository.By");
        AnnotationMirror param = TypeUtils.getAnnotationMirror(parameter, "jakarta.data.repository.Param");
        if (by != null) {
            String name = NullnessUtil.castNonNull(TypeUtils.getAnnotationValue(by, "value")).getValue().toString();
            if (name.contains("<error>")) {
                throw new ProcessLaterException();
            }
            return name.replace('$', '.').replace('_', '.');
        }
        if (param != null) {
            String name = NullnessUtil.castNonNull(TypeUtils.getAnnotationValue(param, "value")).getValue().toString();
            if (name.contains("<error>")) {
                throw new ProcessLaterException();
            }
            return name;
        }
        return parameter.getSimpleName().toString().replace('$', '.').replace('_', '.');
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isNullable(@UnknownKeyFor @NonNull @Initialized Element member) {
        switch (member.getKind()) {
            case METHOD: {
                ExecutableElement method = (ExecutableElement)member;
                if (method.getReturnType().getKind().isPrimitive()) {
                    return false;
                }
            }
            case FIELD: 
            case PARAMETER: {
                if (!member.asType().getKind().isPrimitive()) break;
                return false;
            }
        }
        for (AnnotationMirror annotationMirror : member.getAnnotationMirrors()) {
            AnnotationValue optional;
            TypeElement annotationType = (TypeElement)annotationMirror.getAnnotationType().asElement();
            Name name = annotationType.getQualifiedName();
            if (name.contentEquals("jakarta.persistence.Id") || name.contentEquals("jakarta.validation.constraints.NotNull") || name.contentEquals("jakarta.annotation.Nonnull")) {
                return false;
            }
            if (!name.contentEquals("jakarta.persistence.Basic") && !name.contentEquals("jakarta.persistence.ManyToOne") && !name.contentEquals("jakarta.persistence.OneToOne") || (optional = TypeUtils.getAnnotationValue(annotationMirror, "optional")) == null || !optional.getValue().equals(Boolean.FALSE)) continue;
            return false;
        }
        return true;
    }

    private void checkParameters(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value, @UnknownKeyFor @NonNull @Initialized String hql) {
        for (int i = 1; i <= paramNames.size(); ++i) {
            String type;
            String string = paramNames.get(i - 1);
            if (!AnnotationMetaEntity.parameterIsMissing(hql, i, string, type = paramTypes.get(i - 1))) continue;
            this.message(method, mirror, value, "missing query parameter for '" + string + "' (no parameter named :" + string + " or ?" + i + ")", Diagnostic.Kind.ERROR);
        }
        if (returnType != null) {
            for (VariableElement variableElement : method.getParameters()) {
                TypeElement entity = this.implicitEntityType(returnType);
                if (entity == null) continue;
                this.checkFinderParameter(entity, variableElement);
            }
        }
    }

    private @Nullable @UnknownKeyFor @Initialized TypeElement implicitEntityType(@Nullable @UnknownKeyFor @Initialized TypeMirror resultType) {
        DeclaredType declaredType;
        Element typeElement;
        if (resultType != null && resultType.getKind() == TypeKind.DECLARED && TypeUtils.hasAnnotation(typeElement = (declaredType = (DeclaredType)resultType).asElement(), "jakarta.persistence.Entity")) {
            return (TypeElement)typeElement;
        }
        return this.primaryEntity;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean typeNameEquals(@UnknownKeyFor @NonNull @Initialized TypeMirror parameterType, @UnknownKeyFor @NonNull @Initialized String typeName) {
        if (parameterType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)parameterType;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            return typeElement.getQualifiedName().contentEquals(typeName);
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean typeNameEqualsArray(@UnknownKeyFor @NonNull @Initialized TypeMirror parameterType, @UnknownKeyFor @NonNull @Initialized String typeName) {
        if (parameterType.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)parameterType;
            return AnnotationMetaEntity.typeNameEquals(arrayType.getComponentType(), typeName);
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized String typeName(@UnknownKeyFor @NonNull @Initialized TypeMirror parameterType) {
        if (parameterType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)parameterType;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            return typeElement.getQualifiedName().toString();
        }
        return parameterType.toString();
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean parameterIsMissing(@UnknownKeyFor @NonNull @Initialized String hql, @UnknownKeyFor @NonNull @Initialized int i, @UnknownKeyFor @NonNull @Initialized String param, @UnknownKeyFor @NonNull @Initialized String type) {
        return !AnnotationMetaEntity.hasParameter(hql, i, param) && !AbstractQueryMethod.isSpecialParam(type);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean hasParameter(@UnknownKeyFor @NonNull @Initialized String hql, @UnknownKeyFor @NonNull @Initialized int i, @UnknownKeyFor @NonNull @Initialized String param) {
        return Pattern.compile(".*(:" + param + "|\\?" + i + ")\\b.*", 32).matcher(hql).matches();
    }

    static @UnknownKeyFor @NonNull @Initialized boolean usingReactiveSession(@UnknownKeyFor @NonNull @Initialized String sessionType) {
        return "org.hibernate.reactive.mutiny.Mutiny.Session".equals(sessionType) || "org.hibernate.reactive.mutiny.Mutiny.StatelessSession".equals(sessionType) || "io.smallrye.mutiny.Uni<org.hibernate.reactive.mutiny.Mutiny.Session>".equals(sessionType) || "io.smallrye.mutiny.Uni<org.hibernate.reactive.mutiny.Mutiny.StatelessSession>".equals(sessionType);
    }

    static @UnknownKeyFor @NonNull @Initialized boolean usingStatelessSession(@UnknownKeyFor @NonNull @Initialized String sessionType) {
        return "org.hibernate.StatelessSession".equals(sessionType) || "org.hibernate.reactive.mutiny.Mutiny.StatelessSession".equals(sessionType) || "io.smallrye.mutiny.Uni<org.hibernate.reactive.mutiny.Mutiny.StatelessSession>".equals(sessionType);
    }

    static @UnknownKeyFor @NonNull @Initialized boolean usingReactiveSessionAccess(@UnknownKeyFor @NonNull @Initialized String sessionType) {
        return "io.smallrye.mutiny.Uni<org.hibernate.reactive.mutiny.Mutiny.Session>".equals(sessionType) || "io.smallrye.mutiny.Uni<org.hibernate.reactive.mutiny.Mutiny.StatelessSession>".equals(sessionType);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isLocal(@UnknownKeyFor @NonNull @Initialized Element methodOrParam) {
        switch (methodOrParam.getKind()) {
            case PARAMETER: {
                return this.element.getEnclosedElements().contains(methodOrParam.getEnclosingElement());
            }
            case METHOD: 
            case FIELD: {
                return this.element.getEnclosedElements().contains(methodOrParam);
            }
        }
        return true;
    }

    public void message(@UnknownKeyFor @NonNull @Initialized Element method, @UnknownKeyFor @NonNull @Initialized String message,  @UnknownKeyFor @NonNull @Initialized Diagnostic.Kind severity) {
        if (this.isLocal(method)) {
            this.context.message(method, message, severity);
        } else {
            this.context.message(this.element, AnnotationMetaEntity.messageWithLocation(method, message), severity);
        }
    }

    public void message(@UnknownKeyFor @NonNull @Initialized Element method, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized String message,  @UnknownKeyFor @NonNull @Initialized Diagnostic.Kind severity) {
        if (this.isLocal(method)) {
            this.context.message(method, mirror, message, severity);
        } else {
            this.context.message(this.element, AnnotationMetaEntity.messageWithLocation(method, message), severity);
        }
    }

    public void message(@UnknownKeyFor @NonNull @Initialized Element method, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value, @UnknownKeyFor @NonNull @Initialized String message,  @UnknownKeyFor @NonNull @Initialized Diagnostic.Kind severity) {
        if (this.isLocal(method)) {
            this.context.message(method, mirror, value, message, severity);
        } else {
            this.context.message(this.element, AnnotationMetaEntity.messageWithLocation(method, message), severity);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized String messageWithLocation(@UnknownKeyFor @NonNull @Initialized Element element, @UnknownKeyFor @NonNull @Initialized String message) {
        return element.getKind() == ElementKind.PARAMETER ? message + " for parameter '" + element.getSimpleName() + "' of inherited member '" + element.getEnclosingElement().getSimpleName() + "'" : message + " for inherited member '" + element.getSimpleName() + "'";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AnnotationMirror> inheritedAnnotations() {
        if (this.jakartaDataRepository) {
            return this.element.getAnnotationMirrors().stream().filter(annotationMirror -> TypeUtils.hasAnnotation(annotationMirror.getAnnotationType().asElement(), "jakarta.interceptor.InterceptorBinding")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    static enum FieldType {
        ID,
        NATURAL_ID,
        BASIC,
        MULTIVALUED;

    }
}

