/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.proxool.internal;

import org.hibernate.internal.log.ConnectionInfoLogger;
import org.hibernate.internal.log.SubSystemLogging;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@SubSystemLogging(name="org.hibernate.orm.connections.pooling.proxool", description="Logs details related to Proxool connection pooling")
@MessageLogger(projectCode="HHH")
@ValidIdRange(min=30001, max=35000)
public interface ProxoolMessageLogger
extends ConnectionInfoLogger {
    public static final String LOGGER_NAME = "org.hibernate.orm.connections.pooling.proxool";
    public static final ProxoolMessageLogger PROXOOL_MESSAGE_LOGGER = (ProxoolMessageLogger)Logger.getMessageLogger(ProxoolMessageLogger.class, (String)"org.hibernate.orm.connections.pooling.proxool");

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Configuring Proxool Provider to use pool alias: %s", id=30002)
    public void configuringProxoolProviderToUsePoolAlias(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Configuring Proxool Provider using existing pool in memory: %s", id=30003)
    public void configuringProxoolProviderUsingExistingPool(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Configuring Proxool Provider using JAXPConfigurator: %s", id=30004)
    public void configuringProxoolProviderUsingJaxpConfigurator(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Configuring Proxool Provider using Properties File: %s", id=30005)
    public void configuringProxoolProviderUsingPropertiesFile(String var1);
}

