/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.hibernate.Incubating;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;

@Incubating
public class AffectedEntities {
    private static final Class<?>[] NO_ENTITIES = new Class[0];
    private static final String[] NO_TABLES = new String[0];
    private final String[] queryTables;
    private final Class<?>[] queryEntities;

    public AffectedEntities(Class<?> ... queryEntities) {
        this.queryTables = NO_TABLES;
        this.queryEntities = queryEntities;
    }

    public AffectedEntities(String ... queryTables) {
        this.queryTables = queryTables;
        this.queryEntities = NO_ENTITIES;
    }

    public String[] getAffectedTables() {
        return this.queryTables;
    }

    public Class<?>[] getAffectedEntities() {
        return this.queryEntities;
    }

    public String[] getAffectedSpaces(SessionFactoryImplementor factory) {
        ArrayList<String> spaces = new ArrayList<String>();
        for (String table : this.getAffectedTables()) {
            spaces.add(table);
        }
        for (Class<?> entity : this.getAffectedEntities()) {
            Serializable[] querySpaces = factory.getMetamodel().entityPersister((Class)entity).getQuerySpaces();
            spaces.addAll(Arrays.asList((String[])querySpaces));
        }
        return spaces.toArray(ArrayHelper.EMPTY_STRING_ARRAY);
    }
}

