/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.CollectionAction;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostCollectionUpdateEvent;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PreCollectionUpdateEvent;
import org.hibernate.event.spi.PreCollectionUpdateEventListener;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.engine.ReactiveExecutable;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.persister.collection.impl.ReactiveCollectionPersister;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.stat.spi.StatisticsImplementor;

public class ReactiveCollectionUpdateAction
extends CollectionAction
implements ReactiveExecutable {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final boolean emptySnapshot;

    public ReactiveCollectionUpdateAction(PersistentCollection collection, CollectionPersister persister, Object key, boolean emptySnapshot, EventSource session) {
        super(persister, collection, key, session);
        this.emptySnapshot = emptySnapshot;
    }

    @Override
    public CompletionStage<Void> reactiveExecute() {
        CompletionStage<Void> updateStage;
        Object key = this.getKey();
        EventSource session = this.getSession();
        ReactiveCollectionPersister reactivePersister = (ReactiveCollectionPersister)this.getPersister();
        CollectionPersister persister = this.getPersister();
        PersistentCollection collection = this.getCollection();
        boolean affectedByFilters = persister.isAffectedByEnabledFilters((SharedSessionContractImplementor)session);
        this.preUpdate();
        if (!collection.wasInitialized()) {
            if (!collection.isDirty()) {
                throw new AssertionFailure("collection is not dirty");
            }
            updateStage = CompletionStages.voidFuture();
        } else if (!affectedByFilters && collection.empty()) {
            updateStage = this.emptySnapshot ? CompletionStages.voidFuture() : reactivePersister.reactiveRemove(key, (SharedSessionContractImplementor)session);
        } else if (collection.needsRecreate(persister)) {
            if (affectedByFilters) {
                throw LOG.cannotRecreateCollectionWhileFilterIsEnabled(MessageHelper.collectionInfoString((CollectionPersister)persister, (PersistentCollection)collection, (Object)key, (SharedSessionContractImplementor)session));
            }
            updateStage = this.emptySnapshot ? reactivePersister.reactiveRecreate(collection, key, (SharedSessionContractImplementor)session) : reactivePersister.reactiveRemove(key, (SharedSessionContractImplementor)session).thenCompose(arg_0 -> ReactiveCollectionUpdateAction.lambda$reactiveExecute$0(reactivePersister, collection, key, (SharedSessionContractImplementor)session, arg_0));
        } else {
            updateStage = CompletionStages.voidFuture().thenCompose(arg_0 -> ReactiveCollectionUpdateAction.lambda$reactiveExecute$1(reactivePersister, collection, key, (SharedSessionContractImplementor)session, arg_0)).thenCompose(arg_0 -> ReactiveCollectionUpdateAction.lambda$reactiveExecute$2(reactivePersister, collection, key, (SharedSessionContractImplementor)session, arg_0)).thenCompose(arg_0 -> ReactiveCollectionUpdateAction.lambda$reactiveExecute$3(reactivePersister, collection, key, (SharedSessionContractImplementor)session, arg_0));
        }
        return updateStage.thenAccept(arg_0 -> this.lambda$reactiveExecute$4((SharedSessionContractImplementor)session, collection, persister, arg_0));
    }

    public void execute() throws HibernateException {
        throw new UnsupportedOperationException("Use reactiveExecute() instead");
    }

    private void preUpdate() {
        this.getFastSessionServices().eventListenerGroup_PRE_COLLECTION_UPDATE.fireLazyEventOnEachListener(this::newPreCollectionUpdateEvent, PreCollectionUpdateEventListener::onPreUpdateCollection);
    }

    private PreCollectionUpdateEvent newPreCollectionUpdateEvent() {
        return new PreCollectionUpdateEvent(this.getPersister(), this.getCollection(), this.eventSource());
    }

    private void postUpdate() {
        this.getFastSessionServices().eventListenerGroup_POST_COLLECTION_UPDATE.fireLazyEventOnEachListener(this::newPostCollectionUpdateEvent, PostCollectionUpdateEventListener::onPostUpdateCollection);
    }

    private PostCollectionUpdateEvent newPostCollectionUpdateEvent() {
        return new PostCollectionUpdateEvent(this.getPersister(), this.getCollection(), this.eventSource());
    }

    private /* synthetic */ void lambda$reactiveExecute$4(SharedSessionContractImplementor session, PersistentCollection collection, CollectionPersister persister, Void v) {
        session.getPersistenceContextInternal().getCollectionEntry(collection).afterAction(collection);
        this.evict();
        this.postUpdate();
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        if (statistics.isStatisticsEnabled()) {
            statistics.updateCollection(persister.getRole());
        }
    }

    private static /* synthetic */ CompletionStage lambda$reactiveExecute$3(ReactiveCollectionPersister reactivePersister, PersistentCollection collection, Object key, SharedSessionContractImplementor session, Void v) {
        return reactivePersister.reactiveInsertRows(collection, key, session);
    }

    private static /* synthetic */ CompletionStage lambda$reactiveExecute$2(ReactiveCollectionPersister reactivePersister, PersistentCollection collection, Object key, SharedSessionContractImplementor session, Void v) {
        return reactivePersister.reactiveUpdateRows(collection, key, session);
    }

    private static /* synthetic */ CompletionStage lambda$reactiveExecute$1(ReactiveCollectionPersister reactivePersister, PersistentCollection collection, Object key, SharedSessionContractImplementor session, Void v) {
        return reactivePersister.reactiveDeleteRows(collection, key, session);
    }

    private static /* synthetic */ CompletionStage lambda$reactiveExecute$0(ReactiveCollectionPersister reactivePersister, PersistentCollection collection, Object key, SharedSessionContractImplementor session, Void v) {
        return reactivePersister.reactiveRecreate(collection, key, session);
    }
}

