/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.jdbc.env.internal;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.OperationResultChecker;
import org.hibernate.engine.jdbc.mutation.TableInclusionChecker;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.reactive.adaptor.impl.PrepareStatementDetailsAdaptor;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.engine.jdbc.ResultsCheckerUtil;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ValuesAnalysis;

public interface ReactiveMutationExecutor
extends MutationExecutor {
    public static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    default public Object execute(Object modelReference, ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        throw LOG.nonReactiveMethodCall("executeReactive");
    }

    default public CompletionStage<Object> executeReactive(Object modelReference, ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        return this.performReactiveNonBatchedOperations(valuesAnalysis, inclusionChecker, resultChecker, session).thenCompose(ignore -> this.performReactiveSelfExecutingOperations(valuesAnalysis, inclusionChecker, session)).thenCompose(ignore -> this.performReactiveBatchedOperations(valuesAnalysis, inclusionChecker, resultChecker, session)).thenApply(CompletionStages::nullFuture);
    }

    default public CompletionStage<Void> performReactiveNonBatchedOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        return CompletionStages.voidFuture();
    }

    default public CompletionStage<Void> performReactiveSelfExecutingOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, SharedSessionContractImplementor session) {
        return CompletionStages.voidFuture();
    }

    default public CompletionStage<Void> performReactiveBatchedOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        return CompletionStages.voidFuture();
    }

    default public CompletionStage<Void> performReactiveNonBatchedMutation(PreparedStatementDetails statementDetails, JdbcValueBindings valueBindings, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        if (statementDetails == null) {
            return CompletionStages.voidFuture();
        }
        TableMapping tableDetails = statementDetails.getMutatingTableDetails();
        if (inclusionChecker != null && !inclusionChecker.include(tableDetails)) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isTraceEnabled()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Skipping execution of secondary insert : %s", (Object)tableDetails.getTableName());
            }
            return CompletionStages.voidFuture();
        }
        Object[] params = PreparedStatementAdaptor.bind(statement -> {
            PrepareStatementDetailsAdaptor details = new PrepareStatementDetailsAdaptor(statementDetails, statement, session.getJdbcServices());
            valueBindings.beforeStatement((PreparedStatementDetails)details);
        });
        ReactiveConnection reactiveConnection = ((ReactiveConnectionSupplier)session).getReactiveConnection();
        String sqlString = statementDetails.getSqlString();
        return reactiveConnection.update(sqlString, params).thenCompose(affectedRowCount -> {
            if (affectedRowCount == 0 && tableDetails.isOptional()) {
                return CompletionStages.voidFuture();
            }
            ResultsCheckerUtil.checkResults(session, statementDetails, resultChecker, affectedRowCount, -1);
            return CompletionStages.voidFuture();
        }).whenComplete((o, throwable) -> {
            if (statementDetails.getStatement() != null) {
                statementDetails.releaseStatement(session);
            }
            valueBindings.afterStatement(tableDetails);
        });
    }
}

