/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.event.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.entry.CollectionCacheEntry;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.InitializeCollectionEvent;
import org.hibernate.event.spi.InitializeCollectionEventListener;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.persister.collection.impl.ReactiveCollectionPersister;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.results.internal.ResultsHelper;
import org.hibernate.stat.spi.StatisticsImplementor;

public class DefaultReactiveInitializeCollectionEventListener
implements InitializeCollectionEventListener {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public void onInitializeCollection(InitializeCollectionEvent event) throws HibernateException {
        throw LOG.nonReactiveMethodCall("onReactiveInitializeCollection(InitializeCollectionEvent)");
    }

    public CompletionStage<Void> onReactiveInitializeCollection(InitializeCollectionEvent event) throws HibernateException {
        boolean foundInCache;
        PersistentCollection collection = event.getCollection();
        EventSource source = event.getSession();
        CollectionEntry ce = source.getPersistenceContextInternal().getCollectionEntry(collection);
        if (ce == null) {
            throw LOG.collectionWasEvicted();
        }
        if (collection.wasInitialized()) {
            return CompletionStages.voidFuture();
        }
        CollectionPersister loadedPersister = ce.getLoadedPersister();
        Object loadedKey = ce.getLoadedKey();
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Initializing collection {0}", MessageHelper.collectionInfoString((CollectionPersister)loadedPersister, (PersistentCollection)collection, (Object)loadedKey, (SharedSessionContractImplementor)source));
            LOG.trace("Checking second-level cache");
        }
        if (foundInCache = this.initializeCollectionFromCache(loadedKey, loadedPersister, collection, (SessionImplementor)source)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Collection initialized from cache");
            }
            return CompletionStages.voidFuture();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Collection not cached");
        }
        return ((ReactiveCollectionPersister)loadedPersister).reactiveInitialize(loadedKey, (SharedSessionContractImplementor)source).thenApply(arg_0 -> this.lambda$onReactiveInitializeCollection$0(collection, (SessionImplementor)source, ce, loadedPersister, arg_0)).thenAccept(arg_0 -> DefaultReactiveInitializeCollectionEventListener.lambda$onReactiveInitializeCollection$1((SessionImplementor)source, loadedPersister, arg_0));
    }

    private void handlePotentiallyEmptyCollection(PersistentCollection<?> collection, SessionImplementor source, CollectionEntry ce, CollectionPersister loadedPersister) {
        if (!collection.wasInitialized()) {
            collection.initializeEmptyCollection(loadedPersister);
            ResultsHelper.finalizeCollectionLoading((PersistenceContext)source.getPersistenceContext(), (CollectionPersister)loadedPersister, collection, (Object)ce.getLoadedKey(), (boolean)true);
        }
    }

    private boolean initializeCollectionFromCache(Object id, CollectionPersister persister, PersistentCollection<?> collection, SessionImplementor source) {
        boolean useCache;
        if (source.getLoadQueryInfluencers().hasEnabledFilters() && persister.isAffectedByEnabledFilters((SharedSessionContractImplementor)source)) {
            LOG.trace("Disregarding cached version (if any) of collection due to enabled filters");
            return false;
        }
        boolean bl = useCache = persister.hasCache() && source.getCacheMode().isGetEnabled();
        if (!useCache) {
            return false;
        }
        SessionFactoryImplementor factory = source.getFactory();
        CollectionDataAccess cacheAccessStrategy = persister.getCacheAccessStrategy();
        Object ck = cacheAccessStrategy.generateCacheKey(id, persister, factory, source.getTenantIdentifier());
        Object ce = CacheHelper.fromSharedCache((SharedSessionContractImplementor)source, (Object)ck, (CachedDomainDataAccess)cacheAccessStrategy);
        StatisticsImplementor statistics = factory.getStatistics();
        if (statistics.isStatisticsEnabled()) {
            if (ce == null) {
                statistics.collectionCacheMiss(persister.getNavigableRole(), cacheAccessStrategy.getRegion().getName());
            } else {
                statistics.collectionCacheHit(persister.getNavigableRole(), cacheAccessStrategy.getRegion().getName());
            }
        }
        if (ce == null) {
            return false;
        }
        CollectionCacheEntry cacheEntry = (CollectionCacheEntry)persister.getCacheEntryStructure().destructure(ce, factory);
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        cacheEntry.assemble(collection, persister, persistenceContext.getCollectionOwner(id, persister));
        persistenceContext.getCollectionEntry(collection).postInitialize(collection);
        return true;
    }

    private static /* synthetic */ void lambda$onReactiveInitializeCollection$1(SessionImplementor source, CollectionPersister loadedPersister, Void list) {
        StatisticsImplementor statistics;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Collection initialized");
        }
        if ((statistics = source.getFactory().getStatistics()).isStatisticsEnabled()) {
            statistics.fetchCollection(loadedPersister.getRole());
        }
    }

    private /* synthetic */ Void lambda$onReactiveInitializeCollection$0(PersistentCollection collection, SessionImplementor source, CollectionEntry ce, CollectionPersister loadedPersister, Void list) {
        this.handlePotentiallyEmptyCollection(collection, source, ce, loadedPersister);
        return list;
    }
}

