/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.event.impl;

import org.hibernate.AssertionFailure;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.jpa.event.spi.CallbackRegistry;
import org.hibernate.jpa.event.spi.CallbackRegistryConsumer;
import org.hibernate.reactive.engine.ReactiveActionQueue;
import org.hibernate.reactive.engine.impl.ReactiveEntityIncrementVersionProcess;
import org.hibernate.reactive.engine.impl.ReactiveEntityVerifyVersionProcess;
import org.hibernate.reactive.session.ReactiveSession;

public class DefaultReactivePostLoadEventListener
implements PostLoadEventListener,
CallbackRegistryConsumer {
    private CallbackRegistry callbackRegistry;

    public void injectCallbackRegistry(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    public void onPostLoad(PostLoadEvent event) {
        Object entity = event.getEntity();
        this.callbackRegistry.postLoad(entity);
        EventSource session = event.getSession();
        EntityEntry entry = session.getPersistenceContextInternal().getEntry(entity);
        if (entry == null) {
            throw new AssertionFailure("possible non-threadsafe access to the session");
        }
        ReactiveActionQueue actionQueue = ((ReactiveSession)session).getReactiveActionQueue();
        switch (entry.getLockMode()) {
            case OPTIMISTIC_FORCE_INCREMENT: {
                actionQueue.registerProcess(new ReactiveEntityIncrementVersionProcess(entity));
                break;
            }
            case OPTIMISTIC: {
                actionQueue.registerProcess(new ReactiveEntityVerifyVersionProcess(entity));
            }
        }
    }
}

