/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.id.impl;

import java.lang.invoke.MethodHandles;
import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.Generator;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.SelectGenerator;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.SequenceStructure;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.id.enhanced.TableGenerator;
import org.hibernate.id.enhanced.TableStructure;
import org.hibernate.id.factory.internal.StandardIdentifierGeneratorFactory;
import org.hibernate.reactive.id.ReactiveIdentifierGenerator;
import org.hibernate.reactive.id.impl.EmulatedSequenceReactiveIdentifierGenerator;
import org.hibernate.reactive.id.impl.ReactiveGeneratorWrapper;
import org.hibernate.reactive.id.impl.ReactiveSequenceIdentifierGenerator;
import org.hibernate.reactive.id.impl.TableReactiveIdentifierGenerator;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;

public class ReactiveIdentifierGeneratorFactory
extends StandardIdentifierGeneratorFactory {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final ServiceRegistry serviceRegistry;

    public ReactiveIdentifierGeneratorFactory(ServiceRegistry serviceRegistry) {
        super(serviceRegistry);
        this.serviceRegistry = serviceRegistry;
    }

    public Generator createIdentifierGenerator(String strategy, Type type, Properties config) {
        Generator generator;
        try {
            generator = super.createIdentifierGenerator(strategy, type, config);
        }
        catch (MappingException ignored) {
            try {
                Class<? extends Generator> clazz = this.generatorClassForName(strategy);
                generator = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (generator instanceof Configurable) {
                    ((Configurable)generator).configure(type, config, this.serviceRegistry);
                }
            }
            catch (Exception e) {
                String entityName = config.getProperty("entity_name");
                throw new MappingException(String.format("Could not instantiate id generator [entity-name=%s]", entityName), (Throwable)e);
            }
        }
        if (generator instanceof BeforeExecutionGenerator) {
            return this.augmentWithReactiveGenerator((Generator)((BeforeExecutionGenerator)generator), type, config);
        }
        if (generator instanceof OnExecutionGenerator) {
            return this.augmentWithReactiveGenerator((Generator)((OnExecutionGenerator)generator), type, config);
        }
        if (generator instanceof ReactiveIdentifierGenerator) {
            return new ReactiveGeneratorWrapper((ReactiveIdentifierGenerator)generator);
        }
        String entityName = config.getProperty("entity_name");
        throw new MappingException(String.format("Not an id generator [entity-name=%s]", entityName));
    }

    public Class<? extends Generator> getIdentifierGeneratorClass(String strategy) {
        try {
            return super.getIdentifierGeneratorClass(strategy);
        }
        catch (MappingException ignored) {
            return this.generatorClassForName(strategy);
        }
    }

    protected Class<? extends Generator> generatorClassForName(String strategy) {
        try {
            return ((ClassLoaderService)this.serviceRegistry.getService(ClassLoaderService.class)).classForName(strategy);
        }
        catch (ClassLoadingException e) {
            throw new MappingException(String.format("Could not interpret id generator strategy [%s]", strategy));
        }
    }

    public Generator augmentWithReactiveGenerator(Generator generator, Type type, Properties params) {
        return ReactiveIdentifierGeneratorFactory.augmentWithReactiveGenerator(this.serviceRegistry, generator, type, params);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Generator augmentWithReactiveGenerator(ServiceRegistry serviceRegistry, Generator generator, Type type, Properties params) {
        void var4_9;
        String catalog;
        String schema;
        if (generator instanceof SequenceStyleGenerator) {
            DatabaseStructure structure = ((SequenceStyleGenerator)generator).getDatabaseStructure();
            if (structure instanceof TableStructure) {
                EmulatedSequenceReactiveIdentifierGenerator emulatedSequenceReactiveIdentifierGenerator = new EmulatedSequenceReactiveIdentifierGenerator();
            } else {
                if (!(structure instanceof SequenceStructure)) throw LOG.unknownStructureType();
                ReactiveSequenceIdentifierGenerator reactiveSequenceIdentifierGenerator = new ReactiveSequenceIdentifierGenerator();
            }
        } else if (generator instanceof TableGenerator) {
            TableReactiveIdentifierGenerator tableReactiveIdentifierGenerator = new TableReactiveIdentifierGenerator();
        } else {
            if (!(generator instanceof SelectGenerator)) return generator;
            throw LOG.selectGeneratorIsNotSupportedInHibernateReactive();
        }
        ConfigurationService cs = (ConfigurationService)serviceRegistry.getService(ConfigurationService.class);
        if (!params.containsKey("schema") && (schema = (String)cs.getSetting("hibernate.default_schema", StandardConverters.STRING)) != null) {
            params.put("schema", schema);
        }
        if (!params.containsKey("catalog") && (catalog = (String)cs.getSetting("hibernate.default_catalog", StandardConverters.STRING)) != null) {
            params.put("catalog", catalog);
        }
        ((Configurable)var4_9).configure(type, params, serviceRegistry);
        return new ReactiveGeneratorWrapper((ReactiveIdentifierGenerator<?>)var4_9, (IdentifierGenerator)generator);
    }
}

