/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.id.insert;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import org.hibernate.dialect.CockroachDialect;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.Binder;
import org.hibernate.reactive.adaptor.impl.PrepareStatementDetailsAdaptor;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.id.insert.ReactiveInsertGeneratedIdentifierDelegate;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.type.Type;

public interface ReactiveAbstractReturningDelegate
extends ReactiveInsertGeneratedIdentifierDelegate {
    public static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public PostInsertIdentityPersister getPersister();

    @Override
    default public CompletionStage<Object> reactivePerformInsert(PreparedStatementDetails insertStatementDetails, JdbcValueBindings jdbcValueBindings, Object entity, SharedSessionContractImplementor session) {
        Class idType = this.getPersister().getIdentifierType().getReturnedClass();
        JdbcServices jdbcServices = session.getJdbcServices();
        String identifierColumnName = this.getPersister().getIdentifierColumnNames()[0];
        String insertSql = ReactiveAbstractReturningDelegate.createInsert(insertStatementDetails, identifierColumnName, jdbcServices.getDialect());
        Object[] params = PreparedStatementAdaptor.bind(statement -> {
            PrepareStatementDetailsAdaptor details = new PrepareStatementDetailsAdaptor(insertStatementDetails, statement, jdbcServices);
            jdbcValueBindings.beforeStatement((PreparedStatementDetails)details);
        });
        ReactiveConnection reactiveConnection = ((ReactiveConnectionSupplier)session).getReactiveConnection();
        return reactiveConnection.insertAndSelectIdentifier(insertSql, params, idType, identifierColumnName).thenApply(this::validateGeneratedIdentityId);
    }

    private Object validateGeneratedIdentityId(Object generatedId) {
        if (generatedId == null) {
            throw LOG.noNativelyGeneratedValueReturned();
        }
        Type identifierType = this.getPersister().getIdentifierType();
        if ((identifierType.getReturnedClass().equals(Short.class) || identifierType.getReturnedClass().equals(Integer.class)) && this.getPersister().getFactory().getJdbcServices().getDialect() instanceof CockroachDialect) {
            throw LOG.invalidIdentifierTypeForCockroachDB(identifierType.getReturnedClass(), this.getPersister().getEntityName());
        }
        return generatedId;
    }

    private static String createInsert(PreparedStatementDetails insertStatementDetails, String identifierColumnName, Dialect dialect) {
        String sqlEnd = " returning " + identifierColumnName;
        if (dialect instanceof MySQLDialect) {
            String sql = insertStatementDetails.getSqlString();
            int index = sql.lastIndexOf(sqlEnd);
            return index > -1 ? sql.substring(0, index) : sql;
        }
        if (dialect instanceof SQLServerDialect) {
            Object sql = insertStatementDetails.getSqlString();
            int index = ((String)sql).lastIndexOf(sqlEnd);
            if (index > -1) {
                sql = ((String)sql).substring(0, index);
            }
            if (((String)sql).endsWith("default values")) {
                index = ((String)sql).indexOf("default values");
                sql = ((String)sql).substring(0, index);
                sql = (String)sql + "output inserted." + identifierColumnName + " default values";
            } else {
                sql = ((String)sql).replace(") values (", ") output inserted." + identifierColumnName + " values (");
            }
            return sql;
        }
        if (dialect instanceof DB2Dialect) {
            return insertStatementDetails.getSqlString().replace(" values ( ))", " (" + identifierColumnName + ") values (default))");
        }
        if (dialect instanceof OracleDialect) {
            String valuesStr = " values ( )";
            Object sql = insertStatementDetails.getSqlString();
            int index = ((String)sql).lastIndexOf(sqlEnd);
            if (index > -1) {
                sql = ((String)sql).substring(0, index);
            }
            if (((String)sql).endsWith(" values ( )")) {
                index = ((String)sql).lastIndexOf(" values ( )");
                sql = ((String)sql).substring(0, index);
                sql = (String)sql + " values (default)";
            }
            return sql;
        }
        return insertStatementDetails.getSqlString();
    }

    @Override
    default public CompletionStage<Object> reactivePerformInsert(String insertSQL, SharedSessionContractImplementor session, Binder binder) {
        throw LOG.notYetImplemented();
    }
}

