/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.id.insert;

import java.lang.invoke.MethodHandles;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.concurrent.CompletionStage;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.reactive.adaptor.impl.PrepareStatementDetailsAdaptor;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.id.insert.ReactiveInsertGeneratedIdentifierDelegate;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.reactive.util.impl.CompletionStages;

public interface ReactiveAbstractSelectingDelegate
extends ReactiveInsertGeneratedIdentifierDelegate {
    public static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public String getSelectSQL();

    public void bindParameters(Object var1, PreparedStatement var2, SharedSessionContractImplementor var3);

    public Object extractGeneratedValue(ResultSet var1, SharedSessionContractImplementor var2);

    @Override
    default public CompletionStage<Object> reactivePerformInsert(PreparedStatementDetails insertStatementDetails, JdbcValueBindings jdbcValueBindings, Object entity, SharedSessionContractImplementor session) {
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        JdbcServices jdbcServices = session.getJdbcServices();
        Object[] updateParams = PreparedStatementAdaptor.bind(statement -> {
            PrepareStatementDetailsAdaptor details = new PrepareStatementDetailsAdaptor(insertStatementDetails, statement, session.getJdbcServices());
            jdbcValueBindings.beforeStatement((PreparedStatementDetails)details);
        });
        String selectSQL = this.getSelectSQL();
        ReactiveConnection reactiveConnection = ((ReactiveConnectionSupplier)session).getReactiveConnection();
        return reactiveConnection.update(insertStatementDetails.getSqlString(), updateParams).thenCompose(updated -> {
            Object[] selectParams = PreparedStatementAdaptor.bind(statement -> this.bindParameters(entity, statement, session));
            return reactiveConnection.selectJdbc(selectSQL, selectParams).handle((resultSet, e) -> {
                if (e != null) {
                    throw LOG.unableToExecutePostInsertIdSelectionQuery(selectSQL, (Throwable)e);
                }
                return resultSet;
            });
        }).thenCompose(resultSet -> {
            try {
                return CompletionStages.completedFuture(this.extractGeneratedValue((ResultSet)resultSet, session));
            }
            catch (Throwable e) {
                return CompletionStages.failedFuture((Throwable)LOG.bindParametersForPostInsertIdSelectQueryError(selectSQL, e));
            }
        });
    }
}

