/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.ast.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.internal.BatchFetchQueueHelper;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.ast.internal.CacheEntityLoaderHelper;
import org.hibernate.loader.ast.internal.LoaderHelper;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.MultiIdEntityLoaderArrayParam;
import org.hibernate.loader.ast.internal.MultiKeyLoadHelper;
import org.hibernate.loader.ast.internal.MultiKeyLoadLogging;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.MultiIdLoadOptions;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.reactive.loader.ast.internal.ExecutionContextWithSubselectFetchHandler;
import org.hibernate.reactive.loader.ast.internal.ReactiveAbstractMultiIdEntityLoader;
import org.hibernate.reactive.loader.ast.internal.ReactiveLoaderHelper;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveSelectExecutor;
import org.hibernate.reactive.sql.results.spi.ReactiveListResultsConsumer;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.descriptor.java.JavaType;

public class ReactiveMultiIdEntityLoaderArrayParam<E>
extends ReactiveAbstractMultiIdEntityLoader<E> {
    private JdbcMapping arrayJdbcMapping;
    private JdbcParameter jdbcParameter;

    public ReactiveMultiIdEntityLoaderArrayParam(EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        super(entityDescriptor, sessionFactory);
    }

    public BasicEntityIdentifierMapping getIdentifierMapping() {
        return (BasicEntityIdentifierMapping)super.getIdentifierMapping();
    }

    @Override
    protected <K> CompletionStage<List<E>> performOrderedMultiLoad(K[] ids, MultiIdLoadOptions loadOptions, EventSource session) {
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isTraceEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.tracef("ReactiveMultiIdEntityLoaderArrayParam#performOrderedMultiLoad - %s", (Object)this.getLoadable().getEntityName());
        }
        boolean coerce = !this.getSessionFactory().getJpaMetamodel().getJpaCompliance().isLoadByIdComplianceEnabled();
        LockOptions lockOptions = loadOptions.getLockOptions() == null ? new LockOptions(LockMode.NONE) : loadOptions.getLockOptions();
        ArrayList result = CollectionHelper.arrayList((int)ids.length);
        ArrayList idsToLoadFromDatabase = new ArrayList();
        ArrayList idsToLoadFromDatabaseResultIndexes = new ArrayList();
        return CompletionStages.loop(0, ids.length, i -> {
            Object id = coerce ? this.getLoadable().getIdentifierMapping().getJavaType().coerce(ids[i], (JavaType.CoercionContext)session) : ids[i];
            EntityKey entityKey = new EntityKey(id, this.getLoadable().getEntityPersister());
            if (loadOptions.isSessionCheckingEnabled() || loadOptions.isSecondLevelCacheCheckingEnabled()) {
                CacheEntityLoaderHelper.PersistenceContextEntry persistenceContextEntry;
                LoadEvent loadEvent = new LoadEvent(id, this.getLoadable().getJavaType().getJavaTypeClass().getName(), lockOptions, session, LoaderHelper.getReadOnlyFromLoadQueryInfluencers((SharedSessionContractImplementor)session));
                Object managedEntity = null;
                if (loadOptions.isSessionCheckingEnabled() && (managedEntity = (persistenceContextEntry = CacheEntityLoaderHelper.loadFromSessionCacheStatic((LoadEvent)loadEvent, (EntityKey)entityKey, (LoadEventListener.LoadType)LoadEventListener.GET)).getEntity()) != null && !loadOptions.isReturnOfDeletedEntitiesEnabled() && !persistenceContextEntry.isManaged()) {
                    result.add(i, null);
                    return CompletionStages.voidFuture();
                }
                if (managedEntity == null && loadOptions.isSecondLevelCacheCheckingEnabled()) {
                    managedEntity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(loadEvent, this.getLoadable().getEntityPersister(), entityKey);
                }
                if (managedEntity != null) {
                    result.add(i, managedEntity);
                    return CompletionStages.voidFuture();
                }
            }
            result.add(i, entityKey);
            idsToLoadFromDatabase.add(id);
            idsToLoadFromDatabaseResultIndexes.add(i);
            return CompletionStages.voidFuture();
        }).thenCompose(v -> {
            if (idsToLoadFromDatabase.isEmpty()) {
                return CompletionStages.completedFuture(result);
            }
            SelectStatement sqlAst = LoaderSelectBuilder.createSelectBySingleArrayParameter((Loadable)this.getLoadable(), (ValuedModelPart)this.getIdentifierMapping(), (LoadQueryInfluencers)session.getLoadQueryInfluencers(), (LockOptions)lockOptions, (JdbcParameter)this.jdbcParameter, (SessionFactoryImplementor)this.getSessionFactory());
            JdbcOperationQuerySelect jdbcSelectOperation = (JdbcOperationQuerySelect)this.getSessionFactory().getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(this.getSessionFactory(), sqlAst).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE);
            JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(1);
            jdbcParameterBindings.addBinding(this.jdbcParameter, (JdbcParameterBinding)new JdbcParameterBindingImpl(this.arrayJdbcMapping, idsToLoadFromDatabase.toArray(this.createTypedArray(0))));
            PersistenceContext persistenceContext = session.getPersistenceContext();
            BatchFetchQueue batchFetchQueue = persistenceContext.getBatchFetchQueue();
            SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler = SubselectFetch.createRegistrationHandler((BatchFetchQueue)batchFetchQueue, (SelectStatement)sqlAst, (JdbcParametersList)JdbcParametersList.singleton((JdbcParameter)this.jdbcParameter), (JdbcParameterBindings)jdbcParameterBindings);
            return StandardReactiveSelectExecutor.INSTANCE.list(jdbcSelectOperation, (JdbcParameterBindings)jdbcParameterBindings, (ExecutionContext)new ExecutionContextWithSubselectFetchHandler((SharedSessionContractImplementor)session, subSelectFetchableKeysHandler), RowTransformerStandardImpl.instance(), ReactiveListResultsConsumer.UniqueSemantic.FILTER);
        }).thenApply(ignore -> {
            PersistenceContext persistenceContext = session.getPersistenceContext();
            for (int i = 0; i < idsToLoadFromDatabaseResultIndexes.size(); ++i) {
                EntityEntry entry;
                Integer resultIndex = (Integer)idsToLoadFromDatabaseResultIndexes.get(i);
                EntityKey entityKey = (EntityKey)result.get(resultIndex);
                BatchFetchQueueHelper.removeBatchLoadableEntityKey((EntityKey)entityKey, (SharedSessionContractImplementor)session);
                Object entity = persistenceContext.getEntity(entityKey);
                if (entity != null && !loadOptions.isReturnOfDeletedEntitiesEnabled() && (entry = persistenceContext.getEntry(entity)).getStatus().isDeletedOrGone()) {
                    entity = null;
                }
                result.set(resultIndex, entity);
            }
            return result;
        });
    }

    @Override
    protected <K> CompletionStage<List<E>> performUnorderedMultiLoad(K[] ids, MultiIdLoadOptions loadOptions, EventSource session) {
        LockOptions lockOptions;
        ArrayList result;
        Object[] idsToLoadFromDatabase;
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isTraceEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.tracef("ReactiveMultiIdEntityLoaderArrayParam#performUnorderedMultiLoad - %s", (Object)this.getLoadable().getEntityName());
        }
        if ((idsToLoadFromDatabase = this.processResolvableEntities(ids, (arg_0, arg_1, arg_2) -> ReactiveMultiIdEntityLoaderArrayParam.lambda$performUnorderedMultiLoad$3(result = CollectionHelper.arrayList((int)ids.length), arg_0, arg_1, arg_2), loadOptions, lockOptions = loadOptions.getLockOptions() == null ? new LockOptions(LockMode.NONE) : loadOptions.getLockOptions(), session)) == null) {
            return CompletionStages.completedFuture(result);
        }
        SelectStatement sqlAst = LoaderSelectBuilder.createSelectBySingleArrayParameter((Loadable)this.getLoadable(), (ValuedModelPart)this.getIdentifierMapping(), (LoadQueryInfluencers)session.getLoadQueryInfluencers(), (LockOptions)lockOptions, (JdbcParameter)this.jdbcParameter, (SessionFactoryImplementor)this.getSessionFactory());
        JdbcOperationQuerySelect jdbcSelectOperation = (JdbcOperationQuerySelect)this.getSessionFactory().getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(this.getSessionFactory(), sqlAst).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE);
        return ReactiveLoaderHelper.loadByArrayParameter(idsToLoadFromDatabase, sqlAst, jdbcSelectOperation, this.jdbcParameter, this.arrayJdbcMapping, null, null, lockOptions, session.isDefaultReadOnly(), (SharedSessionContractImplementor)session).thenApply(databaseResults -> {
            result.addAll(databaseResults);
            for (int i = 0; i < idsToLoadFromDatabase.length; ++i) {
                Object id = idsToLoadFromDatabase[i];
                if (id == null) continue;
                BatchFetchQueueHelper.removeBatchLoadableEntityKey((Object)id, (EntityMappingType)this.getLoadable(), (SharedSessionContractImplementor)session);
            }
            return result;
        });
    }

    protected final <R, K> K[] processResolvableEntities(K[] ids, MultiIdEntityLoaderArrayParam.ResolutionConsumer<R> resolutionConsumer, MultiIdLoadOptions loadOptions, LockOptions lockOptions, EventSource session) {
        if (!loadOptions.isSessionCheckingEnabled() && !loadOptions.isSecondLevelCacheCheckingEnabled()) {
            return ids;
        }
        boolean coerce = !this.getSessionFactory().getJpaMetamodel().getJpaCompliance().isLoadByIdComplianceEnabled();
        boolean foundAnyResolvedEntities = false;
        ArrayList<K> nonResolvedIds = null;
        for (int i = 0; i < ids.length; ++i) {
            Object id = coerce ? this.getLoadable().getIdentifierMapping().getJavaType().coerce(ids[i], (JavaType.CoercionContext)session) : ids[i];
            EntityKey entityKey = new EntityKey(id, this.getLoadable().getEntityPersister());
            LoadEvent loadEvent = new LoadEvent(id, this.getLoadable().getJavaType().getJavaTypeClass().getName(), lockOptions, session, LoaderHelper.getReadOnlyFromLoadQueryInfluencers((SharedSessionContractImplementor)session));
            Object resolvedEntity = null;
            CacheEntityLoaderHelper.PersistenceContextEntry persistenceContextEntry = CacheEntityLoaderHelper.loadFromSessionCacheStatic((LoadEvent)loadEvent, (EntityKey)entityKey, (LoadEventListener.LoadType)LoadEventListener.GET);
            if (loadOptions.isSessionCheckingEnabled() && (resolvedEntity = persistenceContextEntry.getEntity()) != null && !loadOptions.isReturnOfDeletedEntitiesEnabled() && !persistenceContextEntry.isManaged()) {
                foundAnyResolvedEntities = true;
                resolutionConsumer.consume(i, entityKey, null);
                continue;
            }
            if (resolvedEntity == null && loadOptions.isSecondLevelCacheCheckingEnabled()) {
                resolvedEntity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(loadEvent, this.getLoadable().getEntityPersister(), entityKey);
            }
            if (resolvedEntity != null) {
                foundAnyResolvedEntities = true;
                resolutionConsumer.consume(i, entityKey, resolvedEntity);
                continue;
            }
            if (nonResolvedIds == null) {
                nonResolvedIds = new ArrayList<K>();
            }
            nonResolvedIds.add(id);
        }
        if (foundAnyResolvedEntities) {
            if (CollectionHelper.isEmpty(nonResolvedIds)) {
                return null;
            }
            return nonResolvedIds.toArray(this.createTypedArray(0));
        }
        return ids;
    }

    private <X> X[] createTypedArray(int length) {
        return (Object[])Array.newInstance(this.getIdentifierMapping().getJavaType().getJavaTypeClass(), length);
    }

    @Override
    public void prepare() {
        super.prepare();
        Class<?> arrayClass = this.createTypedArray(0).getClass();
        BasicTypeRegistry basicTypeRegistry = this.getSessionFactory().getTypeConfiguration().getBasicTypeRegistry();
        BasicType arrayBasicType = basicTypeRegistry.getRegisteredType(arrayClass);
        this.arrayJdbcMapping = MultiKeyLoadHelper.resolveArrayJdbcMapping((BasicType)arrayBasicType, (JdbcMapping)this.getIdentifierMapping().getJdbcMapping(), arrayClass, (SessionFactoryImplementor)this.getSessionFactory());
        this.jdbcParameter = new JdbcParameterImpl(this.arrayJdbcMapping);
    }

    private static /* synthetic */ void lambda$performUnorderedMultiLoad$3(List result, int index, EntityKey entityKey, Object resolvedEntity) {
        result.add(resolvedEntity);
    }
}

