/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.ast.internal;

import java.util.Collections;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.AbstractNaturalIdLoader;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.LoaderSqlAstCreationState;
import org.hibernate.loader.ast.internal.NoCallbackExecutionContext;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.NaturalIdLoadOptions;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.query.internal.SimpleQueryOptions;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.reactive.loader.ast.spi.ReactiveNaturalIdLoader;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveSelectExecutor;
import org.hibernate.reactive.sql.results.spi.ReactiveListResultsConsumer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SimpleFromClauseAccessImpl;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.internal.CallbackImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.stat.spi.StatisticsImplementor;

public abstract class ReactiveNaturalIdLoaderDelegate<T>
extends AbstractNaturalIdLoader<CompletionStage<T>>
implements ReactiveNaturalIdLoader<T> {
    public ReactiveNaturalIdLoaderDelegate(NaturalIdMapping naturalIdMapping, EntityMappingType entityDescriptor) {
        super(naturalIdMapping, entityDescriptor);
    }

    public CompletionStage<T> load(Object naturalIdValue, NaturalIdLoadOptions options, SharedSessionContractImplementor session) {
        return this.reactiveSelectByNaturalId(this.naturalIdMapping().normalizeInput(naturalIdValue), options, (tableGroup, creationState) -> this.entityDescriptor().createDomainResult(new NavigablePath(this.entityDescriptor().getRootPathName()), tableGroup, null, (DomainResultCreationState)creationState), ReactiveNaturalIdLoaderDelegate::visitFetches, ReactiveNaturalIdLoaderDelegate::statsEnabled, (result, startToken) -> {
            if (startToken > 0L) {
                session.getFactory().getStatistics().naturalIdQueryExecuted(this.entityDescriptor().getEntityPersister().getRootEntityName(), System.nanoTime() - startToken);
            }
        }, session).thenApply(this::castToClassType);
    }

    private static Long statsEnabled(Boolean statsEnabled) {
        return statsEnabled != false ? System.nanoTime() : -1L;
    }

    private T castToClassType(Object o) {
        return (T)o;
    }

    @Override
    public CompletionStage<Object> resolveNaturalIdToId(Object naturalIdValue, SharedSessionContractImplementor session) {
        return this.reactiveSelectByNaturalId(this.naturalIdMapping().normalizeInput(naturalIdValue), NaturalIdLoadOptions.NONE, (tableGroup, creationState) -> this.entityDescriptor().getIdentifierMapping().createDomainResult(tableGroup.getNavigablePath().append("{id}"), tableGroup, null, (DomainResultCreationState)creationState), ReactiveNaturalIdLoaderDelegate::visitFetches, ReactiveNaturalIdLoaderDelegate::statsEnabled, (result, startToken) -> {
            if (startToken > 0L) {
                session.getFactory().getStatistics().naturalIdQueryExecuted(this.entityDescriptor().getEntityPersister().getRootEntityName(), System.nanoTime() - startToken);
            }
        }, session);
    }

    @Override
    public CompletionStage<Object> resolveIdToNaturalId(Object id, SharedSessionContractImplementor session) {
        SessionFactoryImplementor sessionFactory = session.getFactory();
        JdbcParametersList.Builder jdbcParametersListBuilder = JdbcParametersList.newBuilder();
        SelectStatement sqlSelect = LoaderSelectBuilder.createSelect((Loadable)this.entityDescriptor(), Collections.singletonList(this.naturalIdMapping()), (ModelPart)this.entityDescriptor().getIdentifierMapping(), null, (int)1, (LoadQueryInfluencers)session.getLoadQueryInfluencers(), (LockOptions)LockOptions.NONE, arg_0 -> ((JdbcParametersList.Builder)jdbcParametersListBuilder).add(arg_0), (SessionFactoryImplementor)sessionFactory);
        JdbcParametersList jdbcParameters = jdbcParametersListBuilder.build();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcParameterBindingsImpl jdbcParamBindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        int offset = jdbcParamBindings.registerParametersForEachJdbcValue(id, (Bindable)this.entityDescriptor().getIdentifierMapping(), jdbcParameters, session);
        assert (offset == jdbcParameters.size());
        JdbcOperationQuerySelect jdbcSelect = (JdbcOperationQuerySelect)sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, sqlSelect).translate((JdbcParameterBindings)jdbcParamBindings, QueryOptions.NONE);
        return StandardReactiveSelectExecutor.INSTANCE.list(jdbcSelect, (JdbcParameterBindings)jdbcParamBindings, (ExecutionContext)new NoCallbackExecutionContext(session), row -> {
            assert (row.length == 1);
            return row[0];
        }, ReactiveListResultsConsumer.UniqueSemantic.FILTER).thenApply(results -> {
            if (results.isEmpty()) {
                return null;
            }
            if (results.size() > 1) {
                throw new HibernateException(String.format("Resolving id to natural-id returned more that one row : %s #%s", this.entityDescriptor().getEntityName(), id));
            }
            return results.get(0);
        });
    }

    public CompletionStage<Object> reactiveSelectByNaturalId(Object bindValue, NaturalIdLoadOptions options, BiFunction<TableGroup, LoaderSqlAstCreationState, DomainResult<?>> domainResultProducer, LoaderSqlAstCreationState.FetchProcessor fetchProcessor, Function<Boolean, Long> statementStartHandler, BiConsumer<Object, Long> statementCompletionHandler, SharedSessionContractImplementor session) {
        SessionFactoryImplementor sessionFactory = session.getFactory();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        LockOptions lockOptions = options.getLockOptions() != null ? options.getLockOptions() : LockOptions.NONE;
        NavigablePath entityPath = new NavigablePath(this.entityDescriptor().getRootPathName());
        QuerySpec rootQuerySpec = new QuerySpec(true);
        LoaderSqlAstCreationState sqlAstCreationState = new LoaderSqlAstCreationState((QueryPart)rootQuerySpec, new SqlAliasBaseManager(), (FromClauseAccess)new SimpleFromClauseAccessImpl(), lockOptions, fetchProcessor, true, LoadQueryInfluencers.NONE, (SqlAstCreationContext)sessionFactory);
        TableGroup rootTableGroup = this.entityDescriptor().createRootTableGroup(true, entityPath, null, null, () -> arg_0 -> ((QuerySpec)rootQuerySpec).applyPredicate(arg_0), (SqlAstCreationState)sqlAstCreationState);
        rootQuerySpec.getFromClause().addRoot(rootTableGroup);
        sqlAstCreationState.getFromClauseAccess().registerTableGroup(entityPath, rootTableGroup);
        DomainResult<?> domainResult = domainResultProducer.apply(rootTableGroup, sqlAstCreationState);
        SelectStatement sqlSelect = new SelectStatement((QueryPart)rootQuerySpec, Collections.singletonList(domainResult));
        JdbcParameterBindingsImpl jdbcParamBindings = new JdbcParameterBindingsImpl(this.naturalIdMapping().getJdbcTypeCount());
        this.applyNaturalIdRestriction(bindValue, rootTableGroup, arg_0 -> ((QuerySpec)rootQuerySpec).applyPredicate(arg_0), (arg_0, arg_1) -> ((JdbcParameterBindings)jdbcParamBindings).addBinding(arg_0, arg_1), sqlAstCreationState, session);
        SimpleQueryOptions queryOptions = new SimpleQueryOptions(lockOptions, Boolean.valueOf(false));
        JdbcOperationQuerySelect jdbcSelect = (JdbcOperationQuerySelect)sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, sqlSelect).translate((JdbcParameterBindings)jdbcParamBindings, (QueryOptions)queryOptions);
        StatisticsImplementor statistics = sessionFactory.getStatistics();
        Long startToken = statementStartHandler.apply(statistics.isStatisticsEnabled());
        return StandardReactiveSelectExecutor.INSTANCE.list(jdbcSelect, (JdbcParameterBindings)jdbcParamBindings, (ExecutionContext)new NaturalIdLoaderWithOptionsExecutionContext(session, (QueryOptions)queryOptions), row -> row[0], ReactiveListResultsConsumer.UniqueSemantic.FILTER).thenApply(results -> {
            if (results.size() > 1) {
                throw new HibernateException(String.format("Loading by natural-id returned more that one row : %s", this.getLoadable().getEntityName()));
            }
            Object result = results.isEmpty() ? null : (Object)results.get(0);
            statementCompletionHandler.accept(result, startToken);
            return result;
        });
    }

    protected static ImmutableFetchList visitFetches(FetchParent fetchParent, LoaderSqlAstCreationState creationState) {
        FetchableContainer fetchableContainer = fetchParent.getReferencedMappingContainer();
        int size = fetchableContainer.getNumberOfFetchables();
        ImmutableFetchList.Builder fetches = new ImmutableFetchList.Builder(fetchableContainer);
        for (int i = 0; i < size; ++i) {
            Fetchable fetchable = fetchableContainer.getFetchable(i);
            NavigablePath navigablePath = fetchParent.resolveNavigablePath(fetchable);
            Fetch fetch = fetchParent.generateFetchableFetch(fetchable, navigablePath, fetchable.getMappedFetchOptions().getTiming(), true, null, (DomainResultCreationState)creationState);
            fetches.add(fetch);
        }
        return fetches.build();
    }

    private static class NaturalIdLoaderWithOptionsExecutionContext
    extends BaseExecutionContext {
        private final Callback callback;
        private final QueryOptions queryOptions;

        public NaturalIdLoaderWithOptionsExecutionContext(SharedSessionContractImplementor session, QueryOptions queryOptions) {
            super(session);
            this.queryOptions = queryOptions;
            this.callback = new CallbackImpl();
        }

        public QueryOptions getQueryOptions() {
            return this.queryOptions;
        }

        public Callback getCallback() {
            return this.callback;
        }
    }
}

