/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.ast.internal;

import java.util.EnumMap;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.Internal;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.SingleIdEntityLoaderStandardImpl;
import org.hibernate.loader.ast.internal.SingleIdLoadPlan;
import org.hibernate.loader.ast.spi.CascadingFetchProfile;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.reactive.loader.ast.internal.DatabaseSnapshotExecutor;
import org.hibernate.reactive.loader.ast.internal.ReactiveSingleIdLoadPlan;
import org.hibernate.reactive.loader.ast.spi.ReactiveSingleIdEntityLoader;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcParametersList;

public class ReactiveSingleIdEntityLoaderStandardImpl<T>
extends SingleIdEntityLoaderStandardImpl<CompletionStage<T>>
implements ReactiveSingleIdEntityLoader<T> {
    private EnumMap<LockMode, ReactiveSingleIdLoadPlan> selectByLockMode = new EnumMap(LockMode.class);
    private EnumMap<CascadingFetchProfile, ReactiveSingleIdLoadPlan> selectByInternalCascadeProfile;
    private AtomicInteger nonReusablePlansGenerated = new AtomicInteger();
    private DatabaseSnapshotExecutor databaseSnapshotExecutor;
    private final EntityMappingType entityDescriptor;

    public AtomicInteger getNonReusablePlansGenerated() {
        return this.nonReusablePlansGenerated;
    }

    public ReactiveSingleIdEntityLoaderStandardImpl(EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        super(entityDescriptor, sessionFactory);
        this.entityDescriptor = entityDescriptor;
    }

    public EntityMappingType getLoadable() {
        return this.entityDescriptor;
    }

    @Override
    public CompletionStage<Object[]> reactiveLoadDatabaseSnapshot(Object id, SharedSessionContractImplementor session) {
        if (this.databaseSnapshotExecutor == null) {
            this.databaseSnapshotExecutor = new DatabaseSnapshotExecutor(this.entityDescriptor, this.sessionFactory);
        }
        return this.databaseSnapshotExecutor.loadDatabaseSnapshot(id, session);
    }

    public void prepare() {
        LockOptions lockOptions = LockOptions.NONE;
        LoadQueryInfluencers queryInfluencers = new LoadQueryInfluencers(this.sessionFactory);
        ReactiveSingleIdLoadPlan<T> plan = this.createLoadPlan(lockOptions, queryInfluencers, this.sessionFactory);
        if (this.determineIfReusable(lockOptions, queryInfluencers)) {
            this.selectByLockMode.put(lockOptions.getLockMode(), plan);
        }
    }

    private boolean determineIfReusable(LockOptions lockOptions, LoadQueryInfluencers loadQueryInfluencers) {
        if (this.getLoadable().isAffectedByEntityGraph(loadQueryInfluencers)) {
            return false;
        }
        if (this.getLoadable().isAffectedByEnabledFetchProfiles(loadQueryInfluencers)) {
            return false;
        }
        return lockOptions.getTimeOut() == -1;
    }

    public CompletionStage<T> load(Object key, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        SingleIdLoadPlan loadPlan = this.resolveLoadPlan(lockOptions, session.getLoadQueryInfluencers(), session.getFactory());
        return (CompletionStage)loadPlan.load(key, readOnly, Boolean.valueOf(true), session);
    }

    public CompletionStage<T> load(Object key, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        SingleIdLoadPlan loadPlan = this.resolveLoadPlan(lockOptions, session.getLoadQueryInfluencers(), session.getFactory());
        return loadPlan.load(key, entityInstance, readOnly, false, session);
    }

    @Internal
    public ReactiveSingleIdLoadPlan<T> resolveLoadPlan(LockOptions lockOptions, LoadQueryInfluencers loadQueryInfluencers, SessionFactoryImplementor sessionFactory) {
        if (this.getLoadable().isAffectedByEnabledFilters(loadQueryInfluencers)) {
            this.nonReusablePlansGenerated.incrementAndGet();
            return this.createLoadPlan(lockOptions, loadQueryInfluencers, sessionFactory);
        }
        CascadingFetchProfile enabledCascadingFetchProfile = loadQueryInfluencers.getEnabledCascadingFetchProfile();
        if (enabledCascadingFetchProfile != null && LockMode.WRITE.greaterThan(lockOptions.getLockMode())) {
            if (this.selectByInternalCascadeProfile == null) {
                this.selectByInternalCascadeProfile = new EnumMap(CascadingFetchProfile.class);
            } else {
                ReactiveSingleIdLoadPlan existing = this.selectByInternalCascadeProfile.get(enabledCascadingFetchProfile);
                if (existing != null) {
                    return existing;
                }
            }
            ReactiveSingleIdLoadPlan<T> plan = this.createLoadPlan(lockOptions, loadQueryInfluencers, sessionFactory);
            this.selectByInternalCascadeProfile.put(enabledCascadingFetchProfile, plan);
            return plan;
        }
        boolean reusable = this.determineIfReusable(lockOptions, loadQueryInfluencers);
        if (reusable) {
            ReactiveSingleIdLoadPlan existing = this.selectByLockMode.get(lockOptions.getLockMode());
            if (existing != null) {
                return existing;
            }
            ReactiveSingleIdLoadPlan<T> plan = this.createLoadPlan(lockOptions, loadQueryInfluencers, sessionFactory);
            this.selectByLockMode.put(lockOptions.getLockMode(), plan);
            return plan;
        }
        this.nonReusablePlansGenerated.incrementAndGet();
        return this.createLoadPlan(lockOptions, loadQueryInfluencers, sessionFactory);
    }

    private ReactiveSingleIdLoadPlan<T> createLoadPlan(LockOptions lockOptions, LoadQueryInfluencers queryInfluencers, SessionFactoryImplementor sessionFactory) {
        JdbcParametersList.Builder jdbcParametersListBuilder = JdbcParametersList.newBuilder();
        SelectStatement sqlAst = LoaderSelectBuilder.createSelect((Loadable)this.getLoadable(), null, (ModelPart)this.getLoadable().getIdentifierMapping(), null, (int)1, (LoadQueryInfluencers)queryInfluencers, (LockOptions)lockOptions, arg_0 -> ((JdbcParametersList.Builder)jdbcParametersListBuilder).add(arg_0), (SessionFactoryImplementor)sessionFactory);
        JdbcParametersList jdbcParameters = jdbcParametersListBuilder.build();
        return new ReactiveSingleIdLoadPlan((org.hibernate.persister.entity.Loadable)this.getLoadable(), (ModelPart)this.getLoadable().getIdentifierMapping(), sqlAst, jdbcParameters, lockOptions, sessionFactory);
    }
}

