/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.ast.internal;

import java.util.concurrent.CompletionStage;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.reactive.loader.ast.internal.DatabaseSnapshotExecutor;
import org.hibernate.reactive.loader.ast.spi.ReactiveSingleIdEntityLoader;

public abstract class ReactiveSingleIdEntityLoaderSupport<T>
implements ReactiveSingleIdEntityLoader<T> {
    private final EntityMappingType entityDescriptor;
    protected final SessionFactoryImplementor sessionFactory;
    private DatabaseSnapshotExecutor databaseSnapshotExecutor;

    public ReactiveSingleIdEntityLoaderSupport(EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        this.sessionFactory = sessionFactory;
    }

    public EntityMappingType getLoadable() {
        return this.entityDescriptor;
    }

    @Override
    public CompletionStage<Object[]> reactiveLoadDatabaseSnapshot(Object id, SharedSessionContractImplementor session) {
        if (this.databaseSnapshotExecutor == null) {
            this.databaseSnapshotExecutor = new DatabaseSnapshotExecutor(this.entityDescriptor, this.sessionFactory);
        }
        return this.databaseSnapshotExecutor.loadDatabaseSnapshot(id, session);
    }
}

