/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.mutiny.impl;

import io.smallrye.mutiny.Uni;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.metamodel.Metamodel;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.Cache;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.reactive.common.InternalStateAssertions;
import org.hibernate.reactive.common.spi.Implementor;
import org.hibernate.reactive.context.Context;
import org.hibernate.reactive.context.impl.BaseKey;
import org.hibernate.reactive.context.impl.MultitenantKey;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.mutiny.Mutiny;
import org.hibernate.reactive.mutiny.impl.MutinySessionImpl;
import org.hibernate.reactive.mutiny.impl.MutinyStatelessSessionImpl;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.pool.ReactiveConnectionPool;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.session.ReactiveStatelessSession;
import org.hibernate.reactive.session.impl.ReactiveSessionImpl;
import org.hibernate.reactive.session.impl.ReactiveStatelessSessionImpl;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.stat.Statistics;

public class MutinySessionFactoryImpl
implements Mutiny.SessionFactory,
Implementor {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final SessionFactoryImpl delegate;
    private final ReactiveConnectionPool connectionPool;
    private final Context context;
    private final BaseKey<Mutiny.Session> contextKeyForSession;
    private final BaseKey<Mutiny.StatelessSession> contextKeyForStatelessSession;

    public MutinySessionFactoryImpl(SessionFactoryImpl delegate) {
        Objects.requireNonNull(delegate);
        this.delegate = delegate;
        this.context = (Context)delegate.getServiceRegistry().getService(Context.class);
        this.connectionPool = (ReactiveConnectionPool)delegate.getServiceRegistry().getService(ReactiveConnectionPool.class);
        this.contextKeyForSession = new BaseKey<Mutiny.Session>(Mutiny.Session.class, delegate.getUuid());
        this.contextKeyForStatelessSession = new BaseKey<Mutiny.StatelessSession>(Mutiny.StatelessSession.class, delegate.getUuid());
    }

    <T> Uni<T> uni(Supplier<CompletionStage<T>> stageSupplier) {
        return Uni.createFrom().completionStage(stageSupplier).runSubscriptionOn((Executor)this.context);
    }

    @Override
    public String getUuid() {
        return this.delegate.getUuid();
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.delegate.getServiceRegistry();
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public Uni<Mutiny.Session> openSession() {
        SessionCreationOptions options = this.options();
        return this.uni(() -> this.connection(options.getTenantIdentifier())).chain(reactiveConnection -> this.create((ReactiveConnection)reactiveConnection, () -> new ReactiveSessionImpl(this.delegate, options, (ReactiveConnection)reactiveConnection))).map(s -> new MutinySessionImpl((ReactiveSession)s, this));
    }

    @Override
    public Uni<Mutiny.Session> openSession(String tenantId) {
        return this.uni(() -> this.connection(tenantId)).chain(reactiveConnection -> this.create((ReactiveConnection)reactiveConnection, () -> new ReactiveSessionImpl(this.delegate, this.options(tenantId), (ReactiveConnection)reactiveConnection))).map(s -> new MutinySessionImpl((ReactiveSession)s, this));
    }

    private <S> Uni<S> create(ReactiveConnection connection, Supplier<S> supplier) {
        return Uni.createFrom().item(supplier).onFailure().call(() -> Uni.createFrom().completionStage(connection.close()));
    }

    @Override
    public Uni<Mutiny.StatelessSession> openStatelessSession() {
        SessionCreationOptions options = this.options();
        return this.uni(() -> this.connection(options.getTenantIdentifier())).chain(reactiveConnection -> this.create((ReactiveConnection)reactiveConnection, () -> new ReactiveStatelessSessionImpl(this.delegate, options, (ReactiveConnection)reactiveConnection))).map(s -> new MutinyStatelessSessionImpl((ReactiveStatelessSession)s, this));
    }

    @Override
    public Uni<Mutiny.StatelessSession> openStatelessSession(String tenantId) {
        return this.uni(() -> this.connection(tenantId)).chain(reactiveConnection -> this.create((ReactiveConnection)reactiveConnection, () -> new ReactiveStatelessSessionImpl(this.delegate, this.options(tenantId), (ReactiveConnection)reactiveConnection))).map(s -> new MutinyStatelessSessionImpl((ReactiveStatelessSession)s, this));
    }

    private SessionCreationOptions options() {
        return new SessionFactoryImpl.SessionBuilderImpl(this.delegate);
    }

    private SessionCreationOptions options(String tenantIdentifier) {
        return new SessionFactoryImpl.SessionBuilderImpl(this.delegate).tenantIdentifier(tenantIdentifier);
    }

    private CompletionStage<ReactiveConnection> connection(String tenantId) {
        InternalStateAssertions.assertUseOnEventLoop();
        return tenantId == null ? this.connectionPool.getConnection() : this.connectionPool.getConnection(tenantId);
    }

    @Override
    public <T> Uni<T> withSession(Function<Mutiny.Session, Uni<T>> work) {
        Objects.requireNonNull(work, "parameter 'work' is required");
        Mutiny.Session current = this.context.get(this.contextKeyForSession);
        if (current != null && current.isOpen()) {
            LOG.debug("Reusing existing open Mutiny.Session which was found in the current Vert.x context");
            return work.apply(current);
        }
        LOG.debug("No existing open Mutiny.Session was found in the current Vert.x context: opening a new instance");
        return this.withSession(this.openSession(), work, this.contextKeyForSession);
    }

    @Override
    public <T> Uni<T> withSession(String tenantId, Function<Mutiny.Session, Uni<T>> work) {
        Objects.requireNonNull(tenantId, "parameter 'tenantId' is required");
        Objects.requireNonNull(work, "parameter 'work' is required");
        MultitenantKey<Mutiny.Session> key = new MultitenantKey<Mutiny.Session>(this.contextKeyForSession, tenantId);
        Mutiny.Session current = this.context.get(key);
        if (current != null && current.isOpen()) {
            LOG.debugf("Reusing existing open Mutiny.Session which was found in the current Vert.x context for current tenant '%s'", tenantId);
            return work.apply(current);
        }
        LOG.debugf("No existing open Mutiny.Session was found in the current Vert.x context for current tenant '%s': opening a new instance", tenantId);
        return this.withSession(this.openSession(tenantId), work, key);
    }

    @Override
    public <T> Uni<T> withStatelessSession(Function<Mutiny.StatelessSession, Uni<T>> work) {
        Objects.requireNonNull(work, "parameter 'work' is required");
        Mutiny.StatelessSession current = this.context.get(this.contextKeyForStatelessSession);
        if (current != null && current.isOpen()) {
            LOG.debug("Reusing existing open Mutiny.StatelessSession which was found in the current Vert.x context");
            return work.apply(current);
        }
        LOG.debug("No existing open Mutiny.StatelessSession was found in the current Vert.x context: opening a new instance");
        return this.withSession(this.openStatelessSession(), work, this.contextKeyForStatelessSession);
    }

    @Override
    public <T> Uni<T> withStatelessSession(String tenantId, Function<Mutiny.StatelessSession, Uni<T>> work) {
        Objects.requireNonNull(tenantId, "parameter 'tenantId' is required");
        Objects.requireNonNull(work, "parameter 'work' is required");
        MultitenantKey<Mutiny.StatelessSession> key = new MultitenantKey<Mutiny.StatelessSession>(this.contextKeyForStatelessSession, tenantId);
        Mutiny.StatelessSession current = this.context.get(key);
        if (current != null && current.isOpen()) {
            LOG.debugf("Reusing existing open Mutiny.StatelessSession which was found in the current Vert.x context for current tenant '%s'", tenantId);
            return work.apply(current);
        }
        LOG.debugf("No existing open Mutiny.StatelessSession was found in the current Vert.x context for current tenant '%s': opening a new instance", tenantId);
        return this.withSession(this.openStatelessSession(tenantId), work, key);
    }

    private <S extends Mutiny.Closeable, T> Uni<T> withSession(Uni<S> sessionUni, Function<S, Uni<T>> work, Context.Key<S> contextKey) {
        return sessionUni.chain(session -> Uni.createFrom().voidItem().invoke(() -> this.context.put(contextKey, session)).chain(() -> (Uni)work.apply(session)).eventually(() -> this.context.remove(contextKey)).eventually(session::close));
    }

    @Override
    public <T> Uni<T> withTransaction(BiFunction<Mutiny.Session, Mutiny.Transaction, Uni<T>> work) {
        Objects.requireNonNull(work, "parameter 'work' is required");
        return this.withSession(s -> s.withTransaction((Mutiny.Transaction t) -> (Uni)work.apply((Mutiny.Session)s, (Mutiny.Transaction)t)));
    }

    @Override
    public <T> Uni<T> withStatelessTransaction(BiFunction<Mutiny.StatelessSession, Mutiny.Transaction, Uni<T>> work) {
        Objects.requireNonNull(work, "parameter 'work' is required");
        return this.withStatelessSession(s -> s.withTransaction((Mutiny.Transaction t) -> (Uni)work.apply((Mutiny.StatelessSession)s, (Mutiny.Transaction)t)));
    }

    @Override
    public <T> Uni<T> withTransaction(String tenantId, BiFunction<Mutiny.Session, Mutiny.Transaction, Uni<T>> work) {
        Objects.requireNonNull(work, "parameter 'work' is required");
        return this.withSession(tenantId, s -> s.withTransaction((Mutiny.Transaction t) -> (Uni)work.apply((Mutiny.Session)s, (Mutiny.Transaction)t)));
    }

    @Override
    public <T> Uni<T> withStatelessTransaction(String tenantId, BiFunction<Mutiny.StatelessSession, Mutiny.Transaction, Uni<T>> work) {
        Objects.requireNonNull(work, "parameter 'work' is required");
        return this.withStatelessSession(tenantId, s -> s.withTransaction((Mutiny.Transaction t) -> (Uni)work.apply((Mutiny.StatelessSession)s, (Mutiny.Transaction)t)));
    }

    @Override
    public CriteriaBuilder getCriteriaBuilder() {
        return this.delegate.getCriteriaBuilder();
    }

    @Override
    public Metamodel getMetamodel() {
        return this.delegate.getMetamodel();
    }

    @Override
    public Cache getCache() {
        return this.delegate.getCache();
    }

    @Override
    public Statistics getStatistics() {
        return this.delegate.getStatistics();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }
}

