/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.mutiny.impl;

import io.smallrye.mutiny.Uni;
import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.metamodel.Attribute;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.CacheMode;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.graph.RootGraph;
import org.hibernate.reactive.common.AffectedEntities;
import org.hibernate.reactive.common.Identifier;
import org.hibernate.reactive.common.ResultSetMapping;
import org.hibernate.reactive.engine.spi.ReactiveSharedSessionContractImplementor;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.mutiny.Mutiny;
import org.hibernate.reactive.mutiny.impl.MutinyMutationQueryImpl;
import org.hibernate.reactive.mutiny.impl.MutinyQueryImpl;
import org.hibernate.reactive.mutiny.impl.MutinySelectionQueryImpl;
import org.hibernate.reactive.mutiny.impl.MutinySessionFactoryImpl;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.query.sqm.internal.ReactiveQuerySqmImpl;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.reactive.session.ReactiveQueryProducer;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.util.impl.CompletionStages;

public class MutinySessionImpl
implements Mutiny.Session {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final ReactiveSession delegate;
    private final MutinySessionFactoryImpl factory;
    private Transaction<?> currentTransaction;

    public MutinySessionImpl(ReactiveSession session, MutinySessionFactoryImpl factory) {
        this.delegate = session;
        this.factory = factory;
    }

    <T> Uni<T> uni(Supplier<CompletionStage<T>> stageSupplier) {
        return this.factory.uni(stageSupplier);
    }

    @Override
    public Uni<Void> flush() {
        return this.uni(this.delegate::reactiveFlush);
    }

    @Override
    public <T> Uni<T> fetch(T association) {
        return this.uni(() -> this.delegate.reactiveFetch(association, false));
    }

    @Override
    public <E, T> Uni<T> fetch(E entity, Attribute<E, T> field) {
        return this.uni(() -> this.delegate.reactiveFetch(entity, field));
    }

    @Override
    public <T> Uni<T> unproxy(T association) {
        return this.uni(() -> this.delegate.reactiveFetch(association, true));
    }

    @Override
    public <T> T getReference(Class<T> entityClass, Object id) {
        return this.delegate.getReference(entityClass, id);
    }

    public ReactiveConnection getReactiveConnection() {
        return this.delegate.getReactiveConnection();
    }

    @Override
    public <T> T getReference(T entity) {
        return this.delegate.getReference(this.delegate.getEntityClass(entity), this.delegate.getEntityId(entity));
    }

    @Override
    public LockMode getLockMode(Object entity) {
        return this.delegate.getCurrentLockMode(entity);
    }

    @Override
    public boolean contains(Object entity) {
        return this.delegate.contains(entity);
    }

    @Override
    public <R> Mutiny.SelectionQuery<R> createSelectionQuery(String queryString) {
        return new MutinySelectionQueryImpl(this.delegate.createReactiveQuery(queryString), this.factory);
    }

    @Override
    public Mutiny.MutationQuery createMutationQuery(String queryString) {
        return new MutinyMutationQueryImpl(this.delegate.createReactiveQuery(queryString), this.factory);
    }

    @Override
    public <R> Mutiny.Query<R> createQuery(String queryString) {
        return new MutinyQueryImpl(this.delegate.createReactiveQuery(queryString), this.factory);
    }

    @Override
    public <R> Mutiny.SelectionQuery<R> createQuery(String queryString, Class<R> resultType) {
        return new MutinySelectionQueryImpl<R>(this.delegate.createReactiveQuery(queryString, resultType), this.factory);
    }

    @Override
    public <R> Mutiny.SelectionQuery<R> createQuery(CriteriaQuery<R> criteriaQuery) {
        return new MutinySelectionQueryImpl<R>(this.delegate.createReactiveQuery(criteriaQuery), this.factory);
    }

    @Override
    public <R> Mutiny.MutationQuery createQuery(CriteriaUpdate<R> criteriaUpdate) {
        return new MutinyMutationQueryImpl((ReactiveQuerySqmImpl)this.delegate.createReactiveMutationQuery(criteriaUpdate), this.factory);
    }

    @Override
    public <R> Mutiny.MutationQuery createQuery(CriteriaDelete<R> criteriaDelete) {
        return new MutinyMutationQueryImpl((ReactiveQuerySqmImpl)this.delegate.createReactiveMutationQuery(criteriaDelete), this.factory);
    }

    @Override
    public <R> Mutiny.Query<R> createNamedQuery(String queryName) {
        return new MutinyQueryImpl(this.delegate.createReactiveNamedQuery(queryName, null), this.factory);
    }

    @Override
    public <R> Mutiny.SelectionQuery<R> createNamedQuery(String queryName, Class<R> resultType) {
        return new MutinySelectionQueryImpl<R>(this.delegate.createReactiveNamedQuery(queryName, resultType), this.factory);
    }

    @Override
    public <R> Mutiny.Query<R> createNativeQuery(String queryString) {
        return new MutinyQueryImpl(this.delegate.createReactiveNativeQuery(queryString), this.factory);
    }

    @Override
    public <R> Mutiny.Query<R> createNativeQuery(String queryString, AffectedEntities affectedEntities) {
        return new MutinyQueryImpl(this.delegate.createReactiveNativeQuery(queryString, affectedEntities), this.factory);
    }

    @Override
    public <R> Mutiny.SelectionQuery<R> createNativeQuery(String queryString, Class<R> resultType) {
        return new MutinySelectionQueryImpl<R>(this.delegate.createReactiveNativeQuery(queryString, resultType), this.factory);
    }

    @Override
    public <R> Mutiny.SelectionQuery<R> createNativeQuery(String queryString, Class<R> resultType, AffectedEntities affectedEntities) {
        return new MutinySelectionQueryImpl<R>(this.delegate.createReactiveNativeQuery(queryString, resultType, affectedEntities), this.factory);
    }

    @Override
    public <R> Mutiny.SelectionQuery<R> createNativeQuery(String queryString, ResultSetMapping<R> resultSetMapping) {
        return new MutinySelectionQueryImpl<R>(this.delegate.createReactiveNativeQuery(queryString, resultSetMapping), this.factory);
    }

    @Override
    public <R> Mutiny.SelectionQuery<R> createNativeQuery(String queryString, ResultSetMapping<R> resultSetMapping, AffectedEntities affectedEntities) {
        return new MutinySelectionQueryImpl<R>(this.delegate.createReactiveNativeQuery(queryString, resultSetMapping, affectedEntities), this.factory);
    }

    @Override
    public <T> Uni<T> find(Class<T> entityClass, Object primaryKey) {
        return this.uni(() -> this.delegate.reactiveFind(entityClass, primaryKey, null, null));
    }

    @Override
    public <T> Uni<List<T>> find(Class<T> entityClass, Object ... ids) {
        return this.uni(() -> this.delegate.reactiveFind(entityClass, ids));
    }

    @Override
    public <T> Uni<T> find(Class<T> entityClass, Identifier<T> id) {
        return this.uni(() -> this.delegate.reactiveFind(entityClass, id.namedValues()));
    }

    @Override
    public <T> Uni<T> find(Class<T> entityClass, Object primaryKey, LockMode lockMode) {
        return this.uni(() -> this.delegate.reactiveFind(entityClass, primaryKey, new LockOptions(lockMode), null));
    }

    @Override
    public <T> Uni<T> find(Class<T> entityClass, Object id, LockModeType lockModeType) {
        return Mutiny.Session.super.find(entityClass, id, lockModeType);
    }

    public <T> Uni<T> find(Class<T> entityClass, Object primaryKey, LockOptions lockOptions) {
        return this.uni(() -> this.delegate.reactiveFind(entityClass, primaryKey, lockOptions, null));
    }

    @Override
    public <T> Uni<T> find(EntityGraph<T> entityGraph, Object id) {
        Class entityClass = ((RootGraph)entityGraph).getGraphedType().getJavaType();
        return this.uni(() -> this.delegate.reactiveFind(entityClass, id, null, entityGraph));
    }

    @Override
    public Uni<Void> persist(Object entity) {
        return this.uni(() -> this.delegate.reactivePersist(entity));
    }

    @Override
    public Uni<Void> persistAll(Object ... entity) {
        return this.uni(() -> CompletionStages.applyToAll(this.delegate::reactivePersist, entity));
    }

    @Override
    public Uni<Void> remove(Object entity) {
        return this.uni(() -> this.delegate.reactiveRemove(entity));
    }

    @Override
    public Uni<Void> removeAll(Object ... entity) {
        return this.uni(() -> CompletionStages.applyToAll(this.delegate::reactiveRemove, entity));
    }

    @Override
    public <T> Uni<T> merge(T entity) {
        return this.uni(() -> this.delegate.reactiveMerge(entity));
    }

    @Override
    public final Uni<Void> mergeAll(Object ... entity) {
        return this.uni(() -> CompletionStages.applyToAll(this.delegate::reactiveMerge, entity));
    }

    @Override
    public Uni<Void> refresh(Object entity) {
        return this.uni(() -> this.delegate.reactiveRefresh(entity, LockOptions.NONE));
    }

    @Override
    public Uni<Void> refresh(Object entity, LockMode lockMode) {
        return this.uni(() -> this.delegate.reactiveRefresh(entity, new LockOptions(lockMode)));
    }

    @Override
    public Uni<Void> refresh(Object entity, LockModeType lockModeType) {
        return Mutiny.Session.super.refresh(entity, lockModeType);
    }

    public Uni<Void> refresh(Object entity, LockOptions lockOptions) {
        return this.uni(() -> this.delegate.reactiveRefresh(entity, lockOptions));
    }

    @Override
    public Uni<Void> refreshAll(Object ... entity) {
        return this.uni(() -> CompletionStages.applyToAll(e -> this.delegate.reactiveRefresh(e, LockOptions.NONE), entity));
    }

    @Override
    public Uni<Void> lock(Object entity, LockMode lockMode) {
        return this.uni(() -> this.delegate.reactiveLock(entity, new LockOptions(lockMode)));
    }

    @Override
    public Uni<Void> lock(Object entity, LockModeType lockModeType) {
        return Mutiny.Session.super.lock(entity, lockModeType);
    }

    public Uni<Void> lock(Object entity, LockOptions lockOptions) {
        return this.uni(() -> this.delegate.reactiveLock(entity, lockOptions));
    }

    @Override
    public FlushMode getFlushMode() {
        switch (this.delegate.getHibernateFlushMode()) {
            case MANUAL: {
                return FlushMode.MANUAL;
            }
            case COMMIT: {
                return FlushMode.COMMIT;
            }
            case AUTO: {
                return FlushMode.AUTO;
            }
            case ALWAYS: {
                return FlushMode.ALWAYS;
            }
        }
        throw LOG.impossibleFlushModeIllegalState();
    }

    @Override
    public Mutiny.Session setFlushMode(FlushMode flushMode) {
        switch (flushMode) {
            case COMMIT: {
                this.delegate.setHibernateFlushMode(FlushMode.COMMIT);
                break;
            }
            case AUTO: {
                this.delegate.setHibernateFlushMode(FlushMode.AUTO);
                break;
            }
            case MANUAL: {
                this.delegate.setHibernateFlushMode(FlushMode.MANUAL);
                break;
            }
            case ALWAYS: {
                this.delegate.setHibernateFlushMode(FlushMode.ALWAYS);
            }
        }
        return this;
    }

    @Override
    public Mutiny.Session setFlushMode(FlushModeType flushModeType) {
        return Mutiny.Session.super.setFlushMode(flushModeType);
    }

    @Override
    public Mutiny.Session setDefaultReadOnly(boolean readOnly) {
        this.delegate.setDefaultReadOnly(readOnly);
        return this;
    }

    @Override
    public boolean isDefaultReadOnly() {
        return this.delegate.isDefaultReadOnly();
    }

    @Override
    public Mutiny.Session setReadOnly(Object entityOrProxy, boolean readOnly) {
        this.delegate.setReadOnly(entityOrProxy, readOnly);
        return this;
    }

    @Override
    public boolean isReadOnly(Object entityOrProxy) {
        return this.delegate.isReadOnly(entityOrProxy);
    }

    @Override
    public CacheMode getCacheMode() {
        return this.delegate.getCacheMode();
    }

    @Override
    public Mutiny.Session setCacheMode(CacheMode cacheMode) {
        this.delegate.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public Mutiny.Session setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        return Mutiny.Session.super.setCacheStoreMode(cacheStoreMode);
    }

    @Override
    public Mutiny.Session setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        return Mutiny.Session.super.setCacheRetrieveMode(cacheRetrieveMode);
    }

    @Override
    public Mutiny.Session setBatchSize(Integer batchSize) {
        this.delegate.setBatchSize(batchSize);
        return this;
    }

    @Override
    public Integer getBatchSize() {
        return this.delegate.getBatchSize();
    }

    @Override
    public Mutiny.Session detach(Object entity) {
        this.delegate.detach(entity);
        return this;
    }

    @Override
    public Mutiny.Session clear() {
        this.delegate.clear();
        return this;
    }

    @Override
    public Mutiny.Session enableFetchProfile(String name) {
        this.delegate.enableFetchProfile(name);
        return this;
    }

    @Override
    public Mutiny.Session disableFetchProfile(String name) {
        this.delegate.disableFetchProfile(name);
        return this;
    }

    @Override
    public boolean isFetchProfileEnabled(String name) {
        return this.delegate.isFetchProfileEnabled(name);
    }

    @Override
    public Filter enableFilter(String filterName) {
        return this.delegate.enableFilter(filterName);
    }

    @Override
    public void disableFilter(String filterName) {
        this.delegate.disableFilter(filterName);
    }

    @Override
    public Filter getEnabledFilter(String filterName) {
        return this.delegate.getEnabledFilter(filterName);
    }

    @Override
    public <T> Uni<T> withTransaction(Function<Mutiny.Transaction, Uni<T>> work) {
        return this.currentTransaction == null ? new Transaction().execute(work) : work.apply(this.currentTransaction);
    }

    @Override
    public Mutiny.Transaction currentTransaction() {
        return this.currentTransaction;
    }

    @Override
    public Uni<Void> close() {
        return this.uni(this.delegate::reactiveClose);
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public Mutiny.SessionFactory getFactory() {
        return this.factory;
    }

    @Override
    public <T> ResultSetMapping<T> getResultSetMapping(Class<T> resultType, String mappingName) {
        return this.delegate.getResultSetMapping(resultType, mappingName);
    }

    @Override
    public <T> EntityGraph<T> getEntityGraph(Class<T> rootType, String graphName) {
        return this.delegate.getEntityGraph(rootType, graphName);
    }

    @Override
    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        return this.delegate.createEntityGraph(rootType);
    }

    @Override
    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType, String graphName) {
        return this.delegate.createEntityGraph(rootType, graphName);
    }

    public <T> T unwrap(Class<T> clazz) {
        if (ReactiveConnectionSupplier.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.delegate);
        }
        if (ReactiveSession.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.delegate);
        }
        if (ReactiveQueryProducer.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.delegate);
        }
        if (ReactiveSharedSessionContractImplementor.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.delegate);
        }
        throw new PersistenceException("Cannot unwrap type " + clazz);
    }

    private class Transaction<T>
    implements Mutiny.Transaction {
        boolean rollback;

        private Transaction() {
        }

        Uni<T> execute(Function<Mutiny.Transaction, Uni<T>> work) {
            MutinySessionImpl.this.currentTransaction = this;
            return this.begin().chain(() -> this.executeInTransaction(work)).eventually(() -> {
                MutinySessionImpl.this.currentTransaction = null;
            });
        }

        Uni<T> executeInTransaction(Function<Mutiny.Transaction, Uni<T>> work) {
            return work.apply(this).call(this::flush).call(this::beforeCompletion).onFailure().call(this::rollback).onCancellation().call(this::rollback).call(() -> this.rollback ? this.rollback() : this.commit()).call(this::afterCompletion);
        }

        Uni<Void> flush() {
            return Uni.createFrom().completionStage(MutinySessionImpl.this.delegate.reactiveAutoflush());
        }

        Uni<Void> begin() {
            return Uni.createFrom().completionStage(MutinySessionImpl.this.delegate.getReactiveConnection().beginTransaction());
        }

        Uni<Void> rollback() {
            return Uni.createFrom().completionStage(MutinySessionImpl.this.delegate.getReactiveConnection().rollbackTransaction());
        }

        Uni<Void> commit() {
            return Uni.createFrom().completionStage(MutinySessionImpl.this.delegate.getReactiveConnection().commitTransaction());
        }

        private Uni<Void> beforeCompletion() {
            return Uni.createFrom().completionStage(MutinySessionImpl.this.delegate.getReactiveActionQueue().beforeTransactionCompletion());
        }

        private Uni<Void> afterCompletion() {
            return Uni.createFrom().completionStage(MutinySessionImpl.this.delegate.getReactiveActionQueue().afterTransactionCompletion(!this.rollback));
        }

        @Override
        public void markForRollback() {
            this.rollback = true;
        }

        @Override
        public boolean isMarkedForRollback() {
            return this.rollback;
        }
    }
}

