/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.collection.mutation;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CompletionStage;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.persister.collection.mutation.UpdateRowsCoordinatorStandard;
import org.hibernate.reactive.engine.jdbc.env.internal.ReactiveMutationExecutor;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.persister.collection.mutation.ReactiveUpdateRowsCoordinator;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationOperationGroup;

public class ReactiveUpdateRowsCoordinatorStandard
extends UpdateRowsCoordinatorStandard
implements ReactiveUpdateRowsCoordinator {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final RowMutationOperations rowMutationOperations;

    public ReactiveUpdateRowsCoordinatorStandard(CollectionMutationTarget mutationTarget, RowMutationOperations rowMutationOperations, SessionFactoryImplementor sessionFactory) {
        super(mutationTarget, rowMutationOperations, sessionFactory);
        this.rowMutationOperations = rowMutationOperations;
    }

    public void updateRows(Object key, PersistentCollection<?> collection, SharedSessionContractImplementor session) {
        throw LOG.nonReactiveMethodCall("reactiveUpdateRows");
    }

    @Override
    public CompletionStage<Void> reactiveUpdateRows(Object key, PersistentCollection<?> collection, SharedSessionContractImplementor session) {
        ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Updating collection rows - %s#%s", (Object)this.getMutationTarget().getRolePath(), key);
        return this.doReactiveUpdate(key, collection, session).thenAccept(count -> ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Updated `%s` collection rows - %s#%s", count, (Object)this.getMutationTarget().getRolePath(), key));
    }

    private CompletionStage<Integer> doReactiveUpdate(Object key, PersistentCollection<?> collection, SharedSessionContractImplementor session) {
        ReactiveMutationExecutor mutationExecutor = this.reactiveMutationExecutor(session, this.getOperationGroup());
        return CompletionStages.completedFuture(mutationExecutor).thenCompose(ignore -> {
            int[] counter = new int[]{0};
            Iterator entries = collection.entries(this.getMutationTarget().getTargetPart().getCollectionDescriptor());
            if (collection.isElementRemoved()) {
                ArrayList elements = new ArrayList();
                while (entries.hasNext()) {
                    elements.add(entries.next());
                }
                return CompletionStages.loop(0, elements.size(), index -> {
                    int i = elements.size() - index - 1;
                    Object entry = elements.get(i);
                    return this.processRow(key, collection, entry, i, mutationExecutor, session).thenAccept(updated -> {
                        if (updated.booleanValue()) {
                            counter[0] = counter[0] + 1;
                        }
                    });
                }).thenApply(unused -> counter[0]);
            }
            int[] position = new int[]{0};
            return CompletionStages.loop(entries, (entry, integer) -> {
                int n = position[0];
                position[0] = n + 1;
                return this.processRow(key, collection, entry, n, mutationExecutor, session).thenAccept(updated -> {
                    if (updated.booleanValue()) {
                        counter[0] = counter[0] + 1;
                    }
                });
            }).thenApply(unused -> counter[0]);
        }).whenComplete((o, throwable) -> mutationExecutor.release());
    }

    private CompletionStage<Boolean> processRow(Object key, PersistentCollection<?> collection, Object entry, int entryPosition, ReactiveMutationExecutor mutationExecutor, SharedSessionContractImplementor session) {
        PluralAttributeMapping attribute = this.getMutationTarget().getTargetPart();
        if (!collection.needsUpdating(entry, entryPosition, attribute)) {
            return CompletionStages.falseFuture();
        }
        this.rowMutationOperations.getUpdateRowValues().applyValues(collection, key, entry, entryPosition, session, mutationExecutor.getJdbcValueBindings());
        this.rowMutationOperations.getUpdateRowRestrictions().applyRestrictions(collection, key, entry, entryPosition, session, mutationExecutor.getJdbcValueBindings());
        return mutationExecutor.executeReactive(collection, null, null, null, session).thenCompose(ReactiveUpdateRowsCoordinatorStandard::alwaysTrue);
    }

    private static CompletionStage<Boolean> alwaysTrue(Object ignore) {
        return CompletionStages.trueFuture();
    }

    private ReactiveMutationExecutor reactiveMutationExecutor(SharedSessionContractImplementor session, MutationOperationGroup operationGroup) {
        MutationExecutorService mutationExecutorService = (MutationExecutorService)session.getFactory().getServiceRegistry().getService(MutationExecutorService.class);
        return (ReactiveMutationExecutor)mutationExecutorService.createExecutor(this::getBatchKey, operationGroup, session);
    }

    private BatchKey getBatchKey() {
        return new BasicBatchKey(this.getMutationTarget().getRolePath() + "#UPDATE");
    }
}

