/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.entity.mutation;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import org.hibernate.Internal;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.TableInclusionChecker;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.persister.entity.mutation.InsertCoordinator;
import org.hibernate.reactive.engine.jdbc.env.internal.ReactiveMutationExecutor;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.persister.entity.mutation.GeneratorValueUtil;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ValuesAnalysis;
import org.hibernate.tuple.entity.EntityMetamodel;

@Internal
public class ReactiveInsertCoordinator
extends InsertCoordinator {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public ReactiveInsertCoordinator(AbstractEntityPersister entityPersister, SessionFactoryImplementor factory) {
        super(entityPersister, factory);
    }

    public Object coordinateInsert(Object id, Object[] values, Object entity, SharedSessionContractImplementor session) {
        throw LOG.nonReactiveMethodCall("coordinateReactiveInsert");
    }

    public CompletionStage<Object> coordinateReactiveInsert(Object id, Object[] currentValues, Object entity, SharedSessionContractImplementor session) {
        return this.reactivePreInsertInMemoryValueGeneration(currentValues, entity, session).thenCompose(v -> this.entityPersister().getEntityMetamodel().isDynamicInsert() ? this.doDynamicInserts(id, currentValues, entity, session) : this.doStaticInserts(id, currentValues, entity, session));
    }

    private CompletionStage<Void> reactivePreInsertInMemoryValueGeneration(Object[] currentValues, Object entity, SharedSessionContractImplementor session) {
        CompletionStage<Void> stage = CompletionStages.voidFuture();
        EntityMetamodel entityMetamodel = this.entityPersister().getEntityMetamodel();
        if (entityMetamodel.hasPreInsertGeneratedValues()) {
            Generator[] generators = entityMetamodel.getGenerators();
            for (int i = 0; i < generators.length; ++i) {
                int index = i;
                Generator generator = generators[i];
                if (generator == null || generator.generatedOnExecution() || !generator.generatesOnInsert()) continue;
                Object currentValue = currentValues[i];
                BeforeExecutionGenerator beforeGenerator = (BeforeExecutionGenerator)generator;
                stage = stage.thenCompose(v -> GeneratorValueUtil.generateValue(session, entity, currentValue, beforeGenerator, EventType.INSERT).thenAccept(generatedValue -> {
                    currentValues[index] = generatedValue;
                    this.entityPersister().setPropertyValue(entity, index, generatedValue);
                }));
            }
        }
        return stage;
    }

    protected void decomposeForInsert(MutationExecutor mutationExecutor, Object id, Object[] values, MutationOperationGroup mutationGroup, boolean[] propertyInclusions, TableInclusionChecker tableInclusionChecker, SharedSessionContractImplementor session) {
        throw LOG.nonReactiveMethodCall("decomposeForReactiveInsert");
    }

    protected CompletionStage<Void> decomposeForReactiveInsert(MutationExecutor mutationExecutor, Object id, Object[] values, MutationOperationGroup mutationGroup, boolean[] propertyInclusions, TableInclusionChecker tableInclusionChecker, SharedSessionContractImplementor session) {
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        mutationGroup.forEachOperation((position, operation) -> {
            EntityTableMapping tableDetails = (EntityTableMapping)operation.getTableDetails();
            if (tableInclusionChecker.include((TableMapping)tableDetails)) {
                int[] attributeIndexes;
                for (int attributeIndex : attributeIndexes = tableDetails.getAttributeIndexes()) {
                    if (!propertyInclusions[attributeIndex]) continue;
                    AttributeMapping mapping = this.entityPersister().getAttributeMappings().get(attributeIndex);
                    this.decomposeAttribute(values[attributeIndex], session, jdbcValueBindings, mapping);
                }
            }
        });
        mutationGroup.forEachOperation((position, jdbcOperation) -> {
            if (id == null) {
                assert (this.entityPersister().getIdentityInsertDelegate() != null);
            } else {
                EntityTableMapping tableDetails = (EntityTableMapping)jdbcOperation.getTableDetails();
                this.breakDownJdbcValue(id, session, jdbcValueBindings, tableDetails);
            }
        });
        return CompletionStages.voidFuture();
    }

    protected CompletionStage<Object> doDynamicInserts(Object id, Object[] values, Object object, SharedSessionContractImplementor session) {
        boolean[] insertability = this.getPropertiesToInsert(values);
        MutationOperationGroup insertGroup = this.generateDynamicInsertSqlGroup(insertability);
        ReactiveMutationExecutor mutationExecutor = this.getReactiveMutationExecutor(session, insertGroup);
        InsertCoordinator.InsertValuesAnalysis insertValuesAnalysis = new InsertCoordinator.InsertValuesAnalysis((EntityMutationTarget)this.entityPersister(), values);
        TableInclusionChecker tableInclusionChecker = ReactiveInsertCoordinator.getTableInclusionChecker((InsertCoordinator.InsertValuesAnalysis)insertValuesAnalysis);
        return this.decomposeForReactiveInsert(mutationExecutor, id, values, insertGroup, insertability, tableInclusionChecker, session).thenCompose(v -> mutationExecutor.executeReactive(object, (ValuesAnalysis)insertValuesAnalysis, tableInclusionChecker, (statementDetails, affectedRowCount, batchPosition) -> {
            statementDetails.getExpectation().verifyOutcome(affectedRowCount, statementDetails.getStatement(), batchPosition, statementDetails.getSqlString());
            return true;
        }, session).whenComplete((o, t) -> mutationExecutor.release()));
    }

    protected CompletionStage<Object> doStaticInserts(Object id, Object[] values, Object object, SharedSessionContractImplementor session) {
        InsertCoordinator.InsertValuesAnalysis insertValuesAnalysis = new InsertCoordinator.InsertValuesAnalysis((EntityMutationTarget)this.entityPersister(), values);
        TableInclusionChecker tableInclusionChecker = ReactiveInsertCoordinator.getTableInclusionChecker((InsertCoordinator.InsertValuesAnalysis)insertValuesAnalysis);
        ReactiveMutationExecutor mutationExecutor = this.getReactiveMutationExecutor(session, this.getStaticInsertGroup());
        return this.decomposeForReactiveInsert(mutationExecutor, id, values, this.getStaticInsertGroup(), this.entityPersister().getPropertyInsertability(), tableInclusionChecker, session).thenCompose(v -> mutationExecutor.executeReactive(object, (ValuesAnalysis)insertValuesAnalysis, tableInclusionChecker, (statementDetails, affectedRowCount, batchPosition) -> {
            statementDetails.getExpectation().verifyOutcome(affectedRowCount, statementDetails.getStatement(), batchPosition, statementDetails.getSqlString());
            return true;
        }, session));
    }

    private ReactiveMutationExecutor getReactiveMutationExecutor(SharedSessionContractImplementor session, MutationOperationGroup operationGroup) {
        MutationExecutorService mutationExecutorService = (MutationExecutorService)session.getFactory().getServiceRegistry().getService(MutationExecutorService.class);
        return (ReactiveMutationExecutor)mutationExecutorService.createExecutor(() -> ((ReactiveInsertCoordinator)this).getInsertBatchKey(), operationGroup, session);
    }
}

