/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.pool.impl;

import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.SqlConnection;
import java.util.concurrent.CompletionStage;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.pool.ReactiveConnectionPool;
import org.hibernate.reactive.pool.impl.SqlClientConnection;

public abstract class SqlClientPool
implements ReactiveConnectionPool {
    protected abstract Pool getPool();

    protected abstract SqlStatementLogger getSqlStatementLogger();

    protected abstract SqlExceptionHelper getSqlExceptionHelper();

    protected Pool getTenantPool(String tenantId) {
        throw new UnsupportedOperationException("multitenancy not supported by built-in SqlClientPool");
    }

    @Override
    public CompletionStage<ReactiveConnection> getConnection() {
        return this.getConnectionFromPool(this.getPool());
    }

    @Override
    public CompletionStage<ReactiveConnection> getConnection(SqlExceptionHelper sqlExceptionHelper) {
        return this.getConnectionFromPool(this.getPool(), sqlExceptionHelper);
    }

    @Override
    public CompletionStage<ReactiveConnection> getConnection(String tenantId) {
        return this.getConnectionFromPool(this.getTenantPool(tenantId));
    }

    @Override
    public CompletionStage<ReactiveConnection> getConnection(String tenantId, SqlExceptionHelper sqlExceptionHelper) {
        return this.getConnectionFromPool(this.getTenantPool(tenantId), sqlExceptionHelper);
    }

    private CompletionStage<ReactiveConnection> getConnectionFromPool(Pool pool) {
        return pool.getConnection().toCompletionStage().thenApply(this::newConnection);
    }

    private CompletionStage<ReactiveConnection> getConnectionFromPool(Pool pool, SqlExceptionHelper sqlExceptionHelper) {
        return pool.getConnection().toCompletionStage().thenApply(sqlConnection -> this.newConnection((SqlConnection)sqlConnection, sqlExceptionHelper));
    }

    private SqlClientConnection newConnection(SqlConnection connection) {
        return this.newConnection(connection, this.getSqlExceptionHelper());
    }

    private SqlClientConnection newConnection(SqlConnection connection, SqlExceptionHelper sqlExceptionHelper) {
        return new SqlClientConnection(connection, this.getPool(), this.getSqlStatementLogger(), sqlExceptionHelper);
    }
}

