/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.provider;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.spi.LoadState;
import jakarta.persistence.spi.PersistenceProvider;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.ProviderUtil;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.boot.internal.PersistenceUnitInfoDescriptor;
import org.hibernate.jpa.boot.internal.PersistenceXmlParser;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.jpa.internal.util.PersistenceUtilHelper;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.provider.impl.ReactiveEntityManagerFactoryBuilder;
import org.hibernate.reactive.provider.impl.ReactiveProviderChecker;

public class ReactivePersistenceProvider
implements PersistenceProvider {
    private static final Log log = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final PersistenceUtilHelper.MetadataCache cache = new PersistenceUtilHelper.MetadataCache();
    private final ProviderUtil providerUtil = new ProviderUtil(){

        public LoadState isLoadedWithoutReference(Object proxy, String property) {
            return PersistenceUtilHelper.isLoadedWithoutReference((Object)proxy, (String)property, (PersistenceUtilHelper.MetadataCache)ReactivePersistenceProvider.this.cache);
        }

        public LoadState isLoadedWithReference(Object proxy, String property) {
            return PersistenceUtilHelper.isLoadedWithReference((Object)proxy, (String)property, (PersistenceUtilHelper.MetadataCache)ReactivePersistenceProvider.this.cache);
        }

        public LoadState isLoaded(Object o) {
            return PersistenceUtilHelper.isLoaded((Object)o);
        }
    };

    public EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map properties) {
        log.tracef("Starting createEntityManagerFactory for persistenceUnitName %s", persistenceUnitName);
        Map immutableProperties = ReactivePersistenceProvider.immutable(properties);
        EntityManagerFactoryBuilder builder = this.getEntityManagerFactoryBuilderOrNull(persistenceUnitName, immutableProperties);
        if (builder == null) {
            log.trace("Could not obtain matching EntityManagerFactoryBuilder, returning null");
            return null;
        }
        return builder.build();
    }

    protected EntityManagerFactoryBuilder getEntityManagerFactoryBuilderOrNull(String persistenceUnitName, Map properties) {
        List units;
        log.tracef("Attempting to obtain correct EntityManagerFactoryBuilder for persistenceUnitName : %s", persistenceUnitName);
        try {
            units = PersistenceXmlParser.locatePersistenceUnits((Map)properties);
        }
        catch (Exception e) {
            throw log.unableToLocatePersistenceUnits(e);
        }
        log.debugf("Located and parsed %s persistence units; checking each", units.size());
        if (persistenceUnitName == null && units.size() > 1) {
            throw log.noNameProvidedAndMultiplePersistenceUnitsFound();
        }
        for (ParsedPersistenceXmlDescriptor persistenceUnit : units) {
            boolean matches;
            log.debugf("Checking persistence-unit [name=%s, explicit-provider=%s] against incoming persistence unit name [%s]", persistenceUnit.getName(), persistenceUnit.getProviderClassName(), persistenceUnitName);
            boolean bl = matches = persistenceUnitName == null || persistenceUnit.getName().equals(persistenceUnitName);
            if (!matches) {
                log.debug("Excluding from consideration due to name mis-match");
                continue;
            }
            if (!ReactiveProviderChecker.isProvider((PersistenceUnitDescriptor)persistenceUnit, properties)) {
                log.debug("Excluding from consideration due to provider mis-match");
                continue;
            }
            return this.getEntityManagerFactoryBuilder((PersistenceUnitDescriptor)persistenceUnit, properties);
        }
        log.debug("Found no matching persistence units");
        return null;
    }

    private static Map immutable(Map properties) {
        return properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(properties);
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map properties) {
        log.tracef("Starting createContainerEntityManagerFactory : %s", info.getPersistenceUnitName());
        return this.getEntityManagerFactoryBuilder(info, properties).build();
    }

    public void generateSchema(PersistenceUnitInfo info, Map map) {
        log.tracef("Starting generateSchema : PUI.name=%s", info.getPersistenceUnitName());
        EntityManagerFactoryBuilder builder = this.getEntityManagerFactoryBuilder(info, map);
        builder.generateSchema();
    }

    public boolean generateSchema(String persistenceUnitName, Map map) {
        log.tracef("Starting generateSchema for persistenceUnitName %s", persistenceUnitName);
        EntityManagerFactoryBuilder builder = this.getEntityManagerFactoryBuilderOrNull(persistenceUnitName, map);
        if (builder == null) {
            log.trace("Could not obtain matching EntityManagerFactoryBuilder, returning false");
            return false;
        }
        builder.generateSchema();
        return true;
    }

    protected EntityManagerFactoryBuilder getEntityManagerFactoryBuilder(PersistenceUnitInfo info, Map integration) {
        return this.getEntityManagerFactoryBuilder((PersistenceUnitDescriptor)new PersistenceUnitInfoDescriptor(info), integration);
    }

    protected EntityManagerFactoryBuilder getEntityManagerFactoryBuilder(PersistenceUnitDescriptor persistenceUnitDescriptor, Map integration) {
        return new ReactiveEntityManagerFactoryBuilder(persistenceUnitDescriptor, integration);
    }

    public ProviderUtil getProviderUtil() {
        return this.providerUtil;
    }
}

