/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.provider.impl;

import java.util.Map;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.jpa.boot.spi.ProviderChecker;
import org.hibernate.reactive.provider.ReactivePersistenceProvider;
import org.jboss.logging.Logger;

public final class ReactiveProviderChecker {
    private static final Logger log = Logger.getLogger(ProviderChecker.class);
    private static final String IMPLEMENTATION_NAME = ReactivePersistenceProvider.class.getName();

    public static boolean isProvider(PersistenceUnitDescriptor persistenceUnit, Map integration) {
        return ReactiveProviderChecker.hibernateProviderNamesContain(ReactiveProviderChecker.extractRequestedProviderName(persistenceUnit, integration));
    }

    public static boolean hibernateProviderNamesContain(String requestedProviderName) {
        if (requestedProviderName == null) {
            return false;
        }
        log.tracef("Checking requested PersistenceProvider name [%s] against Hibernate provider names", (Object)requestedProviderName);
        return IMPLEMENTATION_NAME.equalsIgnoreCase(requestedProviderName);
    }

    public static String extractRequestedProviderName(PersistenceUnitDescriptor persistenceUnit, Map integration) {
        String integrationProviderName = ReactiveProviderChecker.extractProviderName(integration);
        if (integrationProviderName != null) {
            log.debugf("Integration provided explicit PersistenceProvider [%s]", (Object)integrationProviderName);
            return integrationProviderName;
        }
        String persistenceUnitRequestedProvider = ReactiveProviderChecker.extractProviderName(persistenceUnit);
        if (persistenceUnitRequestedProvider != null) {
            log.debugf("Persistence-unit [%s] requested PersistenceProvider [%s]", (Object)persistenceUnit.getName(), (Object)persistenceUnitRequestedProvider);
            return persistenceUnitRequestedProvider;
        }
        log.debug((Object)"No PersistenceProvider explicitly requested");
        return null;
    }

    private static String extractProviderName(Map integration) {
        if (integration == null) {
            return null;
        }
        String setting = (String)integration.get("javax.persistence.provider");
        return setting == null ? null : setting.trim();
    }

    private static String extractProviderName(PersistenceUnitDescriptor persistenceUnit) {
        String persistenceUnitRequestedProvider = persistenceUnit.getProviderClassName();
        return persistenceUnitRequestedProvider == null ? null : persistenceUnitRequestedProvider.trim();
    }

    private ReactiveProviderChecker() {
    }
}

