/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.TemporalType;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.query.BindableType;
import org.hibernate.query.CommonQueryContract;
import org.hibernate.query.QueryParameter;

public interface ReactiveSelectionQuery<R>
extends CommonQueryContract {
    public String getQueryString();

    default public CompletionStage<List<R>> getReactiveResultList() {
        return this.reactiveList();
    }

    public CompletionStage<List<R>> reactiveList();

    public CompletionStage<R> getReactiveSingleResult();

    public CompletionStage<R> getReactiveSingleResultOrNull();

    public CompletionStage<R> reactiveUnique();

    public CompletionStage<Optional<R>> reactiveUniqueResultOptional();

    public ReactiveSelectionQuery<R> setHint(String var1, Object var2);

    public ReactiveSelectionQuery<R> setFlushMode(FlushModeType var1);

    public ReactiveSelectionQuery<R> setHibernateFlushMode(FlushMode var1);

    public ReactiveSelectionQuery<R> setTimeout(int var1);

    public Integer getFetchSize();

    public ReactiveSelectionQuery<R> setFetchSize(int var1);

    public boolean isReadOnly();

    public ReactiveSelectionQuery<R> setReadOnly(boolean var1);

    public ReactiveSelectionQuery<R> setMaxResults(int var1);

    public int getFirstResult();

    public int getMaxResults();

    public ReactiveSelectionQuery<R> setFirstResult(int var1);

    public CacheMode getCacheMode();

    public CacheStoreMode getCacheStoreMode();

    public CacheRetrieveMode getCacheRetrieveMode();

    public ReactiveSelectionQuery<R> setCacheMode(CacheMode var1);

    public ReactiveSelectionQuery<R> setCacheStoreMode(CacheStoreMode var1);

    public ReactiveSelectionQuery<R> setCacheRetrieveMode(CacheRetrieveMode var1);

    public boolean isCacheable();

    public ReactiveSelectionQuery<R> setCacheable(boolean var1);

    public String getCacheRegion();

    public ReactiveSelectionQuery<R> setCacheRegion(String var1);

    public LockOptions getLockOptions();

    public LockModeType getLockMode();

    public ReactiveSelectionQuery<R> setLockMode(LockModeType var1);

    public LockMode getHibernateLockMode();

    public ReactiveSelectionQuery<R> setHibernateLockMode(LockMode var1);

    public ReactiveSelectionQuery<R> setLockMode(String var1, LockMode var2);

    public ReactiveSelectionQuery<R> setAliasSpecificLockMode(String var1, LockMode var2);

    public ReactiveSelectionQuery<R> setFollowOnLocking(boolean var1);

    public void applyGraph(RootGraphImplementor<?> var1, GraphSemantic var2);

    public ReactiveSelectionQuery<R> setParameter(String var1, Object var2);

    public <P> ReactiveSelectionQuery<R> setParameter(String var1, P var2, Class<P> var3);

    public <P> ReactiveSelectionQuery<R> setParameter(String var1, P var2, BindableType<P> var3);

    public ReactiveSelectionQuery<R> setParameter(String var1, Instant var2, TemporalType var3);

    public ReactiveSelectionQuery<R> setParameter(String var1, Calendar var2, TemporalType var3);

    public ReactiveSelectionQuery<R> setParameter(String var1, Date var2, TemporalType var3);

    public ReactiveSelectionQuery<R> setParameter(int var1, Object var2);

    public <P> ReactiveSelectionQuery<R> setParameter(int var1, P var2, Class<P> var3);

    public <P> ReactiveSelectionQuery<R> setParameter(int var1, P var2, BindableType<P> var3);

    public ReactiveSelectionQuery<R> setParameter(int var1, Instant var2, TemporalType var3);

    public ReactiveSelectionQuery<R> setParameter(int var1, Date var2, TemporalType var3);

    public ReactiveSelectionQuery<R> setParameter(int var1, Calendar var2, TemporalType var3);

    public <T> ReactiveSelectionQuery<R> setParameter(QueryParameter<T> var1, T var2);

    public <P> ReactiveSelectionQuery<R> setParameter(QueryParameter<P> var1, P var2, Class<P> var3);

    public <P> ReactiveSelectionQuery<R> setParameter(QueryParameter<P> var1, P var2, BindableType<P> var3);

    public <T> ReactiveSelectionQuery<R> setParameter(Parameter<T> var1, T var2);

    public ReactiveSelectionQuery<R> setParameter(Parameter<Calendar> var1, Calendar var2, TemporalType var3);

    public ReactiveSelectionQuery<R> setParameter(Parameter<Date> var1, Date var2, TemporalType var3);

    public ReactiveSelectionQuery<R> setParameterList(String var1, Collection var2);

    public <P> ReactiveSelectionQuery<R> setParameterList(String var1, Collection<? extends P> var2, Class<P> var3);

    public <P> ReactiveSelectionQuery<R> setParameterList(String var1, Collection<? extends P> var2, BindableType<P> var3);

    public ReactiveSelectionQuery<R> setParameterList(String var1, Object[] var2);

    public <P> ReactiveSelectionQuery<R> setParameterList(String var1, P[] var2, Class<P> var3);

    public <P> ReactiveSelectionQuery<R> setParameterList(String var1, P[] var2, BindableType<P> var3);

    public ReactiveSelectionQuery<R> setParameterList(int var1, Collection var2);

    public <P> ReactiveSelectionQuery<R> setParameterList(int var1, Collection<? extends P> var2, Class<P> var3);

    public <P> ReactiveSelectionQuery<R> setParameterList(int var1, Collection<? extends P> var2, BindableType<P> var3);

    public ReactiveSelectionQuery<R> setParameterList(int var1, Object[] var2);

    public <P> ReactiveSelectionQuery<R> setParameterList(int var1, P[] var2, Class<P> var3);

    public <P> ReactiveSelectionQuery<R> setParameterList(int var1, P[] var2, BindableType<P> var3);

    public <P> ReactiveSelectionQuery<R> setParameterList(QueryParameter<P> var1, Collection<? extends P> var2);

    public <P> ReactiveSelectionQuery<R> setParameterList(QueryParameter<P> var1, Collection<? extends P> var2, Class<P> var3);

    public <P> ReactiveSelectionQuery<R> setParameterList(QueryParameter<P> var1, Collection<? extends P> var2, BindableType<P> var3);

    public <P> ReactiveSelectionQuery<R> setParameterList(QueryParameter<P> var1, P[] var2);

    public <P> ReactiveSelectionQuery<R> setParameterList(QueryParameter<P> var1, P[] var2, Class<P> var3);

    public <P> ReactiveSelectionQuery<R> setParameterList(QueryParameter<P> var1, P[] var2, BindableType<P> var3);

    public ReactiveSelectionQuery<R> setProperties(Object var1);

    public ReactiveSelectionQuery<R> setProperties(Map var1);
}

