/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sql.spi;

import java.util.Map;
import java.util.Objects;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.criteria.internal.NamedCriteriaQueryMementoImpl;
import org.hibernate.query.hql.internal.NamedHqlQueryMementoImpl;
import org.hibernate.query.hql.spi.SqmQueryImplementor;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.SqmSelectionQuery;
import org.hibernate.query.sqm.spi.NamedSqmQueryMemento;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.reactive.query.sqm.internal.ReactiveQuerySqmImpl;
import org.hibernate.reactive.query.sqm.internal.ReactiveSqmSelectionQueryImpl;

public class ReactiveNamedSqmQueryMemento
implements NamedSqmQueryMemento {
    private final NamedSqmQueryMemento delegate;

    public ReactiveNamedSqmQueryMemento(NamedSqmQueryMemento delegate) {
        Objects.requireNonNull(delegate);
        this.delegate = delegate;
    }

    public <T> SqmQueryImplementor<T> toQuery(SharedSessionContractImplementor session) {
        return this.toQuery(session, null);
    }

    public <T> SqmQueryImplementor<T> toQuery(SharedSessionContractImplementor session, Class<T> resultType) {
        if (this.delegate instanceof NamedHqlQueryMementoImpl) {
            return new ReactiveQuerySqmImpl<T>((NamedHqlQueryMementoImpl)this.delegate, resultType, session);
        }
        if (this.delegate instanceof NamedCriteriaQueryMementoImpl) {
            return new ReactiveQuerySqmImpl<T>((NamedCriteriaQueryMementoImpl)this.delegate, resultType, session);
        }
        throw new UnsupportedOperationException("NamedSqmQueryMemento not recognized: " + this.delegate.getClass());
    }

    public <T> SqmSelectionQuery<T> toSelectionQuery(Class<T> resultType, SharedSessionContractImplementor session) {
        SqmSelectionQuery selectionQuery = this.delegate.toSelectionQuery(resultType, session);
        if (selectionQuery == null) {
            return null;
        }
        SqmSelectStatement statement = (SqmSelectStatement)selectionQuery.getSqmStatement();
        return new ReactiveSqmSelectionQueryImpl<T>(statement, resultType, session);
    }

    public String getHqlString() {
        return this.delegate.getHqlString();
    }

    public SqmStatement<?> getSqmStatement() {
        return this.delegate.getSqmStatement();
    }

    public Integer getFirstResult() {
        return this.delegate.getFirstResult();
    }

    public Integer getMaxResults() {
        return this.delegate.getMaxResults();
    }

    public LockOptions getLockOptions() {
        return this.delegate.getLockOptions();
    }

    public Map<String, String> getParameterTypes() {
        return this.delegate.getParameterTypes();
    }

    public NamedSqmQueryMemento makeCopy(String name) {
        return new ReactiveNamedSqmQueryMemento(this.delegate.makeCopy(name));
    }

    public String getRegistrationName() {
        return this.delegate.getRegistrationName();
    }

    public Boolean getCacheable() {
        return this.delegate.getCacheable();
    }

    public String getCacheRegion() {
        return this.delegate.getCacheRegion();
    }

    public CacheMode getCacheMode() {
        return this.delegate.getCacheMode();
    }

    public FlushMode getFlushMode() {
        return this.delegate.getFlushMode();
    }

    public Boolean getReadOnly() {
        return this.delegate.getReadOnly();
    }

    public Integer getTimeout() {
        return this.delegate.getTimeout();
    }

    public Integer getFetchSize() {
        return this.delegate.getFetchSize();
    }

    public String getComment() {
        return this.delegate.getComment();
    }

    public Map<String, Object> getHints() {
        return this.delegate.getHints();
    }

    public void validate(QueryEngine queryEngine) {
        this.delegate.validate(queryEngine);
    }
}

