/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sqm.mutation.internal.temptable;

import java.lang.invoke.MethodHandles;
import java.sql.PreparedStatement;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableColumn;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.StatementPreparer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.BeforeUseAction;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.query.sqm.mutation.internal.temptable.ReactiveTemporaryTableHelper;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveJdbcMutationExecutor;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQueryInsert;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.internal.SqlSelectionImpl;

public final class ReactiveExecuteWithTemporaryTableHelper {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    private ReactiveExecuteWithTemporaryTableHelper() {
    }

    public static CompletionStage<Integer> saveMatchingIdsIntoIdTable(MultiTableSqmMutationConverter sqmConverter, Predicate suppliedPredicate, TemporaryTable idTable, Function<SharedSessionContractImplementor, String> sessionUidAccess, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        TableGroup mutatingTableGroup = sqmConverter.getMutatingTableGroup();
        assert (mutatingTableGroup.getModelPart() instanceof EntityMappingType);
        EntityMappingType mutatingEntityDescriptor = (EntityMappingType)mutatingTableGroup.getModelPart();
        NamedTableReference idTableReference = new NamedTableReference(idTable.getTableExpression(), "to_insert_");
        InsertSelectStatement idTableInsert = new InsertSelectStatement(idTableReference);
        for (int i = 0; i < idTable.getColumns().size(); ++i) {
            TemporaryTableColumn column = (TemporaryTableColumn)idTable.getColumns().get(i);
            idTableInsert.addTargetColumnReferences(new ColumnReference[]{new ColumnReference((TableReference)idTableReference, column.getColumnName(), false, null, column.getJdbcMapping())});
        }
        QuerySpec matchingIdSelection = new QuerySpec(true, 1);
        idTableInsert.setSourceSelectStatement((QueryPart)matchingIdSelection);
        matchingIdSelection.getFromClause().addRoot(mutatingTableGroup);
        mutatingEntityDescriptor.getIdentifierMapping().forEachSelectable((selectionIndex, selection) -> {
            TableReference tableReference = mutatingTableGroup.resolveTableReference(mutatingTableGroup.getNavigablePath(), selection.getContainingTableExpression());
            matchingIdSelection.getSelectClause().addSqlSelection((SqlSelection)new SqlSelectionImpl(selectionIndex + 1, sqmConverter.getSqlExpressionResolver().resolveSqlExpression(tableReference, selection)));
        });
        if (idTable.getSessionUidColumn() != null) {
            int jdbcPosition = matchingIdSelection.getSelectClause().getSqlSelections().size();
            matchingIdSelection.getSelectClause().addSqlSelection((SqlSelection)new SqlSelectionImpl(jdbcPosition, (Expression)new QueryLiteral((Object)UUID.fromString(sessionUidAccess.apply(executionContext.getSession())), (BasicValuedMapping)idTable.getSessionUidColumn().getJdbcMapping())));
        }
        matchingIdSelection.applyPredicate(suppliedPredicate);
        return ReactiveExecuteWithTemporaryTableHelper.saveIntoTemporaryTable(idTableInsert, jdbcParameterBindings, executionContext);
    }

    public static CompletionStage<Integer> saveIntoTemporaryTable(InsertSelectStatement temporaryTableInsert, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        LockOptions lockOptions = executionContext.getQueryOptions().getLockOptions();
        LockMode lockMode = lockOptions.getLockMode();
        lockOptions.setLockMode(LockMode.WRITE);
        if (temporaryTableInsert.getSourceSelectStatement() != null && !jdbcEnvironment.getDialect().supportsOuterJoinForUpdate()) {
            temporaryTableInsert.getSourceSelectStatement().visitQuerySpecs(querySpec -> querySpec.getFromClause().visitTableJoins(tableJoin -> {
                if (tableJoin.getJoinType() != SqlAstJoinType.INNER) {
                    lockOptions.setLockMode(lockMode);
                }
            }));
        }
        JdbcOperationQueryInsert jdbcInsert = (JdbcOperationQueryInsert)sqlAstTranslatorFactory.buildInsertTranslator(factory, (InsertStatement)temporaryTableInsert).translate(jdbcParameterBindings, executionContext.getQueryOptions());
        lockOptions.setLockMode(lockMode);
        return StandardReactiveJdbcMutationExecutor.INSTANCE.executeReactive((JdbcOperationQueryMutation)jdbcInsert, jdbcParameterBindings, arg_0 -> ((StatementPreparer)executionContext.getSession().getJdbcCoordinator().getStatementPreparer()).prepareStatement(arg_0), ReactiveExecuteWithTemporaryTableHelper::doNothing, executionContext);
    }

    public static QuerySpec createIdTableSelectQuerySpec(TemporaryTable idTable, Function<SharedSessionContractImplementor, String> sessionUidAccess, EntityMappingType entityDescriptor, ExecutionContext executionContext) {
        return ReactiveExecuteWithTemporaryTableHelper.createIdTableSelectQuerySpec(idTable, null, sessionUidAccess, entityDescriptor, executionContext);
    }

    public static QuerySpec createIdTableSelectQuerySpec(TemporaryTable idTable, ModelPart fkModelPart, Function<SharedSessionContractImplementor, String> sessionUidAccess, EntityMappingType entityDescriptor, ExecutionContext executionContext) {
        QuerySpec querySpec = new QuerySpec(false);
        NamedTableReference idTableReference = new NamedTableReference(idTable.getTableExpression(), "temptable_", true);
        StandardTableGroup idTableGroup = new StandardTableGroup(true, new NavigablePath(idTableReference.getTableExpression()), (TableGroupProducer)entityDescriptor, null, (TableReference)idTableReference, null, executionContext.getSession().getFactory());
        querySpec.getFromClause().addRoot((TableGroup)idTableGroup);
        ReactiveExecuteWithTemporaryTableHelper.applyIdTableSelections(querySpec, (TableReference)idTableReference, idTable, fkModelPart, executionContext);
        ReactiveExecuteWithTemporaryTableHelper.applyIdTableRestrictions(querySpec, (TableReference)idTableReference, idTable, sessionUidAccess, executionContext);
        return querySpec;
    }

    private static void applyIdTableSelections(QuerySpec querySpec, TableReference tableReference, TemporaryTable idTable, ModelPart fkModelPart, ExecutionContext executionContext) {
        if (fkModelPart == null) {
            int size = idTable.getEntityDescriptor().getIdentifierMapping().getJdbcTypeCount();
            for (int i2 = 0; i2 < size; ++i2) {
                TemporaryTableColumn temporaryTableColumn = (TemporaryTableColumn)idTable.getColumns().get(i2);
                if (temporaryTableColumn == idTable.getSessionUidColumn()) continue;
                querySpec.getSelectClause().addSqlSelection((SqlSelection)new SqlSelectionImpl(i2, (Expression)new ColumnReference(tableReference, temporaryTableColumn.getColumnName(), false, null, temporaryTableColumn.getJdbcMapping())));
            }
        } else {
            fkModelPart.forEachSelectable((i, selectableMapping) -> querySpec.getSelectClause().addSqlSelection((SqlSelection)new SqlSelectionImpl(i, (Expression)new ColumnReference(tableReference, selectableMapping.getSelectionExpression(), false, null, selectableMapping.getJdbcMapping()))));
        }
    }

    private static void applyIdTableRestrictions(QuerySpec querySpec, TableReference idTableReference, TemporaryTable idTable, Function<SharedSessionContractImplementor, String> sessionUidAccess, ExecutionContext executionContext) {
        if (idTable.getSessionUidColumn() != null) {
            querySpec.applyPredicate((Predicate)new ComparisonPredicate((Expression)new ColumnReference(idTableReference, idTable.getSessionUidColumn().getColumnName(), false, null, idTable.getSessionUidColumn().getJdbcMapping()), ComparisonOperator.EQUAL, (Expression)new QueryLiteral((Object)UUID.fromString(sessionUidAccess.apply(executionContext.getSession())), (BasicValuedMapping)idTable.getSessionUidColumn().getJdbcMapping())));
        }
    }

    public static CompletionStage<Void> performBeforeTemporaryTableUseActions(TemporaryTable temporaryTable, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        Dialect dialect = factory.getJdbcServices().getDialect();
        if (dialect.getTemporaryTableBeforeUseAction() == BeforeUseAction.CREATE) {
            ReactiveTemporaryTableHelper.TemporaryTableCreationWork temporaryTableCreationWork = new ReactiveTemporaryTableHelper.TemporaryTableCreationWork(temporaryTable, factory);
            TempTableDdlTransactionHandling ddlTransactionHandling = dialect.getTemporaryTableDdlTransactionHandling();
            if (ddlTransactionHandling == TempTableDdlTransactionHandling.NONE) {
                return temporaryTableCreationWork.reactiveExecute(((ReactiveConnectionSupplier)executionContext.getSession()).getReactiveConnection());
            }
            throw LOG.notYetImplemented();
        }
        return CompletionStages.voidFuture();
    }

    public static CompletionStage<Void> performAfterTemporaryTableUseActions(TemporaryTable temporaryTable, Function<SharedSessionContractImplementor, String> sessionUidAccess, AfterUseAction afterUseAction, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        Dialect dialect = factory.getJdbcServices().getDialect();
        switch (afterUseAction) {
            case CLEAN: {
                return ReactiveTemporaryTableHelper.cleanTemporaryTableRows(temporaryTable, dialect.getTemporaryTableExporter(), sessionUidAccess, executionContext.getSession());
            }
            case DROP: {
                return ReactiveExecuteWithTemporaryTableHelper.dropAction(temporaryTable, executionContext, factory, dialect);
            }
        }
        return CompletionStages.voidFuture();
    }

    private static CompletionStage<Void> dropAction(TemporaryTable temporaryTable, ExecutionContext executionContext, SessionFactoryImplementor factory, Dialect dialect) {
        TempTableDdlTransactionHandling ddlTransactionHandling = dialect.getTemporaryTableDdlTransactionHandling();
        if (ddlTransactionHandling == TempTableDdlTransactionHandling.NONE) {
            return new ReactiveTemporaryTableHelper.TemporaryTableDropWork(temporaryTable, factory).reactiveExecute(((ReactiveConnectionSupplier)executionContext.getSession()).getReactiveConnection());
        }
        throw LOG.notYetImplemented();
    }

    private static void doNothing(Integer integer, PreparedStatement preparedStatement) {
    }
}

