/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sqm.mutation.internal.temptable;

import java.util.concurrent.CompletionStage;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.reactive.query.sqm.mutation.internal.temptable.ReactiveTableBasedInsertHandler;
import org.hibernate.reactive.query.sqm.mutation.spi.ReactiveSqmMultiTableInsertStrategy;

public class ReactiveLocalTemporaryTableInsertStrategy
extends LocalTemporaryTableInsertStrategy
implements ReactiveSqmMultiTableInsertStrategy {
    public ReactiveLocalTemporaryTableInsertStrategy(LocalTemporaryTableInsertStrategy insertStrategy) {
        super(insertStrategy.getTemporaryTable(), insertStrategy.getSessionFactory());
    }

    @Override
    public CompletionStage<Integer> reactiveExecuteInsert(SqmInsertStatement<?> sqmInsertStatement, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        return new ReactiveTableBasedInsertHandler(sqmInsertStatement, domainParameterXref, this.getTemporaryTable(), this.afterUserAction(), ReactiveLocalTemporaryTableInsertStrategy::throwUnexpectedCallToSessionUIDError, this.getSessionFactory()).reactiveExecute(context);
    }

    private static String throwUnexpectedCallToSessionUIDError(SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException("Unexpected call to access Session uid");
    }

    private AfterUseAction afterUserAction() {
        return this.isDropIdTables() ? AfterUseAction.DROP : this.getSessionFactory().getJdbcServices().getDialect().getTemporaryTableAfterUseAction();
    }
}

