/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sqm.mutation.internal.temptable;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.temptable.PersistentTableInsertStrategy;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.reactive.query.sqm.mutation.internal.temptable.ReactivePersistentTableStrategy;
import org.hibernate.reactive.query.sqm.mutation.internal.temptable.ReactiveTableBasedInsertHandler;
import org.hibernate.reactive.query.sqm.mutation.spi.ReactiveSqmMultiTableInsertStrategy;

public class ReactivePersistentTableInsertStrategy
extends PersistentTableInsertStrategy
implements ReactivePersistentTableStrategy,
ReactiveSqmMultiTableInsertStrategy {
    private final CompletableFuture<Void> tableCreatedStage = new CompletableFuture();
    private final CompletableFuture<Void> tableDroppedStage = new CompletableFuture();
    private boolean prepared;
    private boolean dropIdTables;

    public ReactivePersistentTableInsertStrategy(PersistentTableInsertStrategy strategy) {
        super(strategy.getTemporaryTable(), strategy.getSessionFactory());
    }

    public void prepare(MappingModelCreationProcess mappingModelCreationProcess, JdbcConnectionAccess connectionAccess) {
        this.prepare(mappingModelCreationProcess, connectionAccess, this.tableCreatedStage);
    }

    public void release(SessionFactoryImplementor sessionFactory, JdbcConnectionAccess connectionAccess) {
        this.release(sessionFactory, connectionAccess, this.tableDroppedStage);
    }

    @Override
    public CompletionStage<Integer> reactiveExecuteInsert(SqmInsertStatement<?> sqmInsertStatement, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        return this.tableCreatedStage.thenCompose(v -> new ReactiveTableBasedInsertHandler(sqmInsertStatement, domainParameterXref, this.getTemporaryTable(), this.getSessionFactory().getJdbcServices().getDialect().getTemporaryTableAfterUseAction(), ReactivePersistentTableStrategy::sessionIdentifier, this.getSessionFactory()).reactiveExecute(context));
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    @Override
    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
    }

    @Override
    public boolean isDropIdTables() {
        return this.dropIdTables;
    }

    @Override
    public void setDropIdTables(boolean dropIdTables) {
        this.dropIdTables = dropIdTables;
    }

    @Override
    public CompletionStage<Void> getDropTableActionStage() {
        return this.tableDroppedStage;
    }

    @Override
    public CompletionStage<Void> getCreateTableActionStage() {
        return this.tableCreatedStage;
    }
}

