/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sqm.mutation.internal.temptable;

import java.lang.invoke.MethodHandles;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.StatementPreparer;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.UpdateExecutionDelegate;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.query.sqm.mutation.internal.temptable.ReactiveExecuteWithTemporaryTableHelper;
import org.hibernate.reactive.query.sqm.mutation.internal.temptable.ReactiveTableBasedUpdateHandler;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveJdbcMutationExecutor;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.predicate.ExistsPredicate;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQueryInsert;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcOperationQueryUpdate;
import org.hibernate.sql.results.internal.SqlSelectionImpl;

public class ReactiveUpdateExecutionDelegate
extends UpdateExecutionDelegate
implements ReactiveTableBasedUpdateHandler.ReactiveExecutionDelegate {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public ReactiveUpdateExecutionDelegate(MultiTableSqmMutationConverter sqmConverter, TemporaryTable idTable, AfterUseAction afterUseAction, Function<SharedSessionContractImplementor, String> sessionUidAccess, DomainParameterXref domainParameterXref, TableGroup updatingTableGroup, Map<String, TableReference> tableReferenceByAlias, List<Assignment> assignments, Predicate suppliedPredicate, Map<SqmParameter<?>, List<List<JdbcParameter>>> parameterResolutions, Map<SqmParameter<?>, MappingModelExpressible<?>> paramTypeResolutions, DomainQueryExecutionContext executionContext) {
        super(sqmConverter, idTable, afterUseAction, sessionUidAccess, domainParameterXref, updatingTableGroup, tableReferenceByAlias, assignments, suppliedPredicate, parameterResolutions, paramTypeResolutions, executionContext);
    }

    private static void doNothing(Integer integer, PreparedStatement preparedStatement) {
    }

    @Override
    public int execute(ExecutionContext executionContext) {
        throw LOG.nonReactiveMethodCall("reactiveExecute");
    }

    @Override
    public CompletionStage<Integer> reactiveExecute(ExecutionContext executionContext) {
        return ReactiveExecuteWithTemporaryTableHelper.performBeforeTemporaryTableUseActions(this.getIdTable(), executionContext).thenCompose(v -> ReactiveExecuteWithTemporaryTableHelper.saveMatchingIdsIntoIdTable(this.getSqmConverter(), this.getSuppliedPredicate(), this.getIdTable(), this.getSessionUidAccess(), this.getJdbcParameterBindings(), executionContext)).thenCompose(rows -> {
            QuerySpec idTableSubQuery = ReactiveExecuteWithTemporaryTableHelper.createIdTableSelectQuerySpec(this.getIdTable(), this.getSessionUidAccess(), this.getEntityDescriptor(), executionContext);
            CompletionStage[] resultStage = new CompletionStage[]{CompletionStages.voidFuture()};
            this.getEntityDescriptor().visitConstraintOrderedTables((tableExpression, tableKeyColumnVisitationSupplier) -> {
                resultStage[0] = resultStage[0].thenCompose(arg_0 -> this.lambda$reactiveExecute$1(tableExpression, (Supplier)tableKeyColumnVisitationSupplier, rows, idTableSubQuery, executionContext, arg_0));
            });
            return resultStage[0].thenApply(v -> rows);
        }).handle(CompletionStages::handle).thenCompose(handler -> ReactiveExecuteWithTemporaryTableHelper.performAfterTemporaryTableUseActions(this.getIdTable(), this.getSessionUidAccess(), this.getAfterUseAction(), executionContext).thenCompose(handler::getResultAsCompletionStage));
    }

    private CompletionStage<Void> reactiveUpdateTable(String tableExpression, Supplier<Consumer<SelectableConsumer>> tableKeyColumnVisitationSupplier, int expectedUpdateCount, QuerySpec idTableSubQuery, ExecutionContext executionContext) {
        TableReference updatingTableReference = this.getUpdatingTableGroup().getTableReference(this.getUpdatingTableGroup().getNavigablePath(), tableExpression, true);
        List assignments = (List)this.getAssignmentsByTable().get(updatingTableReference);
        if (assignments == null || assignments.isEmpty()) {
            return CompletionStages.voidFuture();
        }
        NamedTableReference dmlTableReference = this.resolveUnionTableReference(updatingTableReference, tableExpression);
        JdbcServices jdbcServices = this.getSessionFactory().getJdbcServices();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory();
        Expression keyExpression = this.resolveMutatingTableKeyExpression(tableExpression, tableKeyColumnVisitationSupplier);
        return this.executeUpdate(idTableSubQuery, executionContext, assignments, dmlTableReference, sqlAstTranslatorFactory, keyExpression).thenCompose(updateCount -> {
            if (updateCount == expectedUpdateCount) {
                return CompletionStages.voidFuture();
            }
            if (this.isTableOptional(tableExpression)) {
                return this.executeInsert(tableExpression, dmlTableReference, keyExpression, tableKeyColumnVisitationSupplier, idTableSubQuery, assignments, sqlAstTranslatorFactory, executionContext).thenAccept(insertCount -> {
                    assert (insertCount + updateCount == expectedUpdateCount);
                });
            }
            return CompletionStages.voidFuture();
        });
    }

    private CompletionStage<Integer> executeUpdate(QuerySpec idTableSubQuery, ExecutionContext executionContext, List<Assignment> assignments, NamedTableReference dmlTableReference, SqlAstTranslatorFactory sqlAstTranslatorFactory, Expression keyExpression) {
        UpdateStatement sqlAst = new UpdateStatement(dmlTableReference, assignments, (Predicate)new InSubQueryPredicate(keyExpression, (QueryPart)idTableSubQuery, false));
        JdbcOperationQueryUpdate jdbcUpdate = (JdbcOperationQueryUpdate)sqlAstTranslatorFactory.buildUpdateTranslator(this.getSessionFactory(), sqlAst).translate(this.getJdbcParameterBindings(), executionContext.getQueryOptions());
        return StandardReactiveJdbcMutationExecutor.INSTANCE.executeReactive((JdbcOperationQueryMutation)jdbcUpdate, this.getJdbcParameterBindings(), arg_0 -> ((StatementPreparer)executionContext.getSession().getJdbcCoordinator().getStatementPreparer()).prepareStatement(arg_0), ReactiveUpdateExecutionDelegate::doNothing, executionContext);
    }

    private CompletionStage<Integer> executeInsert(String targetTableExpression, NamedTableReference targetTableReference, Expression targetTableKeyExpression, Supplier<Consumer<SelectableConsumer>> tableKeyColumnVisitationSupplier, QuerySpec idTableSubQuery, List<Assignment> assignments, SqlAstTranslatorFactory sqlAstTranslatorFactory, ExecutionContext executionContext) {
        QuerySpec insertSourceSelectQuerySpec = ReactiveUpdateExecutionDelegate.makeInsertSourceSelectQuerySpec((QuerySpec)idTableSubQuery);
        QuerySpec existsSubQuerySpec = this.createExistsSubQuerySpec(targetTableExpression, tableKeyColumnVisitationSupplier, idTableSubQuery);
        insertSourceSelectQuerySpec.applyPredicate((Predicate)new ExistsPredicate((QueryPart)existsSubQuerySpec, true, (JdbcMappingContainer)this.getSessionFactory().getTypeConfiguration().getBasicTypeForJavaType(Boolean.class)));
        ArrayList<ColumnReference> targetColumnReferences = new ArrayList<ColumnReference>();
        if (targetTableKeyExpression instanceof SqlTuple) {
            targetColumnReferences.addAll(((SqlTuple)targetTableKeyExpression).getExpressions());
        } else {
            targetColumnReferences.add((ColumnReference)targetTableKeyExpression);
        }
        for (Assignment assignment : assignments) {
            targetColumnReferences.addAll(assignment.getAssignable().getColumnReferences());
            insertSourceSelectQuerySpec.getSelectClause().addSqlSelection((SqlSelection)new SqlSelectionImpl(assignment.getAssignedValue()));
        }
        InsertSelectStatement insertSqlAst = new InsertSelectStatement(targetTableReference);
        insertSqlAst.addTargetColumnReferences(targetColumnReferences.toArray(new ColumnReference[0]));
        insertSqlAst.setSourceSelectStatement((QueryPart)insertSourceSelectQuerySpec);
        JdbcOperationQueryInsert jdbcInsert = (JdbcOperationQueryInsert)sqlAstTranslatorFactory.buildInsertTranslator(this.getSessionFactory(), (InsertStatement)insertSqlAst).translate(this.getJdbcParameterBindings(), executionContext.getQueryOptions());
        return StandardReactiveJdbcMutationExecutor.INSTANCE.executeReactive((JdbcOperationQueryMutation)jdbcInsert, this.getJdbcParameterBindings(), arg_0 -> ((StatementPreparer)executionContext.getSession().getJdbcCoordinator().getStatementPreparer()).prepareStatement(arg_0), ReactiveUpdateExecutionDelegate::doNothing, executionContext);
    }

    private /* synthetic */ CompletionStage lambda$reactiveExecute$1(String tableExpression, Supplier tableKeyColumnVisitationSupplier, Integer rows, QuerySpec idTableSubQuery, ExecutionContext executionContext, Void v) {
        return this.reactiveUpdateTable(tableExpression, tableKeyColumnVisitationSupplier, rows, idTableSubQuery, executionContext);
    }
}

