/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.session.impl;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.UnknownEntityTypeException;
import org.hibernate.UnknownProfileException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.bytecode.spi.BytecodeEnhancementMetadata;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.internal.RootGraphImpl;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.AbstractSharedSessionContract;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.StatelessSessionImpl;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jpa.spi.NativeQueryTupleTransformer;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.query.IllegalMutationQueryException;
import org.hibernate.query.Query;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.criteria.JpaCriteriaInsertSelect;
import org.hibernate.query.hql.spi.SqmQueryImplementor;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.sql.internal.NativeQueryImpl;
import org.hibernate.query.sql.spi.NamedNativeQueryMemento;
import org.hibernate.query.sql.spi.NativeQueryImplementor;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.spi.NamedSqmQueryMemento;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.reactive.common.AffectedEntities;
import org.hibernate.reactive.common.ResultSetMapping;
import org.hibernate.reactive.engine.impl.ReactivePersistenceContextAdapter;
import org.hibernate.reactive.id.ReactiveIdentifierGenerator;
import org.hibernate.reactive.id.impl.IdentifierGeneration;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.persister.collection.impl.ReactiveCollectionPersister;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.pool.BatchingConnection;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.query.ReactiveMutationQuery;
import org.hibernate.reactive.query.ReactiveNativeQuery;
import org.hibernate.reactive.query.ReactiveQuery;
import org.hibernate.reactive.query.ReactiveQueryImplementor;
import org.hibernate.reactive.query.ReactiveSelectionQuery;
import org.hibernate.reactive.query.sql.internal.ReactiveNativeQueryImpl;
import org.hibernate.reactive.query.sql.spi.ReactiveNativeQueryImplementor;
import org.hibernate.reactive.query.sqm.internal.ReactiveQuerySqmImpl;
import org.hibernate.reactive.query.sqm.internal.ReactiveSqmSelectionQueryImpl;
import org.hibernate.reactive.session.ReactiveSqmQueryImplementor;
import org.hibernate.reactive.session.ReactiveStatelessSession;
import org.hibernate.reactive.session.impl.SessionUtil;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.tuple.entity.EntityMetamodel;

public class ReactiveStatelessSessionImpl
extends StatelessSessionImpl
implements ReactiveStatelessSession {
    private static final LoadQueryInfluencers NO_INFLUENCERS = new LoadQueryInfluencers(){

        public String getInternalFetchProfile() {
            return null;
        }

        public void setInternalFetchProfile(String internalFetchProfile) {
        }

        public boolean isFetchProfileEnabled(String name) throws UnknownProfileException {
            return false;
        }
    };
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final ReactiveConnection reactiveConnection;
    private final ReactiveStatelessSession batchingHelperSession;
    private final PersistenceContext persistenceContext;

    public ReactiveStatelessSessionImpl(SessionFactoryImpl factory, SessionCreationOptions options, ReactiveConnection connection) {
        super(factory, options);
        this.reactiveConnection = connection;
        this.persistenceContext = new ReactivePersistenceContextAdapter((SharedSessionContractImplementor)this);
        this.batchingHelperSession = new ReactiveStatelessSessionImpl(factory, options, this.reactiveConnection, this.persistenceContext);
    }

    private ReactiveStatelessSessionImpl(SessionFactoryImpl factory, SessionCreationOptions options, ReactiveConnection connection, PersistenceContext persistenceContext) {
        super(factory, options);
        this.persistenceContext = persistenceContext;
        Integer batchSize = this.getConfiguredJdbcBatchSize();
        this.reactiveConnection = batchSize == null || batchSize < 2 ? connection : new BatchingConnection(connection, batchSize);
        this.batchingHelperSession = this;
    }

    private LockMode getNullSafeLockMode(LockMode lockMode) {
        return lockMode == null ? LockMode.NONE : lockMode;
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    public void checkOpen() {
        this.threadCheck();
        super.checkOpen();
    }

    private void threadCheck() {
    }

    @Override
    public Dialect getDialect() {
        return this.getJdbcServices().getDialect();
    }

    @Override
    public SharedSessionContractImplementor getSharedContract() {
        return this;
    }

    public PersistenceContext getPersistenceContextInternal() {
        return this.persistenceContext;
    }

    @Override
    public ReactiveConnection getReactiveConnection() {
        return this.reactiveConnection;
    }

    public void checkTransactionNeededForUpdateOperation(String exceptionMessage) {
    }

    @Override
    public <T> CompletionStage<T> reactiveGet(Class<? extends T> entityClass, Object id) {
        return this.reactiveGet(entityClass.getName(), id, LockMode.NONE, null);
    }

    @Override
    public <T> CompletionStage<T> reactiveGet(String entityName, Object id) {
        return this.reactiveGet(entityName, id, LockMode.NONE, null);
    }

    @Override
    public <T> CompletionStage<T> reactiveGet(Class<? extends T> entityClass, Object id, LockMode lockMode, EntityGraph<T> fetchGraph) {
        return this.reactiveGet(entityClass.getName(), id, LockMode.NONE, fetchGraph);
    }

    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return NO_INFLUENCERS;
    }

    @Override
    public <T> CompletionStage<T> reactiveGet(String entityName, Object id, LockMode lockMode, EntityGraph<T> fetchGraph) {
        this.checkOpen();
        if (fetchGraph != null) {
            this.getLoadQueryInfluencers().getEffectiveEntityGraph().applyGraph((RootGraphImplementor)fetchGraph, GraphSemantic.FETCH);
        }
        return this.getEntityPersister(entityName).reactiveLoad(id, null, this.getNullSafeLockMode(lockMode), (SharedSessionContractImplementor)this).whenComplete((v, e) -> {
            if (this.getPersistenceContext().isLoadFinished()) {
                this.getPersistenceContext().clear();
            }
            this.getLoadQueryInfluencers().getEffectiveEntityGraph().clear();
        }).thenApply(entity -> entity);
    }

    private ReactiveEntityPersister getEntityPersister(String entityName) {
        return (ReactiveEntityPersister)this.getFactory().getMappingMetamodel().getEntityDescriptor(entityName);
    }

    public ReactiveEntityPersister getEntityPersister(String entityName, Object object) throws HibernateException {
        return (ReactiveEntityPersister)super.getEntityPersister(entityName, object);
    }

    @Override
    public CompletionStage<Void> reactiveInsert(Object entity) {
        this.checkOpen();
        ReactiveEntityPersister persister = this.getEntityPersister(null, entity);
        Object[] state = persister.getValues(entity);
        Generator generator = persister.getGenerator();
        if (!generator.generatedOnExecution()) {
            return this.generateId(entity, generator).thenCompose(generatedId -> {
                Object id = IdentifierGeneration.castToIdentifierType(generatedId, persister);
                if (persister.isVersioned() && Versioning.seedVersion((Object)entity, (Object[])state, (EntityPersister)persister, (SharedSessionContractImplementor)this)) {
                    persister.setValues(entity, state);
                }
                return persister.insertReactive(id, state, entity, (SharedSessionContractImplementor)this).thenAccept(ignore -> persister.setIdentifier(entity, id, (SharedSessionContractImplementor)this));
            });
        }
        return persister.insertReactive(state, entity, (SharedSessionContractImplementor)this).thenAccept(id -> persister.setIdentifier(entity, id, (SharedSessionContractImplementor)this));
    }

    private CompletionStage<?> generateId(Object entity, Generator generator) {
        return generator instanceof ReactiveIdentifierGenerator ? ((ReactiveIdentifierGenerator)generator).generate(this, this) : CompletionStages.completedFuture(((BeforeExecutionGenerator)generator).generate((SharedSessionContractImplementor)this, entity, null, EventType.INSERT));
    }

    @Override
    public CompletionStage<Void> reactiveDelete(Object entity) {
        this.checkOpen();
        ReactiveEntityPersister persister = this.getEntityPersister(null, entity);
        Object id = persister.getIdentifier(entity, (SharedSessionContractImplementor)this);
        Object version = persister.getVersion(entity);
        return persister.deleteReactive(id, version, entity, (SharedSessionContractImplementor)this);
    }

    @Override
    public CompletionStage<Void> reactiveUpdate(Object entity) {
        this.checkOpen();
        if (entity instanceof HibernateProxy) {
            LazyInitializer hibernateLazyInitializer = ((HibernateProxy)entity).getHibernateLazyInitializer();
            return hibernateLazyInitializer.isUninitialized() ? CompletionStages.failedFuture((Throwable)LOG.uninitializedProxyUpdate(entity.getClass())) : this.executeReactiveUpdate(hibernateLazyInitializer.getImplementation());
        }
        return this.executeReactiveUpdate(entity);
    }

    private CompletionStage<Void> executeReactiveUpdate(Object entity) {
        Object oldVersion;
        ReactiveEntityPersister persister = this.getEntityPersister(null, entity);
        Object id = persister.getIdentifier(entity, (SharedSessionContractImplementor)this);
        Object[] state = persister.getValues(entity);
        if (persister.isVersioned()) {
            oldVersion = persister.getVersion(entity);
            Object newVersion = Versioning.incrementVersion((Object)entity, (Object)oldVersion, (EntityPersister)persister, (SharedSessionContractImplementor)this);
            Versioning.setVersion((Object[])state, (Object)newVersion, (EntityPersister)persister);
            persister.setValues(entity, state);
        } else {
            oldVersion = null;
        }
        return persister.updateReactive(id, state, null, false, null, oldVersion, entity, null, (SharedSessionContractImplementor)this);
    }

    @Override
    public CompletionStage<Void> reactiveRefresh(Object entity) {
        return this.reactiveRefresh(entity, LockMode.NONE);
    }

    @Override
    public CompletionStage<Void> reactiveRefresh(Object entity, LockMode lockMode) {
        EntityDataAccess cacheAccess;
        ReactiveEntityPersister persister = this.getEntityPersister(null, entity);
        Object id = persister.getIdentifier(entity, (SharedSessionContractImplementor)this);
        if (persister.canWriteToCache() && (cacheAccess = persister.getCacheAccessStrategy()) != null) {
            Object ck = cacheAccess.generateCacheKey(id, (EntityPersister)persister, this.getFactory(), this.getTenantIdentifier());
            cacheAccess.evict(ck);
        }
        String previousFetchProfile = this.getLoadQueryInfluencers().getInternalFetchProfile();
        this.getLoadQueryInfluencers().setInternalFetchProfile("refresh");
        return persister.reactiveLoad(id, entity, this.getNullSafeLockMode(lockMode), (SharedSessionContractImplementor)this).thenAccept(result -> {
            if (this.getPersistenceContext().isLoadFinished()) {
                this.getPersistenceContext().clear();
            }
            UnresolvableObjectException.throwIfNull((Object)result, (Object)id, (String)persister.getEntityName());
        }).whenComplete((v, e) -> this.getLoadQueryInfluencers().setInternalFetchProfile(previousFetchProfile));
    }

    @Override
    public CompletionStage<Void> reactiveInsertAll(Object ... entities) {
        return CompletionStages.loop(entities, this.batchingHelperSession::reactiveInsert).thenCompose(v -> this.batchingHelperSession.getReactiveConnection().executeBatch());
    }

    @Override
    public CompletionStage<Void> reactiveInsertAll(int batchSize, Object ... entities) {
        ReactiveConnection connection = this.batchingConnection(batchSize);
        return CompletionStages.loop(entities, this.batchingHelperSession::reactiveInsert).thenCompose(v -> connection.executeBatch());
    }

    @Override
    public CompletionStage<Void> reactiveUpdateAll(Object ... entities) {
        return CompletionStages.loop(entities, this.batchingHelperSession::reactiveUpdate).thenCompose(v -> this.batchingHelperSession.getReactiveConnection().executeBatch());
    }

    @Override
    public CompletionStage<Void> reactiveUpdateAll(int batchSize, Object ... entities) {
        ReactiveConnection connection = this.batchingConnection(batchSize);
        return CompletionStages.loop(entities, this.batchingHelperSession::reactiveUpdate).thenCompose(v -> connection.executeBatch());
    }

    @Override
    public CompletionStage<Void> reactiveDeleteAll(Object ... entities) {
        return CompletionStages.loop(entities, this.batchingHelperSession::reactiveDelete).thenCompose(v -> this.batchingHelperSession.getReactiveConnection().executeBatch());
    }

    @Override
    public CompletionStage<Void> reactiveDeleteAll(int batchSize, Object ... entities) {
        ReactiveConnection connection = this.batchingConnection(batchSize);
        return CompletionStages.loop(entities, this.batchingHelperSession::reactiveDelete).thenCompose(v -> connection.executeBatch());
    }

    @Override
    public CompletionStage<Void> reactiveRefreshAll(Object ... entities) {
        return CompletionStages.loop(entities, this.batchingHelperSession::reactiveRefresh).thenCompose(v -> this.batchingHelperSession.getReactiveConnection().executeBatch());
    }

    @Override
    public CompletionStage<Void> reactiveRefreshAll(int batchSize, Object ... entities) {
        ReactiveConnection connection = this.batchingConnection(batchSize);
        return CompletionStages.loop(entities, this.batchingHelperSession::reactiveRefresh).thenCompose(v -> connection.executeBatch());
    }

    private ReactiveConnection batchingConnection(int batchSize) {
        return this.batchingHelperSession.getReactiveConnection().withBatchSize(batchSize);
    }

    private Object createProxy(EntityKey entityKey) {
        Object proxy = entityKey.getPersister().createProxy(entityKey.getIdentifier(), (SharedSessionContractImplementor)this);
        this.getPersistenceContext().addProxy(entityKey, proxy);
        return proxy;
    }

    @Override
    public CompletionStage<Object> reactiveInternalLoad(String entityName, Object id, boolean eager, boolean nullable) {
        this.checkOpen();
        ReactiveEntityPersister persister = this.getEntityPersister(entityName);
        EntityKey entityKey = this.generateEntityKey(id, persister);
        PersistenceContext persistenceContext = this.getPersistenceContext();
        Object loaded = persistenceContext.getEntity(entityKey);
        if (loaded != null) {
            return CompletionStages.completedFuture(loaded);
        }
        if (!eager) {
            EntityMetamodel entityMetamodel = persister.getEntityMetamodel();
            BytecodeEnhancementMetadata enhancementMetadata = entityMetamodel.getBytecodeEnhancementMetadata();
            if (enhancementMetadata.isEnhancedForLazyLoading()) {
                if (persister.getRepresentationStrategy().getProxyFactory() != null) {
                    Object proxy = persistenceContext.getProxy(entityKey);
                    if (proxy != null) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Entity proxy found in session cache");
                        }
                        if (LOG.isDebugEnabled() && ((HibernateProxy)proxy).getHibernateLazyInitializer().isUnwrap()) {
                            LOG.debug("Ignoring NO_PROXY to honor laziness");
                        }
                        return CompletionStages.completedFuture(persistenceContext.narrowProxy(proxy, (EntityPersister)persister, entityKey, null));
                    }
                    if (entityMetamodel.hasSubclasses()) {
                        return CompletionStages.completedFuture(this.createProxy(entityKey));
                    }
                    return CompletionStages.completedFuture(enhancementMetadata.createEnhancedProxy(entityKey, false, (SharedSessionContractImplementor)this));
                }
                if (!entityMetamodel.hasSubclasses()) {
                    return CompletionStages.completedFuture(enhancementMetadata.createEnhancedProxy(entityKey, false, (SharedSessionContractImplementor)this));
                }
            } else if (persister.hasProxy()) {
                Object existingProxy = persistenceContext.getProxy(entityKey);
                if (existingProxy != null) {
                    return CompletionStages.completedFuture(persistenceContext.narrowProxy(existingProxy, (EntityPersister)persister, entityKey, null));
                }
                return CompletionStages.completedFuture(this.createProxy(entityKey));
            }
        }
        persistenceContext.beforeLoad();
        return this.reactiveGet(persister.getEntityName(), id).whenComplete((r, e) -> persistenceContext.afterLoad());
    }

    @Override
    public <T> CompletionStage<T> reactiveFetch(T association, boolean unproxy) {
        this.checkOpen();
        if (association == null) {
            return CompletionStages.nullFuture();
        }
        PersistenceContext persistenceContext = this.getPersistenceContext();
        LazyInitializer initializer = HibernateProxy.extractLazyInitializer(association);
        if (initializer != null) {
            if (initializer.isUninitialized()) {
                String entityName = initializer.getEntityName();
                Object id = initializer.getIdentifier();
                initializer.setSession((SharedSessionContractImplementor)this);
                persistenceContext.beforeLoad();
                ReactiveEntityPersister persister = this.getEntityPersister(entityName);
                CompletionStage<Object> stage = initializer.getImplementation() instanceof CompletionStage ? (CompletionStage<Object>)initializer.getImplementation() : CompletionStages.completedFuture(initializer.getImplementation());
                return stage.thenCompose(implementation -> persister.reactiveLoad(id, implementation, LockOptions.NONE, (SharedSessionContractImplementor)this)).thenApply(entity -> {
                    SessionUtil.checkEntityFound((SharedSessionContractImplementor)this, entityName, id, entity);
                    initializer.setImplementation(entity);
                    return unproxy ? entity : association;
                }).whenComplete((v, e) -> {
                    initializer.unsetSession();
                    persistenceContext.afterLoad();
                    if (persistenceContext.isLoadFinished()) {
                        persistenceContext.clear();
                    }
                });
            }
            return CompletionStages.completedFuture(unproxy ? initializer.getImplementation() : association);
        }
        if (association instanceof PersistentCollection) {
            PersistentCollection persistentCollection = (PersistentCollection)association;
            if (persistentCollection.wasInitialized()) {
                return CompletionStages.completedFuture(association);
            }
            ReactiveCollectionPersister collectionDescriptor = (ReactiveCollectionPersister)this.getFactory().getMappingMetamodel().getCollectionDescriptor(persistentCollection.getRole());
            Object key = persistentCollection.getKey();
            persistenceContext.addUninitializedCollection((CollectionPersister)collectionDescriptor, persistentCollection, key);
            persistentCollection.setCurrentSession((SharedSessionContractImplementor)this);
            return collectionDescriptor.reactiveInitialize(key, (SharedSessionContractImplementor)this).whenComplete((v, e) -> {
                persistentCollection.unsetSession((SharedSessionContractImplementor)this);
                if (persistenceContext.isLoadFinished()) {
                    persistenceContext.clear();
                }
            }).thenApply(v -> association);
        }
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(association)) {
            PersistentAttributeInterceptable interceptable = ManagedTypeHelper.asPersistentAttributeInterceptable(association);
            PersistentAttributeInterceptor interceptor = interceptable.$$_hibernate_getInterceptor();
            if (interceptor instanceof EnhancementAsProxyLazinessInterceptor) {
                EnhancementAsProxyLazinessInterceptor proxyInterceptor = (EnhancementAsProxyLazinessInterceptor)interceptor;
                proxyInterceptor.setSession((SharedSessionContractImplementor)this);
                return ReactiveEntityPersister.forceInitialize(association, null, proxyInterceptor.getIdentifier(), proxyInterceptor.getEntityName(), (SharedSessionContractImplementor)this).whenComplete((i, e) -> {
                    proxyInterceptor.unsetSession();
                    if (persistenceContext.isLoadFinished()) {
                        persistenceContext.clear();
                    }
                }).thenApply(i -> association);
            }
            return CompletionStages.completedFuture(association);
        }
        return CompletionStages.completedFuture(association);
    }

    public <T> RootGraphImplementor<T> createEntityGraph(Class<T> entity) {
        return new RootGraphImpl(null, this.getFactory().getJpaMetamodel().entity(entity), (JpaMetamodel)this.getSessionFactory().getJpaMetamodel());
    }

    public <T> RootGraphImplementor<T> createEntityGraph(Class<T> entity, String name) {
        RootGraphImplementor<?> entityGraph = this.createEntityGraph(name);
        if (!entityGraph.getGraphedType().getJavaType().equals(entity)) {
            throw LOG.wrongEntityType();
        }
        return entityGraph;
    }

    private RootGraphImplementor<?> createEntityGraph(String graphName) {
        this.checkOpen();
        RootGraphImplementor named = this.getFactory().findEntityGraphByName(graphName);
        return named != null ? named.makeRootGraph(graphName, true) : null;
    }

    public <T> RootGraphImplementor<T> getEntityGraph(Class<T> entity, String name) {
        RootGraphImplementor<?> entityGraph = this.getEntityGraph(name);
        if (!entityGraph.getGraphedType().getJavaType().equals(entity)) {
            throw LOG.wrongEntityType();
        }
        return entityGraph;
    }

    private RootGraphImplementor<?> getEntityGraph(String graphName) {
        this.checkOpen();
        RootGraphImplementor named = this.getFactory().findEntityGraphByName(graphName);
        if (named == null) {
            throw new IllegalArgumentException("Could not locate EntityGraph with given name : " + graphName);
        }
        return named;
    }

    public <R> ReactiveSqmQueryImplementor<R> createReactiveQuery(String queryString) {
        return this.createReactiveQuery(queryString, (Class)null);
    }

    @Override
    public <R> ReactiveQuery<R> createReactiveQuery(CriteriaQuery<R> criteriaQuery) {
        this.checkOpen();
        try {
            SqmQuerySpec querySpec;
            SqmSelectStatement selectStatement = (SqmSelectStatement)criteriaQuery;
            if (!(selectStatement.getQueryPart() instanceof SqmQueryGroup) && (querySpec = selectStatement.getQuerySpec()).getSelectClause().getSelections().isEmpty() && querySpec.getFromClause().getRoots().size() == 1) {
                querySpec.getSelectClause().setSelection((SqmSelectableNode)querySpec.getFromClause().getRoots().get(0));
            }
            return this.createCriteriaQuery((SqmStatement)selectStatement, criteriaQuery.getResultType());
        }
        catch (RuntimeException e) {
            if (this.getSessionFactory().getJpaMetamodel().getJpaCompliance().isJpaTransactionComplianceEnabled()) {
                this.markForRollbackOnly();
            }
            throw this.getExceptionConverter().convert(e);
        }
    }

    private <T> ReactiveQuery<T> createCriteriaQuery(SqmStatement<T> criteria, Class<T> resultType) {
        ReactiveQuerySqmImpl<T> query = new ReactiveQuerySqmImpl<T>(criteria, resultType, (SharedSessionContractImplementor)this);
        this.applyQuerySettingsAndHints((Query)query);
        return query;
    }

    public void prepareForQueryExecution(boolean requiresTxn) {
        this.checkOpen();
        this.checkTransactionSynchStatus();
    }

    public <R> ReactiveSqmQueryImplementor<R> createReactiveQuery(String queryString, Class<R> expectedResultType) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            HqlInterpretation interpretation = this.interpretHql(queryString, expectedResultType);
            ReactiveQuerySqmImpl<R> query = new ReactiveQuerySqmImpl<R>(queryString, interpretation, expectedResultType, (SharedSessionContractImplementor)this);
            this.applyQuerySettingsAndHints((Query)query);
            query.setComment(queryString);
            return query;
        }
        catch (RuntimeException e) {
            this.markForRollbackOnly();
            throw this.getExceptionConverter().convert(e);
        }
    }

    public <R> ReactiveNativeQueryImplementor<R> createReactiveNativeQuery(String sqlString) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            ReactiveNativeQueryImpl query = new ReactiveNativeQueryImpl(sqlString, (SharedSessionContractImplementor)this);
            if (StringHelper.isEmpty((String)query.getComment())) {
                query.setComment("dynamic native SQL query");
            }
            this.applyQuerySettingsAndHints((Query)query);
            return query;
        }
        catch (RuntimeException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    @Override
    public <R> ReactiveNativeQuery<R> createReactiveNativeQuery(String sqlString, Class<R> resultClass) {
        ReactiveNativeQuery query = this.createReactiveNativeQuery(sqlString);
        if (Tuple.class.equals(resultClass)) {
            query.setTupleTransformer((TupleTransformer)new NativeQueryTupleTransformer());
        } else if (this.getFactory().getMappingMetamodel().isEntityClass(resultClass)) {
            query.addEntity("alias1", resultClass.getName(), LockMode.READ);
        } else {
            ((NativeQueryImpl)query).addScalar(1, resultClass);
        }
        return query;
    }

    @Override
    public <R> ReactiveNativeQuery<R> createReactiveNativeQuery(String sqlString, Class<R> resultClass, String tableAlias) {
        ReactiveNativeQuery query = this.createReactiveNativeQuery(sqlString);
        if (this.getFactory().getMappingMetamodel().isEntityClass(resultClass)) {
            query.addEntity(tableAlias, resultClass.getName(), LockMode.READ);
            return query;
        }
        throw new UnknownEntityTypeException("unable to locate persister: " + resultClass.getName());
    }

    @Override
    public <R> ReactiveNativeQuery<R> createReactiveNativeQuery(String sqlString, String resultSetMappingName) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            if (StringHelper.isNotEmpty((String)resultSetMappingName)) {
                NamedResultSetMappingMemento resultSetMappingMemento = this.getFactory().getQueryEngine().getNamedObjectRepository().getResultSetMappingMemento(resultSetMappingName);
                if (resultSetMappingMemento == null) {
                    throw new HibernateException("Could not resolve specified result-set mapping name : " + resultSetMappingName);
                }
                return new ReactiveNativeQueryImpl(sqlString, resultSetMappingMemento, (AbstractSharedSessionContract)this);
            }
            return new ReactiveNativeQueryImpl(sqlString, (SharedSessionContractImplementor)this);
        }
        catch (RuntimeException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    @Override
    public <R> ReactiveNativeQuery<R> createReactiveNativeQuery(String sqlString, String resultSetMappingName, Class<R> resultClass) {
        ReactiveNativeQuery<R> query = this.createReactiveNativeQuery(sqlString, resultSetMappingName);
        if (Tuple.class.equals(resultClass)) {
            query.setTupleTransformer((TupleTransformer)new NativeQueryTupleTransformer());
        }
        return query;
    }

    @Override
    public <R> ReactiveSelectionQuery<R> createReactiveSelectionQuery(String hqlString) {
        return this.interpretAndCreateSelectionQuery(hqlString, null);
    }

    @Override
    public <R> ReactiveSelectionQuery<R> createReactiveSelectionQuery(String hqlString, Class<R> resultType) {
        return this.interpretAndCreateSelectionQuery(hqlString, resultType);
    }

    private <R> ReactiveSelectionQuery<R> interpretAndCreateSelectionQuery(String hql, Class<R> resultType) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            HqlInterpretation interpretation = this.interpretHql(hql, resultType);
            ReactiveStatelessSessionImpl.checkSelectionQuery((String)hql, (HqlInterpretation)interpretation);
            return this.createSelectionQuery(hql, resultType, interpretation);
        }
        catch (RuntimeException e) {
            this.markForRollbackOnly();
            throw e;
        }
    }

    private <R> ReactiveSelectionQuery<R> createSelectionQuery(String hql, Class<R> resultType, HqlInterpretation interpretation) {
        ReactiveSqmSelectionQueryImpl<R> query = new ReactiveSqmSelectionQueryImpl<R>(hql, interpretation, resultType, (SharedSessionContractImplementor)this);
        if (resultType != null) {
            ReactiveStatelessSessionImpl.checkResultType(resultType, query);
        }
        query.setComment(hql);
        this.applyQuerySettingsAndHints((SelectionQuery)query);
        return query;
    }

    @Override
    public <R> ReactiveSelectionQuery<R> createReactiveSelectionQuery(CriteriaQuery<R> criteria) {
        SqmUtil.verifyIsSelectStatement((SqmStatement)((SqmStatement)criteria), null);
        return new ReactiveSqmSelectionQueryImpl((SqmSelectStatement)criteria, criteria.getResultType(), (SharedSessionContractImplementor)this);
    }

    @Override
    public <R> ReactiveMutationQuery<R> createReactiveMutationQuery(String hqlString) {
        QueryImplementor query = this.createQuery(hqlString);
        SqmStatement sqmStatement = ((SqmQueryImplementor)query).getSqmStatement();
        ReactiveStatelessSessionImpl.checkMutationQuery((String)hqlString, (SqmStatement)sqmStatement);
        return new ReactiveQuerySqmImpl(sqmStatement, null, (SharedSessionContractImplementor)this);
    }

    @Override
    public <R> ReactiveMutationQuery<R> createReactiveMutationQuery(CriteriaUpdate<R> updateQuery) {
        this.checkOpen();
        try {
            return this.createCriteriaQuery((SqmStatement)((SqmUpdateStatement)updateQuery), null);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public <R> ReactiveMutationQuery<R> createReactiveMutationQuery(CriteriaDelete<R> deleteQuery) {
        this.checkOpen();
        try {
            return this.createCriteriaQuery((SqmStatement)((SqmDeleteStatement)deleteQuery), null);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public <R> ReactiveMutationQuery<R> createReactiveMutationQuery(JpaCriteriaInsertSelect<R> insertSelect) {
        this.checkOpen();
        try {
            return this.createCriteriaQuery((SqmStatement)((SqmInsertSelectStatement)insertSelect), null);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public <R> ReactiveSelectionQuery<R> createNamedReactiveSelectionQuery(String queryName) {
        return (ReactiveSelectionQuery)this.createNamedSelectionQuery(queryName, null);
    }

    @Override
    public <R> ReactiveMutationQuery<R> createNamedReactiveMutationQuery(String queryName) {
        return (ReactiveMutationQuery)this.buildNamedQuery(queryName, memento -> this.createSqmQueryImplementor(queryName, (NamedSqmQueryMemento)memento), memento -> this.createNativeQueryImplementor(queryName, (NamedNativeQueryMemento)memento));
    }

    @Override
    public <R> ReactiveSelectionQuery<R> createNamedReactiveSelectionQuery(String queryName, Class<R> expectedResultType) {
        return (ReactiveSelectionQuery)this.createNamedSelectionQuery(queryName, expectedResultType);
    }

    @Override
    public <R> ReactiveMutationQuery<R> createNativeReactiveMutationQuery(String sqlString) {
        ReactiveNativeQuery query = this.createReactiveNativeQuery(sqlString);
        if (query.isSelectQuery() == Boolean.TRUE) {
            throw new IllegalMutationQueryException("Expecting a native mutation query, but found `" + sqlString + "`");
        }
        return query;
    }

    @Override
    public <R> ReactiveQueryImplementor<R> createReactiveNamedQuery(String queryName, Class<R> resultType) {
        return (ReactiveQueryImplementor)this.buildNamedQuery(queryName, resultType);
    }

    @Override
    public <R> ReactiveNativeQuery<R> createReactiveNativeQuery(String queryString, AffectedEntities affectedEntities) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            ReactiveNativeQueryImpl query = new ReactiveNativeQueryImpl(queryString, (SharedSessionContractImplementor)this);
            this.addAffectedEntities(affectedEntities, (NativeQueryImplementor<?>)query);
            if (StringHelper.isEmpty((String)query.getComment())) {
                query.setComment("dynamic native SQL query");
            }
            this.applyQuerySettingsAndHints((Query)query);
            return query;
        }
        catch (RuntimeException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    @Override
    public <R> ReactiveNativeQuery<R> createReactiveNativeQuery(String queryString, Class<R> resultType, AffectedEntities affectedEntities) {
        ReactiveNativeQuery<R> query = this.createReactiveNativeQuery(queryString, affectedEntities);
        return this.addResultType(resultType, query);
    }

    private <T> ReactiveNativeQuery<T> addResultType(Class<T> resultClass, ReactiveNativeQuery<T> query) {
        if (Tuple.class.equals(resultClass)) {
            query.setTupleTransformer((TupleTransformer)new NativeQueryTupleTransformer());
        } else if (this.getFactory().getMappingMetamodel().isEntityClass(resultClass)) {
            query.addEntity("alias1", resultClass.getName(), LockMode.READ);
        } else if (resultClass != Object.class && resultClass != Object[].class) {
            query.addScalar(1, resultClass);
        }
        return query;
    }

    public <R> ReactiveNativeQueryImpl<R> createReactiveNativeQuery(String queryString, ResultSetMapping<R> resultSetMapping) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            ReactiveNativeQueryImpl nativeQuery = resultSetMapping != null ? new ReactiveNativeQueryImpl(queryString, this.getResultSetMappingMemento(resultSetMapping.getName()), (AbstractSharedSessionContract)this) : new ReactiveNativeQueryImpl(queryString, (SharedSessionContractImplementor)this);
            this.applyQuerySettingsAndHints((Query)nativeQuery);
            return nativeQuery;
        }
        catch (RuntimeException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    @Override
    public <R> ReactiveNativeQuery<R> createReactiveNativeQuery(String queryString, ResultSetMapping<R> resultSetMapping, AffectedEntities affectedEntities) {
        ReactiveNativeQuery nativeQuery = this.createReactiveNativeQuery(queryString, (ResultSetMapping)resultSetMapping);
        this.addAffectedEntities(affectedEntities, (NativeQueryImplementor<?>)nativeQuery);
        return nativeQuery;
    }

    @Override
    public <T> ResultSetMapping<T> getResultSetMapping(final Class<T> resultType, final String mappingName) {
        return new ResultSetMapping<T>(){

            @Override
            public String getName() {
                return mappingName;
            }

            @Override
            public Class<T> getResultType() {
                return resultType;
            }
        };
    }

    private void addAffectedEntities(AffectedEntities affectedEntities, NativeQueryImplementor<?> query) {
        for (String space : affectedEntities.getAffectedSpaces(this.getFactory())) {
            query.addSynchronizedQuerySpace(space);
        }
    }

    public void close() {
        throw LOG.nonReactiveMethodCall("close(CompletableFuture<Void> closing)");
    }

    @Override
    public void close(CompletableFuture<Void> closing) {
        this.reactiveConnection.close().thenAccept(v -> super.close()).whenComplete((unused, throwable) -> {
            if (throwable != null) {
                closing.completeExceptionally((Throwable)throwable);
            } else {
                closing.complete(null);
            }
        });
    }
}

