/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.exec.internal;

import java.util.Map;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.internal.EntityMutationOperationGroup;
import org.hibernate.engine.jdbc.mutation.spi.BatchKeyAccess;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.reactive.engine.jdbc.mutation.internal.ReactiveMutationExecutorPostInsert;
import org.hibernate.reactive.engine.jdbc.mutation.internal.ReactiveMutationExecutorPostInsertSingleTable;
import org.hibernate.reactive.engine.jdbc.mutation.internal.ReactiveMutationExecutorSingleBatched;
import org.hibernate.reactive.engine.jdbc.mutation.internal.ReactiveMutationExecutorSingleNonBatched;
import org.hibernate.reactive.engine.jdbc.mutation.internal.ReactiveMutationExecutorSingleSelfExecuting;
import org.hibernate.reactive.engine.jdbc.mutation.internal.ReactiveMutationExecutorStandard;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.PreparableMutationOperation;
import org.hibernate.sql.model.SelfExecutingUpdateOperation;

public class ReactiveStandardMutationExecutorService
implements MutationExecutorService {
    private final int globalBatchSize;

    public ReactiveStandardMutationExecutorService(Map<String, Object> configurationValues) {
        this(ConfigurationHelper.getInt((String)"hibernate.jdbc.batch_size", configurationValues, (int)1));
    }

    public ReactiveStandardMutationExecutorService(int globalBatchSize) {
        this.globalBatchSize = globalBatchSize;
    }

    public MutationExecutor createExecutor(BatchKeyAccess batchKeySupplier, MutationOperationGroup operationGroup, SharedSessionContractImplementor session) {
        Integer sessionBatchSize = session.getJdbcCoordinator().getJdbcSessionOwner().getJdbcBatchSize();
        int batchSizeToUse = sessionBatchSize == null ? this.globalBatchSize : sessionBatchSize;
        int numberOfOperations = operationGroup.getNumberOfOperations();
        MutationType mutationType = operationGroup.getMutationType();
        EntityMutationOperationGroup entityMutationOperationGroup = operationGroup.asEntityMutationOperationGroup();
        if (mutationType == MutationType.INSERT && entityMutationOperationGroup != null && entityMutationOperationGroup.getMutationTarget().getIdentityInsertDelegate() != null) {
            if (numberOfOperations > 1) {
                return new ReactiveMutationExecutorPostInsert(entityMutationOperationGroup, session);
            }
            return new ReactiveMutationExecutorPostInsertSingleTable(entityMutationOperationGroup, session);
        }
        if (numberOfOperations == 1) {
            MutationOperation singleOperation = operationGroup.getSingleOperation();
            if (singleOperation instanceof SelfExecutingUpdateOperation) {
                return new ReactiveMutationExecutorSingleSelfExecuting((SelfExecutingUpdateOperation)singleOperation, session);
            }
            PreparableMutationOperation jdbcOperation = (PreparableMutationOperation)singleOperation;
            BatchKey batchKey = batchKeySupplier.getBatchKey();
            if (jdbcOperation.canBeBatched(batchKey, batchSizeToUse)) {
                return new ReactiveMutationExecutorSingleBatched(jdbcOperation, batchKey, batchSizeToUse, session);
            }
            return new ReactiveMutationExecutorSingleNonBatched(jdbcOperation, session);
        }
        return new ReactiveMutationExecutorStandard(operationGroup, batchKeySupplier, batchSizeToUse, session);
    }
}

