/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.exec.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.hibernate.CacheMode;
import org.hibernate.LockOptions;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsCache;
import org.hibernate.engine.jdbc.spi.StatementPreparer;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.reactive.engine.impl.ReactivePersistenceContextAdapter;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.sql.exec.spi.ReactiveRowProcessingState;
import org.hibernate.reactive.sql.exec.spi.ReactiveSelectExecutor;
import org.hibernate.reactive.sql.exec.spi.ReactiveValuesResultSet;
import org.hibernate.reactive.sql.results.internal.ReactiveDeferredResultSetAccess;
import org.hibernate.reactive.sql.results.internal.ReactiveResultSetAccess;
import org.hibernate.reactive.sql.results.internal.ReactiveResultsHelper;
import org.hibernate.reactive.sql.results.spi.ReactiveListResultsConsumer;
import org.hibernate.reactive.sql.results.spi.ReactiveResultsConsumer;
import org.hibernate.reactive.sql.results.spi.ReactiveRowReader;
import org.hibernate.reactive.sql.results.spi.ReactiveValuesMappingProducer;
import org.hibernate.sql.exec.SqlExecLogger;
import org.hibernate.sql.exec.internal.JdbcExecHelper;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.internal.RowTransformerTupleTransformerAdapter;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.RowTransformer;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class StandardReactiveSelectExecutor
implements ReactiveSelectExecutor {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    public static final StandardReactiveSelectExecutor INSTANCE = new StandardReactiveSelectExecutor();

    private StandardReactiveSelectExecutor() {
    }

    public <R> CompletionStage<List<R>> list(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, ReactiveListResultsConsumer.UniqueSemantic uniqueSemantic) {
        return this.list(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, null, uniqueSemantic);
    }

    @Override
    public <R> CompletionStage<List<R>> list(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, Class<R> domainResultType, ReactiveListResultsConsumer.UniqueSemantic uniqueSemantic) {
        return this.executeQuery(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, domainResultType, arg_0 -> ((StatementPreparer)executionContext.getSession().getJdbcCoordinator().getStatementPreparer()).prepareStatement(arg_0), ReactiveListResultsConsumer.instance(uniqueSemantic));
    }

    @Override
    public <T, R> CompletionStage<T> executeQuery(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, Class<R> domainResultType, Function<String, PreparedStatement> statementCreator, ReactiveResultsConsumer<T, R> resultsConsumer) {
        PersistenceContext persistenceContext = executionContext.getSession().getPersistenceContext();
        boolean defaultReadOnlyOrig = persistenceContext.isDefaultReadOnly();
        Boolean readOnly = executionContext.getQueryOptions().isReadOnly();
        if (readOnly != null) {
            persistenceContext.setDefaultReadOnly(readOnly.booleanValue());
        }
        return this.doExecuteQuery(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, domainResultType, statementCreator, resultsConsumer).thenCompose(list -> ((ReactivePersistenceContextAdapter)persistenceContext).reactiveInitializeNonLazyCollections().thenApply(v -> list)).whenComplete((o, throwable) -> {
            if (readOnly != null) {
                persistenceContext.setDefaultReadOnly(defaultReadOnlyOrig);
            }
        });
    }

    private <T, R> CompletionStage<T> doExecuteQuery(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, final ExecutionContext executionContext, RowTransformer<R> transformer, Class<R> domainResultType, Function<String, PreparedStatement> statementCreator, ReactiveResultsConsumer<T, R> resultsConsumer) {
        ReactiveDeferredResultSetAccess deferredResultSetAccess = new ReactiveDeferredResultSetAccess(jdbcSelect, jdbcParameterBindings, executionContext, statementCreator);
        return this.resolveJdbcValuesSource(executionContext.getQueryIdentifier(deferredResultSetAccess.getFinalSql()), jdbcSelect, resultsConsumer.canResultsBeCached(), executionContext, deferredResultSetAccess).thenCompose(jdbcValues -> {
            RowTransformer rowTransformer = StandardReactiveSelectExecutor.rowTransformer(executionContext, transformer, jdbcValues);
            Statistics statistics = new Statistics(executionContext, (ReactiveValuesResultSet)jdbcValues);
            JdbcValuesSourceProcessingOptions processingOptions = new JdbcValuesSourceProcessingOptions(){

                public Object getEffectiveOptionalObject() {
                    return executionContext.getEntityInstance();
                }

                public String getEffectiveOptionalEntityName() {
                    return null;
                }

                public Object getEffectiveOptionalId() {
                    return executionContext.getEntityId();
                }

                public boolean shouldReturnProxies() {
                    return true;
                }
            };
            JdbcValuesSourceProcessingStateStandardImpl valuesProcessingState = new JdbcValuesSourceProcessingStateStandardImpl(executionContext, processingOptions);
            ReactiveRowReader rowReader = ReactiveResultsHelper.createRowReader(executionContext, deferredResultSetAccess.usesFollowOnLocking() ? LockOptions.NONE : executionContext.getQueryOptions().getLockOptions(), rowTransformer, domainResultType, jdbcValues.getValuesMapping());
            ReactiveRowProcessingState rowProcessingState = new ReactiveRowProcessingState(valuesProcessingState, executionContext, rowReader, (ReactiveValuesResultSet)jdbcValues);
            return resultsConsumer.consume((ReactiveValuesResultSet)jdbcValues, executionContext.getSession(), processingOptions, valuesProcessingState, rowProcessingState, rowReader).thenApply(result -> {
                statistics.end(jdbcSelect, result);
                return result;
            });
        });
    }

    private static <R> RowTransformer<R> rowTransformer(ExecutionContext executionContext, RowTransformer<R> transformer, ReactiveValuesResultSet jdbcValues) {
        RowTransformerStandardImpl rowTransformer = transformer;
        if (rowTransformer == null) {
            TupleTransformer tupleTransformer = executionContext.getQueryOptions().getTupleTransformer();
            if (tupleTransformer == null) {
                rowTransformer = RowTransformerStandardImpl.instance();
            } else {
                List domainResults = jdbcValues.getValuesMapping().getDomainResults();
                String[] aliases = new String[domainResults.size()];
                for (int i = 0; i < domainResults.size(); ++i) {
                    aliases[i] = ((DomainResult)domainResults.get(i)).getResultVariable();
                }
                rowTransformer = new RowTransformerTupleTransformerAdapter(aliases, tupleTransformer);
            }
        }
        return rowTransformer;
    }

    public CompletionStage<ReactiveValuesResultSet> resolveJdbcValuesSource(String queryIdentifier, JdbcOperationQuerySelect jdbcSelect, boolean canBeCached, ExecutionContext executionContext, ReactiveResultSetAccess resultSetAccess) {
        CapturingJdbcValuesMetadata capturingMetadata;
        List cachedResults;
        QueryKey queryResultsCacheKey;
        boolean cacheable;
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        boolean queryCacheEnabled = factory.getSessionFactoryOptions().isQueryCacheEnabled();
        CacheMode cacheMode = JdbcExecHelper.resolveCacheMode((ExecutionContext)executionContext);
        boolean bl = cacheable = queryCacheEnabled && canBeCached && executionContext.getQueryOptions().isResultCachingEnabled() == Boolean.TRUE;
        if (cacheable && cacheMode.isGetEnabled()) {
            SqlExecLogger.SQL_EXEC_LOGGER.debugf("Reading Query result cache data per CacheMode#isGetEnabled [%s]", (Object)cacheMode.name());
            Set querySpaces = jdbcSelect.getAffectedTableNames();
            if (querySpaces == null || querySpaces.size() == 0) {
                SqlExecLogger.SQL_EXEC_LOGGER.tracef("Unexpected querySpaces is empty", new Object[0]);
            } else {
                SqlExecLogger.SQL_EXEC_LOGGER.tracef("querySpaces is `%s`", (Object)querySpaces);
            }
            QueryResultsCache queryCache = factory.getCache().getQueryResultsCache(executionContext.getQueryOptions().getResultCacheRegionName());
            queryResultsCacheKey = QueryKey.from((String)jdbcSelect.getSqlString(), (Limit)executionContext.getQueryOptions().getLimit(), (QueryParameterBindings)executionContext.getQueryParameterBindings(), (SharedSessionContractImplementor)session);
            cachedResults = queryCache.get(queryResultsCacheKey, querySpaces, session);
            StatisticsImplementor statistics = factory.getStatistics();
            if (statistics.isStatisticsEnabled()) {
                if (cachedResults == null) {
                    statistics.queryCacheMiss(queryIdentifier, queryCache.getRegion().getName());
                } else {
                    statistics.queryCacheHit(queryIdentifier, queryCache.getRegion().getName());
                }
            }
        } else {
            SqlExecLogger.SQL_EXEC_LOGGER.debugf("Skipping reading Query result cache data: cache-enabled = %s, cache-mode = %s", (Object)queryCacheEnabled, (Object)cacheMode.name());
            cachedResults = null;
            queryResultsCacheKey = cacheable && cacheMode.isPutEnabled() ? QueryKey.from((String)jdbcSelect.getSqlString(), (Limit)executionContext.getQueryOptions().getLimit(), (QueryParameterBindings)executionContext.getQueryParameterBindings(), (SharedSessionContractImplementor)session) : null;
        }
        ReactiveValuesMappingProducer mappingProducer = (ReactiveValuesMappingProducer)jdbcSelect.getJdbcValuesMappingProducer();
        if (cachedResults == null) {
            if (queryResultsCacheKey == null) {
                return mappingProducer.reactiveResolve(resultSetAccess, session.getLoadQueryInfluencers(), factory).thenApply(jdbcValuesMapping -> new ReactiveValuesResultSet(resultSetAccess, null, queryIdentifier, executionContext.getQueryOptions(), (JdbcValuesMapping)jdbcValuesMapping, null, executionContext));
            }
            capturingMetadata = new CapturingJdbcValuesMetadata(resultSetAccess);
            JdbcValuesMetadata metadataForCache = capturingMetadata.resolveMetadataForCache();
            return mappingProducer.reactiveResolve(resultSetAccess, session.getLoadQueryInfluencers(), factory).thenApply(jdbcValuesMapping -> new ReactiveValuesResultSet(resultSetAccess, queryResultsCacheKey, queryIdentifier, executionContext.getQueryOptions(), (JdbcValuesMapping)jdbcValuesMapping, metadataForCache, executionContext));
        }
        capturingMetadata = new CapturingJdbcValuesMetadata(resultSetAccess);
        CompletionStage<JdbcValuesMapping> stage = cachedResults.isEmpty() || !(cachedResults.get(0) instanceof JdbcValuesMetadata) ? mappingProducer.reactiveResolve(resultSetAccess, session.getLoadQueryInfluencers(), factory) : mappingProducer.reactiveResolve((JdbcValuesMetadata)cachedResults.get(0), session.getLoadQueryInfluencers(), factory);
        return stage.thenApply(jdbcValuesMapping -> new ReactiveValuesResultSet(resultSetAccess, queryResultsCacheKey, queryIdentifier, executionContext.getQueryOptions(), (JdbcValuesMapping)jdbcValuesMapping, capturingMetadata, executionContext));
    }

    private static class Statistics {
        private final ExecutionContext executionContext;
        private final StatisticsImplementor statistics;
        private final boolean enabled;
        private long startTime = 0L;

        public Statistics(ExecutionContext executionContext, ReactiveValuesResultSet jdbcValues) {
            this.executionContext = executionContext;
            this.statistics = executionContext.getSession().getFactory().getStatistics();
            if (executionContext.hasQueryExecutionToBeAddedToStatistics()) {
                this.enabled = this.statistics.isStatisticsEnabled();
                if (this.enabled) {
                    this.startTime = System.nanoTime();
                }
            } else {
                this.enabled = false;
            }
        }

        public <T> void end(JdbcOperationQuerySelect jdbcSelect, T result) {
            if (this.enabled) {
                long endTime = System.nanoTime();
                long milliseconds = TimeUnit.MILLISECONDS.convert(endTime - this.startTime, TimeUnit.NANOSECONDS);
                this.statistics.queryExecuted(this.executionContext.getQueryIdentifier(jdbcSelect.getSqlString()), this.getResultSize(result), milliseconds);
            }
        }

        private <T> int getResultSize(T result) {
            return result instanceof Collection ? ((Collection)result).size() : -1;
        }
    }

    private static class CachedJdbcValuesMetadata
    implements JdbcValuesMetadata,
    Serializable {
        private final String[] columnNames;
        private final BasicType<?>[] types;

        public CachedJdbcValuesMetadata(String[] columnNames, BasicType<?>[] types) {
            this.columnNames = columnNames;
            this.types = types;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int resolveColumnPosition(String columnName) {
            int position = ArrayHelper.indexOf((Object[])this.columnNames, (Object)columnName) + 1;
            if (position == 0) {
                throw new IllegalStateException("Unexpected resolving of unavailable column: " + columnName);
            }
            return position;
        }

        public String resolveColumnName(int position) {
            String name = this.columnNames[position - 1];
            if (name == null) {
                throw new IllegalStateException("Unexpected resolving of unavailable column at position: " + position);
            }
            return name;
        }

        public <J> BasicType<J> resolveType(int position, JavaType<J> explicitJavaType, TypeConfiguration typeConfiguration) {
            BasicType<?> type = this.types[position - 1];
            if (type == null) {
                throw new IllegalStateException("Unexpected resolving of unavailable column at position: " + position);
            }
            if (explicitJavaType == null || type.getJavaTypeDescriptor() == explicitJavaType) {
                return type;
            }
            return typeConfiguration.getBasicTypeRegistry().resolve(explicitJavaType, type.getJdbcType());
        }
    }

    public static class CapturingJdbcValuesMetadata
    implements JdbcValuesMetadata {
        private final ReactiveResultSetAccess resultSetAccess;
        private String[] columnNames;
        private BasicType<?>[] types;

        public CapturingJdbcValuesMetadata(ReactiveResultSetAccess resultSetAccess) {
            this.resultSetAccess = resultSetAccess;
        }

        private void initializeArrays() {
            int columnCount = this.resultSetAccess.getColumnCount();
            this.columnNames = new String[columnCount];
            this.types = new BasicType[columnCount];
        }

        public int getColumnCount() {
            if (this.columnNames == null) {
                this.initializeArrays();
            }
            return this.columnNames.length;
        }

        public int resolveColumnPosition(String columnName) {
            int position;
            if (this.columnNames == null) {
                this.initializeArrays();
            }
            if (this.columnNames == null) {
                position = this.resultSetAccess.resolveColumnPosition(columnName);
                this.columnNames[position - 1] = columnName;
            } else {
                position = ArrayHelper.indexOf((Object[])this.columnNames, (Object)columnName) + 1;
                if (position == 0) {
                    position = this.resultSetAccess.resolveColumnPosition(columnName);
                    this.columnNames[position - 1] = columnName;
                }
            }
            return position;
        }

        public String resolveColumnName(int position) {
            String name;
            if (this.columnNames == null) {
                this.initializeArrays();
            }
            if (this.columnNames == null) {
                this.columnNames[position - 1] = name = this.resultSetAccess.resolveColumnName(position);
            } else {
                name = this.columnNames[position - 1];
                if (name == null) {
                    this.columnNames[position - 1] = name = this.resultSetAccess.resolveColumnName(position);
                }
            }
            return name;
        }

        public <J> BasicType<J> resolveType(int position, JavaType<J> explicitJavaType, TypeConfiguration typeConfiguration) {
            if (this.columnNames == null) {
                this.initializeArrays();
            }
            BasicType<J> basicType = this.resultSetAccess.resolveType(position, explicitJavaType, typeConfiguration);
            this.types[position - 1] = basicType;
            return basicType;
        }

        public JdbcValuesMetadata resolveMetadataForCache() {
            if (this.columnNames == null) {
                return null;
            }
            return new CachedJdbcValuesMetadata(this.columnNames, this.types);
        }
    }
}

